# Schlieren 
Compute the result of (a+b)/(a-b).

## Overview
The benchmark computes the result of expression `(a+b)/(a-b)`, where `a` and `b`
are variables with associated distributional information.

## Inputs
The inputs directory contains subdirectories with the input datasets to this
benchmark. Each subdirectory contains 2 files, one for each input variable. Each
file starts with the number of samples and then the samples for that variable.
The following commands generated the input datasets of the commit.

#### `gaussian-1/`:
```
SamplesGenerator --out inputs/gaussian-1/input-a.txt --samples 5000 Gauss 5  10
SamplesGenerator --out inputs/gaussian-1/input-b.txt --samples 5000 Gauss -5 10
```
#### `gaussian-2/`:
```
SamplesGenerator --out inputs/gaussian-2/input-a.txt --samples 5000 Gauss 10 1
SamplesGenerator --out inputs/gaussian-2/input-b.txt --samples 5000 Gauss 5  1
```

#### `test/`:
```
SamplesGenerator --out inputs/test/input-a.txt --samples 100 Gauss 10 1
SamplesGenerator --out inputs/test/input-b.txt --samples 100 Gauss 0  1
```

#### `laplace-1/`:
```
SamplesGenerator --out inputs/laplace-1/input-a.txt --samples 5000 Laplace 5  10
SamplesGenerator --out inputs/laplace-1/input-b.txt --samples 5000 Laplace -5 10
```

#### `laplace-2/`:
```
SamplesGenerator --out inputs/laplace-2/input-a.txt --samples 5000 Laplace 10 1
SamplesGenerator --out inputs/laplace-2/input-b.txt --samples 5000 Laplace 5  1
```

#### `uniform/`:
```
SamplesGenerator --out inputs/uniform/input-b.txt --samples 5000  Uniform 20 25
SamplesGenerator --out inputs/uniform/input-a.txt --samples 5000  Uniform 5 10
```

## Outputs
The program prints the result of the computation. The `.m` files configure the
emulator to save the trace to a `schlieren.db` database.

## Evaluation Criteria
0. Run without uncertainty propagation enabled
1. Run with point-valued inputs but with uncertainty propagation enabled
2. Run with uncertainty propagation enabled, distributions overlaid on inputs, and verify that point-valued results match Evaluation 1, and record the distributions of all program result variables which depend on the inputs.
3. Taint analysis to give insight into dataflow in application. Represent taint analysis results as a matrix where each row is an input from which we track taint and each column is a variable in the program to which we want to see if taint propagates.

## Notes
The name "Schlieren" is an arbitrary on-the-spot name for this benchmark, to
make it easier to refer to it, and does not relate to any person.
