# Usage
`double-divide` _<input A samples>_ _<input B samples>_ _<mode: 1 for explicit computation, 0 for implicit uncertainty tracking>_

## Overview
Performs floating-point division of two variables `A` and `B` with associated distributions and place the result in `C`.

## Inputs
First line of the input file is the number of samples that follow.

## Outputs
The `.m` emulator configuration files cause the value distribution for variables `A`, `B`, and `C`, along with other results, to be recorded into a database, `double-divide.db`

## Evaluation Criteria
-	`run.m`: This is a basic default emulator configuration with correlation tracking enabled.
-	`run-test.m`: This is a minimal default emulator configuration.
-	`run-exact.m`: This emulator configuration runs the benchmark in the mode where we enumerate all possible values in the problem distribution domain (i.e., with explicit computation flag set).
-	`run-montecarlo.m`: This emulator configuration runs the benchmark in the the emulator-controlled Monte Carlo mode.
-	`run-evaluation.m`: This emulator configuration runs the benchmark with a range of uncertainty representation settings. First, it runs without uncertainty propagation enabled. Second, it runs with point-valued inputs but with uncertainty propagation enabled. Third, it runs with uncertainty propagation enabled, distributions overlaid on inputs. The results in the database should allow us to verify that point-valued results match the first step as well as to record the distributions of all program result variables which depend on the inputs.

-	**TODO:** Taint analysis to give insight into dataflow in application. Represent taint analysis results as a matrix where each row is an input from which we track taint and each column is a variable in the program to which we want to see if taint propagates.

