#!/usr/bin/env python

import sys, os, stat, math
from PIL import Image
import matplotlib
import matplotlib.pyplot as plt
import numpy as np

# 28x28 = 784 pixels

if __name__ == '__main__':

	fdDistr_results = open(sys.argv[1], 'r')
	fdPacalX = open(sys.argv[2], 'r')
	fdPacalY = open(sys.argv[3], 'r')
		
	numOfDDs = int(sys.argv[4])	
	targetDir = sys.argv[5];	
	showPlot = int(sys.argv[6])
	savePlot = int(sys.argv[7])
	saveFormat = sys.argv[8]
	
	print 'numOfDDs is ' + str(numOfDDs)

	resultsPrefix = sys.argv[1].split('/')[-1].split('.')[0]

	print 'results prefix: ' + resultsPrefix

	fontSize = 10

	matplotlib.rcParams.update({'font.size': fontSize})

	index = 0

	pacalX = map(lambda x: float(x), fdPacalX.readline().strip().strip('[]').split(','))

	pacalY = map(lambda x: float(x), fdPacalY.readline().strip().strip('[]').split(','))

	#plt.plot(pacalX, pacalY, color='red', label='Pacal')

	#plt.show()

	#sys.exit(0)

	one_line_results = fdDistr_results.readline()

	while (len(one_line_results) != 0):	

		#if (one_line_results.find(' DD |') != -1):
		if (one_line_results.find('Number of source samples:') != -1):
			one_line_results_split = one_line_results.strip().split(' ')

			meanValue = one_line_results_split[7]

			variance = one_line_results_split[9]

			one_line_results = fdDistr_results.readline() #Remove line  DD |

			one_line_results = fdDistr_results.readline() #Remove line ----+

			DDpositions = [0] * numOfDDs

			DDmasses = [0] * numOfDDs

			for i in range(0, numOfDDs):

				one_line_results = fdDistr_results.readline() #Remove line

				one_line_results_split = one_line_results.strip().split('|')

				DDpositions[i] = float(one_line_results_split[1])

				DDmasses[i] = float(one_line_results_split[2])

				#print one_line_results_split

			#print DDpositions
			maxDDMass = max(DDmasses)

			print 'DDmasses		'
			print DDmasses	
			fig = plt.figure(figsize=(5, 2.0))

			plt.plot(pacalX, pacalY, color='red', label='PaCal', linestyle='--')

			#plt.title('Mean value: ' + meanValue + ' Variance: ' + variance, loc='center')
			plt.xlabel('Thermal Expansion Coefficient Distribution Domain')
			plt.ylabel('Probability Density')			
			
			#FIXME for negative values			
			widthList = [(DDpositions[1] - DDpositions[0])]
			DDmassesAdjusted = [DDmasses[0] / (DDpositions[1] - DDpositions[0])]
			
			for i in range(1, numOfDDs-1):
				widthA = DDpositions[i] - DDpositions[i-1]
				widthB = DDpositions[i+1] - DDpositions[i]
	
				chosenWidth = min(widthA, widthB)

				widthList.append(chosenWidth)

				DDmassesAdjusted.append(DDmasses[i] / chosenWidth)

			print widthList

			widthList.append(DDpositions[numOfDDs-1] - DDpositions[numOfDDs-2])

			DDmassesAdjusted.append(DDmasses[numOfDDs-1] / (DDpositions[numOfDDs-1] - DDpositions[numOfDDs-2]))

			plt.bar(DDpositions, DDmassesAdjusted, width=widthList, color='ghostwhite', edgecolor='white')

			stepsX = [DDpositions[0]-widthList[0]/2]

			stepsY = [0] #for first step position

			for i in range(0, numOfDDs):
				newStepX = round(DDpositions[i]-widthList[i]/2, 3)

				print 'newStepX ' + str(newStepX) + ' stepsX[i-1] ' + str(stepsX[i-1])

				if newStepX - stepsX[-1] > 0.05:
					stepsX.append(stepsX[-1])

					stepsY.append(0)

					stepsX.append(newStepX)

					stepsY.append(0)	
	
					stepsX.append(newStepX)

				else:

					stepsX.append(newStepX)

				stepsY.append(DDmassesAdjusted[i])

				stepsX.append(DDpositions[i]+widthList[i]/2)

				stepsY.append(DDmassesAdjusted[i])

			stepsX.append(DDpositions[numOfDDs-1]+widthList[i]/2)

			stepsY.append(0) #for last step

			plt.plot(stepsX, stepsY, drawstyle='steps', color='goldenrod', label='Laplace')

			#plt.axvline(x=float(meanValue.strip('.')), color='green', linestyle='-.')

			xTicks = [min(DDpositions), max(DDpositions)]

			print xTicks			

			plt.xticks(xTicks, rotation=0, fontsize=fontSize)
			
			plt.grid(b=True, which='major', color='#999999', linestyle='--')

			plt.legend(loc='upper right', borderaxespad=0., fontsize=fontSize)

			plt.xlim([-1.5, 6.5])
			
			plt.subplots_adjust(left=0.12, bottom=0.15, right=1.0, top=1.0)
	
			index += 1
			
			if (showPlot == 1):
				plt.show()

			if (savePlot == 1):
				filename = targetDir + '/' + resultsPrefix + '-TTR-' + str(numOfDDs) + '-hist-' + str(index-1) + '.' + saveFormat

				plt.savefig(filename, format=saveFormat, bbox_inches='tight', pad_inches = 0)

				print 'Saved file ' + filename

				plt.close()

		else:
			one_line_results = fdDistr_results.readline()

	fdDistr_results.close()

	fdPacalX.close()

	fdPacalY.close()

