from pacal import *
import matplotlib as matplotlib
import matplotlib.pyplot as plt

# PaCAL paper: ARITHMETIC OPERATIONS ON INDEPENDENT RANDOM VARIABLES: A NUMERICAL APPROACH

# PaCAL Experiment Figure 4.1

C = NormalDistr(0,1) / NormalDistr(0,1)

P = C * C

Q = C / C

# Get data for P

P.plot()

fig = matplotlib.pyplot.gcf()

axes = fig.gca()

index = 1

xDataList = []

yDataList = []

for line in axes.lines:
    
	print 'line: ' + str(index)
    
	xdata = line.get_xdata()
    
	if len(xdata) > 2:
    
		xDataList.extend(xdata)
    
		ydata = line.get_ydata()

		yDataList.extend(ydata)

	index += 1

fdx = open("PaCAL_fig4-1_P_xdata.txt","w")

fdy = open("PaCAL_fig4-1_P_ydata.txt","w")

fdx.write(str(xDataList)+'\n')

fdy.write(str(yDataList)+'\n')

fdx.close()

fdy.close()

# fig = plt.figure()

# plt.plot(xDataList,yDataList)

# plt.show()


# Get data for Q

Q.plot()

fig = matplotlib.pyplot.gcf()

axes = fig.gca()

index = 1

xDataList = []

yDataList = []

for line in axes.lines:
    
    print 'line: ' + str(index)
    
    xdata = line.get_xdata()
    
    if len(xdata) > 2:
    
        xDataList.extend(xdata)
    
        ydata = line.get_ydata()

        yDataList.extend(ydata)

    index += 1

fdx = open("PaCAL_fig4-1_Q_xdata.txt","w")

fdy = open("PaCAL_fig4-1_Q_ydata.txt","w")

fdx.write(str(xDataList)+'\n')

fdy.write(str(yDataList)+'\n')

fdx.close()

fdy.close()

# fig = plt.figure()

# plt.plot(xDataList,yDataList)

# plt.show()

#######################################################

# PaCAL Experiment Figure 4.5

P1 = NormalDistr(1,1) * NormalDistr(1,1)

P2 = NormalDistr(2,1) * NormalDistr(2,1)

P3 = NormalDistr(3,1) * NormalDistr(3,1)

# Get data for P1

P1.plot()

fig = matplotlib.pyplot.gcf()

axes = fig.gca()

index = 1

xDataList = []

yDataList = []

for line in axes.lines:
    
    print 'line: ' + str(index)
    
    xdata = line.get_xdata()
    
    if len(xdata) > 2:
    
        xDataList.extend(xdata)
    
        ydata = line.get_ydata()

        yDataList.extend(ydata)

    index += 1

fdx = open("PaCAL_fig4-5_P1_xdata.txt","w")

fdy = open("PaCAL_fig4-5_P1_ydata.txt","w")

fdx.write(str(xDataList)+'\n')

fdy.write(str(yDataList)+'\n')

fdx.close()

fdy.close()

# fig = plt.figure()

# plt.plot(xDataList,yDataList)

# plt.show()


# Get data for P2

P2.plot()

fig = matplotlib.pyplot.gcf()

axes = fig.gca()

index = 1

xDataList = []

yDataList = []

for line in axes.lines:
    
    print 'line: ' + str(index)
    
    xdata = line.get_xdata()
    
    if len(xdata) > 2:
    
        xDataList.extend(xdata)
    
        ydata = line.get_ydata()

        yDataList.extend(ydata)

    index += 1

fdx = open("PaCAL_fig4-5_P2_xdata.txt","w")

fdy = open("PaCAL_fig4-5_P2_ydata.txt","w")

fdx.write(str(xDataList)+'\n')

fdy.write(str(yDataList)+'\n')

fdx.close()

fdy.close()

# fig = plt.figure()

# plt.plot(xDataList,yDataList)

# plt.show()


# Get data for P3

P3.plot()

fig = matplotlib.pyplot.gcf()

axes = fig.gca()

index = 1

xDataList = []

yDataList = []

for line in axes.lines:
    
    print 'line: ' + str(index)
    
    xdata = line.get_xdata()
    
    if len(xdata) > 2:
    
        xDataList.extend(xdata)
    
        ydata = line.get_ydata()

        yDataList.extend(ydata)

    index += 1

fdx = open("PaCAL_fig4-5_P3_xdata.txt","w")

fdy = open("PaCAL_fig4-5_P3_ydata.txt","w")

fdx.write(str(xDataList)+'\n')

fdy.write(str(yDataList)+'\n')

fdx.close()

fdy.close()

# fig = plt.figure()

# plt.plot(xDataList,yDataList)

# plt.show()

#######################################################

# PaCAL Experiment Figure 4.6

L0 = UniformDistr(9,10)

L1 = UniformDistr(11,12)

dT = NormalDistr(1,2)

k = (L1/L0 - 1)/dT

# Get data for P1

k.plot()

fig = matplotlib.pyplot.gcf()

axes = fig.gca()

index = 1

xDataList = []

yDataList = []

for line in axes.lines:
    
    print 'line: ' + str(index)
    
    xdata = line.get_xdata()
    
    if len(xdata) > 2:
    
        xDataList.extend(xdata)
    
        ydata = line.get_ydata()

        yDataList.extend(ydata)

    index += 1

fdx = open("PaCAL_fig4-6_TEC_xdata.txt","w")

fdy = open("PaCAL_fig4-6_TEC_ydata.txt","w")

fdx.write(str(xDataList)+'\n')

fdy.write(str(yDataList)+'\n')

fdx.close()

fdy.close()

# fig = plt.figure()

# plt.plot(xDataList,yDataList)

# plt.show()
