#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <uncertain.h>

const double pi = 3.14159265359;

double loadDoubleDistFromPath(double *  var, const char *  filename);

int 
main(int argc, char *argv[])
{
	/* UPP variables */
	double initialLength, initialTemperature, finalLength, finalTemperature, thermalExpansionCoef;

	/* Load all samples from their respective files */
	initialLength = loadDoubleDistFromPath(NULL, "samples-studentst-tec_initialLength.csv");
	printf("initialLength = %f\n", initialLength);
	libUncertainDoublePrint(initialLength);
	
	initialTemperature = loadDoubleDistFromPath(NULL, "samples-studentst-tec_initialTemperature.csv");
	printf("initialTemperature = %f\n", initialTemperature);
	libUncertainDoublePrint(initialTemperature);

	finalLength = loadDoubleDistFromPath(NULL, "samples-studentst-tec_finalLength.csv");
	printf("finalLength = %f\n", finalLength);
	libUncertainDoublePrint(finalLength);

	finalTemperature = loadDoubleDistFromPath(NULL, "samples-studentst-tec_finalTemperature.csv");
	printf("finalTemperature = %f\n", finalTemperature);
	libUncertainDoublePrint(finalTemperature);

	/* Perform calculations as specified by the NIST Uncertainty Machine example */
	thermalExpansionCoef = (finalLength - initialLength) / (initialLength * (finalTemperature - initialTemperature));
	
	/* Print UPP distributions */
	printf("thermalExpansionCoef Result:\n");
	libUncertainDoublePrint(thermalExpansionCoef);

	/* Finished. */
	return 0;
}

double
loadDoubleDistFromPath(double *  var, const char *  filename)
{
	FILE *		inp;
	int			sampleCount;
	double *	samples;
	double		returnValue;

	inp = fopen(filename, "r");
	if (inp == NULL)
	{
		printf("Could not open input file: %s\n", filename);
		exit(EXIT_FAILURE);
	}

	fscanf(inp, "%d\n", &sampleCount);

	printf("Number of samples from %s: %d\n", filename, sampleCount);

	samples = malloc(sampleCount * sizeof(double));
	if (samples == NULL)
	{
		perror("error: could not allocate memory for samples");
		exit(EXIT_FAILURE);
	}

	for (int i = 0; i < sampleCount; i++)
	{
		fscanf(inp, "%lf\n", &samples[i]);
	}

	if (var == NULL )
		returnValue = libUncertainDoubleDistFromSamples(samples, sampleCount);
	else
		(*var) = libUncertainDoubleDistFromSamples(samples, sampleCount);

	if (fclose(inp) != 0)
	{
		perror("warning: could not close input file");
	}

	free(samples);

	return returnValue;
}
