#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <uncertain.h>

const double pi = 3.14159265359;

double loadDoubleDistFromPath(double *  var, const char *  filename);

int 
main(int argc, char *argv[])
{
	/* UPP variables */
	double muC, rhoB, rhoC, rhoM, tM, tC, uppResult;

	/* Load all samples from their respective files */
	muC = loadDoubleDistFromPath(NULL, "samples-gaussian-dv_muC.csv");
	printf("muC = %f\n", muC);
	libUncertainDoublePrint(muC);
	
	rhoB = loadDoubleDistFromPath(NULL, "samples-gaussian-dv_rhoB.csv");
	printf("rhoB = %f\n", rhoB);
	libUncertainDoublePrint(rhoB);

	rhoC = loadDoubleDistFromPath(NULL, "samples-gaussian-dv_rhoC.csv");
	printf("rhoC = %f\n", rhoC);
	libUncertainDoublePrint(rhoC);

	rhoM = loadDoubleDistFromPath(NULL, "samples-gaussian-dv_rhoM.csv");
	printf("rhoM = %f\n", rhoM);
	libUncertainDoublePrint(rhoM);

	tC = loadDoubleDistFromPath(NULL, "samples-gaussian-dv_tC.csv");
	printf("tC = %f\n", tC);
	libUncertainDoublePrint(tC);

	tM = loadDoubleDistFromPath(NULL, "samples-gaussian-dv_tM.csv");
	printf("tM = %f\n", tM);
	libUncertainDoublePrint(tM);

	/* Perform calculations as specified by the NIST Uncertainty Machine example */
	uppResult = muC * ((rhoB-rhoM)/(rhoB-rhoC)) * (tM/tC);

	/* Print UPP distributions */
	printf("Variable Result:\n");
	libUncertainDoublePrint(uppResult);

	/* Finished. */
	return 0;
}

double
loadDoubleDistFromPath(double *  var, const char *  filename)
{
	FILE *		inp;
	int			sampleCount;
	double *	samples;
	double		returnValue;

	inp = fopen(filename, "r");
	if (inp == NULL)
	{
		printf("Could not open input file: %s\n", filename);
		exit(EXIT_FAILURE);
	}

	fscanf(inp, "%d\n", &sampleCount);

	printf("Number of samples from %s: %d\n", filename, sampleCount);

	samples = malloc(sampleCount * sizeof(double));
	if (samples == NULL)
	{
		perror("error: could not allocate memory for samples");
		exit(EXIT_FAILURE);
	}

	for (int i = 0; i < sampleCount; i++)
	{
		fscanf(inp, "%lf\n", &samples[i]);
	}

	if (var == NULL )
		returnValue = libUncertainDoubleDistFromSamples(samples, sampleCount);
	else
		(*var) = libUncertainDoubleDistFromSamples(samples, sampleCount);

	if (fclose(inp) != 0)
	{
		perror("warning: could not close input file");
	}

	free(samples);

	return returnValue;
}
