# The NIST Uncertainty Machine Benchmarks
A comparison against the [NIST Uncertainty Machine](https://uncertainty.nist.gov/).
## Overview
This benchmark is directory contains three benchmark kernels. All three all
examples from the web version of the [NIST Uncertainty Machine](https://uncertainty.nist.gov/).

### 1. Viscosity (`dynamic-viscosity-solution).
Calculates
```
muC * ((rhoB-rhoM)/(rhoB-rhoC)) * (tM/tC)
```
### 2. Stefan (`Stefan-Boltzmann-constant`).
Calculates
```
N = 32 * (pi^5) * h * (R^4) * (Rinf^4)
D = 15 * (e^4) * ((1e-3)^4) * (299792458^6) * (alpha^8)
N / D
```
### 3. Thermal (`thermal-expansion-coefficient`)
Calculates
```
(L1-L0) / (L0*(T1-T0))
```

## Inputs
The inputs are the same with the web version of the [NIST Uncertainty Machine](https://uncertainty.nist.gov/). The following subsections repeat them.

### 1. Viscosity (`dynamic-viscosity-solution).
```
Number of input quantities: 6
Names of input quantities:
muC	rhoB	rhoM	rhoC	tM	tC

muC		Gaussian (Mean, StdDev) 4.63 0.0463
rhoB	Gaussian (Mean, StdDev) 2217 0.5
rhoM	Gaussian (Mean, StdDev) 1180 0.5
rhoC	Gaussian (Mean, StdDev) 810  0.5
tM		Gaussian (Mean, StdDev) 61   6.1
tC		Gaussian (Mean, StdDev) 36.6 5.49
```
### 2. Stefan (`Stefan-Boltzmann-constant`).
```
Number of input quantities: 5
Names of input quantities:
h	R	Rinf	e	alpha	

h	Gaussian (Mean, StdDev) 6.62606957e-34 0.00000029e-34
R	Gaussian (Mean, StdDev) 8.3144621	0.0000075
Rinf	Gaussian (Mean, StdDev) 10973731.568539 0.000055
e	Gaussian (Mean, StdDev) 5.4857990946e-4 0.0000000022e-4
alpha	Gaussian (Mean, StdDev) 7.2973525698e-3 0.0000000024e-3
```
### 3. Thermal (`thermal-expansion-coefficient`)

```
Number of input quantities: 4
Names of input quantities:
L0	T0	L1	T1

L0	Student t (Mean, StdDev, No. of degrees of freedom)	1.4999 0.0001 3
T0	Student t (Mean, StdDev, No. of degrees of freedom) 288.15 0.02   3
L1	Student t (Mean, StdDev, No. of degrees of freedom) 1.5021 0.0002 3
T1	Student t (Mean, StdDev, No. of degrees of freedom) 373.10 0.05   3
```

## Outputs
Each benchmark writes the results of the computation to an SQLite3 database (`.db` file).


## Notes



### Setup
Type `make` to set up all examples from the NIST Uncertainty Machine (NISTUM) specified in `examplesToRun.txt`. This requires a working installation of `R` and some packages for it; see NISTUM repository at https://github.com/usnistgov/NIST-Uncertainty-Machine. Alternatively, you can use the web version of NISTUM, where you may load and execute the configs from their interface at https://uncertainty.nist.gov/. In this case, execute `make makeSamplesForUpp`, which performs only the sampling step needed for the UPP benchmarks and does not execute the NISTUM (i.e. R) benchmarks locally.

### Running a benchmark
Change into the directory `upp<BenchmarkName>`, where BenchmarkName corresponds to the NISTUM example name.

Type `make` to compile the benchmark. Type `make run` to compile and run the benchmark over sunflower.

You might want to change the distribution sample size in the C code (and increase the sampling size in `makeSamples.py` if you intend to go above the default number).

### Example run of the "Stefan" benchmark of NISTUM
This benchmark is an implementation of evaluating the Stefan-Boltzmann constant from its underlying constants, each of which will have an associated uncertainty, which should propagate to the Stefan-Boltzmann constant. See https://en.wikipedia.org/wiki/Stefan%E2%80%93Boltzmann_constant for the equation and theory behind the constant.

The below are excerpts for a benchmark run with a distribution sample size of 10000.

First, by typing `make makeSamplesForUpp` in the root directory of this benchmark, the Python script parses the NIST Uncertainty Machine's config file (given in `examplesToRun.txt`) to create samples for all variables with the given parameters:
```
make makeSamplesForUpp 
	mkdir -p ./uppSamples
	for NIST_CONFIG in config-Stefan; do \
		./makeSamples.py ./NIST-Uncertainty-Machine/conf/${NIST_CONFIG}.txt; \
	done
	Creating Gaussian variable h with parameters 6.62606957e-34, 2.9e-41
	Creating Gaussian variable R with parameters 8.3144621, 7.5e-06
	Creating Gaussian variable Rinf with parameters 10973731.568539, 5.5e-05
	Creating Gaussian variable e with parameters 0.00054857990946, 2.2e-13
	Creating Gaussian variable alpha with parameters 0.0072973525698, 2.4e-12
```

The NISTUM benchmark is specified in its config as:
```
N = 32 * (pi^5) * h * (R^4) * (Rinf^4)
D = 15 * (e^4) * ((1e-3)^4) * (299792458^6) * (alpha^8)
N/D
```

Next, in `nistUncertaintyMachineBenchmarks/uppStefan`, we execute `make run`. The distribution output for the variables *N* (nominator), *D* (denominator), and the result *N/D* are as below:

```
Variable N:

Mem: 0xef7fed40
Number of source samples: 10000. Mean Value: 449.685911. Number of DDs: 16
 DD |     Position     |   Mass   | graphical representation                   
----+------------------+----------+------------------------------------------------
000 |       449.685867 | 0.033200 |#####################
001 |       449.685880 | 0.051200 |################################
002 |       449.685887 | 0.058800 |#####################################
003 |       449.685893 | 0.065300 |#########################################
004 |       449.685898 | 0.070100 |############################################
005 |       449.685902 | 0.071100 |#############################################
006 |       449.685905 | 0.070800 |#############################################
007 |       449.685909 | 0.074800 |###############################################
008 |       449.685913 | 0.076300 |################################################
009 |       449.685916 | 0.075200 |###############################################
010 |       449.685920 | 0.071400 |#############################################
011 |       449.685924 | 0.071900 |#############################################
012 |       449.685929 | 0.065400 |#########################################
013 |       449.685934 | 0.060200 |######################################
014 |       449.685942 | 0.052000 |#################################
015 |       449.685955 | 0.032300 |####################
    |       total      | 1.000000 |                                            
----+------------------+----------+------------------------------------------------



Variable D:

Mem: 0xef7fee80
Particle value: Number of source samples: 0. Mean Value: 7930447734.563791


Variable Result = N/D:

Mem: 0xef8ff980
Number of source samples: 10000. Mean Value: 0.000000. Number of DDs: 16
 DD |     Position     |   Mass   | graphical representation                   
----+------------------+----------+------------------------------------------------
000 |         0.000000 | 0.033200 |#####################
001 |         0.000000 | 0.051200 |################################
002 |         0.000000 | 0.058800 |#####################################
003 |         0.000000 | 0.065300 |#########################################
004 |         0.000000 | 0.070100 |############################################
005 |         0.000000 | 0.071100 |#############################################
006 |         0.000000 | 0.070800 |#############################################
007 |         0.000000 | 0.074800 |###############################################
008 |         0.000000 | 0.076300 |################################################
009 |         0.000000 | 0.075200 |###############################################
010 |         0.000000 | 0.071400 |#############################################
011 |         0.000000 | 0.071900 |#############################################
012 |         0.000000 | 0.065400 |#########################################
013 |         0.000000 | 0.060200 |######################################
014 |         0.000000 | 0.052000 |#################################
015 |         0.000000 | 0.032300 |####################
    |       total      | 1.000000 |                                            
----+------------------+----------+------------------------------------------------



NODE 1 exiting...
User Time elapsed = 102.786712 seconds.
Simulated CPU Time elapsed = 7.360059E+00 seconds.
Simulated Clock Cycles = 441603554
Cycles Spent Waiting = 101223129 (22.92%)
Instruction Simulation Rate = 4296309.74 Cycles/Second.
```

To compare not just the end result, but also *N* and *D*, the NISTUM config has been altered and run three times to produce the output for each of *N*, *D*, and *N/D* separately. The results are in the folder `comparisonToNistUncertaintyMachine/`. These output plots from NISTUM are shown below:

### N
<img src="./uppStefan/comparisonToNistUncertaintyMachine/N-density.jpg" width="800">

### D
<img src="./uppStefan/comparisonToNistUncertaintyMachine/D-density.jpg" width="800">

### Result = N/D
<img src="./uppStefan/comparisonToNistUncertaintyMachine/Result-density.jpg" width="800">
