#!/usr/bin/env python

import sys, os, stat, math
import matplotlib.pyplot as plt
import numpy as np

if __name__ == '__main__':
	#GeoCoordinate Point = GPS.GetHardwareLocation();
	#double Accuracy = GPS.GetHardwareAccuracy();
	
	#// Compute epsilon
	#double epsilon = Accuracy / Math.Sqrt(Math.Log(400));

	#radius = Math.RandomRayleigh(epsilon);
	#angle = Math.RandomUniform(0, 2*Math.PI);

	#// Convert to x,y coordinates in degrees
	#x = Point.Longitude;
	#x += radius*Math.Cos(angle)*DEGREES_PER_METER;
	#y = Point.Latitude;
	#y += radius*Math.Sin(angle)*DEGREES_PER_METER;

	DEGREES_PER_METER = 0.000009009

	centersFilename = sys.argv[1]
	
	numOfSamples = int(sys.argv[2])

	outFilename = centersFilename.split('.')[0] + '-uncertainT-' + str(numOfSamples) + '.csv'  
	
	fd_r = open(centersFilename, 'r')

	fd_w = open(outFilename, 'w')

	#Discard first line
	one_line = fd_r.readline()	

	fd_w.write(one_line)

	#numOfInputPoints = int(one_line.split()[0])

	#vectorSize = int(one_line.split()[1]) - 1

	#numOfClasses = int(one_line.split()[2])

	#print 'vectorSize is ' + str(vectorSize)

	#print 'outFilename is ' + outFilename

	#rng = np.random.default_rng()

	#fd_w.write(str(numOfInputPoints) + ' ' + str(vectorSize+1) + ' ' + str(numOfClasses) + ' ' + str(numOfSamples) + '\n')

	one_line = fd_r.readline()

	#index = 0	

	while (len(one_line) != 0):
		
		fd_w.write(one_line)
	
		one_point = one_line.split(',')

		gpsAccuracy = float(one_point[8])

		epsilon = gpsAccuracy / math.sqrt(math.log(400))

		#radius = Math.RandomRayleigh(epsilon);		
		radius = np.random.rayleigh(epsilon, numOfSamples)

		#angle = Math.RandomUniform(0, 2*Math.PI);
		angle = 2 * math.pi * np.random.random_sample(numOfSamples)

		#x += radius*Math.Cos(angle)*DEGREES_PER_METER;
		#map(lambda x: math.cos(x) * DEGREES_PER_METER, range(10))
		randomLonIncrement = [0] * numOfSamples
		randomLatIncrement = [0] * numOfSamples

		for i in range(0, numOfSamples):
			randomLonIncrement[i] = radius[i] * math.cos(angle[i]) * DEGREES_PER_METER
			randomLatIncrement[i] = radius[i] * math.sin(angle[i]) * DEGREES_PER_METER

		#y += radius*Math.Sin(angle)*DEGREES_PER_METER;
		#randomLatIncrement = radius * math.sin(angle) * DEGREES_PER_METER

		writeStr = ""

		for i in range(0, numOfSamples-1):
			writeStr += str(randomLatIncrement[i]) + ','

		writeStr += str(randomLatIncrement[numOfSamples-1]) + '\n'

		fd_w.write(writeStr)

		writeStr = ""

		for i in range(0, numOfSamples-1):
			writeStr += str(randomLonIncrement[i]) + ','

		writeStr += str(randomLonIncrement[numOfSamples-1]) + '\n'

		fd_w.write(writeStr)

		one_line = fd_r.readline()

	fd_r.close()

	fd_w.close()


