#!/bin/env bash

BENCHMARKS_ALL=" \
comparative-evaluations/Speed-Estimation-using-GPS-data/benchmark/ \
comparative-evaluations/UPP-vs-NISTUM/benchmark/dynamic-viscosity-solution/ \
comparative-evaluations/UPP-vs-NISTUM/benchmark/thermal-expansion-coefficient/ \
comparative-evaluations/UPP-vs-PaCal/benchmark/ \
linear-algebra/matrix-multiplication/benchmark/ \
micro-benchmarks/double-add/benchmark/ \
micro-benchmarks/double-divide/benchmark/ \
micro-benchmarks/double-multiply/benchmark/ \
micro-benchmarks/double-multiply-autocorrelation/benchmark/ \
micro-benchmarks/double-subtract/benchmark/ \
micro-benchmarks/schlieren/benchmark/ \
numerical-methods/Brown-and-Ham-materials-precipitate-cutting-dislocation-model/benchmark/
numerical-methods/FEM1D/benchmark/ \
numerical-methods/FPbench-benchmarks/daisy/benchmark/ \
numerical-methods/FPbench-benchmarks/herbie/benchmark/ \
numerical-methods/FPbench-benchmarks/fptaylor-real2float/benchmark/ \
numerical-methods/MNISTtoPositionalNumber/benchmark/ \
quantum-computing/accelerated-variational-quantum-eigensolver/benchmark/ \
sensor-interfacing/BME680-conversion-routines/benchmark/
"

SRC_BENCHMARKS_DIR=$(pwd)

while getopts ":hd:s:m:b:" opt; do
	case ${opt} in
		d )
			DEST_BENCHMARKS_DIR=$OPTARG
			;;
		s )
			PATH_TO_LAPLACE_SDK=$OPTARG
			;;
		m )
			MODE=$OPTARG
			;;
		b )
			BENCHMARKS=$OPTARG
			;;
		h )
			echo "Usage:"
			echo "    bash exec-MICRO-2021-Artifact-Evaluation-benchmark.sh -d       Set benchmarks directory (absolute path)."
			echo "    bash exec-MICRO-2021-Artifact-Evaluation-benchmark.sh -s       Laplace SDK directory."
			echo "    bash exec-MICRO-2021-Artifact-Evaluation-benchmark.sh -m       Execution mode. Options are 'all' (default), 'test', 'montecarlo', 'evaluation'."
			echo "    bash exec-MICRO-2021-Artifact-Evaluation-benchmark.sh -b       Benchmarks to be evaluated."
			echo "    bash exec-MICRO-2021-Artifact-Evaluation-benchmark.sh -h       Display this help message."
			exit 0
			;;
		\? )
			echo "Invalid Option: -$OPTARG" 1>&2
			exit 1
			;;
		: )
			echo "Invalid option: $OPTARG requires an argument" 1>&2
			;;
		esac
done

shift $((OPTIND -1))

if [ -z "$DEST_BENCHMARKS_DIR" ]
then
        echo "Benchmarks directory is empty. Please specify it using -d flag ."
        
        exit 1
fi

if [ -z "$BENCHMARKS" ]
then
        echo "No provided benchmarks for evaluation. Will evaluate all of them."

		BENCHMARKS=$BENCHMARKS_ALL
fi

if [ ! -d "$DEST_BENCHMARKS_DIR" ]
then
 	echo "Benchmarks directory does not exist. Please specify a valid one using -d flag."
	
	exit 1
fi

if [ -n "$MODE" ]
then
	if ! { [ "$MODE" == "all" ] || [ "$MODE" == "test" ] || [ "$MODE" == "montecarlo" ] || [ "$MODE" == "evaluation" ]; }
	then
		echo "Invalid argument for execution mode option (-m). Valid options are 'all' (default), 'test', 'montecarlo', 'evaluation'."
		
		exit 1
	fi
else
	MODE=all
fi

if [ -n "$PATH_TO_LAPLACE_SDK" ]
then
	sed -i 's|# PATH_TO_LAPLACE_SDK=/<absolute>/<path>/<to>/<Laplace>/<sdk>|PATH_TO_LAPLACE_SDK='$PATH_TO_LAPLACE_SDK'/|g' "$DEST_BENCHMARKS_DIR/config.mk"

	# Evaluation
	for BENCHMARK in $BENCHMARKS
	do
		echo ""
		
		echo "[Execution info]: Entering directory $DEST_BENCHMARKS_DIR/src/$BENCHMARK"
		
		cd "$DEST_BENCHMARKS_DIR/src/$BENCHMARK" || exit
		
		make clean

		if [ "$BENCHMARK" = "sensor-interfacing/BME680-conversion-routines/benchmark/" ]
		then
			make patch
		fi

		if { [ "$MODE" == "test" ] || [ "$MODE" == "montecarlo" ] || [ "$MODE" == "evaluation" ]; }
		then
			make run-"$MODE"
		else
			make run-evaluation

			make run-montecarlo
		fi
		
		cd "$SRC_BENCHMARKS_DIR" || exit
	done
	
	sed -i 's|PATH_TO_LAPLACE_SDK='$PATH_TO_LAPLACE_SDK'/|# PATH_TO_LAPLACE_SDK=/<absolute>/<path>/<to>/<Laplace>/<sdk>|g' "$DEST_BENCHMARKS_DIR/config.mk"
else
	echo "Please provide an absolute path to the Laplace SDK using the -s flag."
fi


