/*
 * This file is part of the OpenKinect Project. http://www.openkinect.org
 *
 * Copyright (c) 2011 individual OpenKinect contributors. See the CONTRIB file
 * for details.
 *
 * This code is licensed to you under the terms of the Apache License, version
 * 2.0, or, at your option, the terms of the GNU General Public License,
 * version 2.0. See the APACHE20 and GPL2 files for the text of the licenses,
 * or the following URLs:
 * http://www.apache.org/licenses/LICENSE-2.0
 * http://www.gnu.org/licenses/gpl-2.0.txt
 *
 * If you redistribute this file in source form, modified or unmodified, you
 * may:
 *   1) Leave this header intact and distribute it under the same terms,
 *      accompanying it with the APACHE20 and GPL20 files, or
 *   2) Delete the Apache 2.0 clause and accompany it with the GPL2 file, or
 *   3) Delete the GPL v2 clause and accompany it with the APACHE20 file
 * In all cases you must keep the copyright notice intact and include a copy
 * of the CONTRIB file.
 *
 * Binary distributions must follow the binary distribution requirements of
 * either License.
 */

#ifndef COLOR_SETTINGS_H_
#define COLOR_SETTINGS_H_

namespace libfreenect2
{

// The following information was found by using the library released by Microsoft under MIT license,
// https://github.com/Microsoft/MixedRealityCompanionKit/tree/master/KinectIPD/NuiSensor
enum ColorSettingCommandType
{
  COLOR_SETTING_SET_EXPOSURE_MODE = 0,
  COLOR_SETTING_SET_INTEGRATION_TIME = 1,
  COLOR_SETTING_GET_INTEGRATION_TIME = 2,
  COLOR_SETTING_SET_WHITE_BALANCE_MODE = 10,
  COLOR_SETTING_SET_RED_CHANNEL_GAIN = 11,
  COLOR_SETTING_SET_GREEN_CHANNEL_GAIN = 12,
  COLOR_SETTING_SET_BLUE_CHANNEL_GAIN = 13,
  COLOR_SETTING_GET_RED_CHANNEL_GAIN = 14,
  COLOR_SETTING_GET_GREEN_CHANNEL_GAIN = 15,
  COLOR_SETTING_GET_BLUE_CHANNEL_GAIN = 16,
  COLOR_SETTING_SET_EXPOSURE_TIME_MS = 17,
  COLOR_SETTING_GET_EXPOSURE_TIME_MS = 18,
  COLOR_SETTING_SET_DIGITAL_GAIN = 19,
  COLOR_SETTING_GET_DIGITAL_GAIN = 20,
  COLOR_SETTING_SET_ANALOG_GAIN = 21,
  COLOR_SETTING_GET_ANALOG_GAIN = 22,
  COLOR_SETTING_SET_EXPOSURE_COMPENSATION = 23,
  COLOR_SETTING_GET_EXPOSURE_COMPENSATION = 24,
  COLOR_SETTING_SET_ACS = 25,
  COLOR_SETTING_GET_ACS = 26,
  COLOR_SETTING_SET_EXPOSURE_METERING_MODE = 27,
  COLOR_SETTING_SET_EXPOSURE_METERING_ZONES = 28,
  COLOR_SETTING_SET_EXPOSURE_METERING_ZONE_0_WEIGHT = 29,
  COLOR_SETTING_SET_EXPOSURE_METERING_ZONE_1_WEIGHT = 30,
  COLOR_SETTING_SET_EXPOSURE_METERING_ZONE_2_WEIGHT = 31,
  COLOR_SETTING_SET_EXPOSURE_METERING_ZONE_3_WEIGHT = 32,
  COLOR_SETTING_SET_EXPOSURE_METERING_ZONE_4_WEIGHT = 33,
  COLOR_SETTING_SET_EXPOSURE_METERING_ZONE_5_WEIGHT = 34,
  COLOR_SETTING_SET_EXPOSURE_METERING_ZONE_6_WEIGHT = 35,
  COLOR_SETTING_SET_EXPOSURE_METERING_ZONE_7_WEIGHT = 36,
  COLOR_SETTING_SET_EXPOSURE_METERING_ZONE_8_WEIGHT = 37,
  COLOR_SETTING_SET_EXPOSURE_METERING_ZONE_9_WEIGHT = 38,
  COLOR_SETTING_SET_EXPOSURE_METERING_ZONE_10_WEIGHT = 39,
  COLOR_SETTING_SET_EXPOSURE_METERING_ZONE_11_WEIGHT = 40,
  COLOR_SETTING_SET_EXPOSURE_METERING_ZONE_12_WEIGHT = 41,
  COLOR_SETTING_SET_EXPOSURE_METERING_ZONE_13_WEIGHT = 42,
  COLOR_SETTING_SET_EXPOSURE_METERING_ZONE_14_WEIGHT = 43,
  COLOR_SETTING_SET_EXPOSURE_METERING_ZONE_15_WEIGHT = 44,
  COLOR_SETTING_SET_EXPOSURE_METERING_ZONE_16_WEIGHT = 45,
  COLOR_SETTING_SET_EXPOSURE_METERING_ZONE_17_WEIGHT = 46,
  COLOR_SETTING_SET_EXPOSURE_METERING_ZONE_18_WEIGHT = 47,
  COLOR_SETTING_SET_EXPOSURE_METERING_ZONE_19_WEIGHT = 48,
  COLOR_SETTING_SET_EXPOSURE_METERING_ZONE_20_WEIGHT = 49,
  COLOR_SETTING_SET_EXPOSURE_METERING_ZONE_21_WEIGHT = 50,
  COLOR_SETTING_SET_EXPOSURE_METERING_ZONE_22_WEIGHT = 51,
  COLOR_SETTING_SET_EXPOSURE_METERING_ZONE_23_WEIGHT = 52,
  COLOR_SETTING_SET_EXPOSURE_METERING_ZONE_24_WEIGHT = 53,
  COLOR_SETTING_SET_EXPOSURE_METERING_ZONE_25_WEIGHT = 54,
  COLOR_SETTING_SET_EXPOSURE_METERING_ZONE_26_WEIGHT = 55,
  COLOR_SETTING_SET_EXPOSURE_METERING_ZONE_27_WEIGHT = 56,
  COLOR_SETTING_SET_EXPOSURE_METERING_ZONE_28_WEIGHT = 57,
  COLOR_SETTING_SET_EXPOSURE_METERING_ZONE_29_WEIGHT = 58,
  COLOR_SETTING_SET_EXPOSURE_METERING_ZONE_30_WEIGHT = 59,
  COLOR_SETTING_SET_EXPOSURE_METERING_ZONE_31_WEIGHT = 60,
  COLOR_SETTING_SET_EXPOSURE_METERING_ZONE_32_WEIGHT = 61,
  COLOR_SETTING_SET_EXPOSURE_METERING_ZONE_33_WEIGHT = 62,
  COLOR_SETTING_SET_EXPOSURE_METERING_ZONE_34_WEIGHT = 63,
  COLOR_SETTING_SET_EXPOSURE_METERING_ZONE_35_WEIGHT = 64,
  COLOR_SETTING_SET_EXPOSURE_METERING_ZONE_36_WEIGHT = 65,
  COLOR_SETTING_SET_EXPOSURE_METERING_ZONE_37_WEIGHT = 66,
  COLOR_SETTING_SET_EXPOSURE_METERING_ZONE_38_WEIGHT = 67,
  COLOR_SETTING_SET_EXPOSURE_METERING_ZONE_39_WEIGHT = 68,
  COLOR_SETTING_SET_EXPOSURE_METERING_ZONE_40_WEIGHT = 69,
  COLOR_SETTING_SET_EXPOSURE_METERING_ZONE_41_WEIGHT = 70,
  COLOR_SETTING_SET_EXPOSURE_METERING_ZONE_42_WEIGHT = 71,
  COLOR_SETTING_SET_EXPOSURE_METERING_ZONE_43_WEIGHT = 72,
  COLOR_SETTING_SET_EXPOSURE_METERING_ZONE_44_WEIGHT = 73,
  COLOR_SETTING_SET_EXPOSURE_METERING_ZONE_45_WEIGHT = 74,
  COLOR_SETTING_SET_EXPOSURE_METERING_ZONE_46_WEIGHT = 75,
  COLOR_SETTING_SET_EXPOSURE_METERING_ZONE_47_WEIGHT = 76,
  COLOR_SETTING_SET_MAX_ANALOG_GAIN_CAP = 77,
  COLOR_SETTING_SET_MAX_DIGITAL_GAIN_CAP = 78,
  COLOR_SETTING_SET_FLICKER_FREE_FREQUENCY = 79,
  COLOR_SETTING_GET_EXPOSURE_MODE = 80,
  COLOR_SETTING_GET_WHITE_BALANCE_MODE = 81,
  COLOR_SETTING_SET_FRAME_RATE = 82,
  COLOR_SETTING_GET_FRAME_RATE = 83,
};

} /* namespace libfreenect2 */

#endif /* COLOR_SETTINGS_H_ */
