######
# Aim: create windows of XX SNPs
######

# ----- global variables, functions and packages ----- #
source("/Volumes/cluster/Claire/SO_PaperI/manuscript/scripts/global_variables.R")
source("/Volumes/cluster/Claire/SO_PaperI/manuscript/scripts/functions.R")

# ----- Load recombination map file
recomb_map <- fread(paste(path_recomb, "recomb_map_reformat.txt",sep=""), header=TRUE, sep = "\t")

# ----- set the window definition 
parents_all <- readRDS(paste(path_traj, "freq_cov_F20_29.RDS", sep = "")) 

windows_boundaries <- NULL
for(w_smooth in smoothed_size){ 
  print(w_smooth)
  for(chr in c("X", "2", "3")){
    print(chr)
    ind <- which(parents_all$CHROM_ALL == chr); idx <- ind[order(parents_all$POS_ALL[ind])]
    for(dist in c("cM", "bp")){ 
      if(dist == "cM"){
        pos <- unlist(subset(parents_all[idx, ], select = "cM_fit"))  
        off <- 0 #we start counting from 0cM          
      }else{ 
        pos <- unlist(subset(parents_all[idx, ], select = "POS_ALL")) 
        off <- 1 #we start counting from the 1st bp
      }
      posx2 <- c(); pos_right <- c(); pos_left <- c()
      spots <- seq(from = 1, to = (length(pos) - w_smooth + 1), by = w_smooth) #windows containing "w_smooth" SNPs 
      for(k in 1:(length(spots)-1)){
        posx2 <- c(posx2, (pos[spots[k]] + pos[spots[k+1]])/2) #mid of window
        pos_left <- c(pos_left, pos[spots[k]]) #left of window
        pos_right <- c(pos_right, pos[spots[k+1]]) #right of window
      }
      # fill up last window with usually <"w_smooth" SNPs
      tmp_pos_left <- pos[spots[length(spots)]]   
      ind <- which(pos>=tmp_pos_left)
      tmp_pos_right <- tail(pos[ind[1:(min(c(length(ind), w_smooth+1)))]], 1)
      pos_left <- c(pos_left, tmp_pos_left)
      pos_right <- c(pos_right, tmp_pos_right)
      posx2 <- c(posx2, (tmp_pos_left + tmp_pos_right)/2)
      ind <- which(pos>tmp_pos_right)
      if(length(ind)>0){
        pos_left <- c(pos_left, tmp_pos_right)
        pos_right <- c(pos_right, max(pos+1))
        posx2 <- c(posx2, (max(pos) + tmp_pos_right)/2)
      }else{
        pos_right[length(pos_right)] <- pos_right[length(pos_right)]+1              
      }
      windows_boundaries <- rbind(windows_boundaries, data.frame(wsmooth = rep(w_smooth, length(posx2)), unit = rep(dist, length(posx2)), chr = rep(chr, length(posx2)),
                                     pos_left = pos_left, pos_right = pos_right, pos_mean = posx2,
   							         nb_SNPs = sapply(1:length(pos_left), function(x) length(which(pos >= pos_left[x] & pos <pos_right[x]))), 
   							         size = pos_right-pos_left+off))
    }

  }
}
write.table(windows_boundaries, paste(path_list, "pos_window_GW_parents_nooverlap.txt", sep = ""), 
   			sep = "\t", col.names = T, row.names = F, quote = F)
