######
# Aim: perform MimicrEE2 neutral simulations
######

# ----- global variables, functions and packages ----- #
source("/Volumes/cluster/Claire/SO_PaperI/manuscript/scripts/global_variables.R")
source("/Volumes/cluster/Claire/SO_PaperI/manuscript/scripts/functions.R")

# --- generate hapmat file to create the founder population
all <- NULL
for(chr in c("2L", "2R", "3L", "3R", "X")){
  parent <- fread(paste(path_list, "chr", chr, "_parental.txt", sep = ""), sep = "\t", header = T)
  nb <- dim(parent)[1]
  starting_hapl <- data.frame(chr = parent$CHROM, pos = parent$POS, or = parent$or, 
  or_sam = paste(parent$or, "/", parent$sam, sep = ""), 
  geno = sapply(1:nb, function(x) paste0(c(rep(paste(parent$or[x], parent$or[x], sep = ""), 450), 
  rep(paste(parent$sam[x], parent$sam[x], sep = ""), 1050)), collapse = " ")))
  all <- rbind(all, starting_hapl)
}
write.table(all, paste(path_neutral_simu_29_F20, "hap_30_70_census.hapmat", sep = ""), col.names = F, row.names = F, sep = "\t", quote = F)
system(paste("cat ", path_neutral_simu_29_F20, "header_sex.txt ", path_neutral_simu_29_F20,
"hap_30_70_census.hapmat > ", path_neutral_simu_29_F20, "hap_30_70_noinit.hapmat", sep = ""))

# --- run neutral MimicrEE2 simulation
system("bash /Volumes/cluster/Claire/SO_PaperI/manuscript/scripts/mim_neutral_simulation.sh")