#!/bin/bash

path_simu_neutral="/Volumes/cluster/Claire/SO_PaperI/manuscript/results/neutral_simulation"
path_software="/Volumes/cluster/Claire/SO_PaperI/manuscript/software"; 
path_anno="/Volumes/cluster/Claire/SO_PaperI/manuscript/annotations"; 
path_simu="/Volumes/cluster/Claire/SO_PaperI/manuscript/results/simulation_with_selection"

suffix="6target"

nb_run=(1)
for run in ${nb_run[@]}; do
  java -Xmx30g -jar ${path_software}/mim2-v208.jar w --replicate-runs 10 --threads 8 \
  --haplotypes-g0 ${path_simu}/hap_30_70_noinit.hapmat  \
  --sex ${path_simu_neutral}/sex_info.txt \
  --snapshots 1,10,20,60 \
  --recombination-rate ${path_anno}/02_recombination_map_moving-median_Dmel_501k_version6.txt \
  --output-sync ${path_simu}/${suffix}_run${run}_v2.sync.gz \
  --fitness ${path_simu}/${suffix}_v2.txt 
done