#!/bin/bash

path_simu="/Volumes/cluster/Claire/SO_PaperI/manuscript/results/neutral_simulation"
path_software="/Volumes/cluster/Claire/SO_PaperI/manuscript/software"; 
path_anno="/Volumes/cluster/Claire/SO_PaperI/manuscript/annotations"; 

# ----- neutral simulations
nb_run=(1)
for run in ${nb_run[@]}; do
  java -Xmx30g -jar ${path_software}/mim2-v208.jar w --replicate-runs 10 --threads 8 \
  --haplotypes-g0 ${path_simu}/hap_30_70_noinit.hapmat  \
  --sex ${path_simu}/sex_info.txt \
  --snapshots 1,10,20 \
  --recombination-rate ${path_anno}/02_recombination_map_moving-median_Dmel_501k_version6.txt \
  --output-sync ${path_simu}/MassX_30_70_targets0_run${run}_s0.sync.gz \
  --fitness ${path_simu}/targets0_run1_h=NA_sO=0_sS=0.txt 
done