######
# Aims: check residual heterozygosity in each inbred parent
######

# ----- global variables, functions and packages ----- #
source("/Volumes/cluster/Claire/SO_PaperI/manuscript/scripts/global_variables.R")
source("/Volumes/cluster/Claire/SO_PaperI/manuscript/scripts/functions.R")

# ----- heterozygosity in each of the parent
info_all <- readRDS(paste(path_data_count, "chrall_DP_GT.RDS", sep = ""))
ind <- which(info_all$sam_AO_RO>=11 & info_all$or_AO_RO>=11 & info_all$sam_AO_RO<=68 & info_all$or_AO_RO<=68) 
info_all <- info_all[-ind, ] 
sam <- info_all[which(info_all$sam_GT == "0/1"), ]
or <- info_all[which(info_all$or_GT == "0/1"), ]
fr <- na.omit(rbind(data.frame(strain = "or", chr = or$CHROM, pos=or$POS, AF_alt=or$or_AO/or$or_AO_RO),
data.frame(strain = "sam", chr = sam$CHROM, pos=sam$POS, AF_alt=sam$or_AO/sam$or_AO_RO)))
write.table(fr, paste(path_list, "heterozyg_Sam_Or.txt", sep = ""), sep = "\t", col.names = T, row.names = F, quote = F)

fr_filt <- read.table(paste(path_list, "heterozyg_Sam_Or.txt", sep = ""), sep = "\t", h=TRUE)
tab <- table(fr_filt$chr, fr_filt$strain)
#      or sam
#  2L 376 472
#  2R 463 501
#  3L 483 429
#  3R 456 420
#  4   10   6
#  X  923 870