# ----- variables ----- #
chrom <- c("2L", "2R", "3L", "3R", "X", "4")
nb_samples <- 57
length <-matrix(c(23513712, 25286936, 28110227, 32079331, 1348131, 23542271), ncol = 6, 
nrow = 1, dimnames = list(NULL, c("2L", "2R", "3L", "3R", "4", "X")))
length_fullchr <-matrix(c(23513712+25286936, 28110227+32079331, 1348131, 23542271), ncol = 4, 
nrow = 1, dimnames = list(NULL, c("2", "3","4", "X")))
bp_sync  <- c("A", "T", "C", "G", "N", "del")
code <- matrix(1:6, nrow = 1, dimnames = list(NULL, bp_sync)) #sync file encoding
nb_SNPs_estimateNe <- 1000
nb_rounds_estimateNe <- 100
thresh <- 0.05
smoothed_size <- c(50, 250, 500, 750, 1000) #smoothing windows in #SNPs
start_or <- 0.3
census <- 1500
prefix_samples <- c(paste("F_020_R0", 1:9, "_B_29", sep = ""), "F_020_R10_B_29")

# ----- paths ----- #
project="/Volumes/cluster/Claire/SO_PaperI/manuscript/"

path_upload <- paste(project, "results/upload/", sep = "")
path_data_count <- paste(project, "results/counts/", sep = "")
path_list <- paste(project,"results/SNPs_list/", sep = "")
path_traj <- paste(project,"results/traj/", sep = "")
path_estimates_29_F20 <- paste(project,"results/estimates/", sep = "")
path_neutral_simu_29_F20 <- paste(project,"results/neutral_simulation/", sep = "")
path_plots_29_F20 <-paste(project,"results/plots/", sep = "")
path_recomb <- paste(project,"annotations/", sep = "")
path_parental_files <- paste(project, "results/processed_BAM_parents/", sep = "")
path_scripts <- paste(project, "scripts/", sep = "")
path_figures <- paste(project, "results/figures/", sep = "")
path_vcf_proc <- paste(project, "results/processed_vcf/", sep = "")
path_sync <- paste(project, "results/sync/", sep = "")