#!/bin/bash

# --- paths
project="/Volumes/cluster/Claire/SO_PaperI/manuscript/"
path_ref=${project}"annotations/"; 
path_software=${project}"software/"; 
path_processed_BAM=${project}"results/processed_BAM/";
path_sync=${project}"results/sync/";

files=("S_000_R00_X_RG" "O_000_R00_X_RG" "F_020_R01_B_29_RG" "F_020_R02_B_29_RG" "F_020_R03_B_29_RG")
files=("F_020_R04_B_29_RG" "F_020_R05_B_29_RG" "F_020_R06_B_29_RG" "F_020_R07_B_29_RG" "F_020_R08_B_29_RG")
files=("F_020_R09_B_29_RG" "F_020_R10_B_29_RG")
for f in ${files[@]}; do 
  ${path_software}samtools-1.10/samtools mpileup -BQ0 \
  -f ${path_ref}dmel6.03-clean.wMel_wRi_Lactobacillus_Acetobacter.fa \
  ${path_processed_BAM}${f}.bam > ${path_sync}${f}.mpileup &&\
  java -jar ${path_software}popoolation2/mpileup2sync.jar --input ${path_sync}${f}.mpileup  \
  --output ${path_sync}${f}.sync --min-qual 0 --fastq-type sanger --threads 6 &&\
  awk '$1 == "2L" {print $0}' ${path_sync}${f}.sync >${path_sync}2L_${f}.sync #&&\ 
  awk '$1 == "2R" {print $0}' ${path_sync}${f}.sync >${path_sync}2R_${f}.sync &&\ 
  awk '$1 == "3L" {print $0}' ${path_sync}${f}.sync >${path_sync}3L_${f}.sync &&\ 
  awk '$1 == "3R" {print $0}' ${path_sync}${f}.sync >${path_sync}3R_${f}.sync &&\ 
  awk '$1 == "X" {print $0}' ${path_sync}${f}.sync >${path_sync}X_${f}.sync &&\ 
  awk '$1 == "4" {print $0}' ${path_sync}${f}.sync >${path_sync}4_${f}.sync
done
