#!/bin/bash

# --- paths
project="/Volumes/cluster/Claire/SO_PaperI/manuscript/"; 
path_data=${project}"data/"; 
path_software=${project}"software/"; 
path_anno=${project}"annotations/"; 

##### demultiplexing command line

cd ${path_data}/Pool/
java -jar -Xmx8G ${path_software}ReadTools.jar AssignReadGroupByBarcode -bc ${path_data}/Pool/barcode.txt \
-I ${path_data}/Pool/pool.bam -O Pool --splitSample true --keepDiscarded true --forceOverwrite true

##### FastQC
cd ${path_software}FastQC-0.11.9/ 
for f in ${path_data}Pool/Pool_**.bam; do 
  fastqc ${f} -o ${path_data}/Pool/ -f bam ; 
done  

##### Trim reads
for f in ${path_data}Pool/Pool_**.bam; do #
  t="${f%.bam}"
  java -jar -Xmx8G ${path_software}ReadTools.jar TrimReads --input ${f} \
  --output ${t}_trimmed.bam --disable5pTrim --interleavedInput true --minReadLength 50 --mottQualityThreshold 18 
done  

##### Mapping reads
#cmd="distmap --hadoop-home /Volumes/cluster/hadoop-2.7.5/ --input \"Pool_trimmed_1.fq.gz,Pool_trimmed_2.fq.gz\" \
#--picard /Volumes/cluster/DistMap_v2.7.5/executables/picard-tools-2.1.0/picard.jar --readtools ${path_software}ReadTools.jar \
#--mapper novoalign --mapper-path ${path_software}novocraft-V3.09.00/novoalign \
#--mapper-args \"-i 250,75 -F STDFQ -r RANDOM\" \ 
#--reference-fasta ${path_anno}dmel6.03-clean.wMel_wRi_Lactobacillus_Acetobacter.fa \ 
#--no-trim --only-index --only-process --only-hdfs-upload --only-map --queue-name pg1 --job-desc \"Pool_trimmed\" \
#--output-format bam --output Pool_trimmed"
#eval $lg 2> Pool_trimmed/Pool_trimmed.out 

#distmap --hadoop-home /Volumes/cluster/hadoop-2.7.5/ --readtools /Volumes/Temp/ReadTools-1.5.2.jar  
#--reference-fasta ${path_anno}dmel6.03-clean.wMel_wRi_Lactobacillus_Acetobacter.fa 
#--input 'Pool_trimmed_1.fq.gz,Pool_trimmed_2.fq.gz' 
#--output Pool_trimmed --no-5p-trim  
#--mapper novoalign  --mapper-path ${path_software}novocraft-V3.09.00/novoalign  
#--mapper-args "-i 250,75 -F STDFQ -r RANDOM"  --picard /Volumes/cluster/DistMap_v2.7.5/executables/picard-tools-2.1.0/picard.jar 
#--output-format bam --queue-name pg3 --job-desc "Pool_trimmed_vn" --only-index --only-process --only-hdfs-upload --only-map