/* coeff.c 
   ======= */

/*
 LICENSE AND DISCLAIMER
 
 Copyright (c) 2012 The Johns Hopkins University/Applied Physics Laboratory
 
 This file is part of the Radar Software Toolkit (RST).
 
 RST is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 any later version.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with RST.  If not, see <http://www.gnu.org/licenses/>.
 
 
 
*/




struct {
  double coef[121][3][5][2];
} sph_harm_model= {
  {
    {
      {
        {2.61587290e-02,-2.10933560e-02},{-3.03028400e-02,1.74480090e-02},
        {3.01418140e-02,-1.04081550e-02},{-2.05068130e-02,3.37942510e-03},
        {6.47421370e-03,-3.11898110e-04}
      },
        {
        {1.20145980e-02,1.54252700e-02},{-2.89349990e-03,-1.90267380e-02},
        {-1.30951220e-02,1.92100320e-02},{2.03915920e-02,-1.33685480e-02},
        {-9.65676480e-03,4.18601870e-03}
      },
        {
        {-3.11359530e-02,3.31041060e-02},{4.08763990e-02,-3.16635690e-02},
        {-4.44255880e-02,3.11485060e-02},{4.35159650e-02,-1.91958540e-02},
        {-2.17278040e-02,5.27224450e-03}
      }
    },
    {
      {
        {-9.20593710e-01,9.41543680e-01},{-3.11564340e-02,7.68618760e-03},
        {4.00678200e-02,-1.74073770e-03},{-2.45803400e-02,-3.76840140e-03},
        {3.52028830e-03,2.38328080e-03}
      },
        {
        {3.02782070e-01,3.12726520e-01},{2.02946170e-02,-7.02938940e-03},
        {-2.37020460e-02,1.09822160e-02},{1.35848920e-02,-9.64830420e-03},
        {-2.15682320e-03,3.42663860e-03}
      },
        {
        {-1.54665530e-01,6.54458440e-02},{-2.31586110e-02,-7.83543970e-02},
        {1.75169200e-02,9.03349940e-02},{-3.54617960e-03,-6.24120670e-02},
        {-1.75043920e-03,1.88583210e-02}
      }
    },
    {
      {
        {-1.79890770e-01,5.32259200e-02},{8.45014100e-03,1.12287700e-03},
        {-1.88209350e-02,2.84558680e-03},{1.96978440e-02,-4.98914960e-03},
        {-7.61432780e-03,2.27407820e-03}
      },
        {
        {2.39218810e-03,-1.68500960e-01},{-7.92317830e-04,-1.74296240e-03},
        {-8.05810590e-03,2.72027490e-03},{1.62362320e-02,-2.05551660e-03},
        {-9.84933740e-03,6.00477830e-04}
      },
        {
        {9.88910250e-01,9.69381190e-01},{-1.59314130e-02,4.17224620e-02},
        {2.64572590e-02,-7.02864780e-02},{-1.30138060e-02,6.35918610e-02},
        {-3.46546710e-03,-2.28073640e-02}
      }
    },
    {
      {
        {-3.13778020e-01,-2.98387140e-01},{1.10904800e-02,-1.78679550e-02},
        {-1.23751930e-02,2.34589560e-02},{9.84292100e-03,-1.82436530e-02},
        {-4.31105530e-03,6.02117530e-03}
      },
        {
        {-9.49896230e-01,9.52999270e-01},{-1.80641410e-02,-3.04492560e-02},
        {4.73133090e-02,3.93163700e-02},{-4.66858300e-02,-3.09509690e-02},
        {1.51024750e-02,1.04622190e-02}
      },
        {
        {2.25745810e-02,1.41619600e-01},{-1.44302330e-01,4.48344440e-02},
        {1.86990330e-01,-5.51427460e-02},{-1.67216130e-01,4.03074140e-02},
        {6.73516310e-02,-1.26812730e-02}
      }
    },
    {
      {
        {-1.57818510e-03,-7.76555360e-04},{4.01084210e-03,1.29739200e-04},
        {-7.64281110e-03,8.31725610e-04},{7.64985930e-03,-9.24423690e-04},
        {-2.91352210e-03,3.45450170e-04}
      },
        {
        {3.16523640e-03,3.36441480e-03},{-3.45902110e-03,-2.52495860e-03},
        {1.88465500e-03,2.12133040e-03},{3.87680240e-04,-1.13681790e-03},
        {-6.21515190e-04,2.83599940e-04}
      },
        {
        {-4.19975340e-04,-1.49239360e-02},{-3.80812540e-03,9.40145570e-03},
        {1.37769100e-02,-3.88571760e-03},{-1.65303260e-02,-1.46867630e-03},
        {6.64999370e-03,1.41827010e-03}
      }
    },
    {
      {
        {7.40667390e-03,-3.68361640e-02},{-6.54216140e-03,3.75805450e-02},
        {4.96869140e-03,-3.04884120e-02},{-2.60889080e-03,1.60641860e-02},
        {6.26016570e-04,-3.86774810e-03}
      },
        {
        {-8.16403920e-03,2.53265570e-03},{1.13258940e-02,-5.83876630e-03},
        {-1.27034200e-02,7.86335300e-03},{8.93915240e-03,-5.86095390e-03},
        {-2.73004190e-03,1.81215650e-03}
      },
        {
        {2.23546360e-02,1.57435060e-03},{-2.84831280e-02,2.70867990e-02},
        {2.68582220e-02,-5.91127460e-02},{-1.37238230e-02,5.68044640e-02},
        {2.44798960e-03,-2.06750790e-02}
      }
    },
    {
      {
        {5.35809080e-02,-4.14642580e-02},{-6.32517910e-02,5.18810920e-02},
        {7.08450890e-02,-5.52799290e-02},{-5.73289960e-02,4.04664850e-02},
        {2.11087290e-02,-1.30998270e-02}
      },
        {
        {2.99681280e-02,3.93719880e-02},{-5.63497240e-02,-3.99229900e-02},
        {8.11403280e-02,3.69219250e-02},{-6.27505900e-02,-2.39664660e-02},
        {1.70397480e-02,7.18452520e-03}
      },
        {
        {5.51736610e-02,-3.13607650e-02},{-7.85626700e-02,2.11670320e-02},
        {7.56538640e-02,-1.83662350e-02},{-3.30997390e-02,5.81616740e-03},
        {-3.84112860e-03,2.35250570e-04}
      }
    },
    {
      {
        {-1.15342760e-02,8.35821660e-03},{7.94818910e-03,-7.26342800e-03},
        {4.73984200e-04,3.38653800e-03},{-5.19421890e-03,3.68757950e-04},
        {2.38340970e-03,-7.39277320e-04}
      },
        {
        {-4.09566430e-02,2.02335580e-02},{4.66467820e-02,-2.15919860e-02},
        {-4.23400050e-02,2.01439880e-02},{2.42149940e-02,-1.32391670e-02},
        {-5.52545160e-03,4.01772040e-03}
      },
        {
        {1.35092040e-02,-1.71718400e-02},{-1.66233360e-03,1.56757850e-02},
        {-2.23304240e-02,-8.97739360e-03},{2.38009390e-02,1.78207350e-03},
        {-4.95737620e-03,4.24865570e-04}
      }
    },
    {
      {
        {7.01244760e-04,-1.39754010e-03},{2.46833850e-03,3.22747290e-03},
        {-6.44805210e-03,-4.93366150e-03},{6.66157670e-03,4.20590540e-03},
        {-2.51297380e-03,-1.43824820e-03}
      },
        {
        {-3.64823620e-03,1.14251150e-03},{1.21427480e-02,-3.48705170e-04},
        {-2.34557390e-02,-5.53409900e-04},{2.32065400e-02,9.72798100e-04},
        {-8.85956710e-03,-4.37058960e-04}
      },
        {
        {-2.68378350e-02,-2.22233100e-02},{2.25024450e-02,1.25946740e-02},
        {-1.49836180e-02,-5.16672650e-03},{1.36226960e-02,-1.11531270e-03},
        {-7.45904750e-03,1.33011200e-03}
      }
    },
    {
      {
        {3.98259610e-05,-7.91684990e-05},{-1.76038970e-04,5.34617810e-04},
        {3.75478630e-04,-1.20794640e-03},{-3.88665690e-04,1.23908630e-03},
        {1.50257320e-04,-4.71837870e-04}
      },
        {
        {-4.05015300e-04,-3.58661180e-04},{7.55018240e-04,4.67375240e-04},
        {-7.89725700e-04,-6.08858620e-04},{4.23399850e-04,4.64642700e-04},
        {-8.10565760e-05,-1.50839210e-04}
      },
        {
        {1.20135930e-03,-6.88630150e-04},{-6.46786490e-04,6.55464750e-04},
        {-1.68133640e-03,-1.00298600e-03},{2.56108340e-03,9.08789140e-04},
        {-1.01217160e-03,-3.33423030e-04}
      }
    },
    {
      {
        {4.40692400e-04,4.56517370e-03},{-1.00279530e-03,-8.51324390e-03},
        {1.37701370e-03,1.00708300e-02},{-1.15366350e-03,-7.07408540e-03},
        {4.20696910e-04,2.15346920e-03}
      },
        {
        {2.21781340e-03,6.45717680e-05},{-4.58848310e-03,-3.08298950e-05},
        {5.57816840e-03,-9.09471690e-05},{-3.87626830e-03,6.94936500e-05},
        {1.14723320e-03,-1.04760320e-05}
      },
        {
        {-1.64861660e-03,-2.23219480e-03},{4.64076660e-03,2.88451310e-03},
        {-5.38945400e-03,-1.73867800e-03},{2.38858580e-03,2.92120240e-04},
        {-1.16836100e-04,1.04133510e-04}
      }
    },
    {
      {
        {1.01729450e-02,-2.05241820e-03},{-2.13643390e-02,7.35628770e-03},
        {2.86525350e-02,-1.15120400e-02},{-2.28149180e-02,1.02643320e-02},
        {7.65049800e-03,-3.68794270e-03}
      },
        {
        {-1.15721340e-03,7.63370990e-03},{2.10481650e-03,-1.20629500e-02},
        {-2.37802870e-03,1.46718370e-02},{1.75064980e-03,-1.07527740e-02},
        {-5.94354210e-04,3.40594860e-03}
      },
        {
        {-2.25749980e-03,-1.58508120e-02},{1.85545500e-03,2.44525020e-03},
        {7.16115580e-04,4.20839630e-03},{-1.89542160e-03,-8.17258050e-03},
        {7.82789810e-04,3.78581020e-03}
      }
    },
    {
      {
        {-1.39062440e-02,4.61147580e-02},{2.45294550e-02,-8.52015010e-02},
        {-2.29463370e-02,1.00080010e-01},{9.69170280e-03,-7.00603930e-02},
        {-2.93652460e-04,2.13047110e-02}
      },
        {
        {-4.31865030e-02,-1.25824540e-02},{8.76780030e-02,2.79080370e-02},
        {-1.18532030e-01,-3.87382190e-02},{1.05392090e-01,3.08270520e-02},
        {-4.28335450e-02,-1.02142910e-02}
      },
        {
        {-1.02231730e-02,8.21365590e-03},{5.11947400e-02,-3.79220000e-02},
        {-1.43245940e-01,7.36923470e-02},{1.92792910e-01,-6.98819030e-02},
        {-9.79530110e-02,2.54405650e-02}
      }
    },
    {
      {
        {-3.10952770e-03,3.45250370e-03},{8.76783960e-03,-7.52770240e-03},
        {-1.51045970e-02,9.62338810e-03},{1.47052460e-02,-7.50197730e-03},
        {-5.83374270e-03,2.50041490e-03}
      },
        {
        {-1.46871170e-03,5.93485070e-03},{7.83951100e-03,-1.67521530e-02},
        {-1.51851380e-02,2.37984890e-02},{1.20350400e-02,-1.97115180e-02},
        {-2.53427990e-03,6.75459940e-03}
      },
        {
        {-2.09090860e-02,1.12789410e-02},{4.09088460e-02,-7.52629340e-03},
        {-5.93102730e-02,8.38363010e-03},{4.95746980e-02,-5.41512530e-03},
        {-1.44298700e-02,1.52782790e-03}
      }
    },
    {
      {
        {2.77953890e-03,2.81931180e-03},{-5.66170140e-03,-4.72157430e-03},
        {7.29280930e-03,4.98251440e-03},{-5.73614420e-03,-3.13945350e-03},
        {1.95995280e-03,8.75668500e-04}
      },
        {
        {4.05830020e-03,-1.05682840e-03},{-8.21185630e-03,2.71110940e-03},
        {1.05038170e-02,-3.87081360e-03},{-8.07997930e-03,3.10764390e-03},
        {2.60879230e-03,-1.03213580e-03}
      },
        {
        {-2.46138120e-03,-5.22542540e-04},{1.64391680e-03,-1.67567600e-03},
        {3.70210970e-03,5.53636380e-03},{-5.79383730e-03,-6.09067230e-03},
        {2.07361670e-03,2.35573240e-03}
      }
    },
    {
      {
        {4.01691970e-05,3.11237850e-05},{-2.08683120e-04,-1.88572370e-04},
        {4.35062090e-04,3.41704640e-04},{-4.33129510e-04,-3.39748700e-04},
        {1.62366270e-04,1.29504050e-04}
      },
        {
        {6.64593600e-04,-5.45667010e-04},{-2.19998560e-03,5.67709230e-04},
        {4.00144910e-03,-4.98382760e-04},{-3.80106200e-03,2.33938510e-04},
        {1.41302920e-03,-4.37879180e-05}
      },
        {
        {2.75744280e-03,2.81538070e-03},{-5.90008840e-03,-3.10989130e-03},
        {9.62751590e-03,3.39653900e-03},{-9.77484600e-03,-2.20947160e-03},
        {4.01149860e-03,6.36815950e-04}
      }
    },
    {
      {
        {5.25914280e-06,-3.25241300e-05},{-3.18002310e-05,8.35736060e-05},
        {7.27927500e-05,-1.18285450e-04},{-7.66147160e-05,9.48501810e-05},
        {2.95720580e-05,-3.17664300e-05}
      },
        {
        {-1.45345440e-05,-9.57387870e-07},{4.37235790e-05,-4.69767420e-06},
        {-8.22583980e-05,2.12375230e-05},{8.00571990e-05,-2.36876370e-05},
        {-3.05259890e-05,8.87088390e-06}
      },
        {
        {-1.77087930e-04,1.18863860e-04},{3.20885510e-04,-9.35501470e-05},
        {-3.60482830e-04,3.47494370e-05},{2.94466400e-04,3.31490700e-05},
        {-1.18599440e-04,-2.40983920e-05}
      }
    },
    {
      {
        {1.22477600e-04,-2.89288930e-04},{-1.42689120e-04,7.92089420e-04},
        {1.50660240e-04,-1.34432260e-03},{-9.06205380e-05,1.22568800e-03},
        {1.95086710e-05,-4.40603850e-04}
      },
        {
        {-2.17201480e-04,-3.47286620e-04},{5.78164700e-04,8.04836920e-04},
        {-7.76131920e-04,-1.15544890e-03},{5.61120980e-04,9.40725050e-04},
        {-1.69221930e-04,-3.15582620e-04}
      },
        {
        {8.98175610e-05,1.59646520e-05},{-1.55765390e-04,-2.23446010e-05},
        {-2.13617410e-04,-7.31503030e-05},{6.13581510e-04,1.58510240e-04},
        {-3.35145410e-04,-8.05876160e-05}
      }
    },
    {
      {
        {-4.85813430e-04,-1.23372900e-03},{3.04107520e-04,1.98412350e-03},
        {-1.55264290e-04,-2.80756730e-03},{8.54524090e-05,2.34801080e-03},
        {-3.30892580e-05,-8.07800550e-04}
      },
        {
        {-6.88958260e-04,2.32461560e-04},{9.42128150e-04,-1.09602670e-03},
        {-1.22944080e-03,1.74564680e-03},{1.01389100e-03,-1.57334320e-03},
        {-3.46406430e-04,5.65445130e-04}
      },
        {
        {-1.55101940e-04,4.57698310e-04},{1.63021220e-03,1.25100200e-03},
        {-3.60608680e-03,-2.09539040e-03},{3.35644860e-03,2.06790780e-03},
        {-1.12673770e-03,-7.88316130e-04}
      }
    },
    {
      {
        {1.43044960e-03,7.58439630e-03},{-8.55188270e-03,-1.40894230e-02},
        {1.64097880e-02,1.77166480e-02},{-1.56587640e-02,-1.25513210e-02},
        {5.80888060e-03,3.81630860e-03}
      },
        {
        {-4.84025130e-05,-1.71515740e-03},{4.00985810e-03,3.69119400e-03},
        {-9.83741620e-03,-4.45974520e-03},{1.06840000e-02,2.85707670e-03},
        {-4.23755690e-03,-7.50804760e-04}
      },
        {
        {-1.06658110e-03,3.70597330e-03},{1.02031320e-03,-1.05531100e-02},
        {5.50683890e-03,1.56161330e-02},{-1.17523070e-02,-1.19516060e-02},
        {6.25745820e-03,3.67051820e-03}
      }
    },
    {
      {
        {-7.93186800e-03,-1.65716360e-02},{1.23128200e-02,4.75186730e-02},
        {-1.63695260e-02,-8.05682950e-02},{1.09971610e-02,7.29820410e-02},
        {-2.07131490e-03,-2.61268040e-02}
      },
        {
        {9.40269330e-03,-8.11398840e-03},{-2.80940430e-02,1.47750330e-02},
        {4.20619240e-02,-2.47498910e-02},{-2.55563750e-02,2.15035950e-02},
        {1.79694100e-03,-7.50425740e-03}
      },
        {
        {-3.30386880e-03,6.70214910e-03},{2.14569480e-03,3.55966590e-02},
        {-3.94251390e-02,-6.35530620e-02},{1.07578850e-01,6.23719540e-02},
        {-7.54828710e-02,-2.36320090e-02}
      }
    },
    {
      {
        {1.01289890e-03,-3.62296730e-03},{-1.43924530e-03,8.06844790e-03},
        {-1.16334070e-04,-1.10551620e-02},{1.94086920e-03,8.40441940e-03},
        {-1.29960500e-03,-2.67772360e-03}
      },
        {
        {4.10234480e-03,1.69420530e-03},{-8.09182220e-03,-8.55884650e-03},
        {1.34161550e-02,1.55317190e-02},{-1.68384500e-02,-1.41807480e-02},
        {9.13454460e-03,5.04808800e-03}
      },
        {
        {-3.95345850e-04,-8.97582950e-04},{-9.57166220e-03,2.83307790e-03},
        {3.98706360e-02,-6.90931200e-03},{-6.02261730e-02,7.69468620e-03},
        {3.20654250e-02,-3.08228900e-03}
      }
    },
    {
      {
        {-3.45299380e-05,-1.20780300e-03},{8.90305590e-04,3.02337670e-03},
        {-2.16813990e-03,-4.90450550e-03},{2.25570200e-03,4.35367050e-03},
        {-8.42805070e-04,-1.54622370e-03}
      },
        {
        {-1.14267620e-03,-2.69699800e-04},{2.48446240e-03,-4.01162980e-04},
        {-4.16978890e-03,1.20815710e-03},{4.07904120e-03,-1.30790390e-03},
        {-1.65541030e-03,5.06916940e-04}
      },
        {
        {-4.32007810e-05,-4.36432440e-05},{1.58194000e-03,3.08853120e-03},
        {-1.68795180e-03,-4.67175490e-03},{3.10268100e-05,4.22889780e-03},
        {2.57441080e-04,-1.53452340e-03}
      }
    },
    {
      {
        {-2.41636010e-04,-2.12577920e-04},{7.39804120e-04,6.76683640e-04},
        {-1.28554430e-03,-1.01624110e-03},{1.21472860e-03,8.12282100e-04},
        {-4.55786030e-04,-2.66610080e-04}
      },
        {
        {1.41508730e-04,8.98595210e-05},{-3.41279070e-04,-4.34865720e-04},
        {5.90222700e-04,7.81836680e-04},{-5.08002430e-04,-6.93317520e-04},
        {1.69671820e-04,2.41113410e-04}
      },
        {
        {-1.76855220e-06,-4.33640990e-05},{2.65094000e-04,9.33594330e-05},
        {-7.33689050e-04,-7.62403820e-05},{7.46964870e-04,-1.16176570e-05},
        {-2.53787720e-04,2.78924850e-05}
      }
    },
    {
      {
        {1.24544720e-05,-1.87979460e-06},{-1.71523990e-05,4.36918850e-06},
        {2.18425710e-05,-1.40770910e-05},{-1.72217710e-05,1.98143380e-05},
        {5.18277430e-06,-9.08034940e-06}
      },
        {
        {-5.17787690e-05,5.76186840e-05},{1.46587560e-04,-6.59926670e-05},
        {-2.21494780e-04,1.02409150e-04},{1.83381080e-04,-8.56970880e-05},
        {-6.31951860e-05,2.91557400e-05}
      },
        {
        {-5.65069570e-05,-1.70707450e-04},{1.21743690e-04,3.12881320e-04},
        {-3.30234160e-04,-4.69596730e-04},{5.08823420e-04,3.76848790e-04},
        {-2.61025000e-04,-1.22426120e-04}
      }
    },
    {
      {
        {6.11063200e-07,2.58718590e-06},{4.32502450e-07,-8.48913030e-06},
        {-5.62562610e-06,1.47046710e-05},{8.45764790e-06,-1.30727130e-05},
        {-3.84463540e-06,4.58250250e-06}
      },
        {
        {2.22419030e-06,1.46017460e-06},{-5.62021370e-06,-2.48784680e-07},
        {5.45486470e-06,-2.82624590e-07},{-1.67958880e-06,6.54667070e-07},
        {-1.77352530e-07,-3.10217120e-07}
      },
        {
        {-3.55708960e-06,3.54773820e-07},{2.30586770e-05,-3.25641050e-06},
        {-3.75446800e-05,8.96599290e-06},{2.23585500e-05,-9.75973270e-06},
        {-3.33860850e-06,3.75009980e-06}
      }
    },
    {
      {
        {-9.90059900e-06,1.38780600e-05},{1.96533700e-05,-4.55019580e-05},
        {-1.90588290e-05,8.01405570e-05},{5.97802610e-06,-7.52133220e-05},
        {1.10347310e-06,2.75494900e-05}
      },
        {
        {-1.19378490e-05,5.84762470e-06},{5.52259030e-05,-1.63621480e-05},
        {-1.23123510e-04,2.25589800e-05},{1.28324320e-04,-1.63375770e-05},
        {-4.93312180e-05,4.86778130e-06}
      },
        {
        {-7.86266520e-06,3.66372700e-06},{1.33433150e-05,-4.81028410e-06},
        {2.04529260e-05,7.34189820e-06},{-5.49415230e-05,-8.64470100e-06},
        {2.94475790e-05,3.90172980e-06}
      }
    },
    {
      {
        {2.33794700e-05,-4.00641050e-05},{-4.21308050e-05,1.47298490e-04},
        {7.76171190e-05,-2.72589680e-04},{-8.21105650e-05,2.56925090e-04},
        {3.26220310e-05,-9.38516980e-05}
      },
        {
        {4.44705710e-06,-3.03580440e-05},{-1.11479540e-05,1.09258650e-04},
        {5.28097250e-05,-1.47984710e-04},{-7.54590890e-05,1.19257010e-04},
        {3.35282060e-05,-4.04559110e-05}
      },
        {
        {3.94080630e-05,3.43873330e-05},{-3.11840260e-04,5.90282780e-05},
        {5.82505960e-04,-7.71774740e-05},{-4.45729570e-04,6.02989790e-05},
        {1.18051810e-04,-1.97381650e-05}
      }
    },
    {
      {
        {3.09060410e-04,-2.49844140e-04},{-8.65888620e-04,4.11687360e-04},
        {1.40979140e-03,-5.93709660e-04},{-1.19425460e-03,4.43345040e-04},
        {3.94876520e-04,-1.38290100e-04}
      },
        {
        {-1.39347640e-04,-2.21470120e-04},{-1.89145500e-04,6.88164260e-04},
        {1.13831610e-03,-1.16568560e-03},{-1.52153260e-03,1.09436380e-03},
        {6.53236480e-04,-4.05275640e-04}
      },
        {
        {4.12114760e-04,-8.18455040e-05},{-8.53478370e-04,2.80109200e-04},
        {-8.30702590e-05,-4.04934750e-04},{1.50487680e-03,2.89495330e-04},
        {-9.56178280e-04,-8.00325830e-05}
      }
    },
    {
      {
        {1.69323940e-04,-3.48388540e-03},{-5.63777690e-04,1.16436880e-02},
        {2.37889840e-04,-2.29370210e-02},{2.74711120e-04,2.22594930e-02},
        {-2.09698220e-04,-8.25029470e-03}
      },
        {
        {9.10727270e-05,5.38127830e-04},{-1.58537880e-03,-3.73538250e-03},
        {3.80452580e-03,5.76287300e-03},{-3.92009020e-03,-4.96854030e-03},
        {1.48710100e-03,1.73500750e-03}
      },
        {
        {3.80361360e-04,-3.44346330e-04},{1.75120780e-03,1.82636310e-02},
        {-3.51048500e-03,-2.48804040e-02},{2.13469170e-03,1.98843490e-02},
        {-3.11932120e-04,-6.65075520e-03}
      }
    },
    {
      {
        {5.26794770e-03,-7.01143380e-03},{-1.39061420e-02,9.46486440e-03},
        {2.46033820e-02,-1.19292880e-02},{-2.67526200e-02,8.08882700e-03},
        {1.22030460e-02,-2.34929810e-03}
      },
        {
        {6.56428130e-03,2.85283000e-03},{-1.52228060e-02,-7.88822440e-03},
        {2.16841340e-02,1.42402640e-02},{-1.34616370e-02,-1.27399880e-02},
        {5.21748130e-04,4.48055400e-03}
      },
        {
        {-5.68186770e-03,2.10753840e-04},{-1.99946880e-02,1.71809380e-03},
        {5.59474530e-02,-4.41070190e-03},{-2.62072570e-02,2.73482250e-03},
        {-1.38913030e-02,-4.55610390e-04}
      }
    },
    {
      {
        {1.62588970e-03,6.19853460e-04},{-3.82055180e-03,-1.36128410e-03},
        {4.68071050e-03,2.34484430e-03},{-2.69869830e-03,-2.01076750e-03},
        {3.48370780e-04,6.78098600e-04}
      },
        {
        {-3.53761760e-04,8.06508480e-04},{3.26800700e-03,-1.82498700e-03},
        {-5.95577990e-03,5.31324190e-03},{1.31912310e-03,-5.96851940e-03},
        {2.42434590e-03,2.37693050e-03}
      },
        {
        {-1.39215760e-05,1.67468870e-04},{-2.61427030e-03,-1.05387760e-02},
        {2.68715380e-02,1.42264460e-02},{-5.38508100e-02,-1.12973880e-02},
        {3.26023970e-02,3.76713400e-03}
      }
    },
    {
      {
        {-2.05632240e-06,-1.18746970e-04},{-2.73716840e-04,1.49370350e-04},
        {7.47677520e-04,-3.16725940e-04},{-8.17502100e-04,3.23661270e-04},
        {3.27992780e-04,-1.25797220e-04}
      },
        {
        {-9.94988860e-05,3.97731480e-04},{3.10192190e-04,-9.98881350e-04},
        {-1.01598850e-03,1.31120280e-03},{1.73837430e-03,-9.71220750e-04},
        {-1.01319300e-03,3.03318850e-04}
      },
        {
        {2.50933950e-04,-9.38806390e-05},{8.02779210e-04,4.69712450e-04},
        {-3.89984600e-03,-7.80692960e-04},{5.80299850e-03,5.95350840e-04},
        {-3.02265120e-03,-1.74578860e-04}
      }
    },
    {
      {
        {3.23736110e-05,1.14889160e-04},{-1.42772360e-04,-3.13780440e-04},
        {3.11079310e-04,5.28067210e-04},{-3.16675830e-04,-4.74461090e-04},
        {1.18665550e-04,1.69066190e-04}
      },
        {
        {1.40769440e-05,-3.64333430e-05},{-7.24719800e-05,2.07796470e-04},
        {1.81368740e-04,-3.72773400e-04},{-2.01118100e-04,3.51685730e-04},
        {8.43450320e-05,-1.29309680e-04}
      },
        {
        {-3.94262500e-05,-4.17052620e-05},{1.73605890e-04,-3.16795230e-04},
        {-6.59468620e-04,4.47390630e-04},{8.76325650e-04,-3.64167110e-04},
        {-3.70954990e-04,1.22389480e-04}
      }
    },
    {
      {
        {4.40243030e-06,2.97699180e-06},{-1.08299030e-05,-1.26092090e-05},
        {2.27143560e-05,2.24843050e-05},{-2.69031990e-05,-1.98035590e-05},
        {1.17725960e-05,6.89484310e-06}
      },
        {
        {-1.33302370e-05,6.68942520e-06},{3.77113270e-05,-5.37332750e-06},
        {-5.27314400e-05,-1.28277660e-05},{3.45400380e-05,2.24583680e-05},
        {-8.30440860e-06,-1.01207410e-05}
      },
        {
        {-3.49514950e-06,-7.24538620e-07},{-2.86011820e-05,1.85264450e-05},
        {7.54863940e-05,-5.10676570e-05},{-7.05471690e-05,5.71774510e-05},
        {2.23692180e-05,-2.28962590e-05}
      }
    },
    {
      {
        {-1.33210360e-06,4.84377210e-07},{3.76566910e-06,-3.32856950e-06},
        {-5.99492800e-06,4.82688650e-06},{5.01409140e-06,-3.73225160e-06},
        {-1.64180010e-06,1.17691160e-06}
      },
        {
        {1.05719000e-06,-3.79293750e-06},{-5.73814750e-07,9.63171080e-06},
        {-3.58386680e-06,-1.94001370e-05},{5.39429670e-06,1.89457100e-05},
        {-2.11550970e-06,-7.04335600e-06}
      },
        {
        {-8.55044480e-07,1.71649350e-06},{2.66111300e-06,-1.22244660e-05},
        {4.36649680e-06,2.40072950e-05},{-1.33933820e-05,-2.26608400e-05},
        {7.77743140e-06,8.16337330e-06}
      }
    },
    {
      {
        {2.43610090e-09,-1.42699190e-07},{-2.24568350e-07,4.71463140e-07},
        {7.61313610e-07,-1.00952450e-06},{-9.03885460e-07,1.00987680e-06},
        {3.65574080e-07,-3.77796410e-07}
      },
        {
        {-1.40116240e-07,-2.19328090e-07},{2.99233310e-07,4.55198610e-07},
        {1.86179080e-08,-9.11225370e-07},{-4.41675050e-07,8.88292930e-07},
        {2.60907250e-07,-3.30532700e-07}
      },
        {
        {3.71166610e-07,3.48330830e-07},{-2.08332270e-06,-1.24378340e-06},
        {4.19575860e-06,2.65780560e-06},{-3.88123300e-06,-2.76170940e-06},
        {1.31202300e-06,1.08037960e-06}
      }
    },
    {
      {
        {-6.12488430e-08,-1.22039520e-06},{1.09896000e-06,4.76351660e-06},
        {-3.95274780e-06,-8.96465660e-06},{5.36325820e-06,8.65380180e-06},
        {-2.43706190e-06,-3.23602080e-06}
      },
        {
        {1.17455920e-06,-1.98827720e-07},{-5.90890830e-06,1.80291120e-06},
        {1.31188500e-05,-5.08159330e-06},{-1.35070880e-05,5.93193260e-06},
        {5.14265540e-06,-2.45752330e-06}
      },
        {
        {2.06075330e-07,-3.01907240e-07},{1.40519460e-06,8.62783470e-07},
        {-5.54279650e-06,-1.09746280e-06},{7.16266310e-06,6.68096310e-07},
        {-3.15971330e-06,-1.57035680e-07}
      }
    },
    {
      {
        {2.23528560e-06,-1.43866290e-06},{-5.26954980e-06,5.68853560e-06},
        {4.92045530e-06,-1.13365680e-05},{-2.22534860e-06,1.15770950e-05},
        {4.15497270e-07,-4.52706720e-06}
      },
        {
        {2.64916690e-07,-2.14973360e-06},{8.76466210e-07,7.78637920e-06},
        {-8.32314430e-06,-1.53451890e-05},{1.27971440e-05,1.48332510e-05},
        {-5.82196040e-06,-5.46540570e-06}
      },
        {
        {-2.88958840e-06,1.91301210e-06},{2.43506350e-05,-2.42809400e-05},
        {-3.52023880e-05,3.67226310e-05},{1.64862850e-05,-2.97721690e-05},
        {-2.33051790e-07,9.78091100e-06}
      }
    },
    {
      {
        {1.51238400e-06,1.01689710e-05},{1.72701610e-05,-4.49438760e-05},
        {-3.96688950e-05,7.11664160e-05},{3.12537570e-05,-5.46608020e-05},
        {-7.92140460e-06,1.60584500e-05}
      },
        {
        {-2.52201850e-06,4.82971920e-06},{6.35977970e-05,-1.40890590e-06},
        {-1.87448920e-04,-4.12965850e-05},{2.17676420e-04,6.52418650e-05},
        {-8.83267300e-05,-2.98163970e-05}
      },
        {
        {-2.86929440e-05,1.84333170e-05},{1.11010170e-05,-8.04916810e-05},
        {1.34859830e-04,1.81143460e-04},{-2.44481950e-04,-1.97050130e-04},
        {1.20985510e-04,7.88626670e-05}
      }
    },
    {
      {
        {-9.34245330e-05,2.75375640e-05},{5.96217090e-05,4.35987440e-05},
        {2.08812220e-04,1.22287710e-06},{-3.83095520e-04,-1.52457630e-05},
        {1.80794240e-04,2.88249600e-06}
      },
        {
        {-6.58110350e-05,7.82477550e-05},{1.82255340e-04,-1.15247230e-04},
        {-3.32116840e-04,3.96352620e-04},{3.01168720e-04,-4.62710080e-04},
        {-1.07696060e-04,1.86694720e-04}
      },
        {
        {5.92609010e-05,1.85446030e-04},{-5.96656810e-04,-1.06285390e-03},
        {8.17088340e-04,1.08736600e-03},{-2.81708390e-04,-6.62718480e-04},
        {-6.96667710e-05,1.76303740e-04}
      }
    },
    {
      {
        {4.97214430e-04,2.01428880e-03},{-3.04878200e-03,-9.88833520e-03},
        {6.87169510e-03,2.05063110e-02},{-7.03760900e-03,-2.07176190e-02},
        {2.66018790e-03,7.89510190e-03}
      },
        {
        {1.79913240e-04,-5.99051640e-05},{-4.32007730e-04,1.10079860e-04},
        {1.22813280e-03,-6.69493960e-04},{-1.47317420e-03,9.95204150e-04},
        {6.20998550e-04,-4.55433050e-04}
      },
        {
        {7.31919630e-05,2.00840030e-03},{1.27699540e-03,-7.74215780e-03},
        {-7.40960490e-03,1.56418300e-02},{1.16413580e-02,-1.59475240e-02},
        {-5.70102550e-03,6.14313720e-03}
      }
    },
    {
      {
        {-2.30090000e-04,4.62162340e-03},{-4.64207740e-04,-2.97312650e-03},
        {-1.64885290e-03,6.73420600e-03},{-3.35035120e-05,-6.27917260e-03},
        {1.81481430e-03,2.09865840e-03}
      },
        {
        {3.12598760e-03,-5.24832420e-03},{-7.06259940e-03,2.10243800e-02},
        {5.19374620e-03,-3.71082320e-02},{2.12386230e-03,3.47032920e-02},
        {-4.26053000e-03,-1.27102810e-02}
      },
        {
        {-6.68569000e-03,5.68614820e-03},{1.65453950e-02,-5.34052600e-02},
        {-1.44575590e-02,6.37225110e-02},{2.25236060e-02,-4.40687950e-02},
        {-2.22468920e-02,1.30092590e-02}
      }
    },
    {
      {
        {4.51525170e-05,-3.98362280e-04},{-8.69706210e-04,2.32180610e-03},
        {1.85199080e-03,-4.92633570e-03},{-7.80176480e-04,5.06991040e-03},
        {-3.61851040e-04,-1.95676910e-03}
      },
        {
        {1.01147600e-03,1.31716030e-04},{-4.39563590e-03,-1.89692670e-03},
        {1.01539080e-02,3.66441000e-03},{-1.29557210e-02,-3.59815490e-03},
        {6.95981550e-03,1.35302490e-03}
      },
        {
        {1.97331090e-03,-2.27821680e-04},{1.17198790e-04,1.00198720e-04},
        {-2.28939110e-04,5.56152820e-04},{-1.21660310e-02,-9.57591180e-04},
        {1.31687310e-02,4.54557310e-04}
      }
    },
    {
      {
        {-1.11099670e-04,1.53852230e-07},{4.27508690e-04,1.47247500e-04},
        {-7.81129110e-04,-2.29936130e-04},{7.15368690e-04,2.08594340e-04},
        {-2.42828450e-04,-7.92964310e-05}
      },
        {
        {-1.80731210e-04,-1.61129940e-04},{5.06201630e-04,2.13458550e-04},
        {-1.07080750e-03,-1.74080820e-04},{1.55731260e-03,8.22012610e-05},
        {-8.92093790e-04,-1.28570830e-05}
      },
        {
        {1.29296420e-04,1.04511320e-04},{2.67317750e-04,-9.27988010e-04},
        {-3.20613950e-03,6.37341300e-04},{6.11941580e-03,-2.11779080e-04},
        {-3.53433510e-03,1.43425020e-05}
      }
    },
    {
      {
        {1.71570050e-06,-1.35839110e-05},{1.26848680e-05,1.14218570e-04},
        {-4.00557590e-05,-2.46927040e-04},{4.19946280e-05,2.54131210e-04},
        {-1.54310480e-05,-9.76907890e-05}
      },
        {
        {2.59729030e-08,-1.64936210e-07},{-2.52813950e-06,-4.04673550e-05},
        {6.66260390e-05,1.02165990e-04},{-1.47143110e-04,-1.17820370e-04},
        {8.80840410e-05,4.88433680e-05}
      },
        {
        {-4.29586860e-05,-3.64422990e-05},{6.54838100e-05,1.36027870e-04},
        {-4.35981650e-05,-2.73183330e-04},{-5.77974850e-05,2.75485730e-04},
        {7.56455840e-05,-1.05283230e-04}
      }
    },
    {
      {
        {-1.36415030e-07,-1.84810430e-06},{3.50720890e-06,7.36493180e-06},
        {-9.00328640e-06,-1.50555350e-05},{8.99706450e-06,1.51525340e-05},
        {-3.12199080e-06,-5.76248930e-06}
      },
        {
        {7.44214760e-06,-2.77396870e-06},{-2.36802780e-05,-3.43911460e-06},
        {4.16717490e-05,6.10660010e-06},{-4.02491100e-05,-5.91146910e-06},
        {1.52721710e-05,2.23261260e-06}
      },
        {
        {-6.43474830e-07,-2.15205930e-06},{-7.11285170e-06,2.78990110e-05},
        {4.13572680e-05,-4.67070090e-05},{-6.11681810e-05,4.19483700e-05},
        {2.76727400e-05,-1.49885430e-05}
      }
    },
    {
      {
        {-1.97874690e-07,-1.47061620e-06},{1.98116160e-07,6.42703300e-06},
        {1.41368500e-07,-1.32995960e-05},{-3.77603000e-07,1.35005030e-05},
        {1.77996100e-07,-5.18985340e-06}
      },
        {
        {8.10665770e-07,-5.36216350e-07},{-2.87293230e-06,1.28429060e-06},
        {4.24328300e-06,-8.83392930e-07},{-2.80615200e-06,-1.32884520e-07},
        {6.62387740e-07,2.85132470e-07}
      },
        {
        {9.07627810e-07,-9.67289330e-07},{-2.26189920e-06,3.39328510e-06},
        {5.14348930e-06,-6.52078180e-06},{-6.00255080e-06,6.54917010e-06},
        {2.50083830e-06,-2.52875330e-06}
      }
    },
    {
      {
        {2.29092010e-08,-1.79849500e-09},{1.08420900e-07,1.80067920e-07},
        {-5.86905140e-07,-2.66293440e-07},{8.46393110e-07,1.97441290e-07},
        {-3.85374250e-07,-5.77219290e-08}
      },
        {
        {3.26080610e-08,1.10061390e-07},{-4.08829040e-07,-4.28532550e-07},
        {1.17450920e-06,9.51958720e-07},{-1.29250910e-06,-9.78458410e-07},
        {4.86953430e-07,3.73611070e-07}
      },
        {
        {3.18102180e-07,-3.55652150e-07},{-1.95529860e-06,1.19474160e-06},
        {5.74844160e-06,-2.53589460e-06},{-7.05971180e-06,2.61516690e-06},
        {2.98112760e-06,-1.01780220e-06}
      }
    },
    {
      {
        {-8.76008190e-10,1.23677230e-08},{1.45402410e-08,-4.34562080e-08},
        {-3.67941940e-08,1.02196560e-07},{3.42759940e-08,-1.09607670e-07},
        {-1.08107120e-08,4.31431630e-08}
      },
        {
        {-2.56667360e-09,7.80510940e-09},{3.65203720e-08,-2.91249600e-08},
        {-1.27357030e-07,6.84497120e-08},{1.63198540e-07,-7.39170480e-08},
        {-7.00563070e-08,2.92452190e-08}
      },
        {
        {-3.59794630e-09,7.04677060e-09},{5.02128010e-08,1.13952110e-08},
        {-1.73330840e-07,-1.33254340e-08},{2.00179750e-07,7.01990640e-09},
        {-7.27487170e-08,-1.30450250e-09}
      }
    },
    {
      {
        {7.49969050e-09,1.64359630e-08},{-5.57102060e-08,-8.07194200e-08},
        {1.79046940e-07,1.97127720e-07},{-2.30418600e-07,-2.16956040e-07},
        {1.00688690e-07,8.66083550e-08}
      },
        {
        {-1.06306530e-08,1.14270320e-08},{8.67058260e-08,-8.53545300e-08},
        {-1.83660730e-07,2.24543510e-07},{1.48983380e-07,-2.53806260e-07},
        {-3.97358430e-08,1.02478320e-07}
      },
        {
        {-7.96610900e-08,-5.44671810e-09},{2.42885690e-07,9.04011210e-09},
        {-4.91288980e-07,1.34935720e-09},{5.49103110e-07,-1.56849970e-08},
        {-2.34335140e-07,9.95334420e-09}
      }
    },
    {
      {
        {-1.50476430e-07,2.05694700e-07},{3.81435030e-07,-1.04401480e-06},
        {-5.48188340e-07,2.21049300e-06},{5.03215120e-07,-2.22689550e-06},
        {-1.99000680e-07,8.44521320e-07}
      },
        {
        {-1.48937410e-07,-6.25250780e-08},{3.55535760e-07,-9.63255850e-08},
        {-1.42119140e-07,2.01437690e-07},{-2.26979740e-07,-2.23205620e-07},
        {1.59333550e-07,9.15659250e-08}
      },
        {
        {2.86022970e-07,-8.20240130e-08},{-1.25134030e-06,4.34709060e-08},
        {4.51890990e-07,3.15569290e-07},{1.55508170e-06,-5.71451510e-07},
        {-1.16080080e-06,2.73123460e-07}
      }
    },
    {
      {
        {5.92279090e-07,-9.70284500e-07},{-1.78952780e-06,6.47804880e-06},
        {8.64100730e-07,-1.18179390e-05},{1.77160180e-06,1.06853540e-05},
        {-1.44631550e-06,-3.74382090e-06}
      },
        {
        {7.27486760e-07,5.48700870e-07},{-4.37316350e-06,-2.63776110e-06},
        {9.52653290e-06,6.13323530e-06},{-9.02022420e-06,-6.58663010e-06},
        {3.13002380e-06,2.58337310e-06}
      },
        {
        {1.51138630e-06,-2.69363170e-06},{-1.33913210e-06,9.38985110e-06},
        {-3.82424240e-06,-1.70160810e-05},{7.77600010e-06,1.58488300e-05},
        {-3.95025830e-06,-5.75279860e-06}
      }
    },
    {
      {
        {6.16145990e-06,-5.59507430e-06},{-1.12285300e-05,1.71566690e-05},
        {6.24518990e-06,-2.93364620e-05},{8.79502120e-07,2.77310930e-05},
        {-1.33265560e-06,-1.04017940e-05}
      },
        {
        {3.06822670e-07,-1.23670890e-05},{6.45074990e-06,2.79385080e-05},
        {-3.34000070e-05,-6.02163650e-05},{4.79736910e-05,6.16773690e-05},
        {-2.15585070e-05,-2.35125070e-05}
      },
        {
        {-7.80307360e-06,-1.01510540e-05},{3.27741680e-05,-2.17092210e-05},
        {2.04469210e-05,3.39402060e-05},{-1.06889490e-04,-3.07005300e-05},
        {6.59786180e-05,1.09932990e-05}
      }
    },
    {
      {
        {-6.05352030e-05,-7.90710670e-05},{2.79997720e-04,5.48215020e-04},
        {-5.28305100e-04,-1.06273980e-03},{4.62417110e-04,1.03639110e-03},
        {-1.52674910e-04,-3.87075630e-04}
      },
        {
        {-2.96121630e-05,3.94765260e-05},{2.08032960e-04,-2.30410860e-04},
        {-4.99789640e-04,4.20301740e-04},{5.25493010e-04,-3.92440330e-04},
        {-2.01980830e-04,1.42464850e-04}
      },
        {
        {-2.93054040e-05,-1.61613440e-04},{-1.68656170e-04,6.17271520e-04},
        {1.01427270e-03,-1.17860490e-03},{-1.55863770e-03,1.12725970e-03},
        {7.44523600e-04,-4.15732150e-04}
      }
    },
    {
      {
        {-2.60518700e-05,-3.76078980e-04},{-7.62897560e-04,3.35602220e-03},
        {2.46047090e-03,-6.34559250e-03},{-2.92746570e-03,6.15229420e-03},
        {1.19700490e-03,-2.31444380e-03}
      },
        {
        {-9.58797570e-05,-2.76374070e-04},{1.69897790e-04,1.29715360e-03},
        {3.03211410e-04,-9.87416090e-04},{-8.42273710e-04,3.36005470e-04},
        {4.62947740e-04,-1.79752650e-05}
      },
        {
        {7.35128750e-05,1.52772230e-04},{-1.32310040e-03,-9.45902450e-03},
        {3.43141840e-04,8.79914020e-03},{2.12099070e-03,-4.23568010e-03},
        {-1.52465930e-03,7.66629270e-04}
      }
    },
    {
      {
        {2.83166700e-04,-4.31019100e-03},{-2.48287090e-03,2.45642580e-02},
        {6.09914070e-03,-4.55183650e-02},{-7.58310550e-03,4.37342660e-02},
        {4.12706890e-03,-1.62707560e-02}
      },
        {
        {1.22841780e-03,1.68004450e-03},{-2.91676560e-03,-6.57350340e-03},
        {-4.33928550e-03,1.16374980e-02},{1.53948920e-02,-1.08554850e-02},
        {-9.94332700e-03,3.95403110e-03}
      },
        {
        {1.48476240e-03,-8.20144420e-03},{1.31528410e-02,2.52895030e-02},
        {-5.55757430e-02,-4.99911810e-02},{8.71630440e-02,4.91516340e-02},
        {-4.90450020e-02,-1.83518090e-02}
      }
    },
    {
      {
        {-2.60696820e-04,1.14409810e-04},{7.95017100e-05,-1.22023610e-03},
        {6.14969540e-04,2.06507350e-03},{-2.07357930e-04,-1.77202940e-03},
        {-3.99348120e-04,6.03280950e-04}
      },
        {
        {-1.64580540e-04,6.08782150e-05},{-1.62118140e-03,-2.35028040e-03},
        {7.17219480e-03,4.40892420e-03},{-1.14722450e-02,-4.27307310e-03},
        {6.60351540e-03,1.60324990e-03}
      },
        {
        {7.74063480e-04,-2.60831130e-04},{1.30022830e-04,6.70093390e-03},
        {-3.50487880e-03,-8.00368800e-03},{-4.77819380e-03,5.56044190e-03},
        {8.99753090e-03,-1.66258930e-03}
      }
    },
    {
      {
        {1.36638820e-05,-6.39131270e-05},{-1.09107610e-04,4.73277650e-04},
        {3.89180030e-04,-9.43457500e-04},{-5.80449330e-04,9.38574000e-04},
        {2.95712750e-04,-3.55310190e-04}
      },
        {
        {-6.53058600e-05,7.50816130e-05},{2.11203070e-04,-2.74902020e-04},
        {-3.53700110e-04,6.57748590e-04},{5.39743780e-04,-7.06930140e-04},
        {-3.91832380e-04,2.76872110e-04}
      },
        {
        {-6.27866220e-05,-1.67898420e-04},{-2.70356670e-04,6.77337840e-04},
        {1.99148080e-04,-1.33471690e-03},{1.06383930e-03,1.31472110e-03},
        {-1.17920050e-03,-4.93468100e-04}
      }
    },
    {
      {
        {6.92463920e-06,1.42571950e-05},{-2.66086620e-05,-7.12759730e-05},
        {5.89931760e-05,1.37628230e-04},{-6.49777920e-05,-1.32395050e-04},
        {2.58434030e-05,4.90252050e-05}
      },
        {
        {4.58458250e-06,-6.53588470e-06},{9.46744610e-06,2.42272460e-05},
        {-2.67206020e-05,-8.11098640e-05},{-4.16008830e-06,9.57331110e-05},
        {2.19668730e-05,-3.90286300e-05}
      },
        {
        {-5.66306980e-06,-7.51917830e-06},{-5.36999230e-05,1.28369270e-04},
        {3.14068010e-04,-1.42949130e-04},{-4.97697720e-04,8.92617380e-05},
        {2.60174380e-04,-2.37978070e-05}
      }
    },
    {
      {
        {1.83953600e-07,4.79834760e-07},{-3.56368800e-07,-2.54780900e-06},
        {-2.36189850e-07,6.04379160e-06},{9.88566340e-07,-6.53907020e-06},
        {-5.57172530e-07,2.58527070e-06}
      },
        {
        {5.77580760e-07,-5.14831180e-07},{5.12128720e-07,4.93409740e-06},
        {-8.64584460e-06,-1.03767320e-05},{1.53672160e-05,1.08082860e-05},
        {-8.00152420e-06,-4.23370300e-06}
      },
        {
        {3.56241730e-07,1.00860180e-06},{1.72471110e-06,-5.84573270e-06},
        {-1.77568510e-06,1.39340740e-05},{2.90521140e-06,-1.48764960e-05},
        {-2.87016410e-06,5.82298620e-06}
      }
    },
    {
      {
        {-6.24558930e-08,2.14164950e-07},{3.79205570e-07,-8.45235760e-07},
        {-1.05140210e-06,1.86769020e-06},{1.28252440e-06,-1.93231620e-06},
        {-5.54289340e-07,7.43684570e-07}
      },
        {
        {-1.21188490e-07,-1.04497910e-08},{1.42343640e-07,7.29997200e-07},
        {-1.64485730e-07,-1.65979850e-06},{3.59950900e-07,1.76484990e-06},
        {-2.30391000e-07,-6.92357620e-07}
      },
        {
        {-1.23040960e-07,2.36260450e-07},{9.88608700e-07,-7.95781040e-07},
        {-2.79350130e-06,1.89461730e-06},{2.99647520e-06,-2.05125690e-06},
        {-1.10489210e-06,8.11049790e-07}
      }
    },
    {
      {
        {-4.17323270e-09,2.97595160e-08},{2.43097520e-08,-1.39985080e-07},
        {-9.21350990e-08,2.88967360e-07},{1.26736020e-07,-2.88609880e-07},
        {-5.53352770e-08,1.09177480e-07}
      },
        {
        {1.66635790e-08,-1.90898190e-08},{-1.35591160e-07,1.07937230e-07},
        {4.16830940e-07,-2.61368810e-07},{-5.29185900e-07,2.84992120e-07},
        {2.30962440e-07,-1.13049720e-07}
      },
        {
        {-1.05852410e-08,8.73847960e-08},{4.82393140e-08,-3.64001090e-07},
        {-8.84843850e-08,7.11122070e-07},{1.39947700e-09,-6.83029240e-07},
        {5.05860820e-08,2.51523740e-07}
      }
    },
    {
      {
        {-3.00612090e-10,3.31043320e-09},{-1.14420570e-08,-2.23546010e-08},
        {5.08153570e-08,5.53559910e-08},{-7.15824570e-08,-6.13521000e-08},
        {3.26530440e-08,2.45618280e-08}
      },
        {
        {-1.74069350e-09,6.92695500e-10},{1.51596710e-08,3.83232300e-09},
        {-3.16651390e-08,-1.78281760e-08},{2.33909800e-08,2.49189810e-08},
        {-4.45145670e-09,-1.11675690e-08}
      },
        {
        {1.94933100e-08,1.20084240e-08},{-3.55199600e-08,-3.39551050e-08},
        {-7.73415250e-08,7.96326000e-08},{1.83742740e-07,-8.48278160e-08},
        {-9.19094440e-08,3.31722700e-08}
      }
    },
    {
      {
        {1.42813010e-10,-3.97020360e-10},{-3.80624480e-10,1.49093690e-09},
        {-4.62202130e-10,-3.70268730e-09},{1.82122950e-09,4.04722970e-09},
        {-1.12701850e-09,-1.60041400e-09}
      },
        {
        {3.63999750e-10,-1.33206360e-10},{-2.72598810e-09,4.74082020e-10},
        {7.76350060e-09,-1.16093420e-09},{-9.15736410e-09,1.27257770e-09},
        {3.77375310e-09,-5.05810900e-10}
      },
        {
        {-6.62924530e-10,-4.66880850e-10},{-1.36487570e-09,2.10888460e-10},
        {1.68792800e-08,-8.37339280e-10},{-3.00511730e-08,1.09071770e-09},
        {1.49656150e-08,-4.69220210e-10}
      }
    },
    {
      {
        {-1.59070560e-09,-1.68718910e-09},{9.29858020e-09,9.54036860e-09},
        {-2.14912570e-08,-2.33438290e-08},{2.19526810e-08,2.59312660e-08},
        {-8.14614910e-09,-1.04643970e-08}
      },
        {
        {3.78976760e-11,6.21029600e-10},{-7.11105230e-10,-2.82999820e-09},
        {-5.14741160e-10,5.71321190e-09},{3.69236870e-09,-5.64388540e-09},
        {-2.65462740e-09,2.13292920e-09}
      },
        {
        {3.92032430e-09,1.09474040e-09},{-1.23959980e-08,-3.65636290e-09},
        {3.03897860e-08,4.72543130e-09},{-4.06642470e-08,-2.52348070e-09},
        {1.98568160e-08,3.66323860e-10}
      }
    },
    {
      {
        {5.54232920e-09,-2.24476420e-09},{-2.32330370e-08,2.61228070e-08},
        {6.14707970e-08,-5.86384070e-08},{-7.62610370e-08,6.00796150e-08},
        {3.29793270e-08,-2.26524310e-08}
      },
        {
        {8.23366190e-09,9.96199780e-10},{-1.19432550e-08,3.10410770e-08},
        {-1.33373330e-08,-7.04357030e-08},{3.24196680e-08,7.57296790e-08},
        {-1.51690660e-08,-3.00464370e-08}
      },
        {
        {-1.68147290e-08,1.30668070e-08},{5.08379430e-08,-8.99057770e-08},
        {-2.62439200e-08,1.96964440e-07},{-1.87426170e-08,-2.05804780e-07},
        {1.75223530e-08,8.04986470e-08}
      }
    },
    {
      {
        {4.87403640e-10,-1.32010570e-08},{-1.25766750e-07,3.97244790e-08},
        {5.73871210e-07,-1.92312870e-07},{-8.29582650e-07,2.52343660e-07},
        {3.83394590e-07,-1.08108290e-07}
      },
        {
        {-4.58960930e-08,2.66844460e-08},{2.02417650e-07,-8.74098850e-08},
        {-2.80268640e-07,2.70260620e-07},{1.29676810e-07,-3.47514460e-07},
        {-1.00802290e-09,1.52795620e-07}
      },
        {
        {-9.05776470e-09,1.04834380e-07},{-1.49739060e-07,-3.73780100e-07},
        {1.41069780e-07,6.19920380e-07},{4.73987400e-08,-5.12511780e-07},
        {-5.02617850e-08,1.67393900e-07}
      }
    },
    {
      {
        {-2.70971710e-08,1.11555570e-06},{-9.25214260e-07,-4.90737370e-06},
        {2.68065690e-06,9.83735610e-06},{-2.85108680e-06,-9.70090700e-06},
        {1.06550620e-06,3.64271060e-06}
      },
        {
        {1.31372330e-08,-2.34194750e-07},{-1.58382030e-06,2.33875560e-06},
        {6.00599110e-06,-5.96249710e-06},{-7.70809850e-06,6.52298260e-06},
        {3.28981730e-06,-2.57228380e-06}
      },
        {
        {6.36872040e-07,8.54081580e-07},{-2.32939340e-06,-1.36796970e-06},
        {-3.79885260e-06,7.27831370e-06},{1.07562130e-05,-9.44931570e-06},
        {-5.88213240e-06,3.99031360e-06}
      }
    },
    {
      {
        {2.13265640e-06,1.55298810e-06},{-3.05531780e-06,-4.00830980e-06},
        {-8.47968470e-06,1.16445880e-05},{2.03820010e-05,-1.34985820e-05},
        {-1.08707960e-05,5.57682620e-06}
      },
        {
        {2.61024140e-06,3.55750600e-06},{-1.35579930e-05,-1.28756360e-05},
        {2.62433380e-05,3.32796190e-05},{-2.28844720e-05,-3.61077400e-05},
        {7.43929070e-06,1.41011190e-05}
      },
        {
        {7.54068830e-07,-4.04783630e-06},{3.06559870e-05,1.73673800e-05},
        {-9.73229160e-05,-3.52577590e-05},{1.19523010e-04,3.55567490e-05},
        {-5.15751460e-05,-1.35047530e-05}
      }
    },
    {
      {
        {-9.81693840e-07,8.47982290e-05},{5.73563470e-05,-5.19552290e-04},
        {-2.11140520e-04,1.03098460e-03},{2.55577900e-04,-1.00078640e-03},
        {-1.03098500e-04,3.71070770e-04}
      },
        {
        {-5.84756620e-06,-8.41910600e-06},{4.64387710e-05,-2.86604800e-05},
        {-2.21707820e-04,-2.87771290e-05},{3.05595460e-04,5.26208870e-05},
        {-1.36195930e-04,-2.22814360e-05}
      },
        {
        {-3.15485470e-05,1.19657860e-05},{1.79742370e-04,2.05428280e-05},
        {8.31913440e-05,5.79917290e-04},{-5.28305940e-04,-8.34788070e-04},
        {3.35481750e-04,3.62175230e-04}
      }
    },
    {
      {
        {-1.12978660e-04,-1.71311630e-04},{4.58677850e-04,1.48781690e-03},
        {-5.89517180e-04,-9.87216550e-04},{3.25881110e-04,1.05823430e-04},
        {-4.35564530e-05,1.21548490e-04}
      },
        {
        {-9.38103140e-05,3.75397520e-04},{8.69237450e-04,-1.57437330e-03},
        {-2.03236860e-03,3.30230180e-03},{2.11192050e-03,-3.31518120e-03},
        {-8.17190670e-04,1.25280180e-03}
      },
        {
        {-4.87816920e-05,-1.14871920e-03},{-7.31308680e-04,4.29421720e-03},
        {3.94119560e-03,-7.83298710e-03},{-6.19764900e-03,7.10124530e-03},
        {3.07157430e-03,-2.49727230e-03}
      }
    },
    {
      {
        {-6.66274000e-04,4.57045070e-03},{-2.80311020e-03,-2.59053270e-02},
        {9.61622830e-03,5.19645450e-02},{-1.29605670e-02,-5.17754350e-02},
        {6.53567060e-03,1.95151150e-02}
      },
        {
        {-6.05652880e-04,-3.66111070e-04},{-4.42113110e-03,-3.05443430e-04},
        {1.36357740e-02,-5.82384930e-03},{-1.33261310e-02,8.17306880e-03},
        {4.62142970e-03,-3.40837930e-03}
      },
        {
        {1.93950360e-03,1.97457120e-03},{1.30260030e-02,8.25262530e-03},
        {-6.71008190e-02,2.78099720e-02},{9.91845220e-02,-4.78174770e-02},
        {-4.93984990e-02,2.19279790e-02}
      }
    },
    {
      {
        {1.89298410e-05,1.34197630e-04},{1.42934690e-04,-8.33995870e-04},
        {-8.10871580e-05,9.90478900e-04},{3.87152940e-04,-6.45382830e-04},
        {-5.03048520e-04,1.75053740e-04}
      },
        {
        {-3.14424520e-04,-4.83211260e-05},{4.45099360e-04,1.93523010e-04},
        {3.56449590e-03,3.56418330e-05},{-9.19061450e-03,-3.36435770e-04},
        {6.10011850e-03,2.02520510e-04}
      },
        {
        {-1.09735510e-04,5.36853570e-04},{-3.83173970e-03,-2.08218650e-03},
        {1.65765860e-02,3.89788590e-03},{-3.16324440e-02,-3.59456430e-03},
        {2.03934370e-02,1.28770070e-03}
      }
    },
    {
      {
        {7.47378330e-06,8.05428020e-05},{4.01672030e-05,-4.80839610e-04},
        {-1.03705670e-04,1.04110240e-03},{2.95235570e-05,-1.08264910e-03},
        {3.68122080e-05,4.20550630e-04}
      },
        {
        {2.27880110e-05,-8.12944730e-07},{8.09989160e-05,1.33414030e-04},
        {-4.42943470e-04,-3.77931160e-04},{8.12754030e-04,4.22353460e-04},
        {-5.25758320e-04,-1.67786420e-04}
      },
        {
        {-4.42384800e-05,6.39398560e-05},{-1.50554020e-04,-1.10671240e-04},
        {5.30781150e-04,9.15062520e-04},{2.35127140e-04,-1.14563510e-03},
        {-7.27007200e-04,4.69074680e-04}
      }
    },
    {
      {
        {-6.95666410e-07,2.09756650e-06},{6.02637960e-06,-1.69529560e-05},
        {-2.26301720e-05,2.51484130e-05},{3.37046100e-05,-2.08054190e-05},
        {-1.70566930e-05,6.85591180e-06}
      },
        {
        {4.74785870e-06,-2.57644220e-06},{-1.41750900e-05,1.19833460e-05},
        {1.74355830e-05,-1.57390890e-05},{-2.48918940e-05,1.30254740e-05},
        {2.03160970e-05,-4.53381060e-06}
      },
        {
        {1.03898230e-06,1.40637300e-05},{9.72154280e-06,-5.41195230e-05},
        {3.19338230e-05,1.01483930e-04},{-1.06990530e-04,-9.37708140e-05},
        {8.15628130e-05,3.33039000e-05}
      }
    },
    {
      {
        {-1.15871130e-07,-2.53106530e-07},{9.06448270e-07,1.26734990e-06},
        {-2.87839230e-06,-2.40847200e-06},{3.67782130e-06,2.11021560e-06},
        {-1.57988380e-06,-7.04292130e-07}
      },
        {
        {-1.10330890e-07,3.56574610e-07},{-1.37789950e-06,8.04261110e-07},
        {2.88998830e-06,-2.96225610e-08},{-7.87999690e-07,-7.21251290e-07},
        {-8.93071520e-07,4.04687190e-07}
      },
        {
        {3.03708050e-07,6.68332660e-07},{2.69018570e-06,-6.05383290e-06},
        {-1.35879090e-05,8.29229150e-06},{2.10275660e-05,-5.89033870e-06},
        {-1.10104280e-05,1.66769440e-06}
      }
    },
    {
      {
        {-1.36538010e-08,-2.62598640e-08},{8.06685510e-08,1.28117840e-07},
        {-2.63909930e-07,-3.19640030e-07},{3.47435030e-07,3.37257320e-07},
        {-1.52529180e-07,-1.28410280e-07}
      },
        {
        {-3.17599430e-08,-3.99216070e-08},{-4.37991740e-08,6.12994920e-08},
        {4.63984430e-07,-1.42485770e-07},{-7.73056100e-07,1.64894070e-07},
        {3.89699060e-07,-7.02590540e-08}
      },
        {
        {2.38878330e-08,7.42478200e-08},{-5.18106450e-08,-2.13402640e-07},
        {-2.33764560e-07,2.73913620e-07},{1.50515300e-07,-1.89077950e-07},
        {8.55743590e-08,5.45552690e-08}
      }
    },
    {
      {
        {9.67119350e-11,-1.37162700e-08},{-1.33421240e-08,5.75424870e-08},
        {5.52853550e-08,-1.30807130e-07},{-7.72105520e-08,1.35692530e-07},
        {3.52297730e-08,-5.20030550e-08}
      },
        {
        {-4.32629920e-09,4.60618440e-09},{4.14737100e-08,-4.46243130e-08},
        {-9.17112150e-08,1.10748200e-07},{7.71106090e-08,-1.20808920e-07},
        {-2.18846410e-08,4.77149720e-08}
      },
        {
        {4.82077800e-09,-9.48701740e-09},{-1.03997640e-08,8.91850050e-08},
        {-8.28188420e-08,-2.08572880e-07},{1.74153240e-07,2.25131230e-07},
        {-8.77411230e-08,-8.94819380e-08}
      }
    },
    {
      {
        {2.59974390e-10,-1.24279150e-09},{-4.03572610e-09,7.01377550e-09},
        {1.62917290e-08,-1.66157200e-08},{-2.23912000e-08,1.82344370e-08},
        {9.93580220e-09,-7.32415810e-09}
      },
        {
        {-1.43614490e-09,-3.06883700e-10},{7.85950600e-09,1.91068970e-09},
        {-1.91262230e-08,-3.55595330e-09},{2.23079590e-08,3.63585780e-09},
        {-9.54040930e-09,-1.48606490e-09}
      },
        {
        {-1.64876250e-09,-2.68225220e-09},{1.16911380e-08,1.34094300e-08},
        {-3.22277520e-08,-2.81939380e-08},{4.06352590e-08,2.75976450e-08},
        {-1.85744580e-08,-1.01355840e-08}
      }
    },
    {
      {
        {-1.97045540e-10,-1.12838650e-10},{1.58171940e-09,1.12060560e-09},
        {-4.42160910e-09,-2.59055430e-09},{5.22217970e-09,2.72841900e-09},
        {-2.19482570e-09,-1.05845990e-09}
      },
        {
        {1.74241840e-10,-1.29936340e-11},{-6.98925290e-10,-2.22081800e-10},
        {1.00996390e-09,1.01186590e-09},{-4.20525870e-10,-1.43722820e-09},
        {-8.09216070e-11,6.53226350e-10}
      },
        {
        {-4.42409080e-10,-7.76917610e-10},{-3.53095270e-09,1.31966500e-09},
        {1.77471170e-08,-3.53477700e-09},{-2.15800870e-08,3.99500090e-09},
        {7.87991440e-09,-1.60309410e-09}
      }
    },
    {
      {
        {-1.10829930e-12,2.00714060e-11},{-4.06828230e-11,-5.26786420e-11},
        {1.95419050e-10,1.44965310e-10},{-2.89538440e-10,-1.69266140e-10},
        {1.36025460e-10,6.97155940e-11}
      },
        {
        {-1.46565370e-11,3.73274970e-12},{7.80269170e-11,-1.57715980e-11},
        {-1.70515820e-10,4.16251540e-11},{1.61950630e-10,-4.85106860e-11},
        {-5.54435510e-11,2.02173960e-11}
      },
        {
        {3.50036340e-11,-6.76597390e-12},{3.06638400e-10,-6.79855280e-13},
        {-1.77514030e-09,3.21339190e-11},{2.65863860e-09,-5.66575780e-11},
        {-1.21395660e-09,2.77465170e-11}
      }
    },
    {
      {
        {3.74734900e-11,6.45034850e-11},{-1.25288050e-10,-3.88464400e-10},
        {1.50934530e-11,9.79650510e-10},{2.42959610e-10,-1.08440750e-09},
        {-1.70560580e-10,4.32314310e-10}
      },
        {
        {1.08229510e-11,-4.06447460e-12},{6.00060920e-11,-7.96725680e-12},
        {-2.74271840e-10,-3.79455280e-13},{3.02635790e-10,1.97055950e-11},
        {-9.35324660e-11,-1.34830500e-11}
      },
        {
        {-1.71097820e-10,-7.78196270e-11},{2.31263000e-10,4.53462090e-10},
        {3.16010610e-10,-1.11596100e-09},{-8.06214670e-10,1.22916650e-09},
        {3.71048580e-10,-4.89992810e-10}
      }
    },
    {
      {
        {-2.24056590e-10,1.94935620e-10},{1.71146150e-09,-2.34972770e-09},
        {-5.68144810e-09,5.74380340e-09},{7.42606030e-09,-6.37715790e-09},
        {-3.26054500e-09,2.56748110e-09}
      },
        {
        {7.02933080e-11,3.19882070e-10},{-1.72767190e-09,-2.82128220e-09},
        {5.63749290e-09,7.21370530e-09},{-6.55576910e-09,-8.13959250e-09},
        {2.56774720e-09,3.29761150e-09}
      },
        {
        {6.33164400e-10,-1.07798530e-09},{-1.18376360e-09,2.27708500e-09},
        {2.37036330e-09,-4.84242960e-09},{-3.25215850e-09,4.88470440e-09},
        {1.49802680e-09,-1.85308210e-09}
      }
    },
    {
      {
        {-5.31993170e-10,-1.45954400e-09},{8.19993270e-09,3.04214330e-09},
        {-2.93374820e-08,-2.82837680e-09},{3.76096890e-08,2.77401330e-10},
        {-1.61339480e-08,5.32098520e-10}
      },
        {
        {2.01866620e-09,2.17032560e-10},{-6.02670980e-09,-2.49339860e-09},
        {-4.32231940e-09,7.71919510e-09},{2.11834320e-08,-9.36379620e-09},
        {-1.31299960e-08,3.92433860e-09}
      },
        {
        {1.66867490e-09,-1.84999190e-09},{-3.12416270e-09,1.24282750e-08},
        {3.50302150e-08,-3.31369740e-08},{-6.27896280e-08,3.82015770e-08},
        {3.13320750e-08,-1.56776000e-08}
      }
    },
    {
      {
        {1.15047030e-08,-3.64751520e-08},{-4.01050800e-08,1.67532060e-07},
        {1.35573100e-07,-3.24894930e-07},{-2.02655370e-07,3.10422550e-07},
        {9.82541210e-08,-1.13748640e-07}
      },
        {
        {-6.29198510e-10,1.77893430e-08},{8.82489670e-08,-5.33427310e-08},
        {-3.05764360e-07,1.70708250e-07},{3.62881060e-07,-2.03277630e-07},
        {-1.45487260e-07,8.33492160e-08}
      },
        {
        {-5.17236260e-08,-2.55412970e-08},{1.49293060e-07,1.69968470e-07},
        {1.70504630e-07,-4.06863340e-07},{-5.34618380e-07,4.29855200e-07},
        {2.97550500e-07,-1.65007100e-07}
      }
    },
    {
      {
        {-2.68982130e-08,-4.54128820e-07},{-5.36680630e-07,1.59143610e-06},
        {2.83271060e-06,-4.37453230e-06},{-4.14953840e-06,4.99455330e-06},
        {1.90707270e-06,-2.02427230e-06}
      },
        {
        {-1.46777730e-07,-2.94006110e-08},{6.63367490e-07,-3.87205910e-08},
        {-5.30347820e-07,3.83559850e-07},{-3.23853940e-07,-6.31689800e-07},
        {3.66626840e-07,3.05664620e-07}
      },
        {
        {3.52657120e-08,3.33528970e-07},{-1.17012180e-06,-8.15402650e-07},
        {2.41517550e-06,6.09011190e-07},{-2.05630850e-06,9.11855910e-08},
        {7.17085400e-07,-2.04892760e-07}
      }
    },
    {
      {
        {-4.38363280e-07,1.16744110e-07},{-2.66654160e-06,4.19214470e-06},
        {9.42120750e-06,-1.44433150e-05},{-1.01022850e-05,1.73462090e-05},
        {3.65458510e-06,-7.14545110e-06}
      },
        {
        {-2.10091160e-07,-5.84444170e-07},{-4.95402670e-06,1.26812390e-05},
        {2.05011340e-05,-2.83567580e-05},{-2.71624230e-05,3.03001920e-05},
        {1.18736480e-05,-1.19780900e-05}
      },
        {
        {2.16214800e-06,4.18442610e-06},{-6.86037480e-06,4.89348370e-06},
        {-1.99700570e-05,-5.91191930e-06},{5.10062310e-05,4.47806530e-06},
        {-2.82609990e-05,-1.41015550e-06}
      }
    },
    {
      {
        {6.64148710e-06,-1.36422120e-05},{2.02389330e-06,7.01620020e-07},
        {-8.75775980e-05,-1.80746330e-04},{1.53676890e-04,2.72965280e-04},
        {-7.57343410e-05,-1.21673180e-04}
      },
        {
        {7.97011610e-06,9.83152310e-06},{-1.83692360e-05,-1.40992740e-05},
        {-2.54401510e-05,9.21415830e-05},{7.97135960e-05,-1.28195290e-04},
        {-4.39577790e-05,5.61102580e-05}
      },
        {
        {-4.65766270e-06,3.41958930e-05},{1.02676940e-04,-1.04963070e-04},
        {-3.86131980e-04,1.42496290e-04},{5.27716080e-04,-8.91938940e-05},
        {-2.42652760e-04,2.08905360e-05}
      }
    },
    {
      {
        {4.82940320e-05,6.27819820e-04},{-2.91793940e-04,-3.79600680e-03},
        {7.06935970e-04,7.46724240e-03},{-8.41995950e-04,-7.36156580e-03},
        {3.67208320e-04,2.76761870e-03}
      },
        {
        {2.94196980e-05,-1.34891480e-04},{1.03693480e-04,4.08015870e-04},
        {-6.34004980e-04,-1.84436800e-03},{9.34807070e-04,2.24058640e-03},
        {-4.31387800e-04,-9.13869290e-04}
      },
        {
        {1.45177610e-04,6.69215820e-04},{-1.41654720e-04,2.11726170e-03},
        {2.41528490e-03,2.35738390e-03},{-4.47349980e-03,-5.20293920e-03},
        {2.30257290e-03,2.48318420e-03}
      }
    },
    {
      {
        {8.18768860e-04,-8.30979010e-05},{-5.88344950e-03,-3.38232310e-03},
        {2.02250680e-02,-6.03227070e-03},{-2.71045980e-02,1.21310640e-02},
        {1.26402510e-02,-5.73732110e-03}
      },
        {
        {-1.42183730e-03,-1.00358120e-03},{1.72061100e-03,7.54425160e-03},
        {8.76468910e-03,-1.39244070e-02},{-2.04137040e-02,1.31795390e-02},
        {1.23039860e-02,-4.83900790e-03}
      },
        {
        {-2.56906300e-03,8.30794570e-04},{-1.65175220e-03,-9.27181000e-03},
        {-8.94464430e-04,1.34050020e-02},{2.13408400e-03,-8.71657390e-03},
        {-7.25563460e-04,1.97430680e-03}
      }
    },
    {
      {
        {-3.49593830e-05,-2.78962190e-04},{4.18434220e-04,1.68060640e-03},
        {-1.31654510e-03,-3.23010340e-03},{2.04646410e-03,3.07731490e-03},
        {-1.22216300e-03,-1.12635780e-03}
      },
        {
        {7.29932020e-05,9.13646350e-05},{4.73055980e-04,6.11335560e-05},
        {4.23401010e-04,8.81986930e-04},{-3.91970750e-03,-1.33940890e-03},
        {3.39810860e-03,5.95776740e-04}
      },
        {
        {-1.47360310e-04,-1.18357970e-04},{-3.38523280e-03,-2.84335710e-03},
        {1.84886250e-02,2.31563530e-03},{-3.25235600e-02,-8.15106310e-04},
        {1.93703890e-02,3.41454100e-05}
      }
    },
    {
      {
        {-3.32019090e-06,-2.38945970e-05},{2.80250080e-05,4.48589150e-05},
        {-1.00176640e-04,-2.22624390e-04},{9.05893970e-05,2.86317070e-04},
        {-9.79034890e-06,-1.21209210e-04}
      },
        {
        {2.24432740e-05,-1.96790740e-05},{3.04349450e-05,-2.27748790e-05},
        {-4.88730710e-04,1.04489980e-04},{1.03083930e-03,-1.44617450e-04},
        {-6.52244100e-04,6.42304250e-05}
      },
        {
        {-8.89308210e-06,2.10649050e-05},{1.85222710e-04,-5.29409470e-05},
        {-9.11602540e-04,2.09626600e-05},{2.19003600e-03,3.97748640e-05},
        {-1.59546960e-03,-3.07378100e-05}
      }
    },
    {
      {
        {-1.75327220e-07,-5.82825070e-06},{1.14733050e-06,2.99428740e-05},
        {-8.67428030e-06,-5.89595750e-05},{1.73891140e-05,5.75578920e-05},
        {-1.02823160e-05,-2.14829060e-05}
      },
        {
        {-4.41227610e-07,1.74712140e-06},{-6.46654430e-06,-6.00885430e-06},
        {2.41772770e-05,2.31733140e-05},{-4.33596730e-05,-2.77654400e-05},
        {2.93813150e-05,1.12992740e-05}
      },
        {
        {1.44862800e-06,-5.09531360e-06},{1.22584930e-05,-8.92389930e-06},
        {-2.53537940e-05,-2.68044110e-05},{-3.61651670e-05,4.51399910e-05},
        {5.66343110e-05,-2.01437560e-05}
      }
    },
    {
      {
        {-6.91658580e-09,3.78432150e-08},{-5.35881780e-08,-4.66784200e-07},
        {2.63591560e-07,1.45744340e-06},{-4.75793510e-07,-1.78083990e-06},
        {2.83945310e-07,7.46479180e-07}
      },
        {
        {-1.32507580e-07,-1.62628530e-07},{-1.32661210e-07,1.65967330e-07},
        {1.15567070e-06,-1.08208720e-06},{-7.89839280e-07,1.47685490e-06},
        {-2.65281450e-07,-6.43119580e-07}
      },
        {
        {2.28462410e-07,-1.78759260e-07},{5.16770700e-07,8.13326990e-07},
        {-5.79458310e-06,-1.79815870e-06},{1.00180980e-05,1.80953730e-06},
        {-5.71913570e-06,-6.79863520e-07}
      }
    },
    {
      {
        {1.27267840e-08,-1.56524350e-08},{-9.37677150e-08,1.66235710e-08},
        {2.83299280e-07,1.25158270e-08},{-3.48820390e-07,-4.65582410e-08},
        {1.48341910e-07,2.62182370e-08}
      },
        {
        {5.41061750e-09,1.70254910e-08},{5.15640820e-09,-1.60560280e-07},
        {1.01089190e-07,2.90601570e-07},{-2.71477940e-07,-2.61973040e-07},
        {1.71133020e-07,9.21612600e-08}
      },
        {
        {1.44017910e-08,-7.45714480e-08},{-1.00701140e-07,2.59418300e-07},
        {2.88082330e-07,-5.12861660e-07},{-3.88009420e-07,4.82514050e-07},
        {2.17497440e-07,-1.72785580e-07}
      }
    },
    {
      {
        {-5.14030040e-10,4.04876350e-09},{-2.27136170e-09,-2.22198680e-08},
        {1.80144930e-08,5.46629170e-08},{-2.80465070e-08,-5.97165100e-08},
        {1.29156500e-08,2.36338450e-08}
      },
        {
        {-1.05097490e-09,-9.20966090e-10},{1.01374220e-08,9.38465660e-09},
        {-2.89625740e-08,-2.77630480e-08},{3.41405390e-08,3.30102310e-08},
        {-1.45170030e-08,-1.36429720e-08}
      },
        {
        {-3.63476870e-10,-2.07202880e-09},{-8.10901080e-09,5.23512040e-10},
        {4.33680580e-09,1.49011820e-08},{4.13258450e-08,-2.56043640e-08},
        {-3.81072830e-08,1.22256760e-08}
      }
    },
    {
      {
        {-7.57905560e-11,4.48440130e-10},{7.81156720e-10,-2.79138570e-09},
        {-2.18712930e-09,7.38136000e-09},{2.54314270e-09,-8.45345270e-09},
        {-1.06997900e-09,3.44708650e-09}
      },
        {
        {2.04842830e-10,3.62833600e-11},{-1.38900180e-09,3.50652980e-10},
        {2.17860590e-09,-1.53833240e-09},{-7.27142260e-10,2.04750830e-09},
        {-2.96037850e-10,-8.91603510e-10}
      },
        {
        {-4.66863140e-10,1.13670630e-10},{4.19851400e-10,-2.87163940e-09},
        {7.94538680e-09,7.35404100e-09},{-1.57378770e-08,-8.23304570e-09},
        {7.98924310e-09,3.30933590e-09}
      }
    },
    {
      {
        {-3.72544230e-11,6.49794340e-11},{4.71811560e-10,-2.79104350e-10},
        {-1.65056130e-09,6.12174810e-10},{2.13415560e-09,-6.22609170e-10},
        {-9.20377250e-10,2.35896000e-10}
      },
        {
        {2.95205770e-11,-2.48419330e-11},{-1.79804430e-11,1.50143020e-10},
        {-1.27515230e-10,-4.33820390e-10},{1.31448000e-10,5.19625530e-10},
        {-1.66530010e-11,-2.17037990e-10}
      },
        {
        {8.36457650e-11,1.27354840e-10},{-8.70110510e-10,-8.20178890e-10},
        {2.85510500e-09,2.12695370e-09},{-3.55015230e-09,-2.42113720e-09},
        {1.52657860e-09,9.86845820e-10}
      }
    },
    {
      {
        {1.03515040e-11,5.74772770e-12},{-6.02609340e-11,-5.61080390e-11},
        {1.32360630e-10,1.45711860e-10},{-1.32708860e-10,-1.63751380e-10},
        {5.07309730e-11,6.58934060e-11}
      },
        {
        {-2.62936800e-12,5.16069170e-12},{-7.82479010e-12,-1.74260560e-11},
        {4.13018230e-11,4.15148160e-11},{-6.33319620e-11,-4.55576800e-11},
        {3.32486730e-11,1.82967740e-11}
      },
        {
        {-2.10140440e-11,4.21461100e-11},{2.95728440e-10,-6.69448460e-11},
        {-7.79196520e-10,1.70516430e-10},{5.47002280e-10,-1.87865040e-10},
        {-4.49940030e-11,7.43510270e-11}
      }
    },
    {
      {
        {-1.99488790e-13,-7.79522960e-13},{2.62842850e-12,1.88092980e-12},
        {-8.13703750e-12,-5.10895190e-12},{9.76074530e-12,5.96362910e-12},
        {-4.06134980e-12,-2.45874290e-12}
      },
        {
        {4.86629990e-13,-2.38093640e-13},{-1.61348060e-12,9.44235890e-13},
        {1.41495320e-12,-3.02806910e-12},{7.92733810e-13,3.82466510e-12},
        {-1.06694590e-12,-1.64936700e-12}
      },
        {
        {-1.50960060e-12,1.25879330e-12},{-1.63568540e-11,-2.64571700e-12},
        {8.97908410e-11,7.94855500e-12},{-1.31237880e-10,-9.82200920e-12},
        {5.84313360e-11,4.19919350e-12}
      }
    },
    {
      {
        {-9.64120130e-13,-1.06234090e-12},{-8.02141130e-12,1.00555080e-11},
        {4.77659770e-11,-2.88324990e-11},{-7.22769120e-11,3.42846780e-11},
        {3.34668140e-11,-1.42524620e-11}
      },
        {
        {-1.53921190e-12,-1.41037590e-12},{2.48087100e-12,1.23985730e-11},
        {8.14001750e-12,-3.62396790e-11},{-1.76818860e-11,4.40619800e-11},
        {8.27092910e-12,-1.86366660e-11}
      },
        {
        {8.27826780e-12,1.95811420e-12},{1.93219130e-11,-8.06774180e-12},
        {-1.75676760e-10,1.37984970e-11},{2.92639740e-10,-1.09395690e-11},
        {-1.43026770e-10,3.30940940e-12}
      }
    },
    {
      {
        {1.00860450e-11,-8.57715920e-12},{-8.31431520e-11,1.01487400e-10},
        {2.58145530e-10,-2.67497700e-10},{-3.24068560e-10,3.05674970e-10},
        {1.39947530e-10,-1.24417250e-10}
      },
        {
        {-7.13453310e-12,-1.48101080e-12},{1.00165410e-10,3.07214920e-11},
        {-3.11457350e-10,-8.03725970e-11},{3.59717010e-10,8.94944540e-11},
        {-1.40784680e-10,-3.56164590e-11}
      },
        {
        {-2.59435080e-11,2.94063590e-11},{4.72337810e-11,-4.19705030e-11},
        {-2.41224260e-10,1.00198310e-10},{5.51199230e-10,-1.09615820e-10},
        {-3.24404890e-10,4.38367320e-11}
      }
    },
    {
      {
        {7.09672180e-11,1.30225210e-10},{-4.27005460e-10,-6.26824490e-10},
        {8.58107640e-10,1.37200710e-09},{-6.62727840e-10,-1.41117110e-09},
        {1.61178930e-10,5.39890150e-10}
      },
        {
        {-6.33681450e-11,-9.15381080e-11},{1.18203700e-10,6.99974380e-10},
        {4.07851630e-10,-1.99867380e-09},{-9.86855350e-10,2.39953750e-09},
        {5.48358930e-10,-1.00779230e-09}
      },
        {
        {-7.40867670e-11,1.24258110e-10},{1.62683300e-10,-8.64978030e-10},
        {-2.15361360e-09,2.36770400e-09},{4.12244860e-09,-2.75437020e-09},
        {-2.22629680e-09,1.13401480e-09}
      }
    },
    {
      {
        {-6.24143490e-10,1.05575510e-09},{4.68113160e-09,-7.05356910e-09},
        {-1.58782770e-08,1.53040040e-08},{2.05558090e-08,-1.55783610e-08},
        {-8.85696720e-09,5.91407800e-09}
      },
        {
        {1.25022530e-10,4.64867830e-10},{-4.51559790e-09,-6.12964840e-09},
        {1.30027860e-08,1.15102140e-08},{-1.35987130e-08,-1.07964360e-08},
        {4.95438130e-09,3.92194160e-09}
      },
        {
        {3.15059550e-09,-2.10846420e-09},{-5.96098570e-09,1.30352400e-08},
        {4.23027510e-10,-2.76381760e-08},{5.06182030e-10,2.90111810e-08},
        {7.39834330e-10,-1.15041500e-08}
      }
    },
    {
      {
        {-3.28857830e-09,1.73025590e-08},{4.52579510e-08,-6.91839810e-08},
        {-1.57918880e-07,1.83816120e-07},{1.98777690e-07,-2.09557340e-07},
        {-8.42280260e-08,8.53586450e-08}
      },
        {
        {1.08702890e-08,-3.24523590e-09},{-4.25162310e-08,1.12363480e-08},
        {3.14829740e-08,-5.15762910e-08},{2.02458830e-08,6.53341800e-08},
        {-2.25152940e-08,-2.66028600e-08}
      },
        {
        {-1.42908770e-08,5.07230640e-10},{4.83642430e-08,-2.54479690e-08},
        {1.01035240e-07,8.86425170e-08},{-2.58808490e-07,-1.12053140e-07},
        {1.31704860e-07,4.78099550e-08}
      }
    },
    {
      {
        {9.34677010e-09,-6.10289110e-08},{1.80920390e-08,-5.59960350e-08},
        {1.61724030e-07,8.23079680e-07},{-4.17815660e-07,-1.23638880e-06},
        {2.40189440e-07,5.58877170e-07}
      },
        {
        {-4.79321550e-10,5.40247070e-08},{3.16887930e-07,-3.66387280e-07},
        {-9.32087740e-07,6.48202500e-07},{1.00871100e-06,-5.02178600e-07},
        {-3.86624520e-07,1.43554450e-07}
      },
        {
        {-1.29174810e-07,-3.97540830e-07},{5.39523390e-07,9.74517090e-07},
        {1.06737390e-06,-2.93990690e-06},{-2.47725830e-06,3.22455580e-06},
        {1.23526330e-06,-1.23735210e-06}
      }
    },
    {
      {
        {2.87772790e-07,-1.88194380e-06},{-4.28451640e-06,8.24630010e-06},
        {1.63164290e-05,-2.02286690e-05},{-2.14166740e-05,2.14270010e-05},
        {9.29434950e-06,-8.24869590e-06}
      },
        {
        {-5.42469860e-07,-7.73348680e-07},{2.46916590e-06,-4.94740330e-07},
        {9.76920250e-08,2.06281360e-06},{-4.68175070e-06,-3.59176360e-06},
        {3.01719490e-06,1.81795550e-06}
      },
        {
        {-6.79192170e-09,-1.01627620e-06},{-7.85723000e-06,6.52787410e-06},
        {1.39113210e-05,-1.88495600e-05},{-1.16191640e-05,2.25622760e-05},
        {4.35108650e-06,-9.45300600e-06}
      }
    },
    {
      {
        {-1.83147100e-06,-1.99689880e-05},{-2.49375140e-05,1.38188410e-04},
        {6.84340600e-05,-2.09395650e-04},{-6.44198160e-05,1.64433640e-04},
        {2.13454970e-05,-5.17318800e-05}
      },
        {
        {-4.11197380e-06,6.40362530e-06},{-2.83535240e-05,-6.17282340e-06},
        {9.60486860e-05,4.78426430e-05},{-1.23316280e-04,-5.56182700e-05},
        {5.58663880e-05,2.14244860e-05}
      },
        {
        {5.01193500e-06,-2.76521040e-05},{-3.05925160e-05,7.92580280e-05},
        {-1.99822000e-04,-4.13308990e-04},{4.54837200e-04,5.02865100e-04},
        {-2.50634710e-04,-2.03735670e-04}
      }
    },
    {
      {
        {6.39699090e-06,-1.85717340e-04},{2.09106420e-04,1.45100020e-03},
        {-7.11074220e-04,-5.16452120e-03},{9.30354190e-04,6.19699800e-03},
        {-4.18814320e-04,-2.56685480e-03}
      },
        {
        {5.08554610e-05,-3.44007740e-05},{-1.84938360e-04,-2.82009920e-04},
        {1.66637300e-04,1.09226590e-03},{-2.27752600e-05,-1.42469980e-03},
        {-2.93596000e-05,6.20244350e-04}
      },
        {
        {-8.79308920e-06,-8.96441510e-05},{4.77314120e-04,8.36193940e-04},
        {-1.88289450e-03,-3.12169700e-03},{2.67278600e-03,4.13116930e-03},
        {-1.26815970e-03,-1.80403280e-03}
      }
    },
    {
      {
        {-7.47412350e-04,-1.18476560e-03},{2.52172330e-03,1.06225060e-02},
        {-5.18780470e-03,-1.58772350e-02},{4.88786760e-03,1.14059980e-02},
        {-1.42986550e-03,-3.27843030e-03}
      },
        {
        {-6.95483760e-05,3.88953820e-04},{2.84286100e-03,-2.16833220e-03},
        {1.26945180e-04,8.57411250e-03},{-1.16615040e-02,-9.86896620e-03},
        {1.04016960e-02,3.99102970e-03}
      },
        {
        {-3.39597740e-05,-2.98838250e-03},{-1.45719100e-02,-2.37079810e-03},
        {4.53525350e-02,-2.19824450e-02},{-5.47860350e-02,3.29865880e-02},
        {2.50180500e-02,-1.43349670e-02}
      }
    },
    {
      {
        {-2.91796460e-05,3.47064490e-05},{5.90056470e-04,-3.63748430e-04},
        {-2.21024540e-03,1.60024360e-03},{3.42595470e-03,-2.03428990e-03},
        {-1.86698950e-03,8.64308650e-04}
      },
        {
        {1.78935790e-04,-5.89755720e-05},{3.49899380e-05,-4.98620170e-04},
        {-3.35899950e-04,9.53420340e-04},{-9.10263450e-04,-8.27423040e-04},
        {1.33168830e-03,2.90297660e-04}
      },
        {
        {-1.07112000e-04,-2.26421430e-05},{-3.93364400e-04,-6.32377680e-05},
        {6.60220980e-03,4.34001930e-04},{-1.49006650e-02,-6.03096960e-04},
        {1.02923910e-02,2.65232310e-04}
      }
    },
    {
      {
        {3.38991740e-06,-1.18301970e-05},{-2.56688210e-05,7.62962680e-05},
        {5.10674650e-05,-9.39375490e-05},{-8.55027250e-05,5.38646030e-05},
        {6.19274870e-05,-1.07983490e-05}
      },
        {
        {5.16161230e-07,8.87413040e-06},{-1.91527600e-05,-9.12326840e-05},
        {-1.74759480e-04,2.33672070e-04},{5.64053450e-04,-2.44041310e-04},
        {-4.24340750e-04,9.25831000e-05}
      },
        {
        {7.14940240e-07,-4.07681980e-05},{2.52190780e-04,8.78541520e-05},
        {-1.41431190e-03,-4.47239240e-04},{2.72606740e-03,5.24240960e-04},
        {-1.73406900e-03,-2.07526230e-04}
      }
    },
    {
      {
        {1.34349790e-07,2.86256240e-06},{-1.67020800e-06,-1.32961170e-05},
        {3.95785280e-06,4.09992960e-05},{-2.00264000e-06,-4.88295440e-05},
        {-7.97446040e-07,2.01557950e-05}
      },
        {
        {-1.10168690e-06,-4.32124390e-07},{-4.74697180e-06,1.17609570e-06},
        {3.48400930e-05,-9.04316470e-06},{-6.79405930e-05,1.29312140e-05},
        {4.23038100e-05,-5.77611080e-06}
      },
        {
        {1.08745180e-06,7.45669270e-07},{-4.14214190e-06,-7.60897600e-06},
        {3.56005090e-05,2.47871650e-05},{-1.21602380e-04,-3.15256350e-05},
        {9.70487690e-05,1.36089640e-05}
      }
    },
    {
      {
        {1.92785950e-08,9.50231470e-08},{-2.03481390e-07,-4.76438570e-07},
        {9.03340190e-07,9.83227120e-07},{-1.40487740e-06,-9.75055150e-07},
        {7.14299530e-07,3.66927690e-07}
      },
        {
        {-5.42056280e-09,1.45276720e-08},{2.12743580e-07,-8.08843360e-07},
        {-4.40646880e-07,1.38775100e-06},{1.06455670e-06,-1.25527730e-06},
        {-9.75562670e-07,4.47698070e-07}
      },
        {
        {-1.74341460e-09,-1.12201190e-07},{-6.63653570e-07,1.43914650e-06},
        {2.40020260e-07,-1.70346880e-06},{3.22337630e-06,9.30306730e-07},
        {-3.32575140e-06,-1.70274280e-07}
      }
    },
    {
      {
        {7.60350620e-11,2.02921980e-08},{-1.28732070e-08,-9.89280550e-08},
        {6.72372850e-08,2.35334710e-07},{-9.43211230e-08,-2.54896770e-07},
        {4.00699820e-08,1.01143230e-07}
      },
        {
        {-3.46615860e-09,-2.93391320e-09},{5.87991270e-08,6.02816870e-08},
        {-1.60038450e-07,-1.35134370e-07},{1.46155740e-07,1.42362900e-07},
        {-3.39923780e-08,-5.57480650e-08}
      },
        {
        {-1.53647790e-08,7.99185470e-09},{-3.83447050e-08,-5.61203150e-08},
        {2.92214880e-07,1.68522670e-07},{-3.76976880e-07,-2.03113920e-07},
        {1.71902150e-07,8.50359290e-08}
      }
    },
    {
      {
        {-3.99379840e-10,-2.13078270e-10},{2.30393130e-09,5.25750900e-09},
        {-5.15541420e-09,-1.56460370e-08},{4.79585320e-09,1.89206860e-08},
        {-1.62792350e-09,-7.93548330e-09}
      },
        {
        {1.28760750e-10,-4.88681650e-10},{2.02417430e-10,3.68859390e-09},
        {-8.12131410e-09,-6.12998070e-09},{1.68193660e-08,4.68891260e-09},
        {-9.43896580e-09,-1.37416790e-09}
      },
        {
        {-8.55691310e-10,2.49037130e-09},{-1.10224740e-09,-1.54651070e-08},
        {1.92392090e-08,3.15470200e-08},{-2.62310290e-08,-3.19491970e-08},
        {8.25960040e-09,1.23569060e-08}
      }
    },
    {
      {
        {-1.00168080e-11,-6.82976370e-11},{3.93207550e-10,4.52180120e-10},
        {-1.76161830e-09,-1.29853820e-09},{2.46171020e-09,1.53597320e-09},
        {-1.09456210e-09,-6.35843980e-10}
      },
        {
        {1.27760470e-10,1.26796730e-11},{-6.09144800e-10,-3.35853520e-10},
        {9.72191120e-10,1.04466610e-09},{-6.95891100e-10,-1.33150670e-09},
        {2.04264970e-10,5.79702170e-10}
      },
        {
        {1.52149360e-11,5.16454910e-11},{4.10679040e-12,-8.88618100e-11},
        {1.58113110e-09,-1.59123860e-10},{-4.41716030e-09,3.97092710e-10},
        {2.85852760e-09,-2.05497340e-10}
      }
    },
    {
      {
        {2.84229780e-12,-2.39168850e-11},{1.49869520e-11,1.16537410e-10},
        {-1.18186580e-10,-2.90709950e-10},{1.92330800e-10,3.22525860e-10},
        {-9.21055290e-11,-1.29185180e-10}
      },
        {
        {-5.97522290e-12,-8.50861500e-13},{2.57086300e-11,-1.69587390e-11},
        {4.38317050e-12,7.96716190e-11},{-8.75665350e-11,-1.14116890e-10},
        {6.41952610e-11,5.21977490e-11}
      },
        {
        {1.74170710e-11,1.87527680e-11},{5.18609680e-11,8.05891970e-11},
        {-5.59291100e-10,-2.46084960e-10},{8.64494480e-10,3.01728190e-10},
        {-3.83030250e-10,-1.27527780e-10}
      }
    },
    {
      {
        {8.71829680e-13,-2.73883950e-12},{-7.89769020e-12,1.63503090e-11},
        {2.02599400e-11,-4.72702040e-11},{-1.89420770e-11,5.72314930e-11},
        {5.71103670e-12,-2.41775030e-11}
      },
        {
        {-7.88731210e-13,1.56360030e-12},{-5.94713710e-12,-8.56195900e-12},
        {2.65890630e-11,2.25892170e-11},{-2.99856480e-11,-2.56774260e-11},
        {1.01349740e-11,1.03957590e-11}
      },
        {
        {-3.48843070e-12,-3.92060200e-12},{3.52304140e-11,2.75029980e-11},
        {-9.60636810e-11,-7.42439960e-11},{1.05794280e-10,8.58707390e-11},
        {-4.29530120e-11,-3.52063970e-11}
      }
    },
    {
      {
        {-4.22399070e-13,-2.57785600e-13},{6.35778320e-13,1.26953440e-12},
        {2.56777790e-12,-3.24554260e-12},{-5.93868270e-12,3.61780010e-12},
        {3.14167910e-12,-1.44830350e-12}
      },
        {
        {-2.63321890e-13,2.74825440e-14},{2.65738630e-12,2.01991720e-13},
        {-7.29379750e-12,-2.29258780e-13},{8.53865070e-12,7.54029500e-14},
        {-3.65594080e-12,1.07244910e-14}
      },
        {
        {2.00526430e-12,-9.60877910e-13},{-6.93929260e-12,2.43978020e-12},
        {-1.34729110e-12,-7.16954590e-12},{2.96544600e-11,8.67087520e-12},
        {-2.31799680e-11,-3.64518320e-12}
      }
    }
  }
};
