[![DOI](https://zenodo.org/badge/74060190.svg)](https://zenodo.org/badge/latestdoi/74060190)

Radar Software Toolkit
========
The Radar Software Toolkit (RST) is maintained by the SuperDARN Data Analysis Working Group (DAWG). For general information and updates from the DAWG, visit our website at https://superdarn.github.io/dawg/

## Documentation
RST's documentation is currently hosted on two sites:
- RST readthedocs includes the installation guide, RST Tutorials, and SuperDARN data formats (coming soon):
  https://radar-software-toolkit-rst.readthedocs.io/en/latest/
- RST API documentation includes the software structure and binary command line description and options: 
  https://superdarn.github.io/rst/

## Installation

Installation guide for:
  - [Linux](https://radar-software-toolkit-rst.readthedocs.io/en/latest/user_guide/linux_install/)
  - [MacOSX](https://radar-software-toolkit-rst.readthedocs.io/en/latest/user_guide/mac_install/)
  - <font color="grey">Windows </font> yet to be implemented

## Citing SuperDARN Data 
The Super Dual Auroral Radar Network (SuperDARN) consists of more than 30 radars operated by institutions in 10 different countries. The following review papers are recommended for general information about the network's scientific achievements, and for citing SuperDARN in publications:

Greenwald, R.A., Baker, K.B., Dudeney, J.R. et al. Space Sci Rev (1995) 71: 761. doi:10.1007/BF00751350

Chisham, G., Lester, M., Milan, S.E. et al. A decade of the Super Dual Auroral Radar Network (SuperDARN): scientific achievements, new techniques and future directions. Surv Geophys 28, 33–109 (2007) doi:10.1007/s10712-007-9017-8

Nishitani, N., Ruohoniemi, J.M., Lester, M. et al. Review of the accomplishments of mid-latitude Super Dual Auroral Radar Network (SuperDARN) HF radars. Prog Earth Planet Sci 6, 27 (2019) doi:10.1186/s40645-019-0270-5

During your study, if using data from individual radars only, **please contact the Principal Investigator (PI) of that radar about potential co-authorship**. A list of radars, institutions, and their PI's information can be found [here](https://superdarn.ca/radar-info)

For more information please read [citing SuperDARN data](https://radar-software-toolkit-rst.readthedocs.io/en/latest/user_guide/citing.md)

## Contribute to RST
The DAWG welcomes new testers and developers to join the team. Here are some ways to contribute:

  - Test pull requests: to determine which [pull requests](https://github.com/SuperDARN/rst/pulls) need to be tested right away, filter them by their milestones
  - Get involved in projects: the [projects](https://github.com/SuperDARN/rst/projects) page is used to organize our priority areas. Each project board shows items which are in progress, ready for testing/review, and completed.
 - Discuss [issues](https://github.com/SuperDARN/rst/issues) and answer questions
 - Become a developer: if you would like to contribute code to RST, please contact us at darn-dawg *at* isee *dot* nagoya-u *dot* ac *dot* jp or submit a new [issue](https://github.com/SuperDARN/rst/issues) on Github.
