--- 
name: New Feature
about: Add a new feature 

---

# New Feature 
**Name:**

**function:** *filename.c*

**bin/lib:** */directory*

## Issue reference

**Issue** *issue number*

## Scope

*What does this feature do?*

*What does this feature not do?* 

### Requirements Checklist

- [ ] RST compiles cleanly (no additional warnings and without errors)
- [ ] code runs as expected 
- [ ] similar user interface to other RST binaries
- [ ] similar code structure to other RST libraries 
- [ ] Code documentation
- [ ] write user documentation 
- [ ] merge to `develop`

## Test code

*Please provide an example of how to test the code*

*Please provide expected output of the test code*

## Extra notes

*Please provide any other information on this PR here.*

*Example info:*
- *Does it use metadata?*
- *Does it require a change in the `make.build; make.code`?*
- *New dependencies or requirements to installing RST?*
- *Are there **performance hits/improvements**?*
- *Compiler version?* `gcc --version`
- *Operating system?*
- *What is the [design pattern](https://refactoring.guru/design-patterns/template-method)?*
