---
name: Documentation
about: Update documentation

---

# Documentation 

**Title:** 

## Issue reference

**Issue:** *issue number*

## Category

Which category does this documentation add/updated/remove?
- [ ] code documentation
- [ ] README
- [ ] installation guide
    - [ ] OS specifics
    - [ ] dependency
- [ ] tutorials 
    - [ ] plotting
    - [ ] io
    - [ ] data products 
- [ ] data product information 
- [ ] examples
- [ ] citing/licensing
- [ ] trouble shooting
    - [ ] installation
    - [ ] tutorials
- [ ] history

### Details

*Please provide more details on the add/updated/removed documentation on the selected categories.* 

### Goals

What goals are you trying to achieve with the add/updated/removed documentation? 
- [ ] readability (fixing typos/grammar)
- [ ] conciseness (making it less confusing)
- [ ] updating (updating old plots/code examples)
- [ ] warnings (warning of caveats or potential issues)
- [ ] user-interface (making something more user friendly)

## Checklist

- [ ] spell checker (US recommended)
- [ ] grammar checker
- [ ] view in readthedocs/markdown viewer (if applicable)
- [ ] proof read

### Reviewers Help

What do you want the review to focus on? 
- [ ] spelling/grammar (US recommended)
- [ ] accuracy
- [ ] readability
- [ ] fluiditiy 
- [ ] test out examples (if applicable)
- [ ] follow steps (if applicable)

## **readthedocs** Link/Display

*Please provide the readthedocs link to your documentation or how to view it.* 
