---
name: New Feature
about: Notify other developers that you intend to add a new feature to the RST

---

# New Feature

**Name**: *Feature name*

**function**:  *filename.c*

**bin/lib**: */directory*

## Description & User Interface

*Please provide a description of the new feature. What will the feature do/not do?*

*Please provide **pseudocode** to demonstrate the new feature's user interface*

## RST Checklist

- [ ] Does the feature fit within RST's scope?
- Is this a major or minor change?
    - [ ] Major (e.g. includes large amounts of new code, existing code significantly restructured, or impacts on other RST libraries/binaries)
    - [ ] Minor (e.g. addition of a new self-contained library)
-  [ ] Do you need help developing it?
-  [ ] Have you created a (github project)[https://github.com/SuperDARN/rst/projects] to reflect the process of developing it? (optional)
-  [ ] Can the code be released under the GPL v3.0 license?
-  [ ] Does the source code include copyright and authorship information? (can be added later at the pull request stage)

## Development help

*RST does not have a dedicated team for full feature development. However, the community may be able to assist you with development.*

*If you need help please indicate what expertise you are looking for:*

- [ ] developer help with design and integration of code
- [ ] scientific help to ensure that the new feature produces the expected results
- [ ] project management to help organize the steps involved in adding the new feature to RST
- [ ] other______

*Note: all code will be tested/reviewed before being merged into the RST codebase.*

## Timeline

*When do you expect the code will be ready for testing?*

*If you need help with development, when do you expect to need help?*

## Extra Notes

*Please provide any other details about this feature*

- *Publications*
- *GitHub link to code in another language*
- *Potential solutions to current/future problems*
