---
name: Deprecation
about: Suggest removing an option or a feature
---

# DEPRECATION

**Feature:**

**function:**  *filename.c*

**bin/lib:** */directory*

## Reason

*Why should this feature be deprecated?  Possible reasons include being outside of RST's current scope, or being a legacy function that is no longer used.*

## Replacement

*Would anything replace this feature?*

## Potential Issues

- [ ] Backwards compatibility - *Could this affect any old-format files or other RST code? Does it affect backward compatibility?*
- [ ] Reproducibility  - *Could this affect the reproducibility of analysis results between different RST versions?*

### Communication with the SuperDARN community

*How should users be informed about this deprecation?*

## Approval from PI Executive Council and/or Data Standards Working Group

*Deprecation of a feature or library may require approval from the PI Executive Council and/or the Data Standards Working Group (DSWG).*

- [ ] Approval from PI Executive Council - *changes that could affect the scientific interpretation of SuperDARN data*
- [ ] Approval from DSWG - *deprecations related to file formats, data file I/O, integration of hardware files*
- [ ] Approval not necessary - *simple deprecations such as command line options or removing duplicated code*

## Details

*Please provide any other details about the deprecation process and the future.*