% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_input.R
\name{write_input}
\alias{write_input}
\title{write_input}
\usage{
write_input(x, file = "TSM_y.txt", nptperyear = 23, missing = -0.1)
}
\arguments{
\item{x}{matrix row is site, column is time.}

\item{file}{a character string naming a file.}

\item{nptperyear}{How many points per year?}
}
\description{
Write matrix into the format of TIMESAT.
}
\note{
not allow NA values in x
}
\examples{
library(rTIMESAT)
data("MOD13A1")
df <- subset(MOD13A1$dt, date >= as.Date("2010-01-01") & date <= as.Date("2017-12-31"))

sitename <- "CA-NS6"
d <- subset(df, site == sitename)
nptperyear <- 23

file_y <- sprintf("TSM_\%s_y.txt", sitename)
file_qc <- sprintf("TSM_\%s_w.txt", sitename)

write_input(d$EVI/1e4 , file_y, nptperyear)
write_input(d$SummaryQA, file_qc, nptperyear)
}
