% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_tts.R
\name{read_tts}
\alias{read_tts}
\title{read_tts}
\usage{
read_tts(file)
}
\arguments{
\item{file}{A .tts file output by TIMESAT}
}
\value{
A data.frame containing 'row' and 'col' columns giving the the row 
and column of a pixel in the input image to timesat, and then a number of 
columns named 't1', 't2', ...'tn', where n is the total number of image 
dates input to TIMESAT.
}
\description{
Read curve fitting time-series in TIMESAT .tts binary format file to dataframe.
}
\examples{
file <- system.file("example/ascii/TSM_fit.tts", package = "rTIMESAT") 
d_tts <- read_tts(file)
}
\seealso{
\code{\link{TSF_fit2time}}
}
