% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TSF_fit2time.R
\name{TSF_fit2time}
\alias{TSF_fit2time}
\title{TSF_fit2time}
\usage{
TSF_fit2time(
  infile,
  row_start = 1,
  row_end = Inf,
  col_start = 1,
  col_end = 1,
  outdir,
  outfile,
  wait = TRUE
)
}
\arguments{
\item{infile}{file path of curve fitting file.}

\item{row_start}{First row in processing window}

\item{row_end}{Last row in processing window}

\item{col_start}{First col in processing window}

\item{col_end}{Last col in processing window}

\item{outdir}{Output directory.}

\item{outfile}{file name of output.}

\item{wait}{A logical (not NA) indicating whether the R interpreter should
wait for the command to finish, or run it asynchronously.}
}
\description{
Extracts time-series data (raw or fitted) for one or many pixels and writes
to an ASCII file
}
\examples{
\dontrun{
TSF_fit2time(file, 1, 1e8, 1, 1, outdir = "TSF", wait = F)
}
}
\seealso{
\code{\link{read_tts}}
}
