C     NICHEMAPR: SOFTWARE FOR BIOPHYSICAL MECHANISTIC NICHE MODELLING

C     COPYRIGHT (C) 2020 MICHAEL R. KEARNEY AND WARREN P. PORTER

C     THIS PROGRAM IS FREE SOFTWARE: YOU CAN REDISTRIBUTE IT AND/OR MODIFY
C     IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
C     THE FREE SOFTWARE FOUNDATION, EITHER VERSION 3 OF THE LICENSE, OR (AT
C      YOUR OPTION) ANY LATER VERSION.

C     THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
C     WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
C     MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
C     GENERAL PUBLIC LICENSE FOR MORE DETAILS.

C     YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
C     ALONG WITH THIS PROGRAM. IF NOT, SEE HTTP://WWW.GNU.ORG/LICENSES/.

C     ROOT FINING ROUTINE TO FIND METABOLIC RATE THAT BALANCES HEAT BUDGET 
C     ACCOUNTING FOR RESPIRATORY HEAT LOSS
C     MODIFIED FROM
C     RICHARD BRENT,
C     ALGORITHMS FOR MINIMIZATION WITHOUT DERIVATIVES,
C     DOVER, 2002,
C     ISBN: 0-486-41998-3,
C     LC: QA402.5.B74.

C     EPS IS MACHINE FLOATING POINT PRECISION

      SUBROUTINE ZBRENT_ENDO(QM1,QM2,TOL,INPUT,RESPOUT)

      IMPLICIT NONE

      INTEGER ITER,ITMAX
      DOUBLE PRECISION A,B,BARPRS,C,CO2GAS,D,DIAGNOS,E,EPS,EXTREF,GMASS
      DOUBLE PRECISION INPUT,N2GAS,O2GAS,P,PANT,Q,QA,QB,QC,QM,QM1,QM2
      DOUBLE PRECISION QMIN,QSUM,R,RELHUM,RELXIT,RESPOUT,RP_CO2,RQ,S
      DOUBLE PRECISION TAEXIT,TAIREF,TIMACT,TLUNG,TOL,TOL1,W1,XM,ZBRENT3
      
      DIMENSION INPUT(17),RESPOUT(15)
      
      TAIREF=INPUT(1)
      O2GAS=INPUT(2) 
      N2GAS=INPUT(3)
      CO2GAS=INPUT(4)
      BARPRS=INPUT(5)
      QMIN=INPUT(6)
      RQ=INPUT(7)
      TLUNG=INPUT(8)
      GMASS=INPUT(9)
      EXTREF=INPUT(10)
      RELHUM=INPUT(11)
      RELXIT=INPUT(12)
      TIMACT=INPUT(13)
      TAEXIT=INPUT(14)
      QSUM=INPUT(15)
      PANT=INPUT(16)
      RP_CO2=INPUT(17)
      
      XM=0.
      W1=0.
      E=0.
      C=0.
C     PARAMETER (ITMAX=20,EPS=3.E-8)
      ITMAX=300
      EPS=3.E-8
      DIAGNOS = 0.
      A=QM1
      B=QM2

      CALL RESPFUN(TAIREF,A,O2GAS,N2GAS,CO2GAS,BARPRS,QMIN,RQ,TLUNG,
     &GMASS,EXTREF,RELHUM,RELXIT,TIMACT,TAEXIT,PANT,QSUM,RP_CO2,RESPOUT)

      QA=RESPOUT(1)
      
      CALL RESPFUN(TAIREF,B,O2GAS,N2GAS,CO2GAS,BARPRS,QMIN,RQ,TLUNG,
     &GMASS,EXTREF,RELHUM,RELXIT,TIMACT,TAEXIT,PANT,QSUM,RP_CO2,RESPOUT)

      QB=RESPOUT(1)
      
      QC=QB ! MAKE THIRD BALANCE THE ONE FROM THE SECOND GUESS
      
      DO 11 ITER=1,ITMAX
       IF(QB*QC.GT.0.) THEN ! EITHER THIRD GUESS AND SECOND GUESS BALANCES ARE BOTH POSITIVE OR BOTH NEGATIVE
        C=A ! MAKE THIRD GUESS VALUE EQUAL TO THE FIRST GUESS
        QC=QA ! MAKE THIRD GUESS BALANCE EQUAL TO FIRST GUESS BALANCE
        D=B-A ! GET MAGNITUDE OF DIFFERENCE BETWEEN SECOND AND FIRST GUESS
        E=D ! KEEP ANOTHER COPY OF THE ABOVE DIFFERENCE
       ENDIF
       IF(ABS(QC).LT.ABS(QB)) THEN ! SECOND AND THIRD GUESSES SPAN THE SOLUTION, WITH GUESS C GIVING THE NEGATIVE BALANCE
        A=B ! USE B AS LOWER GUESS
        B=C ! USE C AS THE UPPER GUESS
        C=A ! USE C 
        QA=QB
        QB=QC
        QC=QA
       ENDIF
       TOL1=2.*EPS*ABS(B)+0.5*TOL
       QM=.5*(C-B)
       IF(ABS(QM).LE.TOL1 .OR. QB.EQ.0.)THEN
        ZBRENT3=B
        GO TO 20
       ENDIF
C      AN ADDITION, SINCE THIS SUBROUTINE SOMETIMES MISSES A SOLUTION
C      WARREN PORTER 2003
       IF(ABS(QB).LE.TOL)THEN
        IF(ITER.GT.1)THEN
         ZBRENT3=B ! SOLUTION FOUND
         GO TO 20
        ENDIF
       ENDIF
       IF(ABS(E).GE.TOL1 .AND. ABS(QA).GT.ABS(QB)) THEN
        S=QB/QA
        IF(A.EQ.C) THEN
         P=2.*QM*S
         Q=1.-S
        ELSE
         Q=QA/QC
         R=QB/QC
         P=S*(2.*QM*Q*(Q-R)-(B-A)*(R-1.))
         Q=(Q-1.)*(R-1.)*(S-1.)
        ENDIF
        IF(P.GT.0.) Q=-Q
        P=ABS(P)
        IF(2.*P .LT. MIN(3.*XM*Q-ABS(TOL1*Q),ABS(E*Q))) THEN
         E=D
         D=P/Q
        ELSE
         D=QM
         E=D
        ENDIF
       ELSE
        D=QM
        E=D
       ENDIF
       A=B
       QA=QB
       IF(ABS(D) .GT. TOL1) THEN
        B=B+D
       ELSE
        B=B+SIGN(TOL1,XM)
       ENDIF
       
       CALL RESPFUN(TAIREF,B,O2GAS,N2GAS,CO2GAS,BARPRS,QMIN,RQ,TLUNG,
     &GMASS,EXTREF,RELHUM,RELXIT,TIMACT,TAEXIT,PANT,QSUM,RP_CO2,RESPOUT)
     
       QB=RESPOUT(1)  

11    CONTINUE
      IF (DIAGNOS .GT. 0.0) THEN
C      WRITE(0,*) 'ZBRENT EXCEEDING MAXIMUM ITERATIONS.'
      ENDIF
      ZBRENT3=B
      
20    RETURN
      END