      SUBROUTINE WINGSOLAR

C     NICHEMAPR: SOFTWARE FOR BIOPHYSICAL MECHANISTIC NICHE MODELLING

C     COPYRIGHT (C) 2018 MICHAEL R. KEARNEY AND WARREN P. PORTER

C     THIS PROGRAM IS FREE SOFTWARE: YOU CAN REDISTRIBUTE IT AND/OR MODIFY
C     IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
C     THE FREE SOFTWARE FOUNDATION, EITHER VERSION 3 OF THE LICENSE, OR (AT
C      YOUR OPTION) ANY LATER VERSION.

C     THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
C     WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
C     MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
C     GENERAL PUBLIC LICENSE FOR MORE DETAILS.

C     YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
C     ALONG WITH THIS PROGRAM. IF NOT, SEE HTTP://WWW.GNU.ORG/LICENSES/.

C     THIS SUBROUTINE COMPUTES THE SOLAR RADIATION ABSORBED BY THE
C     BODY OF A BUTTERFLY USING AN FHAT SOLUTION FOR ALL DIFFUSE
C     REFLECTIONS

      IMPLICIT NONE

      DOUBLE PRECISION ABS1,ABS3,ABSSB,ABSAN,ADIR,ALPHA2,ARDIR,AREA1
      DOUBLE PRECISION AREA2,AREA3,AREA4,AREA4B,AREA5,AREA6,AREF,ASILN
      DOUBLE PRECISION ASILP,BREF,CREF,F12,F13,F14,F15,F16,F21,F23,F24
      DOUBLE PRECISION F25,F26,F31,F32,F34,F35,F36,F41,F42,F43,F45,F46
      DOUBLE PRECISION F51,F52,F54,F56,F61,F62,FATOBJ,FREF,FREF21,FREF31
      DOUBLE PRECISION NM,PDIF,PHI,PHIREF,PI,QDIFF,QDIR,QSOL,QSOLAR
      DOUBLE PRECISION QSOLART,QSOLARW,RHO1,RHO1_3,RHO2,RHO3,SOLDIF
      DOUBLE PRECISION SOLDIR,TRANS1,WC,ZEN

      DIMENSION PHI(20)

      COMMON/AS/AREA1,AREA2,AREA3,AREA4,AREA4B,AREA5,AREA6,ASILP
      COMMON/F1X/F12,F13,F14,F15,F16
      COMMON/F2X/F21,F23,F24,F25,F26
      COMMON/F3X/F31,F32,F34,F35,F36
      COMMON/F4X/F41,F42,F43,F45,F46
      COMMON/F5X/F51,F52,F54,F56
      COMMON/F6X/F61,F62
      COMMON/FLUXES/QSOLARW,QSOLART,QSOL
      COMMON/MASTERS/AREF,BREF,CREF,PHIREF,PHI
      COMMON/REFLS/RHO1_3,RHO2,TRANS1
      COMMON/FUN5/WC,ZEN,PDIF,ABSSB,ABSAN,ASILN,FATOBJ,NM


      DATA PI/3.14159265/

C     ABSORPTIVITY OF THE BACK ON THE BODY
      ALPHA2=1.0-RHO2
C     REFLECTIVITY OF THE WINGS, SURFACES 1 & 3
      RHO1=RHO1_3
      RHO3=RHO1_3
C     INCIDENT SOLAR RADIATION (W/M2)
      SOLDIR=(1.0-PDIF)*QSOL
      SOLDIF=PDIF*QSOL

C     AMOUNT REFLECTED FROM EACH WING
      ABS1 = RHO1*AREA1*QSOL
      ABS3 = RHO3*AREA3*QSOL

C     CONFIGURATION FACTOR FOR WING #1 TO BACK SURFACE #2
      FREF=F12/(1.0 - RHO3*F13-RHO1*RHO2*F12*F21-RHO2*RHO3*F12*F23)
C     CONFIGURATION FACTOR FOR BACK SURFACE #2 TO WING #1
      FREF21=F21/(1.0-RHO3*F23-RHO1*RHO2*F12*F21-RHO1*RHO3*F21*F13)
C     CONFIGURATION FACTOR FOR WING #3 TO WING #1
      FREF31=F31/(1.0-RHO2*F32-RHO1*RHO3*F31*F13-RHO1*RHO3*F21*F13)

C     TOTAL SOLAR ABSORBED BY THE BUTTERFLY DORSAL SURFACE BETWEEN THE WINGS.
C     QSOLAR = QDIR + QDIFF,12 + QDIFF,32
      ADIR=AREA4/AREA2
      IF(ADIR.GT.1.0)THEN
       ARDIR=ASILP
      ELSE
       ARDIR=ASILP*ADIR
      ENDIF
      QDIR=ALPHA2*ARDIR*SOLDIR
      IF(AREA4.LE.0.000000)THEN
C      COMPLETELY CLOSED WINGS.  ONLY TRANSMITTED DIFFUSE GETS TO BACK
       QDIFF=TRANS1*ALPHA2*QSOL
      ELSE
       IF(PHIREF.GT.PI/2)THEN
        QDIFF=2.*RHO1*ALPHA2*AREA1*FREF*QSOL
       ELSE
        QDIFF=2.*TRANS1*ALPHA2*AREA1*FREF*QSOL
       ENDIF
      ENDIF

      QSOLAR=QDIR+QDIFF
      QSOLART=QSOLAR

C     TOTAL SOLAR ABSORBED BY THE BUTTERFLY WING.
C     QSOLAR = QDIR + QDIFF,21 + QDIFF,31
      ARDIR=AREA4B
      QDIR=(1-RHO3)*ARDIR*SOLDIR
      QDIFF=RHO3*AREA4B*FREF31*(1-RHO3)*QSOL+QSOLART*(1-RHO3)*FREF21

      QSOLAR=QDIR+QDIFF
      QSOLARW=QSOLAR

      RETURN
      END