      SUBROUTINE WINGS(RHO1_31,RHO21,TRANS11,QSOL1,AREF1,BREF1,CREF1,
     &PHI1,F211,F311,F411,F511,F611,F121,F321,F421,F521,SIDEX1,QSOLARW1,
     &QSOLART1,AREA11,AREA21,AREA31,AREA41,AREA4B1,AREA51,AREA61,
     &F131,F141,F151,F161,F231,F241,F251,F261,ASILP1)

C     NICHEMAPR: SOFTWARE FOR BIOPHYSICAL MECHANISTIC NICHE MODELLING

C     COPYRIGHT (C) 2018 MICHAEL R. KEARNEY AND WARREN P. PORTER

C     THIS PROGRAM IS FREE SOFTWARE: YOU CAN REDISTRIBUTE IT AND/OR MODIFY
C     IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
C     THE FREE SOFTWARE FOUNDATION, EITHER VERSION 3 OF THE LICENSE, OR (AT
C      YOUR OPTION) ANY LATER VERSION.

C     THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
C     WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
C     MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
C     GENERAL PUBLIC LICENSE FOR MORE DETAILS.

C     YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
C     ALONG WITH THIS PROGRAM. IF NOT, SEE HTTP://WWW.GNU.ORG/LICENSES/.

C     THIS PROGRAM COMPUTES THE RADIANT EXCHANGE BETWEEN TWO RECTANGLES OF THE
C     SAME LENGTH ON THE COMMON EDGE. THEY MAY BE DIFFERENT WIDTHS.
C     ONE EDGE IS COMMON TO BOTH.  THEY CAN BE AT ANY ANGLE TO EACH OTHER.
C     THIS IS AN IMPLIMENTATION OF THE CONFIGURATION FACTOR #2, P.340, IN APPENDIX A OF
C     SPARROW,E.M AND R.D. CESS. 1966.  RADIATION HEAT TRANSFER.  WADSWORTH PUBL.
C     CO., INC.  BELMONT, CA.366 P
C     CURRENTLY THIS ASSUMES UNIFORM COLOR AND TEMPERATURE OF THE WINGS.

      IMPLICIT NONE

      DOUBLE PRECISION A,ANGLE,AREA1,AREA11,AREA2,AREA21,AREA3,AREA31
      DOUBLE PRECISION AREA4,AREA41,AREA4B,AREA4B1,AREA5,AREA51,AREA6
      DOUBLE PRECISION AREA61,AREF,AREF1,ASILP,ASILP1,B,BREF,BREF1,C
      DOUBLE PRECISION CREF,CREF1,F,F12,F121,F13,F131,F14,F141,F15,F151
      DOUBLE PRECISION F16,F161,F1X,F21,F211,F23,F231,F24,F241,F25,F251
      DOUBLE PRECISION F26,F261,F31,F311,F32,F321,F34,F35,F36,F41,F411
      DOUBLE PRECISION F42,F421,F43,F45,F46,F51,F511,F52,F521,F54,F56
      DOUBLE PRECISION F61,F611,F62,FXY,FY3,PHI,PHI1,PHIREF,PI,QSOL
      DOUBLE PRECISION QSOL1,QSOLART,QSOLART1,QSOLARW,QSOLARW1,RHO1_3
      DOUBLE PRECISION RHO1_31,RHO2,RHO21,SIDEX,SIDEX1,SUM1ALL,SUM2ALL
      DOUBLE PRECISION SUM3ALL,SUM4ALL,SUM5ALL,SUM6ALL,SURFAC,TRANS1
      DOUBLE PRECISION TRANS11,X

      INTEGER I,I2,NDEG

      DIMENSION PHI(20)

      COMMON/AS/AREA1,AREA2,AREA3,AREA4,AREA4B,AREA5,AREA6,ASILP
      COMMON/FLUXES/QSOLARW,QSOLART,QSOL
      COMMON/F1X/F12,F13,F14,F15,F16
      COMMON/F2X/F21,F23,F24,F25,F26
      COMMON/F3X/F31,F32,F34,F35,F36
      COMMON/F4X/F41,F42,F43,F45,F46
      COMMON/F5X/F51,F52,F54,F56
      COMMON/F6X/F61,F62
      COMMON/FXX/F1X,FXY,FY3
      COMMON/INTGL/X,ANGLE
      COMMON/LENGTHS/SIDEX
      COMMON/MASTERS/AREF,BREF,CREF,PHIREF,PHI
      COMMON/RECTNGL/A,B,C,F
      COMMON/REFLS/RHO1_3,RHO2,TRANS1
      COMMON/SUMS/SUM1ALL,SUM2ALL,SUM3ALL,SUM4ALL,SUM5ALL,SUM6ALL

      I=0
      ASILP=ASILP1
      PI=3.14159265
C     NUMBER OF DIFFERENT ANGLES TO PROCESS
      NDEG=1
C     SETTING OUTPUT SURFACE TO OTHER SURFACES (USE A REAL NUMBER)
      SURFAC=5.0

      RHO1_3=RHO1_31
      RHO2=1-RHO21
      TRANS1=TRANS11
      QSOL=QSOL1
C     CONVERT LENGTHS TO METRES
      AREF=AREF1/100.
      BREF=BREF1/100.
      CREF=CREF1/100.
      PHI(1)=PHI1

      I2=6

C     WING REFLECTANCES(SURFACES 1,3),TORSO(SURFACE 2), INCOMING SOLAR (W/CM2)
C     AREF = WIDTH OF SURFACE #2 (BACK OR HORIZONTAL OR REFERENCE SURFACE)
C     BREF = COMMON LENGTH WHERE THE TWO RECTANGLES JOIN
C     CREF = WIDTH OF SURFACE #1 (WING)

C     BEGIN CALCULATIONS
      DO 1 I=1,NDEG
C      DEGREES TO RADIANS
       ANGLE=PHI(I)*PI/180.
       PHIREF= ANGLE
C      BODY WIDTH
       A=AREF
C      BODY & WING LENGTH (PARALLEL TO LONG AXIS OF BODY)
       B=BREF
C      WING WIDTH
       C=CREF
C      CALL GEOM SUBROUTINE FOR BUTTERFLY TO GET AREAS AND CONFIGURATION FACTORS, F
       CALL BTRFLGEOM
       CALL WINGSOLAR
1     CONTINUE
C     END OF WING DEGREES CHANGING LOOP

      F211=F21
      F311=F31
      F411=F41
      F511=F51
      F121=F12
      F321=F32
      F421=F42
      F521=F52
      F131=F13
      F141=F14
      F151=F15
      F161=F16
      F611=F61
      F231=F23
      F241=F24
      F251=F25
      F261=F26
      SIDEX1=SIDEX
      QSOLARW1=QSOLARW
      QSOLART1=QSOLART
      AREA11=AREA1
      AREA21=AREA2
      AREA31=AREA3
      AREA41=AREA4
      AREA4B1=AREA4B
      AREA51=AREA5
      AREA61=AREA6
      RETURN
      END