      SUBROUTINE WATER (TWATR,BETA,CP,DENSTY,THCOND,VISDYN)

C     NICHEMAPR: SOFTWARE FOR BIOPHYSICAL MECHANISTIC NICHE MODELLING

C     COPYRIGHT (C) 2018 MICHAEL R. KEARNEY AND WARREN P. PORTER

C     THIS PROGRAM IS FREE SOFTWARE: YOU CAN REDISTRIBUTE IT AND/OR MODIFY
C     IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
C     THE FREE SOFTWARE FOUNDATION, EITHER VERSION 3 OF THE LICENSE, OR (AT
C      YOUR OPTION) ANY LATER VERSION.

C     THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
C     WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
C     MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
C     GENERAL PUBLIC LICENSE FOR MORE DETAILS.

C     YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
C     ALONG WITH THIS PROGRAM. IF NOT, SEE HTTP://WWW.GNU.ORG/LICENSES/.

C     PROPERTIES OF WATER

C     THE REGRESSIONS FOR THESE PROPERTIES WERE OBTAINED USING
C     GRAPHER FROM GOLDEN SOFTWARE ON DATA ON P. 262 OF EDE'S
C     AN INTRODUCTION OF HEAT TRANSFER PRINCIPLES AND CALCULATIONS
C     PERGAMMON PRESS.  1967. (W. PORTER, 14 JULY, 1988)

C     BETA = COEFFICIENT OF EXPANSION (1/C)
C     CP = SPECIFIC HEAT (J/KG-C)
C     DENSTY = WATER DENSITY (KG/M3)
C     THCOND = THERMAL CONDUCTIVITY (W/M-C)
C     VISDYN = DYNAMIC VISCOSITY (KG/M-S)

      IMPLICIT NONE

      DOUBLE PRECISION BETA,CP,DENSTY,THCOND,TWATR,VISDYN

      BETA=0.21E-03
      CP=4220.02-4.5531*TWATR+0.182958*TWATR**2.-0.00310614*
     &  TWATR**3.+1.89399E-5*TWATR**4.
      IF(TWATR.LT.30.)THEN
       DENSTY=1000.
      ELSE
       IF(TWATR.LE.60.)THEN
        DENSTY=1017.-0.6*TWATR
       ELSE
        TWATR= 60.
        DENSTY= 1017.-0.6*TWATR
       ENDIF
      ENDIF
      THCOND=0.551666+0.00282144*TWATR-2.02383E-5*TWATR**2.
      VISDYN=0.0017515-4.31502E-5*TWATR+3.71431E-7*TWATR**2.
      RETURN
      END