      FUNCTION VAPPRS(DB)

C     NICHEMAPR: SOFTWARE FOR BIOPHYSICAL MECHANISTIC NICHE MODELLING

C     COPYRIGHT (C) 2018 MICHAEL R. KEARNEY AND WARREN P. PORTER

C     THIS PROGRAM IS FREE SOFTWARE: YOU CAN REDISTRIBUTE IT AND/OR MODIFY
C     IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
C     THE FREE SOFTWARE FOUNDATION, EITHER VERSION 3 OF THE LICENSE, OR (AT
C      YOUR OPTION) ANY LATER VERSION.

C     THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
C     WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
C     MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
C     GENERAL PUBLIC LICENSE FOR MORE DETAILS.

C     YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
C     ALONG WITH THIS PROGRAM. IF NOT, SEE HTTP://WWW.GNU.ORG/LICENSES/.

      IMPLICIT NONE

      DOUBLE PRECISION DB,ESTAR,LOGE,T,VAPPRS
C     TEMPERATURE LIMITS ON DB
      IF (DB .GT. 100.) THEN
       DB = 100.
      ELSE
       IF (DB .LT. -40.) THEN
        DB = -40.
       ELSE
       CONTINUE
       ENDIF
      ENDIF
      T=DB+273.16
      IF (T .LE. 273.16) GO TO 20
      LOGE=-7.90298*(373.16/T-1.)+5.02808*DLOG10(373.16/T)-1.3816E-07
     &*(10.**(11.344*(1.-T/373.16))-1.)+8.1328E-03*(10.**(-3.49149*
     &(373.16/T-1.))-1.)+ALOG10(1013.246)
      ESTAR=(10.**LOGE)*100
      GO TO 30
20    LOGE=-9.09718*(273.16/T-1.)-3.56654*DLOG10(273.16/T)+.876793*
     & (1.-T/273.16)+ALOG10(6.1071)
       ESTAR=(10.**LOGE)*100.
30    CONTINUE
      VAPPRS=ESTAR
      RETURN
      END