      SUBROUTINE TRAPHR(IHOUR,DTIME)

C     NICHEMAPR: SOFTWARE FOR BIOPHYSICAL MECHANISTIC NICHE MODELLING

C     COPYRIGHT (C) 2018 MICHAEL R. KEARNEY AND WARREN P. PORTER

C     THIS PROGRAM IS FREE SOFTWARE: YOU CAN REDISTRIBUTE IT AND/OR MODIFY
C     IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
C     THE FREE SOFTWARE FOUNDATION, EITHER VERSION 3 OF THE LICENSE, OR (AT
C      YOUR OPTION) ANY LATER VERSION.

C     THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
C     WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
C     MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
C     GENERAL PUBLIC LICENSE FOR MORE DETAILS.

C     YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
C     ALONG WITH THIS PROGRAM. IF NOT, SEE HTTP://WWW.GNU.ORG/LICENSES/.

C     THIS SUBROUTINE USES TRAPEZOIDAL INTEGRATION TO COMPUTE TOTAL
C     METABOLISM;             ZP2,DMET,TMET
C     EVAPORATIVE WATER LOSS; ZP3,DEVP,TEVP
C     ENERGY ABSORBED;        ZP4,DEIN,TEIN
C     WATER ABSORBED;         ZP5,DWIN,TWIN
C     DISCRETIONARY ENERGY;   ZP6,DNRG,TNRG
C     DISCRETIONARY WATER;    ZP7,DWTR,TWTR
C     ON A DAILY (D) AND TOTAL TIME SELECTED (T) BASIS

      USE AACOMMONDAT
      IMPLICIT NONE

      DOUBLE PRECISION AIRVOL,CO2MOL,DAIR,DAYAIR,DAYCO2,DAYEIN,DAYEVP
      DOUBLE PRECISION DAYMET,DAYNRG,DAYWIN,DAYWTR,DCO2,DEIN,DELTAR,DEVP
      DOUBLE PRECISION DMET,DNRG,DTIME,DWIN,DWTR,EXTREF,GEVAP,MR_1
      DOUBLE PRECISION MR_2,MR_3,OLDAIR,OLDCO2,OLDEVP,OLDMET,OLDWIN
      DOUBLE PRECISION QCOND,QCONV,QIRIN,QIROUT,QMETAB,QRESP,QSEVAP
      DOUBLE PRECISION QSOLAR,RQ,TEIN,TEVP,TLUNG,TMET,TNRG,TWIN,TWTR


      INTEGER IHOUR,JP,INTNUM,DEB1,NN

      CHARACTER*1 TRANST

      COMMON/FUN1/QSOLAR,QIRIN,QMETAB,QRESP,QSEVAP,QIROUT,QCONV,QCOND
      COMMON/SUM1/DMET,DEVP,DEIN,DWIN,DNRG,DWTR,DAIR,DCO2
      COMMON/SUM2/TMET,TEVP,TEIN,TWIN,TNRG,TWTR
      COMMON/TRANS/JP
      COMMON/DAYINT/DAYMET,DAYEVP,DAYEIN,DAYWIN,DAYNRG,DAYWTR,DAYAIR
      COMMON/REVAP1/TLUNG,DELTAR,EXTREF,RQ,MR_1,MR_2,MR_3,DEB1
      COMMON/REVAP2/GEVAP,AIRVOL,CO2MOL
      COMMON/USROPT/TRANST
      COMMON/INTNUM/INTNUM
      COMMON/DAYSTORUN/NN

C     WE MUST SAVE THE VALUES OF THESE VARIABLES BETWEEN CALLS.
      SAVE OLDMET,OLDEVP,OLDWIN,OLDAIR,OLDCO2

      IF((TRANST.EQ.'Y').OR.(TRANST.EQ.'Y'))THEN
       JP=JP+1
      ENDIF

C     HOURLY INTEGRATION FOR A DAY
      IF(IHOUR.EQ.1) THEN
C      INITIALIZE VARIABLES: ALL VARIABLE QUANTITIES/S
       OLDMET=ZP2(JP)
       OLDEVP=ZP3(JP)
       OLDWIN=ZP5(JP)
       OLDAIR=AIRVOL
       OLDCO2=CO2MOL
       DMET=0.
       DEVP=0.
       DEIN=0.
       DWIN=0.
       DNRG=0.
       DWTR=0.
       DAIR=0.
       DCO2=0.
       DAYMET=0.
       DAYEVP=0.
       DAYEIN=0.
       DAYWIN=0.
       DAYNRG=0.
       DAYWTR=0.
       DAYAIR=0.
      ELSE
C      DO TRAPEZOIDAL INTEGRATION
       DMET=((ZP2(JP)+OLDMET)/2.)*DTIME+DMET
       DEVP=((ZP3(JP)+OLDEVP)/2.)*DTIME+DEVP
C      METABOLIC WATER PRODUCTION
       DWIN=((ZP5(JP)+OLDWIN)/2.)*DTIME+DWIN
       DAIR=((AIRVOL+OLDAIR)/2.)*DTIME+DAIR
       DCO2=((CO2MOL+OLDCO2)/2.)*DTIME+DCO2
C      SET CURRENT VALUE TO OLD VALUE FOR NEXT INTEGRATION
       OLDMET = ZP2(JP)
       OLDEVP = ZP3(JP)
       OLDWIN = ZP5(JP)
       OLDAIR = AIRVOL
       OLDCO2 = CO2MOL
      ENDIF

      IF (IHOUR .EQ. INTNUM) THEN
C      DAILY TOTALS
       DAYMET=DMET
       DAYEVP=DEVP
       DAYWIN=DWIN
       DAYAIR=DAIR
       DAYCO2=DCO2
       DMET=0.
       DEVP=0
       DWIN=0.
       DAIR=0.
       DCO2=0.
      ENDIF
      RETURN
      END