      SUBROUTINE SHADEADJUST
C     NICHEMAPR: SOFTWARE FOR BIOPHYSICAL MECHANISTIC NICHE MODELLING

C     COPYRIGHT (C) 2018 MICHAEL R. KEARNEY AND WARREN P. PORTER

C     THIS PROGRAM IS FREE SOFTWARE: YOU CAN REDISTRIBUTE IT AND/OR MODIFY
C     IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
C     THE FREE SOFTWARE FOUNDATION, EITHER VERSION 3 OF THE LICENSE, OR (AT
C      YOUR OPTION) ANY LATER VERSION.

C     THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
C     WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
C     MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
C     GENERAL PUBLIC LICENSE FOR MORE DETAILS.

C     YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
C     ALONG WITH THIS PROGRAM. IF NOT, SEE HTTP://WWW.GNU.ORG/LICENSES/.

C     ADJUSTS THE AMOUNT OF SHADE.

      IMPLICIT NONE

      DOUBLE PRECISION A1,A2,A3,A4,A4B,A5,A6,ACTHR,AL,ALT,AMASS,ANDENS
      DOUBLE PRECISION AREF,ASIL,ASILP,ATOT,BP,BREF,CREF,CUSTOMGEOM
      DOUBLE PRECISION DEPSEL,DEPSUB,DSHD,EMISAN,EMISSB,EMISSK,F12,F13
      DOUBLE PRECISION F14,F15,F16,F21,F23,F24,F25,F26,F61,F31,F32,F41
      DOUBLE PRECISION F42,F51,F52,FATOSB,FATOSK,FLSHCOND,FLUID,G
      DOUBLE PRECISION H2O_BALPAST,HRN,HSHSOI,HSOIL,MAXSHD,MSHSOI,MSOIL
      DOUBLE PRECISION NEWDEP,PHI,PHIMAX,PHIMIN,PSHSOI,PSOIL,PTCOND
      DOUBLE PRECISION PTCOND_ORIG,QCOND,QCONV,QIRIN,QIROUT,QMETAB,QRESP
      DOUBLE PRECISION QSEVAP,QSOL,QSOLAR,QSOLR,R,RELHUM,RH,RHO1_3,RHREF
      DOUBLE PRECISION SHADE,SHP,SIDEX,SIG,SUBTK,TA,TALOC,TANNUL,TBASK
      DOUBLE PRECISION TC,TCORES,TDIGPR,TEMERGE,TIME,TMAXPR,TMINPR,TOBJ
      DOUBLE PRECISION TPREF,TQSOL,TR,TRANS1,TREF,TSHSOI,TSKIN,TSKY
      DOUBLE PRECISION TSKYC,TSOIL,TSUB,TSUBST,TWING,VEL,VLOC,VREF,WEVAP
      DOUBLE PRECISION WQSOL,Z,ZSOIL

      INTEGER IHOUR,GEOMETRY,MICRO,NODNUM,WINGCALC,WINGMOD

      CHARACTER*1 BURROW,DAYACT,CLIMB,CKGRSHAD,CREPUS,NOCTURN
      
      DIMENSION ACTHR(25),CUSTOMGEOM(8),DEPSEL(25),HRN(25),HSHSOI(25)
      DIMENSION HSOIL(25),MSHSOI(25),MSOIL(25),PSHSOI(25),PSOIL(25)
      DIMENSION QSOL(25),RH(25),RHREF(25),SHP(3),TALOC(25),TCORES(25)
      DIMENSION TIME(25),TREF(25),TSHSOI(25),TSKYC(25),TSOIL(25)
      DIMENSION TSUB(25),VREF(25),Z(25),ZSOIL(10)

      COMMON/BEHAV1/DAYACT,BURROW,CLIMB,CKGRSHAD,CREPUS,NOCTURN
      COMMON/BEHAV2/GEOMETRY,NODNUM,CUSTOMGEOM,SHP
      COMMON/BEHAV3/ACTHR
      COMMON/DEPTHS/DEPSEL,TCORES
      COMMON/ENVAR1/QSOL,RH,TSKYC,TIME,TALOC,TREF,RHREF,HRN
      COMMON/ENVAR2/TSUB,VREF,Z,TANNUL,VLOC
      COMMON/FUN1/QSOLAR,QIRIN,QMETAB,QRESP,QSEVAP,QIROUT,QCONV,QCOND
      COMMON/FUN2/AMASS,RELHUM,ATOT,FATOSK,FATOSB,EMISAN,SIG,FLSHCOND
      COMMON/FUN3/AL,TA,VEL,PTCOND,SUBTK,DEPSUB,TSUBST,PTCOND_ORIG
      COMMON/FUN4/TSKIN,R,WEVAP,TR,ALT,BP,H2O_BALPAST
      COMMON/SHADE/MAXSHD,DSHD
      COMMON/SOIL/TSOIL,TSHSOI,ZSOIL,MSOIL,MSHSOI,PSOIL,PSHSOI,HSOIL,
     & HSHSOI
      COMMON/TPREFR/TMAXPR,TMINPR,TDIGPR,TPREF,TBASK,TEMERGE
      COMMON/TREG/TC
      COMMON/WDSUB1/ANDENS,ASILP,EMISSB,EMISSK,FLUID,G,IHOUR
      COMMON/WDSUB2/QSOLR,TOBJ,TSKY,MICRO
      COMMON/WSOLAR/ASIL,SHADE
      COMMON/WUNDRG/NEWDEP
      COMMON/WINGFUN/RHO1_3,TRANS1,AREF,BREF,CREF,PHI,F21,F31,F41,F51
     &,SIDEX,WQSOL,PHIMIN,PHIMAX,TWING,F12,F32,F42,F52
     &,F61,TQSOL,A1,A2,A3,A4,A4B,A5,A6,F13,F14,F15,F16,F23,F24,F25,F26
     &,WINGCALC,WINGMOD
     
      IF(MAXSHD.GT.100.)THEN
       MAXSHD=100.
      ENDIF

      IF(SHADE.LT.MAXSHD)THEN
C      INCREASE SHADE, AND DO A SOLUTION IN THE NEW ENVIRONMENT
       SHADE=SHADE+DSHD
       IF(SHADE.GT.MAXSHD)THEN
        SHADE=MAXSHD
       ENDIF
C      GET THE CLIMATE FOR CHANGED SHADE
       CALL ABOVEGROUND
       IF(QSOL(IHOUR).GT.0.00000)THEN
        CALL SOLAR
       ENDIF
      ENDIF
      CALL RADIN

      RETURN
      END