C     NICHEMAPR: SOFTWARE FOR BIOPHYSICAL MECHANISTIC NICHE MODELLING

C     COPYRIGHT (C) 2020 MICHAEL R. KEARNEY AND WARREN P. PORTER

C     THIS PROGRAM IS FREE SOFTWARE: YOU CAN REDISTRIBUTE IT AND/OR MODIFY
C     IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
C     THE FREE SOFTWARE FOUNDATION, EITHER VERSION 3 OF THE LICENSE, OR (AT
C      YOUR OPTION) ANY LATER VERSION.

C     THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
C     WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
C     MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
C     GENERAL PUBLIC LICENSE FOR MORE DETAILS.

C     YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
C     ALONG WITH THIS PROGRAM. IF NOT, SEE HTTP://WWW.GNU.ORG/LICENSES/.

C     THIS SUBROUTINE COMPUTES NON-RESPIRATORY EVAPORATIVE WATER LOSS.

       SUBROUTINE SEVAP_ENDO(BARPRS,TA,RELHUM,VEL,TC,TSKIN,ALT,SKINW,
     & FLYHR,CONVSK,HD,HDFREE,PCTBAREVAP,PCTEYES,ZFUR,FURWET,TFA,
     & CONVAR,RESULTS)

      IMPLICIT NONE
      
      DOUBLE PRECISION AIRVD,ALT,BARPRS,BP,CONVAR,CONVSK,CP,DB,DENAIR,DP
      DOUBLE PRECISION E,EFFSUR,EFFSURF,EFFSURHF,ESAT,FLYHR,FURWET,GWCUT
      DOUBLE PRECISION GWEYES,GWTFUR,HD,HDFREE,HTOVPR,PATMOS,PCTBAREVAP
      DOUBLE PRECISION PCTEYES,PSTD,QFSEVAP,QSEVAP,RELHUM,RESULTS,RH,RW
      DOUBLE PRECISION SKINRA,SKINRAF,SKINRAHF,SKINW,SURFVD,TA,TAIR,TC
      DOUBLE PRECISION TFA,TSKIN,TVINC,TVIR,V,VD,VEL,WATER,WB,WCUT,WCUTF
      DOUBLE PRECISION WCUTHF,WEYES,WTFUR,WTRPOT,ZFUR
     
      DIMENSION RESULTS(7)
      
      WCUTHF=0. ! INITIALISE
      WCUTF=0. ! INITIALISE
      
      BP = BARPRS
      TAIR = TA
      V = VEL

C     CALCULATING SKIN SURFACE SATURATION VAPOR DENSITY
      RH = 100.
C     CHECK FOR TOO LOW A SURFACE TEMPERATURE
      IF (TSKIN .LT. -40.) THEN
       DB = -40.
      ELSE
C      CHECK FOR TOO HIGH A SURFACE TEMPERATURE (STABILITY CHECK)
       IF (TSKIN .GT. (TC+10.)) THEN
        DB = TC + 10.
       ELSE
        DB = TSKIN
       ENDIF
      ENDIF

C     SETTING 3 PARAMETERS FOR WETAIR, SINCE RH IS KNOWN (SEE WETAIR LISTING)
      WB=0.
      DP=999.
C     BP CALCULATED FROM ALTITUDE USING THE STANDARD ATMOSPHERE
C     EQUATIONS FROM SUBROUTINE DRYAIR    (TRACY ET AL,1972)
      PSTD=101325.
      PATMOS=PSTD*((1.-(0.0065*ALT/288.))**(1./0.190284))
      BP = PATMOS

      CALL WETAIR(DB,WB,RH,DP,BP,E,ESAT,VD,RW,TVIR,TVINC,
     * DENAIR,CP,WTRPOT)
      SURFVD = VD

C     AIR VAPOR DENSITY
      RH = RELHUM
      DB = TAIR
      CALL WETAIR(DB,WB,RH,DP,BP,E,ESAT,VD,RW,TVIR,TVINC,
     * DENAIR,CP,WTRPOT)
      AIRVD = VD

C     EYES OPEN
      WEYES = HD * (PCTEYES / 100) * CONVSK * (SURFVD - AIRVD) ! KG/S

C     COMPUTE CUTANEOUS WATER LOSS BASED ON AEFF

C 	  CALCULATE % AREA FOR EVAP  NOTE THIS VALUE ONLY USED IF FLYING OR ALL LOST FROM BARE SKIN. 
C 	  OTHERWISE DIVIDE INTO HF (HANDS & FEET) AND F (FUR) AREAS BELOW. 
C     CONVERTING FROM % TO A RATIO
      SKINRA = 0.01*SKINW
C     SURFACE AREA THAT IS WET
      EFFSUR = CONVSK*SKINRA
C	  DIVIDE INTO LOSS FROM FURRED SURFACES AND BARE SURFACES
C     BARE = FORCED + FREE
C 	  PROPORTION WETTED AREA THAT IS FUR
      SKINRAF = SKINW * (1 - PCTBAREVAP * 0.01) * 0.01
C 	  PROPORTION WETTED AREA THAT IS BARE
      SKINRAHF = (SKINW * PCTBAREVAP * 0.01) * 0.01

C     CONVERT TO ACTUAL AREAS. 
      EFFSURHF = CONVSK * SKINRAHF
      EFFSURF = CONVSK * SKINRAF

C     AMOUNT OF WATER EVAPORATED FROM THE SKIN: FLIGHT (YES OR NO) CHANGES WHETHER FREE & FORCED OR JUST FREE
      IF(ZFUR.LE.0.000000)THEN
C      BARE SKIN - FORCED & FREE
       WCUT = EFFSUR * HD *(SURFVD - AIRVD) ! KG/S
      ELSE
C      INSULATION PRESENT, IS FLIGHT INVOLVED?
       IF(INT(FLYHR).EQ.1)THEN
        WCUT = EFFSUR * HD *(SURFVD - AIRVD) ! KG/S
       ELSE
C       NOT FLIGHT: RESTING BIRD OR MAMMAL WITH FUR: FREE CONVECTION ONLY IN INSULATION
        WCUTHF = EFFSURHF * HD *(SURFVD - AIRVD) ! KG/S
        WCUTF = EFFSURF * HDFREE * (SURFVD - AIRVD) ! KG/S
        WCUT = WCUTHF + WCUTF ! KG/S
       ENDIF
      ENDIF

      WATER = WEYES + WCUT ! KG/S

C     FROM DRYAIR: LATENT HEAT OF VAPORIZATION
      HTOVPR = 2.5012E+06 - 2.3787E+03 * TAIR
      QSEVAP = WATER * HTOVPR

C     KG/S TO G/S
      GWEYES = WEYES * 1000.
      GWCUT  = WCUT * 1000.

C     CALCULATE EVAP FROM WET FUR

C     CALCULATING FUR SURFACE SATURATION VAPOR DENSITY
      RH = 100.
C     CHECK FOR TOO LOW A SURFACE TEMPERATURE
      IF (TFA .LT. -40.) THEN
       DB = -40.
      ELSE
C      CHECK FOR TOO HIGH A SURFACE TEMPERATURE (STABILITY CHECK)
       IF (TFA .GT. (TC+10.)) THEN
        DB = TC + 10.
       ELSE
        DB = TFA
       ENDIF
      ENDIF

C     SETTING 3 PARAMETERS FOR WETAIR, SINCE RH IS KNOWN (SEE WETAIR LISTING)
      WB=0.
      DP=999.
C     BP CALCULATED FROM ALTITUDE USING THE STANDARD ATMOSPHERE
C     EQUATIONS FROM SUBROUTINE DRYAIR    (TRACY ET AL,1972)
      PSTD=101325.
      PATMOS=PSTD*((1.-(0.0065*ALT/288.))**(1./0.190284))
      BP = PATMOS

      CALL WETAIR(DB,WB,RH,DP,BP,E,ESAT,VD,RW,TVIR,TVINC,
     * DENAIR,CP,WTRPOT)
      SURFVD = VD

C     AIR VAPOR DENSITY
      RH = RELHUM
      DB = TAIR
      CALL WETAIR(DB,WB,RH,DP,BP,E,ESAT,VD,RW,TVIR,TVINC,
     * DENAIR,CP,WTRPOT)
      AIRVD = VD

C     COMPUTE SURFACE WATER LOSS BASED ON AEFF
C     SURFACE AREA THAT IS WET
      EFFSURF = CONVAR * (FURWET/100.)

C     AMOUNT OF WATER EVAPORATED FROM THE SURFACE
      
      WTFUR = EFFSURF * HD *(SURFVD - AIRVD)

C     FROM DRYAIR: LATENT HEAT OF VAPORIZATION
      HTOVPR = 2.5012E+06 - 2.3787E+03 * TAIR
      QFSEVAP = WTFUR * HTOVPR

C     KG/S TO G/S
      GWTFUR  = WTFUR * 1000.

      RESULTS = (/QSEVAP,WEYES,WCUTHF,WCUTF,WCUT,WTFUR,QFSEVAP/)
      RETURN
      END