C     NICHEMAPR: SOFTWARE FOR BIOPHYSICAL MECHANISTIC NICHE MODELLING

C     COPYRIGHT (C) 2020 MICHAEL R. KEARNEY AND WARREN P. PORTER

C     THIS PROGRAM IS FREE SOFTWARE: YOU CAN REDISTRIBUTE IT AND/OR MODIFY
C     IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
C     THE FREE SOFTWARE FOUNDATION, EITHER VERSION 3 OF THE LICENSE, OR (AT
C      YOUR OPTION) ANY LATER VERSION.

C     THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
C     WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
C     MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
C     GENERAL PUBLIC LICENSE FOR MORE DETAILS.

C     YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
C     ALONG WITH THIS PROGRAM. IF NOT, SEE HTTP://WWW.GNU.ORG/LICENSES/.

C     PROPERTIES OF SEAWATER

C     THE REGRESSIONS FOR THESE PROPERTIES WERE OBTAINED FROM
c     www.chrismanual.com/Intro/prop.htm
c     and from ...edu/eos/info/mea/mea411_info/VISCOUS.htm
c     ASSUMING 35 ppt (PSU) SALT AND 1 ATM PRESSURE

C     CP = SPECIFIC HEAT (J/KG-C)
C     DENSTY = WATER DENSITY (KG/M3)
C     THCOND = THERMAL CONDUCTIVITY (W/M-C)
C     VISDYN = DYNAMIC VISCOSITY (KG/M-S)

      SUBROUTINE SEAWATER (TWATR,CP,DENSTY,THCOND,VISDYN)

      DOUBLE PRECISION CP,DENSTY,THCOND,TWATR,VISDYN

      CP = 1.0211143*TWATR + 3913.1369
      DENSTY = 0.27907*TWATR + 1029.82
      THCOND = 0.018687*TWATR +6.751631
      VISDYN = 2.6E-5*TWATR + 0.001625

      RETURN
      END