      SUBROUTINE QROMB(FUNC,A,B,SS)
C    ROMBERG INTEGRATION FROM NUMERICAL RECIPES
      IMPLICIT NONE
      INTEGER J,JMAX,K,KM
      DOUBLE PRECISION A,B,FUNC,SS,EPS,DSS
      EXTERNAL FUNC
C     PARAMETER (EPS=1.E-6, JMAX=20, JMAXP=JMAX+1, K=5, KM=K-1)

CU    USES POLINT,TRAPZD
      DOUBLE PRECISION H(21),S(21)
      DATA EPS/0.000001/
      DATA JMAX/20/
      DATA K/5/
      DATA KM/4/
      H(1)=1.
      DO 11 J=1,JMAX
       CALL TRAPZD(A,B,S(J),J)
       IF (J.GE.K) THEN
        CALL POLINT(H(J-KM),S(J-KM),K,0.,SS,DSS)
        IF (ABS(DSS).LE.EPS*ABS(SS)) RETURN
        ENDIF
        S(J+1)=S(J)
        H(J+1)=0.25*H(J)
11    CONTINUE
C      PAUSE 'TOO MANY STEPS IN QROMB'
      END
C  (C) COPR. 1986-92 NUMERICAL RECIPES SOFTWARE |2J.012U2.
