      SUBROUTINE PARECT

C     NICHEMAPR: SOFTWARE FOR BIOPHYSICAL MECHANISTIC NICHE MODELLING

C     COPYRIGHT (C) 2018 MICHAEL R. KEARNEY AND WARREN P. PORTER

C     THIS PROGRAM IS FREE SOFTWARE: YOU CAN REDISTRIBUTE IT AND/OR MODIFY
C     IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
C     THE FREE SOFTWARE FOUNDATION, EITHER VERSION 3 OF THE LICENSE, OR (AT
C      YOUR OPTION) ANY LATER VERSION.

C     THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
C     WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
C     MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
C     GENERAL PUBLIC LICENSE FOR MORE DETAILS.

C     YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
C     ALONG WITH THIS PROGRAM. IF NOT, SEE HTTP://WWW.GNU.ORG/LICENSES/.

C     THIS SUBROUTINE COMPUTES THE CONFIGURATION FACTOR BETWEEN TWO PARALLEL
C     IDENTICAL RECTANGLES, LYING ONE ABOVE THE OTHER WITH THE SAME EDGES OF
C     ONE DIRECTLY ABOVE THE OTHER.  THE RECTANGLES ARE SEPARATED BY DISTANCE, C.
C     THEIR DIMENSIONS ARE A (LENGTH) AND B (WIDTH).

      IMPLICIT NONE

      DOUBLE PRECISION A,APL,B,BPL,CPL,FPARLEL
      DOUBLE PRECISION GRP1,GRP2,GRP3,GRP4,GRP5,GRP6,SQRT1,PI,X,Y

      COMMON/PLATES/APL,BPL,CPL,FPARLEL

      PI=3.14159265

      X=APL/CPL
      Y=BPL/CPL

      GRP1=2./(PI*X*Y)
      A=1+X**2
      B=1+Y**2
      SQRT1=SQRT((A*B)/(A+Y**2))
      GRP2=LOG(SQRT1)
      GRP3=(Y*SQRT(A))*ATAN(Y/SQRT(A))
      GRP4=(X*(SQRT(B)))*ATAN(X/SQRT(B))
      GRP5=Y*ATAN(Y)
      GRP6=X*ATAN(X)
      FPARLEL=GRP1*(GRP2+GRP3+GRP4-GRP5-GRP6)

      RETURN
      END