      SUBROUTINE MICROSEGMT(Z,Z0,T1,T3,V,QC,AMOL,NAIR,ZZ,VV,T,ZEN)
      IMPLICIT NONE

C     NicheMapR: software for biophysical mechanistic niche modelling

C     Copyright (C) 2018 Michael R. Kearney and Warren P. Porter

c     This program is free software: you can redistribute it and/or modify 
c     it under the terms of the GNU General Public License as published by 
c     the Free Software Foundation, either version 3 of the License, or (at
c      your option) any later version.

c     This program is distributed in the hope that it will be useful, but
c     WITHOUT ANY WARRANTY; without even the implied warranty of 
c     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
c     General Public License for more details.

c     You should have received a copy of the GNU General Public License 
c     along with this program. If not, see http://www.gnu.org/licenses/.

C     This subroutine computes a 3 segment velocity and temperature profile

      DOUBLE PRECISION ADUM,AMOL,AMOLN,DEL,DIFFT,DUM,DUM0,DUM1,DUM2,GAM,
     *PSI2,QC,RCP,RCPTKG,RHOCP,STB,STO,STS,T,T1,T3,TAVE,TZO,USTAR,
     *USTAR1,USTAR2,USTARC,V,V100,V30,VV,X,X1,Y,Y1,YY,YY2,Z,Z0,Z01,
     *Z02,Z0C,ZEN,ZH1,ZH2,ZZ,PHI,PSI1,MAXSURF

      INTEGER I,ITER,NAIR,I1,I2,I3,I4,I5,I6,I7,I8,I9,I10,I11,I12,I91,I92
     & ,I93,I94,I95,I96,I97,I98,I99,I100,I101
      DIMENSION ZZ(1),VV(1),T(1)
      COMMON/DMYCRO/Z01,Z02,ZH1,ZH2
      COMMON/WMAIN/I1,I2,I3,I4,I5,I6,I7,I8,I9,I10,I11,I12,I91,I92,I93
     & ,I94,I95,I96,I97,I98,I99,I100,I101
      COMMON/MAXTEMP/MAXSURF
C
C**** 3 SEGMENT VELOCITY PROFILE - W. PORTER
C**** VELOCITY PROFILE - Businger, J. A., Wyngaard, J. C., Izumi, Y., & Bradley, E. F. (1971). Flux-Profile Relationships in the Atmospheric Surface Layer. Journal of the Atmospheric Sciences, 28(2), 181189. doi:10.1175/1520-0469(1971)028<0181:FPRITA>2.0.CO;2
C**** SUBLAYER MODEL - Garratt, J. R., & Hicks, B. B. (1973). Momentum, heat and water vapour transfer to and from natural and artificial surfaces. Quarterly Journal of the Royal Meteorological Society, 99(422), 680687. doi:10.1002/qj.49709942209
C     Z=REFERENCE HEIGHT
C     Z0=ROUGHNESS HEIGHT
C     T1=TEMPERATURE AT REFERENCE HEIGHT
C     T3=CURRENT ESTIMATE OF GROUND SURFACE TEMP.
C     V=VELOCITY AT REF. HEIGHT
C     QC=COMPUTED (HERE) CONVECTIVE HEAT TRANSFER AT THE SURFACE
C     AMOL=MONIN-OBUKHOV LENGTH
C     NAIR=NO. OF HEIGHTS FOR AIR TEMP'S AND VELOCITIES
C     ZZ=ARRAY OF HEIGHT VALUES
C     VV=ARRAY OF COMPUTED (HERE) VELOCITIES FOR EACH HEIGHT
C     T=ARRAY OF AIR TEMP'S COMPUTED HERE ASSUMING A LOG PROFILE
C
C     THIS SUBROUTINE IS MODIFIED (FEB. 1979)FOR SHEAR OCCURRING ABOVE
C     THE SURFACE DUE TO VEGETATION SPACED OVER THE SURFACE.
C     TEMP. PROFILE REMAINS LOGARITHMIC. VEL. PROFILE LOGARITHMIC IN SEGMENTS
C     SEGMENTS OF VEL. PROFILE= 200-100 CM, 100-30 CM, 30-0 CM.
C     TREF=200 CM, VREF=30 CM FOR SANTA FE, GALAPAGOS
C     Z0 IS PLOTTED FROM 30 CM VEL'S DOWN
C
C     ****WHEN STARTING AT MIDNIGHT ON THE VERY FIRST
C     ITERATION BE SURE  BE SURE  BE SURE
C     INITIAL TSURF GUESS IS LESS THAN TREF
C     SO MICRO WILL GO TO LOWER HALF
C
C     DEFINING Z0'S FROM THE TOP DOWN            Steve's
C     GALAPAGOS  TEXAS, WASHINGTON    NEVADA     Carlsbad NM
C     Z01=16.8    11.16               3.67       8.353
C     Z02= 6.42   10.57               3.29       3.015
C     Z0 = LOWEST (REAL) ROUGHNESS HEIGHT
C     Z0 =       0.021                0.90       0.268
C
C     DEFINING HEIGHTS WHERE Z0 CHANGES FROM THE TOP
C     Z = 'FREE STREAM' REFERENCE HEIGHT = 200 CM
C     ZH1=100.   84                   80           50
C     ZH2=30.    13.                  60.          25

      RHOCP(TAVE) = 0.08472/TAVE ! note this is a function, internally defined
      PHI(Z)=(1.-GAM*Z/AMOL)**.25
      PSI1(X)=2.*DLOG((1.+X)/2.)+DLOG((1.+X*X)/2.)-2.*ATAN(X)+3.14159/2
      PSI2(X)=2.*DLOG((1.+X*X)/2.)
      GAM=16.
      RCPTKG=6.003E-8 !RHO*CP*T/(K*G) = 6.003E-8 IN CAL-MIN-CM-C UNITS
      DUM2=DLOG(Z/Z01+1)

C     COMPUTING VEL. PROFILE PARAMETERS FROM 200 CM REFERENCE VELOCITY
      USTAR2=.4*V/DUM2
      V100=(USTAR2/.4)*DLOG(ZH1/Z01+1)
      DUM1=DLOG(ZH1/Z02+1)
      USTAR1=.4*V100/DUM1
      V30=(USTAR1/.4)*DLOG(ZH2/Z02+1)
      DUM0=DLOG(ZH2/Z0+1)
C     LEAVING THE FOLLOWING IN FOR TEMP. PROFILE CALC.
      DUM=DLOG(Z/Z0+1)
      USTAR=.4*V30/DUM0
C
      DIFFT=T1-T3
      TAVE=(T3+T1+546)/2.
      RCP=RHOCP(TAVE)
      AMOL=-30.0
      ITER=0
C      CHECK FOR FREE CONVECTION (LAPSE) CONDITIONS
      IF(T1.GE.T3)GO TO 1000
      IF(T3.LE.MAXSURF)GO TO 1000
      IF(ZEN .GE. 90.)GO TO 1000
C     NEGLECTING FREE CONV. CORRECTION (4%)FOR SEGMENTED PROFILES.
C
C     ITERATING TO FIND THE MONIN-OBUKHOV LENGTH (AMOL)
C
   1  X=PHI(Z)
      Y=PSI1(X)
      YY=PSI2(X)
      USTAR=.4*V30/(DLOG(ZH2/Z0)-Y)
C     SUBLAYER STANTON NO., STS=.75RE* **-.45
      STS=.62/(Z0*USTAR/12.)**.45
C     BULK STANTON NO.
      STB=(.64/DUM0)*(1.-.1*Z/AMOL)
      STO=STB/(1.+STB/STS)
C
      QC=RCP*DIFFT*USTAR*STO
C
      AMOLN=RCPTKG*USTAR**3/QC
      DEL=ABS((AMOLN-AMOL)/AMOL)
      IF (DEL .LT. 1.0E-02) THEN
       GO TO 2
      ELSE
      ENDIF
      AMOL=AMOLN
      ITER=ITER+1
      IF(ITER .GT.30) GO TO 2000
      GO TO 1
C     END OF ITERATION LOOP TO FIND MONIN-OBUKHOV LENGTH

    2 CONTINUE
      IF(NAIR.LE.0) RETURN
      DO 3 I=1,NAIR
       X1=PHI(ZZ(I))
       Y1=PSI1(X1)
       YY2=PSI2(X1)
       IF(ZZ(I)-ZH1) 21,20,20
  20   USTARC=USTAR2
       Z0C=Z01
       GO TO 29
  21   IF(ZZ(I)-ZH2)23,22,22
  22   USTARC=USTAR1
       Z0C=Z02
       GO TO 29
  23   USTARC=USTAR
       Z0C=Z0
C      FILL OUT VELOCITY AND TEMP. PROFILES
   29  ADUM=ZZ(I)/Z0C-Y1
       VV(I)=2.5*USTARC*DLOG(ADUM)
       IF(VV(I)-0.0)291,292,292
  291  continue
C      COMPUTING FICTITIOUS TEMP. AT TOP OF SUBLAYER
  292  TZO=(T1*STB+T3*STS)/(STB+STS)
       T(I+20)=TZO+(T1-TZO)*DLOG(ZZ(I)/Z0-YY2)/DLOG(Z/Z0-YY)
    3 CONTINUE
      RETURN
C     CALC'S BELOW WHEN NO FREE CONV. ENHANCEMENT OF VEL,TEMP PROFILES
 1000 CONTINUE
C     SUBLAYER STANTON NO.
      STS=.62/(Z0*USTAR/12.)**.45
C     BULK STANTON NO.
      STB=.64/DUM0
C
      QC=RCP*DIFFT*USTAR*STB/(1+STB/STS)
C
      IF(NAIR.LE.0) RETURN
      DO 4 I=1,NAIR
       IF(ZZ(I)-ZH1) 31,30,30
  30   USTARC=USTAR2
       Z0C=Z01
       GO TO 39
  31   IF(ZZ(I)-ZH2) 33,32,32
  32   USTARC=USTAR1
       Z0C=Z02
       GO TO 39
  33   USTARC=USTAR
       Z0C=Z0
C      FILL OUT VEL. AND TEMP. PROFILES
  39   VV(I)=2.5*USTARC*DLOG(ZZ(I)/Z0C+1)
C      COMPUTING FICTITIOUS TEMP. AT TOP OF SUBLAYER
       TZO=(T1*STB+T3*STS)/(STB+STS)
       T(I+20)=TZO+(T1-TZO)*DLOG(ZZ(I)/Z0+1)/DUM
    4 CONTINUE
      RETURN

 2000 continue
      RETURN
      END