      SUBROUTINE MET

C     NICHEMAPR: SOFTWARE FOR BIOPHYSICAL MECHANISTIC NICHE MODELLING

C     COPYRIGHT (C) 2018 MICHAEL R. KEARNEY AND WARREN P. PORTER

C     THIS PROGRAM IS FREE SOFTWARE: YOU CAN REDISTRIBUTE IT AND/OR MODIFY
C     IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
C     THE FREE SOFTWARE FOUNDATION, EITHER VERSION 3 OF THE LICENSE, OR (AT
C      YOUR OPTION) ANY LATER VERSION.

C     THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
C     WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
C     MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
C     GENERAL PUBLIC LICENSE FOR MORE DETAILS.

C     YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
C     ALONG WITH THIS PROGRAM. IF NOT, SEE HTTP://WWW.GNU.ORG/LICENSES/.

C      THIS SUBROUTINE METABOLISM

      IMPLICIT NONE

      DOUBLE PRECISION A1,A2,A3,A4,A4B,A5,A6,ACTHR,AIRVOL,AL,ALT,AMASS
      DOUBLE PRECISION ANDENS,AREA,AREF,ASEMAJR,ASILP,ATOT,BP,BREF
      DOUBLE PRECISION BSEMINR,CO2MOL,CREF,CSEMINR,CUSTOMGEOM,DEBQMET
      DOUBLE PRECISION DEBQMET_INIT,DELTAR,DEPSUB,DRYFOOD,EMISAN
      DOUBLE PRECISION EMISSB,EMISSK,EXTREF,F12,F13,F14,F15,F16,F21,F23
      DOUBLE PRECISION F24,F25,F26,F31,F32,F41,F42,F51,F52,F61,FAECES
      DOUBLE PRECISION FATCOND,FATOSB,FATOSK,FLSHCOND,FLUID,FLYMETAB
      DOUBLE PRECISION FLYSPEED,FLYTIME,G,GEVAP,GH2OMET,GH2OMET_INIT
      DOUBLE PRECISION GMASS,H2O_BALPAST,MLO2,MLO2_INIT,MR_1,MR_2,MR_3
      DOUBLE PRECISION NWASTE,PHI,PHIMAX,PHIMIN,PTCOND,PTCOND_ORIG,QCOND
      DOUBLE PRECISION QCONV,QIRIN,QIROUT,QMETAB,QRESP,QSEVAP,QSOLAR
      DOUBLE PRECISION QSOLR,QSWEAT,R,R1,RELHUM,RHO1_3,RINSUL,RQ,SHP
      DOUBLE PRECISION SIDEX,SIG,SUBTK,T_A,T_AH,T_AL,T_H,T_L,T_REF,TA
      DOUBLE PRECISION TBASK,TC,TCORR,TDIGPR,TEMERGE,TLUNG,TMAXPR,TMINPR
      DOUBLE PRECISION TOBJ,TPREF,TQSOL,TR,TRANS1,TSKIN,TSKY,TSUBST
      DOUBLE PRECISION TWING,VEL,VOL,WEVAP,WQSOL,XTRY

      INTEGER CLIMBING,DEB1,FLIGHT,FLYER,FLYTEST,GEOMETRY,IHOUR,MICRO
      INTEGER NODNUM,WINGCALC,WINGMOD

      CHARACTER*1 BURROW,CLIMB,CKGRSHAD,CREPUS,DAYACT,NOCTURN

      DIMENSION ACTHR(25),CUSTOMGEOM(8),DEBQMET(24),DRYFOOD(24)
      DIMENSION FAECES(24),GH2OMET(24),MLO2(24),NWASTE(24),SHP(3)

      COMMON/ANPARMS/RINSUL,R1,AREA,VOL,FATCOND
      COMMON/ARRHEN/T_A,T_AL,T_AH,T_L,T_H,T_REF
      COMMON/BEHAV1/DAYACT,BURROW,CLIMB,CKGRSHAD,CREPUS,NOCTURN
      COMMON/BEHAV2/GEOMETRY,NODNUM,CUSTOMGEOM,SHP
      COMMON/BEHAV3/ACTHR
      COMMON/CLIMB/CLIMBING
      COMMON/DEBRESP/MLO2,GH2OMET,DEBQMET,MLO2_INIT,GH2OMET_INIT, 
     & DEBQMET_INIT,DRYFOOD,FAECES,NWASTE
      COMMON/ELLIPS/ASEMAJR,BSEMINR,CSEMINR
      COMMON/FLY/FLYTIME,FLYSPEED,FLYMETAB,FLIGHT,FLYER,FLYTEST
      COMMON/FUN1/QSOLAR,QIRIN,QMETAB,QRESP,QSEVAP,QIROUT,QCONV,QCOND
      COMMON/FUN2/AMASS,RELHUM,ATOT,FATOSK,FATOSB,EMISAN,SIG,FLSHCOND
      COMMON/FUN3/AL,TA,VEL,PTCOND,SUBTK,DEPSUB,TSUBST,PTCOND_ORIG
      COMMON/FUN4/TSKIN,R,WEVAP,TR,ALT,BP,H2O_BALPAST
      COMMON/GUESS/XTRY
      COMMON/REVAP1/TLUNG,DELTAR,EXTREF,RQ,MR_1,MR_2,MR_3,DEB1
      COMMON/REVAP2/GEVAP,AIRVOL,CO2MOL
      COMMON/TPREFR/TMAXPR,TMINPR,TDIGPR,TPREF,TBASK,TEMERGE
      COMMON/TREG/TC
      COMMON/WDSUB1/ANDENS,ASILP,EMISSB,EMISSK,FLUID,G,IHOUR
      COMMON/WDSUB2/QSOLR,TOBJ,TSKY,MICRO
      COMMON/WINGFUN/RHO1_3,TRANS1,AREF,BREF,CREF,PHI,F21,F31,F41,F51
     &,SIDEX,WQSOL,PHIMIN,PHIMAX,TWING,F12,F32,F42,F52
     &,F61,TQSOL,A1,A2,A3,A4,A4B,A5,A6,F13,F14,F15,F16,F23,F24,F25,F26
     &,WINGCALC,WINGMOD
      COMMON/WMET/QSWEAT
      
      GMASS=AMASS*1000.
      TC = XTRY

      IF(DEB1.EQ.1)THEN
C     USING DEB MODEL TO GET QMETAB, SKIP THE REGRESSIONS!
       TCORR=EXP(T_A*(1./(273.15+T_REF)-1./(273.15+TC)))/(1+EXP(T_AL
     & *(1./(273.15+TC)-1./T_L))+EXP(T_AH*(1/T_H-1./(273.15+TC))))
       IF(IHOUR.EQ.1)THEN
        QMETAB = DEBQMET_INIT*TCORR
       ELSE
        QMETAB = DEBQMET(IHOUR-1)*TCORR
       ENDIF
      ELSE
C      USE REGRESSION
C      LIZARD REGRESSION
       IF(TC .GT. 50)THEN
C       CAP METABOLIC RATE EQUATION WITH MAX OF TC = 50
        QMETAB = 0.0056*10.**(MR_3*50)*MR_1*GMASS**MR_2
        GOTO 101
       ENDIF
       IF(TC.LE.TPREF)THEN
        IF(TC.GE.1.0)THEN
C        ACCEPTABLE TEMPERATURE RANGE
         QMETAB=0.0056*10.**(MR_3*TC)*MR_1*GMASS**MR_2
        ELSE
         QMETAB = 0.01
        ENDIF
       ELSE
C       TOO HOT
C       ALLOWING TCORE TO BE A LITTLE HIGHER THAN TMAX PREFERRED SO THAT THERMOREGULATION
C       BEHAVIORS WILL BE INVOKED TO SELECT MORE MODERATE MICROCLIMATE CONDITIONS
        QMETAB = 0.0056*10.**(MR_3*(TMAXPR+0.5))*MR_1*GMASS**MR_2
       ENDIF
      ENDIF

      IF(FLYTEST.EQ.1)THEN
       QMETAB=QMETAB+FLYMETAB*AMASS*1000
      ENDIF

101   CONTINUE
      RETURN
      END