C     NICHEMAPR: SOFTWARE FOR BIOPHYSICAL MECHANISTIC NICHE MODELLING

C     COPYRIGHT (C) 2020 MICHAEL R. KEARNEY AND WARREN P. PORTER

C     THIS PROGRAM IS FREE SOFTWARE: YOU CAN REDISTRIBUTE IT AND/OR MODIFY
C     IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
C     THE FREE SOFTWARE FOUNDATION, EITHER VERSION 3 OF THE LICENSE, OR (AT
C      YOUR OPTION) ANY LATER VERSION.

C     THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
C     WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
C     MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
C     GENERAL PUBLIC LICENSE FOR MORE DETAILS.

C     YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
C     ALONG WITH THIS PROGRAM. IF NOT, SEE HTTP://WWW.GNU.ORG/LICENSES/.

C     SUBROUTINE TO COMPUTE RADII, DIAMETER, & AREA = F (MASS)

C     4 AREAS ARE COMPUTED HERE:
C     ATOT = TOTAL AREA AT THE FUR/FEATHER INTERFACE WITH THE AIR (USE
C     FOR IR, SOLAR CALCULATIONS).
C     CONVAR = TOTAL AREA AT THE FUR/FEATHER/SKIN INTERFACE WITH THE AIR
C     THAT IS NOT IN CONTACT WITH THE SUBSTRATE (USE FOR CONVECTIVE
C     HEAT LOSS CALCULATIONS).
C     CONVSK = TOTAL SKIN AREA AVAILABLE FOR EVAPORATIVE WATER LOSS:
C     I.E. THE AREA NOT OCCUPIED ON THE SKIN BY HAIR/FEATHER SHAFTS
C     (USE FOR EVAPORATION FROM THE SKIN).
C     AREASKIN = TOTAL SKIN AREA INCLUDING HAIR/FEATHER SHAFTS (USE TO
C     COMPUTE CONVSK AND USE IN SUB. SEVAP FOR WATER LOSS USING AEFF,
C     EFFECTIVE AREA OF SKIN THAT IS WET).

      SUBROUTINE GEOM_ENDO(AMASS,ANDENS,FATPCT,SHAPE,ZFUR,SUBQFAT
     & ,SHAPEB,SHAPEC,DHARA,RHOARA,PCOND,SAMODE,ORIENT,ZEN
     & ,RESULTS)

      IMPLICIT NONE
      
      DOUBLE PRECISION AA,AAA,A2,AHEIT,ALENTH,AMASS,ANDENS,AREA,AREASKIN
      DOUBLE PRECISION ASEMAJ,ASIL,ASILN,ASILP,ATOT,AV,AWIDTH,BB,BBB
      DOUBLE PRECISION BSEMIN,C2,CFA,CFB,CFC,CFD,CFT1,CFT1A,CFT1B
      DOUBLE PRECISION CFT1C,CFT2,CFT2A,CFT2B,CFT3,CFT4,CFT5,CPH,CPS
      DOUBLE PRECISION CONVAR,CONVSK,CSEMIN,CTH,D,DHAIR,DHARA,E,E2
      DOUBLE PRECISION FATDEN,FATPCT,FATTHK,FLSHASEMAJ,FLSHBSEMIN
      DOUBLE PRECISION FLSHCSEMIN,FLSHVL,GMASS,HAIRAR,MASFAT,ORIENT
      DOUBLE PRECISION PCOND,PI,PS,R1,R2,RESULTS,RFLESH,RHO,RHOARA
      DOUBLE PRECISION SAMODE,SEMAX1,SEMAX2,SHAPE,SHAPEB,SHAPEC,SPH,SPS
      DOUBLE PRECISION STH,SUBQFAT,TWOHH,VOL,VOLFAT,ZEN,ZFUR
      
      DIMENSION RESULTS(22)

      PI=ACOS(-1.0D0)
      VOL=AMASS/ANDENS
      
C	  INITIALISE
      ASEMAJ=0.
      BSEMIN=0.
      CSEMIN=0.
      AHEIT=0.
      
C     CONVECTION CHARACTERISTIC DIMENSION (M) JOHN MITCHELL (1976)
      D = VOL**(1./3.)

C     GOING, SB. DENSITOMETRY. IN: HUMAN BODY COMPOSITION, EDITED BY ROCHE AF, HEYMSFIELD SB, AND LOHMAN TG.. CHAMPAIGN, IL: HUMAN KINETICS, 1996, P. 3-24.
C     FAT AND MUSCLE DENSITY (KG/M3). BONE DENSITY = 1050-1200 KG/M3 IN 20 YEAR OLD HUMANS.
      FATDEN = 901.
C     MUSDEN = 1060.

C     CALCULATING FAT MASS, VOLUME IN BODY FROM PERCENT BODY MASS THAT'S FAT
      MASFAT = AMASS*(FATPCT/100.)
      VOLFAT = MASFAT/FATDEN

C     CYLINDER
      IF (SHAPE .EQ. 1) THEN
       R1 = (VOL/(SHAPEB*PI*2))**(1./3.) !R_SKIN
       R2 = R1 + ZFUR ! R_FA
       ALENTH=SHAPEB*R1*2
C      FUR-AIR AREA = END CIRCLE AREA + CIRCLE PERIMETER * LENGTH (LENGTH = 2*D2)
       AREASKIN=2.*PI*R1**2+2.*PI*R1*ALENTH
       ATOT=2.*PI*R2**2+2.*PI*R2*ALENTH
       AWIDTH=2.*R2
       AHEIT=AWIDTH
       AREA=ATOT
       IF((INT(SUBQFAT).EQ.1).AND.(MASFAT.GT.0.00))THEN
C       COMPUTE SUBQ FAT THICKNESS
        FLSHVL = VOL- VOLFAT
        RFLESH = SQRT(FLSHVL/(PI*ALENTH))
        FATTHK = R1 - RFLESH
       ELSE
        FLSHVL = VOL
        RFLESH = R1
        FATTHK = 0.      
       ENDIF
       ASILN = AWIDTH * ALENTH
       ASILP = PI * R2**2
       IF(ORIENT.EQ.0)THEN ! AVERAGE POSTURE
        ASIL = (ASILN + ASILP)/2.
       ENDIF
       IF(ORIENT.EQ.1)THEN ! NORMAL TO SUN'S RAYS (HEAT MAXIMISING)
        ASIL = ASILN
       ENDIF       
       IF(ORIENT.EQ.2)THEN ! PARALLEL TO SUN'S RAYS (HEAT MINIMISING)
        ASIL = ASILP
       ENDIF
       IF(ORIENT.EQ.3)THEN
        ASIL=2*R2*ALENTH*sin(ZEN*pi/180.)+pi*R2**2*cos(ZEN*pi/180.)
       ENDIF
        D = VOL**(1./3.)
       GO TO 999
      ENDIF

      IF (SHAPE .EQ. 2) THEN
C      SPHERE
C      BODY, FUR DIMENSIONS FOR CONDUCTION-RADIATION
C      VOL = 4./3. * PI * R**3
       R1 = ((3./4.)*VOL/PI)**(1./3.)
       R2 = R1+ZFUR
       D = VOL**(1./3.) 
       IF((INT(SUBQFAT).EQ.1).AND.(MASFAT.GT.0.00))THEN
C       COMPUTE SUBQ FAT THICKNESS
        FLSHVL = VOL- VOLFAT
        RFLESH = ((3.0*FLSHVL)/(4.0*PI))**(1./3.)
        FATTHK = R1 - RFLESH
       ELSE
        FLSHVL = VOL
        RFLESH = R1
        FATTHK = 0.      
       ENDIF
       IF(FATTHK.GT.0.000000)THEN
        RFLESH = R1 - FATTHK
       ELSE
        RFLESH = R1
       ENDIF
C      SKIN SURFACE AREA
       AREASKIN=4.*PI*R1**2 ! SPHERE WITHOUT FUR
       AREA = 4.*PI*R2**2 ! SPHERE WITH FUR
       ATOT = AREA
       ASIL = PI * R2**2
       ASILN = ASIL
       ASILP = ASIL
       ALENTH=R2*2.
       AHEIT=R2*2.
       AWIDTH=R2*2.
       GO TO 999
      ENDIF

C     FLAT PLATE
      IF (SHAPE .EQ. 3) THEN
       AHEIT=(VOL/(SHAPEB*SHAPEC))**(1./3.)
       ALENTH=AHEIT*SHAPEB
       AWIDTH=AHEIT*SHAPEC
       AREASKIN=ALENTH*AWIDTH*2.+ALENTH*AHEIT*2.+AWIDTH*AHEIT*2.
       ASILN = (AWIDTH+ZFUR) * (ALENTH+ZFUR)
       ASILP = (AWIDTH+ZFUR) * (AHEIT+ZFUR)
       IF((ORIENT.EQ.0).OR.(ORIENT.EQ.3))THEN ! AVERAGE POSTURE
        ASIL = (ASILN + ASILP)/2.
       ENDIF
       IF(ORIENT.EQ.1)THEN ! NORMAL TO SUN'S RAYS (HEAT MAXIMISING)
        ASIL = ASILN
       ENDIF       
       IF(ORIENT.EQ.2)THEN ! PARALLEL TO SUN'S RAYS (HEAT MINIMISING)
        ASIL = ASILP
       ENDIF      
       R1 = AWIDTH/2.
       R2 = R1+ZFUR
       ATOT=(ALENTH+ZFUR)*(AWIDTH+ZFUR)*2.+(ALENTH+ZFUR)*(AHEIT+ZFUR)*2.
     & +(AWIDTH+ZFUR)*(AHEIT+ZFUR)*2.
       AREA=ATOT
       IF((INT(SUBQFAT).EQ.1).AND.(MASFAT.GT.0.00))THEN
C       COMPUTE SUBQ FAT THICKNESS
        FLSHVL = VOL- VOLFAT
        RFLESH = (FLSHVL/(SHAPEB*SHAPEC))**(1./3.)/2.
        FATTHK = R1 - RFLESH
       ELSE
        FLSHVL = VOL
        RFLESH = R1
        FATTHK = 0.      
       ENDIF       
        D = VOL**(1./3.)
       GO TO 999
      ENDIF
      
C     ELLIPSOID
100   IF (SHAPE .EQ. 4) THEN
       IF(INT(SUBQFAT).EQ.0.OR.(MASFAT.LE.0.00))THEN ! NO SUBCUTANEOUS FAT
C       ASSUMING A PROLATE SPHEROID
C       VOL = 4/3* PI*A*B*C
C       SO VOL = 4/3* PI*G*B*B*B, ASSUMING C = B, A = G*B
C       SO B = ((3*V)/(4*PI*G))**(1/3)
        BSEMIN=(((3./(4.*SHAPEB))*VOL)/PI)**(1./3.)
        CSEMIN=BSEMIN
        ASEMAJ=SHAPEB*(BSEMIN)
        ALENTH=ASEMAJ*2.
        AHEIT=BSEMIN*2.
        AWIDTH=CSEMIN*2.
        E = ((ASEMAJ**2 - CSEMIN**2)**0.5 )/ASEMAJ ! ECCENTRICITY
        ASILN = PI * (ASEMAJ + ZFUR) * (BSEMIN + ZFUR)
        ASILP = PI * (BSEMIN + ZFUR) * (CSEMIN + ZFUR)
        IF(ORIENT.EQ.0)THEN ! AVERAGE POSTURE
         ASIL = (ASILN + ASILP)/2.
        ENDIF
        IF(ORIENT.EQ.1)THEN ! NORMAL TO SUN'S RAYS (HEAT MAXIMISING)
         ASIL = ASILN
        ENDIF       
        IF(ORIENT.EQ.2)THEN ! PARALLEL TO SUN'S RAYS (HEAT MINIMISING)
         ASIL = ASILP
        ENDIF
        IF(ORIENT.EQ.3)THEN ! COMPUTE AS A FUNCTION OF ZENITH ANGLE
         STH=sin(90.*pi/180.)
         CTH=cos(90.*pi/180.)
         SPH=sin(ZEN*pi/180.)
         CPH=cos(ZEN*pi/180.)
         AA=CTH**2*(CPH**2/(ASEMAJ+ZFUR)**2+SPH**2/(BSEMIN+ZFUR)**2)
     &    +STH**2/(CSEMIN+ZFUR)**2
         TWOHH=2.*CTH*STH*CPH*(1./(BSEMIN+ZFUR)**2-1./(ASEMAJ+ZFUR)**2)
         BB=SPH**2/(ASEMAJ+ZFUR)**2+CPH**2/(BSEMIN+ZFUR)**2
         PS=0.5*atan2(TWOHH,AA-BB)
         SPS=sin(PS)
         CPS=cos(PS)
         AAA=CPS*(AA*CPS+TWOHH*SPS)+BB*SPS*SPS
         BBB=SPS*(AA*SPS-TWOHH*CPS)+BB*CPS*CPS
         SEMAX1=1./SQRT(AAA)
         SEMAX2=1./SQRT(BBB)
         ASIL=pi*SEMAX1*SEMAX2
        ENDIF
C       SKIN SURFACE AREA
        IF(SAMODE.EQ.1.)THEN
         AREASKIN=10.*(AMASS*1000.)**0.667/10000. ! WALSBERG G. E. & KING J. E. (1978) THE RELATIONSHIP OF THE EXTERNAL SURFACE AREA OF BIRDS TO SKIN SURFACE AREA AND BODY MASS. JOURNAL OF EXPERIMENTAL BIOLOGY 76 , 185-189.
        ELSE
         IF(SAMODE.EQ.2)THEN
          AREASKIN=1110.*AMASS**0.65/10000. ! STAHL W. R. (1967) SCALING OF RESPIRATORY VARIABLES IN MAMMALS. JOURNAL OF APPLIED PHYSIOLOGY 22 , 453-460.
         ELSE
          AREASKIN=2.*PI*BSEMIN**2.+2.*PI*(ASEMAJ*BSEMIN/E)*ASIN(E) ! ELLIPSOID WITHOUT FUR
         ENDIF
        ENDIF
        R1 = BSEMIN
        R2 = R1 + ZFUR
        A2 = ASEMAJ + ZFUR
        C2 = R1 + ZFUR
        E2 = ((A2**2 - C2**2)**0.5 )/A2 ! ECCENTRICITY FOR TOTAL AREA
       
C       AREA AT THE FUR TIPS
        IF(SAMODE.EQ.1.)THEN
         AREA=8.11*(AMASS*1000.)**0.667/10000. ! WALSBERG G. E. & KING J. E. (1978) THE RELATIONSHIP OF THE EXTERNAL SURFACE AREA OF BIRDS TO SKIN SURFACE AREA AND BODY MASS. JOURNAL OF EXPERIMENTAL BIOLOGY 76 , 185-189.
        ELSE
         IF(SAMODE.EQ.2)THEN
           AREA=1110.*AMASS**0.65* ! STAHL W. R. (1967) SCALING OF RESPIRATORY VARIABLES IN MAMMALS. JOURNAL OF APPLIED PHYSIOLOGY 22 , 453-460.
     &      (2.*PI*R2**2 + 2.*PI*(A2*R2/E2)*ASIN(E2)/ ! OUTER SURFACE AREA IF AN ELLIPSOID WITH FUR
     &      (2.*PI*BSEMIN**2 + 2.*PI*(ASEMAJ*BSEMIN/E)*ASIN(E))) ! OUTER SURFACE AREA OF ELLIPSOID WITHOUT FUR
     &      /10000. ! INCREASE IN AREA DUE TO FUR
         ELSE
          AREA = 2.*PI*R2**2 + 2.*PI*(A2*R2/E2)*ASIN(E2) ! ELLIPSE WITH FUR
         ENDIF
        ENDIF
        ATOT = AREA
        D = VOL**(1./3.)
        FLSHVL = VOL
        RFLESH = R1
        FATTHK = 0.    
       ELSE
C       THERE IS SUBCUTANEOUS FAT
C       FIRST NEED TO GET THE DIMENSIONS OF THE FLESH ELLIPSOID
        FLSHVL=VOL-VOLFAT
C       ASSUMING A PROLATE SPHEROID
C       VOL = 4/3* PI*A*B*C
C       SO VOL = 4/3* PI*G*B*B*B, ASSUMING C = B, A = G*B
C       SO B = (((3/(4*G))*VOL)/PI)^(1/3)
        FLSHBSEMIN = (((3.*FLSHVL)/(4*SHAPEB*PI)))**(1./3.)
        FLSHCSEMIN = FLSHBSEMIN
        FLSHASEMAJ = SHAPEB*FLSHBSEMIN
C       VOLFAT=(4./3.* PI*(FLSHASEMAJ+X)*(FLSHBSEMIN+X)^2)-FLSHVOL, WHERE X IS THE FAT THICKNESS.
C       REMEMBERING THAT FLSHASEMAJ= SHAPEB*FLSHBSEMIN, AND FACTORING:
C       X^3 + ((SHAPEB*FLSHBSEMIN)+(2*FLSHBSEMIN))X^2 + (2*SHAPEB*FLSHBSEMIN^2)+(FLSHBSEMIN^2))X + [(SHAPEB*FLSHBSEMIN^3)-(((VOLFAT+FLSHVL)*3)/(4*PI))] = 0
C       WHICH TAKES THE FORM: AX^3 + BX^2 + CX + D = 0, AND ONE CAN USE THE CUBIC FORMULA TO SOLVE FOR X.
        CFA=1.0
        CFB=(SHAPEB*FLSHBSEMIN)+(2*FLSHBSEMIN)
        CFC=(2.*SHAPEB*(FLSHBSEMIN**2.))+(FLSHBSEMIN**2.)
        CFD=(SHAPEB*(FLSHBSEMIN**3.))-(((VOLFAT+FLSHVL)*3)/(4*PI))
C       BREAKING UP THE FORMULA INTO COMPONENT PARTS FOR CLEARER CODING.
        CFT1A=((-1.*CFB)**3.)/(27.*(CFA**3.))
        CFT1B=(CFB*CFC)/(6*(CFA**2.))
        CFT1C=(CFD/(2*CFA))
        CFT1= CFT1A+CFT1B-CFT1C
        CFT2A=(CFT1**2.)
        CFT2B=((CFC/(3*CFA))-((CFB**2.)/(9*(CFA**2.))))**3.
C       CORRECTING FOR WHEN CFT2A+CFT2B IS LESS THAN 0.0, WHICH CREATES A PROBLEM IN THE
C       FAT THICKNESS CALCULATION. THIS OCCURS WHEN FAT IS GETTING CLOSE TO NOT BEING ENOUGH TO COVER THE ELLIPSOID.
        IF(CFT2A+CFT2B.GE.0.0)THEN
         CFT2=(CFT2A+CFT2B)**0.5
        ELSE
         CFT2=0.0
        ENDIF
        CFT3=(CFB/(3*CFA))
C       FATTHK=((CFT1+CFT2)**0.333)+((CFT1-CFT2)**0.333)-CFT3
C       FORTRAN CAN'T SEEM TO HANDLE THE CUBE ROOTS OF NEGATIVE NUMBERS SO WE NEED TO
C       DO SOME MODIFCATIONS
        IF((CFT1+CFT2).LT.0.0)THEN
         CFT4= -1.*((-1*(CFT1+CFT2))**(1./3.))
        ELSE
         CFT4= (CFT1+CFT2)**(1./3.)
        ENDIF
        IF((CFT1-CFT2).LT.0.0)THEN
         CFT5= -1.*((-1*(CFT1-CFT2))**(1./3.))
        ELSE
         CFT5= (CFT1-CFT2)**(1./3.)
        ENDIF
        FATTHK=CFT4+CFT5-CFT3
        IF(FATTHK.LT.0.0)THEN
C        NOT ENOUGH FAT TO COVER SURFACE AREA
C        SETTING SUBQFAT TO 0
C        SETTING FATTHK TO 0.0
         FATTHK=0.0
         SUBQFAT=0
         GO TO 100
        ENDIF
        ASEMAJ=FLSHASEMAJ+FATTHK
        BSEMIN=FLSHBSEMIN+FATTHK
        CSEMIN=BSEMIN
        ASEMAJ=SHAPEB*(BSEMIN)
        ALENTH=ASEMAJ*2.
        AHEIT=BSEMIN*2.
        AWIDTH=CSEMIN*2.
        E = ((ASEMAJ**2 - CSEMIN**2)**0.5 )/ASEMAJ ! ECCENTRICITY
        ASILN = PI * (ASEMAJ + ZFUR) * (BSEMIN + ZFUR)
        ASILP = PI * (BSEMIN + ZFUR) * (CSEMIN + ZFUR)
        IF(ORIENT.EQ.0)THEN ! AVERAGE POSTURE
         ASIL = (ASILN + ASILP)/2.
        ENDIF
        IF(ORIENT.EQ.1)THEN ! NORMAL TO SUN'S RAYS (HEAT MAXIMISING)
         ASIL = ASILN
        ENDIF       
        IF(ORIENT.EQ.2)THEN ! PARALLEL TO SUN'S RAYS (HEAT MINIMISING)
         ASIL = ASILP
        ENDIF
        IF(ORIENT.EQ.3)THEN ! COMPUTE AS A FUNCTION OF ZENITH ANGLE
         STH=sin(90.*pi/180.)
         CTH=cos(90.*pi/180.)
         SPH=sin(ZEN*pi/180.)
         CPH=cos(ZEN*pi/180.)
         AA=CTH**2*(CPH**2/(ASEMAJ+ZFUR)**2+SPH**2/(BSEMIN+ZFUR)**2)
     &    +STH**2/(CSEMIN+ZFUR)**2
         TWOHH=2.*CTH*STH*CPH*(1./(BSEMIN+ZFUR)**2-1./(ASEMAJ+ZFUR)**2)
         BB=SPH**2/(ASEMAJ+ZFUR)**2+CPH**2/(BSEMIN+ZFUR)**2
         PS=0.5*atan2(TWOHH,AA-BB)
         SPS=sin(PS)
         CPS=cos(PS)
         AAA=CPS*(AA*CPS+TWOHH*SPS)+BB*SPS*SPS
         BBB=SPS*(AA*SPS-TWOHH*CPS)+BB*CPS*CPS
         SEMAX1=1./SQRT(AAA)
         SEMAX2=1./SQRT(BBB)
         ASIL=pi*SEMAX1*SEMAX2
        ENDIF
C       SKIN SURFACE AREA
        IF(SAMODE.EQ.1.)THEN
         AREASKIN=10.*(AMASS*1000.)**0.667/10000. ! WALSBERG G. E. & KING J. E. (1978) THE RELATIONSHIP OF THE EXTERNAL SURFACE AREA OF BIRDS TO SKIN SURFACE AREA AND BODY MASS. JOURNAL OF EXPERIMENTAL BIOLOGY 76 , 185-189.
        ELSE
         IF(SAMODE.EQ.2)THEN
          AREASKIN=1110.*AMASS**0.65/10000. ! STAHL W. R. (1967) SCALING OF RESPIRATORY VARIABLES IN MAMMALS. JOURNAL OF APPLIED PHYSIOLOGY 22 , 453-460.
         ELSE
          AREASKIN=2.*PI*BSEMIN**2.+2.*PI*(ASEMAJ*BSEMIN/E)*ASIN(E) ! ELLIPSOID WITHOUT FUR
         ENDIF
        ENDIF
        R1 = BSEMIN
        R2 = R1 + ZFUR
        A2 = ASEMAJ + ZFUR
        C2 = R1 + ZFUR
        E2 = ((A2**2 - C2**2)**0.5 )/A2 ! ECCENTRICITY FOR TOTAL AREA        
C       AREA AT THE FUR TIPS
        IF(SAMODE.EQ.1.)THEN
         AREA=8.11*(AMASS*1000.)**0.667/10000. ! WALSBERG G. E. & KING J. E. (1978) THE RELATIONSHIP OF THE EXTERNAL SURFACE AREA OF BIRDS TO SKIN SURFACE AREA AND BODY MASS. JOURNAL OF EXPERIMENTAL BIOLOGY 76 , 185-189.
        ELSE
         IF(SAMODE.EQ.2)THEN
           AREA=1110.*AMASS**0.65* ! STAHL W. R. (1967) SCALING OF RESPIRATORY VARIABLES IN MAMMALS. JOURNAL OF APPLIED PHYSIOLOGY 22 , 453-460.
     &      (2.*PI*R2**2 + 2.*PI*(A2*R2/E2)*ASIN(E2)/ ! OUTER SURFACE AREA IF AN ELLIPSOID WITH FUR
     &      (2.*PI*BSEMIN**2 + 2.*PI*(ASEMAJ*BSEMIN/E)*ASIN(E))) ! OUTER SURFACE AREA OF ELLIPSOID WITHOUT FUR
     &      /10000. ! INCREASE IN AREA DUE TO FUR
         ELSE
          AREA = 2.*PI*R2**2 + 2.*PI*(A2*R2/E2)*ASIN(E2) ! ELLIPSE WITH FUR
         ENDIF
        ENDIF
        ATOT = AREA
        D = VOL**(1./3.)
       ENDIF
       GO TO 999
      ENDIF
      
999   CONTINUE
      GMASS = AMASS * 1000.

C     CALCULATING SKIN AREA FOR EVAPORATION
      IF (DHARA .GT. 0.00000) THEN
C      COMPUTING CONVECTIVE AREA OF SKIN NOT OCCUPIED BY HAIR
C      TOTAL AREA ON THE BODY OCCUPIED BY HAIR IS
C     (AREA/HAIR)*(HAIRS/M2)*M2
       DHAIR = DHARA
       RHO = RHOARA
       HAIRAR = (PI * (DHAIR/2.)**2) * (RHO * AREASKIN)
C      SKIN AREA IS TOTAL AREA - HAIR AREA
       CONVSK = AREASKIN - HAIRAR
      ELSE
C      NO FUR
       CONVSK = AREASKIN
      ENDIF

C     COMPUTING CONVECTIVE AREA AT FUR/FEATHER INTERFACE
      AV = AREA*PCOND
      CONVAR = AREA - AV
      
      RESULTS = (/VOL,D,MASFAT,VOLFAT,ALENTH,AWIDTH,AHEIT,ATOT,ASIL,
     & ASILN,ASILP,GMASS,AREASKIN,FLSHVL,FATTHK,ASEMAJ,BSEMIN,
     & CSEMIN,CONVSK,CONVAR,R1,R2/)
      
      RETURN
      END
