      FUNCTION FUNC(XI)
C     NICHEMAPR: SOFTWARE FOR BIOPHYSICAL MECHANISTIC NICHE MODELLING

C     COPYRIGHT (C) 2018 MICHAEL R. KEARNEY AND WARREN P. PORTER

C     THIS PROGRAM IS FREE SOFTWARE: YOU CAN REDISTRIBUTE IT AND/OR MODIFY
C     IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
C     THE FREE SOFTWARE FOUNDATION, EITHER VERSION 3 OF THE LICENSE, OR (AT
C      YOUR OPTION) ANY LATER VERSION.

C     THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
C     WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
C     MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
C     GENERAL PUBLIC LICENSE FOR MORE DETAILS.

C     YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
C     ALONG WITH THIS PROGRAM. IF NOT, SEE HTTP://WWW.GNU.ORG/LICENSES/.

C     FUNCTION XI CALCULATES XI AS PART OF THE ADJACENT RECTANGLES
C     CONFIGURATION/NUMERICAL INTEGRATION CALCULATIONS.


      IMPLICIT NONE

      DOUBLE PRECISION ANGLE,ANS,DEGANGL,FA,FB,FB1,FB2,FC,FC1,FC2,FUNC
      DOUBLE PRECISION PI,X,XI
      
      COMMON/INTGL/X,ANGLE
      DATA PI/3.14159265/

C     X = LENGTHS RATIO, A/B
C     XI = ALL (SEQUENTIAL) VALUES BETWEEN INTEGRATION LIMITS
C     SIN**2(ANGLE) = 0.5*(1.-COS(2*ANGLE)
C     DEBUGGING INFO: ANGLE IN DEGREES

      DEGANGL = ANGLE*180./PI
      FA = SQRT(1.0 + XI**2*(0.5*(1.-COS(2*ANGLE))))
      FB1 = (X-XI*COS(ANGLE))
      FB2 = SQRT(1.0+XI**2* (0.5*(1.-COS(2*ANGLE))))
      FB = ATAN(FB1/FB2)
      FC1 = XI*COS(ANGLE)
      FC2 = SQRT(1.0+XI**2* (0.5*(1.-COS(2*ANGLE))))
      FC=ATAN(FC1/FC2)
      ANS = FA * (FB + FC)
      FUNC = ANS
      RETURN
      END