      SUBROUTINE ECTOTHERM(NN2,NS2,ECTOINPUT1,METOUT1,SHADMET1,SOIL1,
     &SHADSOIL1,SOILMOIST1,SHADMOIST1,SOILPOT1,SHADPOT1,HUMID1
     &,SHADHUMID1,DEP1,RAINFALL1,RAINHR1,DEBMOD1,DEBLAST1,FOODWATERS1
     &,FOODLEVELS1,WETLANDTEMPS1,WETLANDDEPTHS1,GLMTEMP1,GLMO21,GLMSALT1
     &,GLMPH1,GLMFOOD1,ARRHENIUS1,ARRHENIUS12,THERMAL_STAGES1
     &,BEHAV_STAGES1,WATER_STAGES1,NUTRI_STAGES1,MINSHADES1,MAXSHADES1
     &,S_INSTAR1,ENVIRON1,ENBAL1,MASBAL1,DEBOUT1,YEAROUT,YEARSOUT1)

C     NICHEMAPR: SOFTWARE FOR BIOPHYSICAL MECHANISTIC NICHE MODELLING

C     COPYRIGHT (C) 2018 MICHAEL R. KEARNEY AND WARREN P. PORTER

C     THIS PROGRAM IS FREE SOFTWARE: YOU CAN REDISTRIBUTE IT AND/OR MODIFY
C     IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
C     THE FREE SOFTWARE FOUNDATION, EITHER VERSION 3 OF THE LICENSE, OR (AT
C      YOUR OPTION) ANY LATER VERSION.

C     THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
C     WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
C     MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
C     GENERAL PUBLIC LICENSE FOR MORE DETAILS.

C     YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
C     ALONG WITH THIS PROGRAM. IF NOT, SEE HTTP://WWW.GNU.ORG/LICENSES/.

C     ORIGINAL VERSION DEVELOPED BY WARREN P. PORTER BETWEEN 1973 AND 2011
C     MODIFIED BY MICHAEL R. KEARNEY FROM 2011 TO INTERFACE WITH R ENVIRONMENT,
C     WITH INTEGRATION OF KOOIJMAN'S DYNAMIC ENERGY BUDGET (DEB) THEORY IN PLACE OF THE
C     ORIGINAL STATIC ENERGY BUDGET. THE USER CAN SPECIFY AN EMPIRICAL ALLOMETRIC FUNCTION OF
C     O2 CONSUMPTION RATE WITH MASS AND TEMPERATURE TO GET RESPIRATORY WATER LOSS
C     AND METABOLIC HEAT GENERATION OR USE DEB TO OBTAIN THESE FROM FIRST PRINCIPLES.

C     THERE ARE FOUR DEB MODELS - THE STANDARD MODEL (=0), THE ABJ ACCELERATION MODEL 
C     (METAB_MODE=1,TRIGGERED WHEN E_HJ > E_HB), THE ABP ACCELERATION (HEMIMETABOLOUS) INSECT 
C     MODEL (METAB_MODE=1) AND THE HOLOMETABOLOUS INSECT MODEL (METAB_MODE=2).

C     CAN RUN IN STEADY STATE OR TRANSIENT
C     TRANSIENT USES THE GEAR PACKAGE, AN ADAMS PREDICTOR-CORRECTOR
C     INCLUDES A MODEL OF A CONTAINER HOLDING WATER, WHICH CAN BE USED TO SIMLATE AQUATIC LIFE
C     STAGES IN CONTAINERS OR EVEN PONDS. CAN ALSO RECEIVE INPUT FROM THE GENERAL LAKE MODEL
C     (GLM) ON WATER DEPTH, WATER TEMPERATURE, O2, SALT, PH AND FOOD AVAILABILITY.

C     MKS SYSTEM OF UNITS (J, M, KG, S, C, K, PA)

      USE AACOMMONDAT
      IMPLICIT NONE
      EXTERNAL FUN,FUNWING,ONELUMP,SOLOUT

      INTEGER, INTENT(IN) :: NN2
      INTEGER, INTENT(IN) :: NS2
      
      DOUBLE PRECISION, DIMENSION(INT(NN2)), INTENT(IN) :: MAXSHADES1,
     & MINSHADES1
      DOUBLE PRECISION, DIMENSION(INT(NN2)*24,28),INTENT(INOUT) ::
     &ENVIRON1
      DOUBLE PRECISION,DIMENSION(INT(NN2)*24,13),INTENT(INOUT) :: ENBAL1
      DOUBLE PRECISION,DIMENSION(INT(NN2)*24,29),INTENT(INOUT) ::
     & DEBOUT1
       DOUBLE PRECISION,DIMENSION(INT(NN2)*24,19),INTENT(INOUT) ::
     & MASBAL1
      DOUBLE PRECISION, DIMENSION(INT(NN2)), INTENT(IN) :: RAINFALL1,
     & FOODWATERS1,FOODLEVELS1
      DOUBLE PRECISION, DIMENSION(INT(NN2)*24), INTENT(IN) ::
     & WETLANDDEPTHS1,WETLANDTEMPS1,RAINHR1
      DOUBLE PRECISION, DIMENSION(INT(NN2)*24,18), INTENT(IN) :: METOUT1
     &,SHADMET1
      DOUBLE PRECISION, DIMENSION(INT(NN2)*24,12), INTENT(IN) :: SOIL1,
     &SHADSOIL1,SOILMOIST1,SHADMOIST1,SOILPOT1,SHADPOT1,HUMID1,
     &SHADHUMID1
      DOUBLE PRECISION, DIMENSION(INT(NN2)*24,20), INTENT(IN) ::
     & GLMTEMP1,GLMO21,GLMSALT1,GLMPH1,GLMFOOD1
      DOUBLE PRECISION, DIMENSION(INT(CEILING(NN2/365.)),43),
     & INTENT(INOUT) :: YEARSOUT1
      DOUBLE PRECISION, DIMENSION(INT(NS2),6),
     & INTENT(IN) :: THERMAL_STAGES1
      DOUBLE PRECISION, DIMENSION(INT(NS2),15),
     & INTENT(IN) :: BEHAV_STAGES1
      DOUBLE PRECISION, DIMENSION(INT(NS2),8),
     & INTENT(IN) :: WATER_STAGES1
      DOUBLE PRECISION, DIMENSION(INT(NS2),1),
     & INTENT(IN) :: NUTRI_STAGES1
      DOUBLE PRECISION, DIMENSION(INT(NS2),5),
     & INTENT(IN) :: ARRHENIUS1
      DOUBLE PRECISION, DIMENSION(INT(NS2),5),
     & INTENT(IN) :: ARRHENIUS12     
      DOUBLE PRECISION, DIMENSION(INT(NS2)),
     & INTENT(IN) :: S_INSTAR1

      DOUBLE PRECISION A1,A2,A3,A4,A4B,A5,A6,AAIR,ABSAN,ABSMAX,ABSMIN
      DOUBLE PRECISION ABSSB,ACTHR,ADIS,AEFF,AEIN,AEVP,AFOD,AHEIT,AHRS
      DOUBLE PRECISION AIRVOL,AL,ALENTH,ALT,AMASS,AMET,ANDENS,ANDENS_DEB
      DOUBLE PRECISION ANNFOOD,ANNUALACT,ANRG,AREA,AREF,ASIL,ASILN,ASILP
      DOUBLE PRECISION AT,ATGLMFOOD,ATGLMO2,ATGLMPH,ATGLMSALT,ATGLMTEMP
      DOUBLE PRECISION ATHUMID,ATMOIST,ATOL,ATOT,ATPOT,ATSHADHUMID
      DOUBLE PRECISION ATSHADMOIST,ATSHADPOT,ATSHSOI,ATSOIL,AV,AWIDTH
      DOUBLE PRECISION AWIN,AWTR,BIRTHDAY,BIRTHMASS,BP,BREEDRAINTHRESH
      DOUBLE PRECISION BREEDTEMPTHRESH,BREF,CAUSEDEATH,CLUTCHA
      DOUBLE PRECISION CLUTCHB,CLUTCHES,CLUTCHSIZE,CO2FLUX,CO2GAS,CO2MOL
      DOUBLE PRECISION CONTDEP,CONTDEPTH,CONTH,CONTHOLE,CONTINIT
      DOUBLE PRECISION CONTLAST,CONTREF,CONTVOL,CONTW,CONTWET,CONVAR
      DOUBLE PRECISION COUNT,CREF,CTMAX,CTMIN,CUMBATCH,CUMBATCH_INIT
      DOUBLE PRECISION CUMREPRO,CUMREPRO_INIT,CURSOIL,CUSTOMGEOM,CUTFA
      DOUBLE PRECISION D_V,DAIR,DAJABS,DAMT,DAVP,DAWTR,DAYAIR,DAYEIN
      DOUBLE PRECISION DAYEVP,DAYLENGTHFINISH,DAYLENGTHSTART,DAYMET
      DOUBLE PRECISION DAYNRG,DAYWIN,DAYWTR,DCO2,DDOY,DEATHSTAGE
      DOUBLE PRECISION DEBFIRST,DEBLAST1,DEBMOD1,DEBQMET,DEBQMET_INIT
      DOUBLE PRECISION DEIN,DELTA_DEB,DELTAR,DEP1,DEPMAX,DEPRESS,DEPSEL
      DOUBLE PRECISION DEPSUB,DEPTH,DESIDEATH,DEVP,DEVTIME,DMET,DNRG
      DOUBLE PRECISION DRUNK,DRYFOOD,DSHD,DTIME,DWIN,DWTR,E_BABY
      DOUBLE PRECISION E_BABY_INIT,E_BABY1,E_EGG,E_G,E_H,E_H_INIT
      DOUBLE PRECISION E_H_START,E_HB,E_HE,E_HJ,E_M2,E_HP,E_HPUP
      DOUBLE PRECISION E_HPUP_INIT,E_INIT,E_INIT_BABY,E_M,ECTOINPUT
      DOUBLE PRECISION ECTOINPUT1,ED,EGGDRYFRAC,EGGSHSOI,EGGSOIL
      DOUBLE PRECISION EH_BABY,EH_BABY_INIT
      DOUBLE PRECISION EH_BABY1,EMISAN,EMISSB,EMISSK,ENARY1,ENARY10
      DOUBLE PRECISION ENARY11,ENARY12,ENARY13,ENARY14,ENARY15,ENARY16
      DOUBLE PRECISION ENARY17,ENARY18,ENARY19,ENARY2,ENARY20,ENARY21
      DOUBLE PRECISION ENARY22,ENARY23,ENARY24,ENARY25,ENARY26,ENARY27
      DOUBLE PRECISION ENARY28,ENARY29,ENARY3,ENARY30,ENARY31,ENARY32
      DOUBLE PRECISION ENARY33,ENARY34,ENARY35,ENARY36,ENARY37,ENARY38
      DOUBLE PRECISION ENARY39,ENARY4,ENARY40,ENARY41,ENARY42,ENARY43
      DOUBLE PRECISION ENARY44,ENARY45,ENARY46,ENARY47,ENARY48,ENARY5
      DOUBLE PRECISION ENARY6,ENARY7,ENARY8,ENARY9,ENB,ENBERR,ENBERR2
      DOUBLE PRECISION EPUP,EPUP_INIT,ER,ERRTES,E_S,E_S_INIT,E_SM,ETAO
      DOUBLE PRECISION EXTREF,F12,F13,F14,F15,F16,F21,F23,F24,F25,F26
      DOUBLE PRECISION F31,F32,F41,F42,F51,F52,F61,FAECES,FATCOND,FATOBJ
      DOUBLE PRECISION FATOSB,FATOSK,FECUNDITY,FLSHCOND,FLTYPE,FLUID
      DOUBLE PRECISION FLYMETAB,FLYSPEED,FLYTIME,FOOD,FOODLIM,FOODMAX
      DOUBLE PRECISION FOODMIN,FOODWATER,FOODWATERCUR,FUN,FUNCT
      DOUBLE PRECISION G,GEVAP,GH2OMET,GH2OMET_INIT,GUTFILL,GUTFREEMASS
      DOUBLE PRECISION GUTFULL,H_AREF,H2O_BAL,H2O_BAL_HR,H2O_BALPAST
      DOUBLE PRECISION H2O_FAECES,H2O_FREE,H2O_URINE,HALFSAT,HC,HD
      DOUBLE PRECISION HDFORC,HDFREE,HRN,HRSACT,HS,HS_INIT,HSHSOI,HSOIL
      DOUBLE PRECISION JM_JO,K_JREF,K_EL,K_EV,KAP,KAP_R,KAP_V,KAP_X
      DOUBLE PRECISION KAP_X_P,L_B,L_J,L_J2,L_W,L_WREPRO,LAMBDA,LAT
      DOUBLE PRECISION LENGTHDAY,LENGTHDAYDIR,LONGEV,MA,MAX_PCTDESI
      DOUBLE PRECISION MAXMASS,MAXSHADE,MAXSHD,MAXTC,MH,MI,MINCLUTCH
      DOUBLE PRECISION MINED,MINTC,MINWATER,MINWATER2,MINWATERLOW,MLO2
      DOUBLE PRECISION MLO2_INIT,MONMATURE,MONREPRO,MR_1,MR_2,MR_3
      DOUBLE PRECISION MSHSOI,MSOIL,MU_E,MU_N,MU_P,MU_V,MU_X,N2GAS
      DOUBLE PRECISION NEWCLUTCH,NEWDEP,NTRY1,NWASTE,O2FLUX,O2GAS
      DOUBLE PRECISION O2WATERS,OBJDIS,OBJL,ORIG_CLUTCHSIZE,ORIG_E_SM
      DOUBLE PRECISION P_AM_ACC,P_AM_REF,P_MREF,P_XM_ACC
      DOUBLE PRECISION P_XMREF,PAS,PBS,PCS,PDS,PGS,PJS,PMS,PRS,PANT
      DOUBLE PRECISION PANTMAX,PCTDESI,PDIF,PEYES,PFEWAT,PHI,PHI_INIT
      DOUBLE PRECISION PHIMAX,PHIMIN,PHMAX,PHMIN,PHWATERS,PI,PMOUTH
      DOUBLE PRECISION PO2MAX,PO2MIN,PO2THRESH,PO2WATER,POND_DEPTH
      DOUBLE PRECISION PONDMAX,PONDMIN,POTFREEMASS,PREVDAYLENGTH
      DOUBLE PRECISION PREVSTAGE,PSHSOI,PSOIL,PTCOND,PTCOND_ORIG,PTUREA
      DOUBLE PRECISION Q,Q_INIT,QCOND,QCONV,QIRIN
      DOUBLE PRECISION QIROUT,QMETAB,QRESP,QSEVAP,QSOL,QSOLAR,QSOLR
      DOUBLE PRECISION QSOLRF,QUIT,R,R0,R1,RAINDRINK,RAINFALL,RAINMULT
      DOUBLE PRECISION RAINTHRESH,REFLSH,REFSHD,REFTOL,RELHUM,REPRO,RH
      DOUBLE PRECISION RHO1_3,RHREF,RINSUL,RMAX,RQ,RTOL,S_G,S_J
      DOUBLE PRECISION SALWATER,SALWATERS,SHADE,SHD,SHP
      DOUBLE PRECISION SIDEX,SIG,SKINT,SKINW,SPARE3,SPARE4
      DOUBLE PRECISION SPHEAT,STAGE,STAGE_REC,SUBTK,SURVIV,SURVIV_INIT
      DOUBLE PRECISION T,T_A,T_A2,T_AH,T_AH2,T_AL,T_AL2,T_H,T_H2,T_L
      DOUBLE PRECISION T_L2,T_REF,TA,TALOC,TANNUL,TBASK,TC,TC_OLD
      DOUBLE PRECISION TCINIT,TCORES,TDIGPR,TEIN,TEMERGE,TESTX,TEVP,TIME
      DOUBLE PRECISION TIMEND,TLUNG,TMAXPR,TMET,TMINPR,TNRG,TOBJ,TOTLEN
      DOUBLE PRECISION TPREF,TPRINT,TQSOL,TR,TRANS1,TRANSAR
      DOUBLE PRECISION TREF,TSHLOC,TSHLOW,TSHOIL,TSHSKI,TSHSKY,TSHSOI
      DOUBLE PRECISION TSKIN,TSKY,TSKYC,TSOIL,TSOILS,TSUB,TSUBST
      DOUBLE PRECISION TT,TWATER,TWATERS,TWIN,TWING,TWTR
      DOUBLE PRECISION URINEFLUX,V,V_ACC,V_BABY,V_BABY_INIT,V_BABY1
      DOUBLE PRECISION V_INIT,V_INIT_BABY,VDOTREF,VEL,VLOC,VOL,VOLD
      DOUBLE PRECISION VOLD_INIT,VPUP,VPUP_INIT,VREF,W_E,W_N,W_P,W_V
      DOUBLE PRECISION W_X,WC,WCUT,WETFAECESFLUX,WETFOOD,WETFOODFLUX
      DOUBLE PRECISION WETGONAD,WETMASS,WETSTORAGE,WEVAP,WEYES,WINGTEMP
      DOUBLE PRECISION WQSOL,WRESP,X,X_FOOD,X1,X2,XTRY,XWATERS,Y
      DOUBLE PRECISION YBSK,YCLUTCH,YDEGG,YDHATCH,YDIST,YDLAY,YDRINK
      DOUBLE PRECISION YDSTG1,YDSTG2,YDSTG3,YDSTG4,YDSTG5,YDSTG6,YDSTG7
      DOUBLE PRECISION YDSTG8,YEARFRACT,YEAROUT,YFEC,YFECES,YFOOD
      DOUBLE PRECISION YFORAGE,YMAXDEP,YMAXDES,YMAXLEN,YMAXSHADE,YMAXSTG
      DOUBLE PRECISION YMAXWGT,YMINDEP,YMINRES,YMINSHADE,YMSTG1,YMSTG2
      DOUBLE PRECISION YMSTG3,YMSTG4,YMSTG5,YMSTG6,YMSTG7,YMSTG8,YNWASTE
      DOUBLE PRECISION YO2,YSURV,YTMAX,YTMIN,Z,ZBRENT,ZEN
      DOUBLE PRECISION ZFACT,ZSOIL,ZTHRESH
      DOUBLE PRECISION WORK,RPAR,YY,XEND,VSTI,WARMSIG,PREVSOIL

      INTEGER AEST,AESTIVATE,AESTNODE,AQUABASK,AQUABREED,AQUASTAGE
      INTEGER AQUATIC,BATCH,BIRTH,BREED,BREEDACT,BREEDACTTHRES,BREEDEND
      INTEGER BREEDING,BREEDSTART,BREEDTEMPCUM,BREEDVECT,BURROWSHADE
      INTEGER CENSUS,CLIMBING,COMPLETE,COMPLETION,CONTONLY,CONTYPE
      INTEGER COUNTDAY,COUNTER,CTKILL,CTMINCUM,CTMINTHRESH,CURNOD
      INTEGER DAYCOUNT,DEAD,DEADEAD,DEB1,DEHYDRATED,DOY,EGGSHADE,F1COUNT
      INTEGER FEEDING,FLIGHT,FLYER,FLYTEST,FORAGE,GEOMETRY,GEOMREF
      INTEGER GOODSOIL,HCT,HOURCOUNT,HRCALL,HRCALL2,I,I2,IDAY,IHOUR,II1
      INTEGER II2,II3,II4,II5,II6,INTMETHOD,INTNUM,INWATER,IOPT,ISS
      INTEGER ISTATE,IT,ITASK,ITEST,ITOL,IWORK,IYEAR,J,JP,JULSTART,LIVE
      INTEGER LIW,LRW,METAB_MODE,METAMORPH,MF,MICRO,MICROF,MICROF2
      INTEGER MICROS,MICROS2,MICROYEAR,MINNODE,MINWDEP,NA,NALT,NEQ
      INTEGER NM,NN,NODNUM,NON,NQ,NS,NSIMDAY,NTOBJ,NTRY,NTSUB,NYEAR,NZ
      INTEGER PHOTODIRF,PHOTODIRS,PHOTOFINISH,PHOTOSTART,POND,POSTUR
      INTEGER PREGNANT,RESET,SCENAR,SHDBURROW,SOILNODE,STAGE3
      INTEGER STAGES,STARTDAY,STARVING,TESTER,TRANCT,TRANNY
      INTEGER VIVIPAROUS,WETMOD,WINGCALC,WINGMOD,WRITECSV
      INTEGER RAINHOUR

      CHARACTER*1 BURROW,DAYACT,CLIMB,CKGRSHAD,CREPUS,RAINACT
      CHARACTER*1 NOCTURN,FOSORIAL
      LOGICAL SUCCES
      CHARACTER*1 TRANST
      CHARACTER*1 INACTIVE
      CHARACTER(LEN=20) STR

      INTEGER IDID,IOUT,IPAR,NDGL,NRDENS,N,LIWORK,LWORK
      PARAMETER (NDGL=10,NRDENS=10)
      PARAMETER (LWORK=8*NDGL+5*NRDENS+21,LIWORK=NRDENS+21)
      DIMENSION ATOL(1),IWORK(LIWORK),RTOL(1),WORK(LWORK),YY(NDGL)
      DIMENSION IPAR(31),RPAR(34),VSTI(NDGL)
      
      DIMENSION ACTHR(52),ATGLMFOOD(25,20),ATGLMO2(25,20),ATGLMPH(25,20)
      DIMENSION ATGLMSALT(25,20),ATGLMTEMP(25,20),ATHUMID(25,10)
      DIMENSION ATMOIST(25,10),ATPOT(25,10),ATSHADHUMID(25,10)
      DIMENSION ATSHADMOIST(25,10),ATSHADPOT(25,10),ATSHSOI(25,10)
      DIMENSION ATSOIL(25,10),BREEDVECT(24),CUMBATCH(24)
      DIMENSION CUMREPRO(24),CUSTOMGEOM(8),DEBFIRST(13),DEBLAST1(13)
      DIMENSION DEBMOD1(97),DEBQMET(24),DEP1(10),DEPSEL(25),DRYFOOD(24)
      DIMENSION E_BABY1(24),E_H(24),E_HPUP(24),ECTOINPUT(131)
      DIMENSION ECTOINPUT1(131),ED(24),EGGSHSOI(25),EGGSOIL(25)
      DIMENSION EH_BABY1(24),ENARY1(25),ENARY10(25),ENARY11(25)
      DIMENSION ENARY12(25),ENARY13(25),ENARY14(25),ENARY15(25)
      DIMENSION ENARY16(25),ENARY17(25),ENARY18(25),ENARY19(25)
      DIMENSION ENARY2(25),ENARY20(25),ENARY21(25),ENARY22(25)
      DIMENSION ENARY23(25),ENARY24(25),ENARY25(25),ENARY26(25)
      DIMENSION ENARY27(25),ENARY28(25),ENARY29(25),ENARY3(25)
      DIMENSION ENARY30(25),ENARY31(25),ENARY32(25),ENARY33(25)
      DIMENSION ENARY34(25),ENARY35(25),ENARY36(25),ENARY37(25)
      DIMENSION ENARY38(25),ENARY39(25),ENARY4(25),ENARY40(25)
      DIMENSION ENARY41(25),ENARY42(25),ENARY43(25),ENARY44(25)
      DIMENSION ENARY45(25),ENARY46(25),ENARY47(25),ENARY48(25)
      DIMENSION ENARY5(25),ENARY6(25),ENARY7(25),ENARY8(25),ENARY9(25)
      DIMENSION EPUP(24),E_S(24),ETAO(4,3),FAECES(24),FOOD(50)
      DIMENSION GH2OMET(24),HRN(25),HS(24),HSHSOI(25)
      DIMENSION HSOIL(25),INACTIVE(25),JM_JO(4,4),L_W(24)
      DIMENSION MLO2(24),MSHSOI(25),MSOIL(25),NTRY1(24),NWASTE(24)
      DIMENSION O2WATERS(20),PAS(24),PCS(24),PMS(24),PGS(24),PDS(24)
      DIMENSION PJS(24),PRS(24),PBS(24),PHWATERS(20),PSHSOI(25)
      DIMENSION PSOIL(25),Q(24),QSOL(25),REPRO(24),RH(25),RHREF(25)
      DIMENSION SALWATERS(20),SHD(25),SHP(3),STAGE_REC(25),SURVIV(24)
      DIMENSION TALOC(25),TCORES(25),TIME(25),TRANSAR(5,25),TREF(25)
      DIMENSION TSHLOW(25),TSHOIL(25),TSHSKI(25),TSHSOI(25),TSKYC(25)
      DIMENSION TSOIL(25),TSOILS(25),TSUB(25),TWATERS(20),V(24)
      DIMENSION V_BABY1(24),VLOC(25),VOLD(24),VPUP(24),VREF(25)
      DIMENSION WETFOOD(24),WETGONAD(24),WETMASS(24),WETSTORAGE(24)
      DIMENSION XWATERS(20),Y(10),YEAROUT(20),Z(25),ZSOIL(10)
      
      COMMON/ACCEL/P_AM_ACC,V_ACC,P_XM_ACC,ER,L_J2
      COMMON/AIRGAS/O2GAS,CO2GAS,N2GAS
      COMMON/ANNUALACT/ANNUALACT
      COMMON/ANPARMS/RINSUL,R1,AREA,VOL,FATCOND
      COMMON/ARRHEN/T_A,T_AL,T_AH,T_L,T_H,T_REF
      COMMON/ARRHEN2/T_A2,T_AL2,T_AH2,T_L2,T_H2
      COMMON/BEHAV1/DAYACT,BURROW,CLIMB,CKGRSHAD,CREPUS,NOCTURN
      COMMON/BEHAV2/GEOMETRY,NODNUM,CUSTOMGEOM,SHP
      COMMON/BEHAV3/ACTHR
      COMMON/BEHAV4/FOSORIAL
      COMMON/BODYTEMP/BREEDTEMPTHRESH,BREEDTEMPCUM
      COMMON/BREEDER/BREEDING,BREEDVECT
      COMMON/BUR/NON,MINNODE
      COMMON/BURROW/SHDBURROW,BURROWSHADE
      COMMON/CLIMB/CLIMBING
      COMMON/CONT/CONTH,CONTW,CONTVOL,CONTDEP,CONTHOLE,CONTWET,RAINMULT,
     & WETMOD,CONTONLY,CONTYPE,RAINHOUR
      COMMON/CONTDEPTH/CONTDEPTH
      COMMON/COUNTDAY/COUNTDAY,DAYCOUNT
      COMMON/CTMAXMIN/CTMAX,CTMIN,CTMINCUM,CTMINTHRESH,CTKILL
      COMMON/DAYINT/DAYMET,DAYEVP,DAYEIN,DAYWIN,DAYNRG,DAYWTR,DAYAIR
      COMMON/DAYITR/IDAY
      COMMON/DAYSTORUN/NN
      COMMON/DEATH/CAUSEDEATH,DEATHSTAGE
      COMMON/DEBBABY/V_BABY,E_BABY,EH_BABY
      COMMON/DEBINIT1/V_INIT,E_INIT,CUMREPRO_INIT,CUMBATCH_INIT,
     & VOLD_INIT,VPUP_INIT,EPUP_INIT
      COMMON/DEBINIT2/E_S_INIT,Q_INIT,HS_INIT,P_MREF,VDOTREF,H_AREF,
     & E_BABY_INIT,V_BABY_INIT,EH_BABY_INIT,K_JREF,S_G,SURVIV_INIT,
     & HALFSAT,X_FOOD,E_HPUP_INIT,P_XMREF
      COMMON/DEBINPUT/DEBFIRST,ECTOINPUT
      COMMON/DEBMASS/ETAO,JM_JO
      COMMON/DEBMOD/V,ED,WETMASS,WETSTORAGE,WETGONAD,WETFOOD,O2FLUX,
     & CO2FLUX,CUMREPRO,HS,E_S,L_W,CUMBATCH,Q,V_BABY1,E_BABY1,
     & E_H,STAGE,EH_BABY1,GUTFREEMASS,SURVIV,VOLD,VPUP,EPUP,E_HPUP,
     & RAINDRINK,POTFREEMASS,PAS,PBS,PCS,PDS,PGS,PJS,PMS,PRS,CENSUS,
     & RESET,DEADEAD,STARTDAY,DEAD
      COMMON/DEBMOD2/REPRO,ORIG_CLUTCHSIZE,NEWCLUTCH,ORIG_E_SM,MINCLUTCH
      COMMON/DEBOUTT/FECUNDITY,CLUTCHES,MONREPRO,L_WREPRO,MONMATURE,
     & MINED,ANNFOOD,FOOD,LONGEV,COMPLETION,COMPLETE
      COMMON/DEBPAR1/CLUTCHSIZE,ANDENS_DEB,D_V,EGGDRYFRAC,W_E,MU_E,MU_V,
     & W_V,E_EGG,KAP_V,KAP_X,KAP_X_P,MU_X,MU_P,W_N,W_P,W_X,FUNCT,MU_N
      COMMON/DEBPAR2/ZFACT,KAP,E_G,KAP_R,DELTA_DEB,E_H_START,MAXMASS,
     & E_INIT_BABY,V_INIT_BABY,E_H_INIT,E_HB,E_HP,E_HJ,E_SM,LAMBDA,
     & BREEDRAINTHRESH,DAYLENGTHSTART,DAYLENGTHFINISH,LENGTHDAY,
     & LENGTHDAYDIR,PREVDAYLENGTH,LAT,CLUTCHA,CLUTCHB,E_HE,
     & AQUABREED,AQUASTAGE,PHOTODIRS,PHOTODIRF,
     & BREEDACTTHRES,METAMORPH,PHOTOSTART,PHOTOFINISH,BREEDACT,BATCH
      COMMON/DEBPAR3/METAB_MODE,STAGES,K_EL,K_EV
      COMMON/DEBPAR4/S_J,L_B,L_J,E_M2
      COMMON/DEBRESP/MLO2,GH2OMET,DEBQMET,MLO2_INIT,GH2OMET_INIT,
     & DEBQMET_INIT,DRYFOOD,FAECES,NWASTE
      COMMON/DEPTHS/DEPSEL,TCORES
      COMMON/DIMENS/ALENTH,AWIDTH,AHEIT
      COMMON/DOYMON/DOY
      COMMON/DSUB1/ENARY1,ENARY2,ENARY3,ENARY4,ENARY9,ENARY10,ENARY11,
     & ENARY12,ENARY17,ENARY18,ENARY19,ENARY20,ENARY21,ENARY22,ENARY23,
     & ENARY24,ENARY25,ENARY26,ENARY27,ENARY28,ENARY45,ENARY46,ENARY47,
     & ENARY48
      COMMON/DSUB2/ENARY5,ENARY6,ENARY7,ENARY8,ENARY13,ENARY14,ENARY15,
     & ENARY16,ENARY29,ENARY30,ENARY31,ENARY32,ENARY33,ENARY34,ENARY35,
     & ENARY36,ENARY37,ENARY38,ENARY39,ENARY40,ENARY41,ENARY42,ENARY43,
     & ENARY44
      COMMON/EGGDEV/SOILNODE
      COMMON/EGGSOIL/EGGSOIL
      COMMON/ENVAR1/QSOL,RH,TSKYC,TIME,TALOC,TREF,RHREF,HRN
      COMMON/ENVAR2/TSUB,VREF,Z,TANNUL,VLOC
      COMMON/ENVIRS/TSOILS,TSHOIL
      COMMON/EVAP1/WEYES,WRESP,WCUT,AEFF,CUTFA,HD,PEYES,SKINW,
     & SKINT,HC,CONVAR,PMOUTH,PANT,PANTMAX
      COMMON/EVAP2/HDFREE,HDFORC
      COMMON/FLY/FLYTIME,FLYSPEED,FLYMETAB,FLIGHT,FLYER,FLYTEST
      COMMON/FOOD2/DAMT,DAVP,DAJABS,DAWTR
      COMMON/FUN1/QSOLAR,QIRIN,QMETAB,QRESP,QSEVAP,QIROUT,QCONV,QCOND
      COMMON/FUN2/AMASS,RELHUM,ATOT,FATOSK,FATOSB,EMISAN,SIG,FLSHCOND
      COMMON/FUN3/AL,TA,VEL,PTCOND,SUBTK,DEPSUB,TSUBST,PTCOND_ORIG
      COMMON/FUN4/TSKIN,R,WEVAP,TR,ALT,BP,H2O_BALPAST
      COMMON/FUN5/WC,ZEN,PDIF,ABSSB,ABSAN,ASILN,FATOBJ,NM
      COMMON/FUN6/SPHEAT,ABSMAX,ABSMIN,LIVE
      COMMON/GITRAC/PFEWAT,FOODWATERCUR
      COMMON/GOODSOIL/GOODSOIL
      COMMON/GUESS/XTRY
      COMMON/GUT/GUTFULL,GUTFILL,FOODLIM
      COMMON/INTNUM/INTNUM
      COMMON/METDEP/DEPRESS,AESTIVATE,DEHYDRATED,AEST,STARVING
      COMMON/OUTSUB/IT
      COMMON/PONDDATA/INWATER,AQUATIC,TWATER,POND_DEPTH,FEEDING
      COMMON/PONDTEST/POND
      COMMON/POSTURE/POSTUR
      COMMON/RAINACT/RAINACT
      COMMON/RAINFALL/RAINFALL
      COMMON/REFSHADE/REFSHD
      COMMON/REPYEAR/IYEAR,NYEAR
      COMMON/REVAP1/TLUNG,DELTAR,EXTREF,RQ,MR_1,MR_2,MR_3,DEB1
      COMMON/REVAP2/GEVAP,AIRVOL,CO2MOL
      COMMON/SCENARIO/SCENAR
      COMMON/SHADE/MAXSHD,DSHD
      COMMON/SHENV1/TSHSKI,TSHLOW
      COMMON/SOIL/TSOIL,TSHSOI,ZSOIL,MSOIL,MSHSOI,PSOIL,PSHSOI,HSOIL,
     & HSHSOI
      COMMON/SOLN/ENB
      COMMON/STAGE_R/STAGE_REC,F1COUNT,COUNTER
      COMMON/SUM1/DMET,DEVP,DEIN,DWIN,DNRG,DWTR,DAIR,DCO2
      COMMON/SUM2/TMET,TEVP,TEIN,TWIN,TNRG,TWTR
      COMMON/TPREFR/TMAXPR,TMINPR,TDIGPR,TPREF,TBASK,TEMERGE
      COMMON/TRANS/JP
      COMMON/TRANS/TRANCT
      COMMON/TRANSIENT1/TCINIT,TRANSAR
      COMMON/TREG/TC
      COMMON/USROP2/ENBERR,TPRINT
      COMMON/USROPT/TRANST
      COMMON/VIVIP/VIVIPAROUS,PREGNANT
      COMMON/WCOND/TOTLEN,AV,AT
      COMMON/WCONV/FLTYPE
      COMMON/WDSUB1/ANDENS,ASILP,EMISSB,EMISSK,FLUID,G,IHOUR
      COMMON/WDSUB2/QSOLR,TOBJ,TSKY,MICRO
      COMMON/WINGFUN/RHO1_3,TRANS1,AREF,BREF,CREF,PHI,F21,F31,F41,F51,
     & SIDEX,WQSOL,PHIMIN,PHIMAX,TWING,F12,F32,F42,F52,F61,TQSOL,A1,A2,
     & A3,A4,A4B,A5,A6,F13,F14,F15,F16,F23,F24,F25,F26,WINGCALC,WINGMOD
      COMMON/WSOLAR/ASIL,SHADE
      COMMON/WTRAPEZ/DTIME
      COMMON/WUNDRG/NEWDEP
      COMMON/YEAR2/AMET,AEVP,AEIN,AWIN,ANRG,AWTR,AFOD,AHRS,AAIR,ADIS

C     ****************** BEGINING OF I/O *********************

      ECTOINPUT=ECTOINPUT1 ! ECTOTHERM PARAMETER LIST
      NN=INT(NN2) ! NUMBER OF HOURS TO SIMULATE
      NS=INT(NS2) ! NUMBER OF LIFE STAGES TO SIMULATE (DEB MODEL)
      NYEAR=INT(ECTOINPUT1(69)) ! NUMBER OF YEARS TO SIMULATE
      
      ALLOCATE (POND_ENV(NYEAR,NN,25,2),TBS(NN*24),DAYDOY(NN*24))
      ALLOCATE (RAINHR(NN*24),WETLANDDEPTHS(NN*24),WETLANDTEMPS(NN*24))
      ALLOCATE (RAINFALL2(NN),MAXSHADES(NN),MINSHADES(NN))
      ALLOCATE (FOODWATERS(NN),FOODLEVELS(NN))
      ALLOCATE (XP(NN*25),YP(NN*25),DAY(NN),TRANSIENT(NN*25))
      ALLOCATE (ZP1(NN*25),ZP2(NN*25),ZP3(NN*25),ZP4(NN*25))
      ALLOCATE (ZP5(NN*25),ZP6(NN*25),ZP7(NN*25))
      ALLOCATE (ZD1(NN*25),ZD2(NN*25),ZD3(NN*25),ZD4(NN*25))
      ALLOCATE (ZD5(NN*25),ZD6(NN*25),ZD7(NN*25))
      ALLOCATE (FEC(NYEAR),SURV(NYEAR),ACT(NYEAR),FOR(NYEAR),
     & LX(NYEAR),MX(NYEAR))
      ALLOCATE ( THERMAL_STAGES(NS,6) )
      ALLOCATE ( BEHAV_STAGES(NS,15) )
      ALLOCATE ( WATER_STAGES(NS,8) )
      ALLOCATE ( NUTRI_STAGES(NS,1) )
      ALLOCATE ( ARRHENIUS(NS,5) )
      ALLOCATE ( ARRHENIUS2(NS,5) )
      ALLOCATE ( S_INSTAR(NS) )
      ALLOCATE ( L_INSTAR(NS) )
      
C     OUTPUT FILE SETUP
      II1=1
      II2=2
      II3=3
      II4=4
      II5=5
      WRITECSV=INT(ECTOINPUT1(127))
      IF(WRITECSV.EQ.2)THEN ! WRITING CSV FILES FOR HOURLY OUTPUT
       OPEN (II1, FILE = 'ENVIRON.CSV')
       OPEN (II2, FILE = 'MASBAL.CSV')
       OPEN (II3, FILE = 'ENBAL.CSV')
       OPEN (II4, FILE = 'DEBOUT.CSV')
       WRITE(II1,1111) "DOY",",","YEAR",",","DAY",",","TIME",",","TC"
     & ,",","SHADE",",","QSOLAR",",","DEP",",","ACT",",","TA"
     & ,",","TSUB",",","TSKY",",","VEL"
     & ,",","RELHUM",",","ZEN",",","CONDEP",",","WATERTEMP",",",
     & "DAYLENGTH",",","WINGANGLE",",","WINGTEMP",",","FLYING",",",
     & "FLYTIME",",","PO2WATER",",","SALWATER",",","ABS",",",
     & "PTCOND",",","POSTURE",",","PANT"
       WRITE(II2,1112) "DOY",",","YEAR",",","DAY",",","TIME",","
     & ,"O2_ML",",","CO2_ML",",","NWASTE_G",",","H2OFREE_G",",",
     & "H2OMET_G",",","DRYFOOD_G",",","WETFOOD_G",",","DRYFAECES_G",",",
     & "WETFAECES_G",",","URINE_G",",","H2ORESP_G",",","H2OCUT_G",",",
     & "H2OEYES_G",",","H2OBAL_G",",","H2OCUMBAL_G"
       WRITE(II3,1113) "DOY",",","YEAR",",","DAY",",","TIME",","
     & ,"QSOL",",","QIRIN",",","QMET",",","QEVAP",",","QIROUT",",",
     & "QCONV",",","QCOND",",","ENB",",","NTRY"
       WRITE(II4,1114) "DOY",",","YEAR",",","DAY",",","TIME",",",
     & "STAGE",",","V",",","E",",","E_H",",","LENGTH",","
     & ,"WETMASS",",","WETGONAD",",","WETGUT",",","PCT_DESIC",","
     & ,"E_R",",","E_B"
     & ,",","BREEDING",",","PREGNANT",",","V_BABY",",","E_BABY",","
     & ,"H_S",",","P_SURV",",","p_A",",","p_C",",","p_M",",","p_G",",
     & ","p_D",",","p_J",",","p_R",",","p_B"
      ENDIF
      IF(WRITECSV.GT.0)THEN ! WRITING CSV OUTPUT (YEARLY SUMMARIES)
       OPEN (II5, FILE = 'YEAROUT.CSV')
       WRITE(II5,1115) "DEVTIME",",","BIRTHDAY",",","BIRTHMASS",","
     & ,"MONMATURE",",","MONREPRO",",","LENREPRO",",","FECUNDITY",","
     & ,"CLUTCHES",",","ANNUALACT",",","MINRESERVE",",","LASTFOOD",","
     & ,"TOTFOOD",",","MINTB",",","MAXTB",","
     & ,"PCT_DESI",",","LIFESPAN",",","GENTIME",",","R0",",","RMAX",","
     & ,"LENGTH"
      ENDIF

1111  FORMAT(27(A8,A1),A8)
1112  FORMAT(20(A13,A1),A13)
1113  FORMAT(13(A8,A1),A8)
1114  FORMAT(28(A13,A1),A13)
1115  FORMAT(19(A13,A1),A13)

C     INITIALISATIONS AND PARAMETER SETTINGS
      TPRINT=60. ! SETTING PRINT INTERVAL(MIN.)
      PI=3.14159265
      SIG=5.669E - 08
      ZTHRESH=1e-20 ! THRESHOLD FOR SOLVING HEAT BUDGET WITH ZBRENT
      PREVSTAGE=0
      CLIMBING=0
      AEST=0
      MAXSHADE=0.
      PCTDESI=0.
      STARVING=0
      HOURCOUNT=0
      E_H_START=0
      BREEDACT=0
      CAUSEDEATH=0.
      DEATHSTAGE=-1
      DEHYDRATED=0
      WETFOODFLUX=0.
      WETFAECESFLUX=0.
      URINEFLUX=0.
      PTUREA=0.
      H2O_FREE=0.
      H2O_BAL_HR=0.
      H2O_BAL=0.
      ERRTES=0.
      ENBERR2=0.
      E_M=0.
      DRUNK=0.
      DEPTH=0.
      DDOY=0.
      CURSOIL=0.
      PREVSOIL=0.
      CURNOD=0
      CONTLAST=CONTDEP
      VPUP_INIT=1E-4**3.
      EPUP_INIT=0.
      E_HPUP_INIT=0.
      KAP_V=0.
      E_M2=0.
      
      TC_OLD=TC
      L_J=0.1
      L_J2=0.1
      DO 987 I=1,13
       DEBFIRST(I)=DEBLAST1(I)
987   CONTINUE
      RAINFALL2=RAINFALL1
      RAINHR=RAINHR1
      FOODWATERS=FOODWATERS1
      FOODLEVELS=FOODLEVELS1
      WETLANDTEMPS=WETLANDTEMPS1
      WETLANDDEPTHS=WETLANDDEPTHS1
      THERMAL_STAGES=THERMAL_STAGES1
      BEHAV_STAGES=INT(BEHAV_STAGES1)
      WATER_STAGES=WATER_STAGES1
      NUTRI_STAGES=NUTRI_STAGES1
      IF(VIVIPAROUS.EQ.1)THEN ! EMBRYOS DON'T GO TO NEGATIVE WATER BALANCE
       WATER_STAGES(1,1)=0. ! WATERTIGHT
       WATER_STAGES(1,7)=0. ! DRINK
      ENDIF
      ARRHENIUS=ARRHENIUS1
      ARRHENIUS2=ARRHENIUS12
      S_INSTAR=S_INSTAR1
      MAXSHADES=MAXSHADES1
      MINSHADES=MINSHADES1
      WARMSIG=ECTOINPUT1(124)!INT(ECTOINPUT1(124))
      TESTER=INT(ECTOINPUT1(86))
      RAINTHRESH=ECTOINPUT(61)
      PO2THRESH=INT(ECTOINPUT1(130))
      MINWATER=ECTOINPUT1(99)
      MICROYEAR=INT(ECTOINPUT1(100))
      PHI_INIT=PHI
      MA=DEBMOD1(87)
      MI=DEBMOD1(88)
      MH=DEBMOD1(89)
      INTMETHOD=INT(ECTOINPUT1(131))
      EGGSHADE=INT(ECTOINPUT1(129))
      DESIDEATH=ECTOINPUT1(126)
      AQUABASK=INT(ECTOINPUT1(125))
      CONTINIT=ECTOINPUT1(115)
      AESTNODE=INT(ECTOINPUT1(128))
      
C     CHECK IF CONTAINTER MODEL IS ON (ECTOINPUT(101)), THEN CHECK IF GENERAL WETLAND MODEL IS BEING USED (ECTOINPUT(116))
      IF(ECTOINPUT1(101).EQ.1)THEN
       AQUATIC=1
       IF(ECTOINPUT1(116).EQ.1)THEN
        POND=0
       ELSE
        POND=1
       ENDIF
      ENDIF

5501  CONTINUE ! DIRECTED BACK HERE AFTER CONTAINER MODEL HAS JUST RUN, SO RESTARTING FOR ANIMAL SIMULATION

C     MORE INITIALISATIONS
C     ZEROING ANNUAL OUTPUTS OF FECUNDITY AND ACTIVITY
      DO 5500 I=1,NYEAR
       FEC(I)=0.
       MX(I)=0.
       LX(I)=0.
       SURV(I)=0.
5500  CONTINUE
      COMPLETION=0
      COMPLETE=0
      DEAD=0
      DEADEAD=0
      ACT(1:NYEAR)=0.
      FOR(1:NYEAR)=0.
      BIRTH=0
      BIRTHDAY=0.
      MAXTC=0.
      MINTC=0.
      DEVTIME=0.
      BIRTHMASS=0.
      LONGEV=0.
      R0=0.
      RMAX=0.
      TT=0.
      ANNUALACT=0.
      FECUNDITY=0.
      CLUTCHES=0.
      BREEDING=0
      MAX_PCTDESI=0.
      MONMATURE=0.
      DAYCOUNT=1
      IDAY=1
      IYEAR=1
      COUNTDAY=1
      METAMORPH=0
      NSIMDAY = 1
      INACTIVE = 'N'
      TPREF = TDIGPR
      NQ=1
      NZ=1
      NA=11
      NM=1
      NTSUB = 11
      NTOBJ = 1
      NALT = 1

C     WITH MULTI-DIMENSIONAL ARRAYS COLUMN MAJOR ORDER IS USED IN FORTRAN,
C     AND ROW MAJOR ORDER USED IN C.
C     LET'S EXAMINE A SMALL MATRIX:
C        A11  A12  A13
C        A21  A22  A23
C        A31  A32  A33
C     WE CAN STORE THE ELEMENTS IN MEMORY LIKE THIS:
C     A11 A21 A31 A12 A22 A32 A13 A23 A33     ---> HIGHER ADDRESSES
C     THIS IS FORTRAN'S COLUMN MAJOR ORDER, THE FIRST ARRAY INDEX
C     VARIES MOST RAPIDLY, THE ENARY DIMENSIONED BELOW REPRESENTS
C     A 2 COLUMN TABLE WITH 175 ROWS.  COLUMN 1 IS TIME.
C     COLUMN 2 HAS THE TIME DEPENDENT VARIABLES FOR A DAY
C     (25 HRS*7VARIABLES=175).

C     DEFINING ALLOWABLE ERRORS FOR LSODE (GEAR INTEGRATOR)
      RTOL = 1.D-05
      ATOL = 1.D-07

C     SETTING OTHER PARAMETERS FOR LSODE
C     NUMBER OF DIFFERENTIAL EQUATIONS = NEQ
      NEQ=1
      ITASK=1
      ITOL=1
      ISTATE=1
      IOPT=0
      LRW=20+16*NEQ
      LIW=20
      MF=10

2000  CONTINUE ! DIRECTED BACK HERE AFTER COMPLETION OF A DAY IF MORE DAYS TO DO

      IF(DAYCOUNT.GT.1)THEN ! THINGS MAY HAVE CHANGED - DEATH, METAMORPHOSIS - CHECK IF RESETS NEEDED
       IF(METAMORPH.EQ.1)THEN ! METAMORPHOSIS HAS OCCURRED, NEED TO RESET PARAMETERS
C       RESETTING INPUT PARAMETERS
        TRANST='N' ! MAY NOT WANT THIS IF LARGE ANIMAL
        FLTYPE=ECTOINPUT(2)
        OBJDIS=ECTOINPUT(3)
        OBJL=ECTOINPUT(4)
        PDIF=ECTOINPUT(5)
        EMISSK=ECTOINPUT(6)
        EMISSB=ECTOINPUT(7)
        ABSSB=ECTOINPUT(8)
        SHADE=MINSHADES(DAYCOUNT)!ECTOINPUT(9)
        ENBERR2=ECTOINPUT(10)
        EMISAN=ECTOINPUT(12)
        ABSAN=ECTOINPUT(13)
        RQ=ECTOINPUT(14)
        RINSUL=ECTOINPUT(15)
        GEOMETRY=INT(ECTOINPUT(16))
        LIVE=INT(ECTOINPUT(17))
        PANTMAX=ECTOINPUT(18)
        FLSHCOND=ECTOINPUT(19)
        SPHEAT=ECTOINPUT(20)
        ANDENS=ECTOINPUT(21)
        ABSMAX=ECTOINPUT(22)
        ABSMIN=ECTOINPUT(23)
        FATOSK=ECTOINPUT(24)
        FATOSB=ECTOINPUT(25)
        FATOBJ=ECTOINPUT(26)
        TMAXPR=ECTOINPUT(27)
        TMINPR=ECTOINPUT(28)
        DELTAR=ECTOINPUT(29)
        SKINW=ECTOINPUT(30)/100.
        PEYES=ECTOINPUT(31)/100.
        PMOUTH=ECTOINPUT(32)/100.
        EXTREF=ECTOINPUT(33)
        TPREF=ECTOINPUT(34)
        TDIGPR=TPREF
        PTCOND=ECTOINPUT(35)/100.
        PTCOND_ORIG = PTCOND/100.
        SKINT=ECTOINPUT(36)
        O2GAS=ECTOINPUT(37)
        CO2GAS=ECTOINPUT(38)
        N2GAS=ECTOINPUT(39)
        SOILNODE=INT(ECTOINPUT(41))
        POSTUR=INT(ECTOINPUT(46))
        MAXSHD=MAXSHADES(DAYCOUNT)!ECTOINPUT(47)
        REFSHD=MINSHADES(DAYCOUNT)!ECTOINPUT(48)
        CTMAX=ECTOINPUT(49)
        CTMIN=ECTOINPUT(50)
        IF(ECTOINPUT(51).EQ.1)THEN
         DAYACT = 'Y'
        ELSE
         DAYACT = 'N'
        ENDIF
        IF(ECTOINPUT(52).EQ.1)THEN
         NOCTURN = 'Y'
        ELSE
         NOCTURN = 'N'
        ENDIF
        IF(ECTOINPUT(53).EQ.1)THEN
         CREPUS='Y'
        ELSE
         CREPUS='N'
        ENDIF
        IF(ECTOINPUT(54).EQ.1)THEN
         RAINACT='Y'
        ELSE
         RAINACT='N'
        ENDIF
        IF(ECTOINPUT(55).EQ.1)THEN
         BURROW = 'Y'
        ELSE
         BURROW = 'N'
        ENDIF
        IF(ECTOINPUT(56).EQ.1)THEN
         CKGRSHAD='Y'
        ELSE
         CKGRSHAD='N'
        ENDIF
        IF(ECTOINPUT(57).EQ.1)THEN
         CLIMB='Y'
        ELSE
         CLIMB='N'
        ENDIF
        IF(ECTOINPUT(58).EQ.1)THEN
         FOSORIAL='Y'
        ELSE
         FOSORIAL='N'
        ENDIF
        SPARE3=ECTOINPUT(59) !WAS NOFOOD
        RAINTHRESH=ECTOINPUT(61)
        RAINFALL=RAINFALL2(DAYCOUNT)
       ENDIF !END CHECK FOR METAMORPHOSIS

       IF(DEAD.EQ.1)THEN ! ANIMAL DIED, REINITIALISE
        STAGE=DEBLAST1(13)
        V_INIT=DEBFIRST(3)
        E_INIT=DEBFIRST(4)
        E_S_INIT=DEBFIRST(5)
        CUMREPRO_INIT=DEBFIRST(6)
        Q_INIT=DEBFIRST(7)
        HS_INIT=DEBFIRST(8)
        CUMBATCH_INIT=DEBFIRST(9)
        V_BABY_INIT=DEBFIRST(10)
        E_BABY_INIT=DEBFIRST(11)
        E_H_INIT=DEBFIRST(12)
        EH_BABY_INIT=0.
        MLO2_INIT=0.
        GH2OMET_INIT=0.
        DEBQMET_INIT=0.
        IF(DEADEAD.EQ.0)THEN
         SURVIV_INIT=1.
        ENDIF
        VOLD_INIT=DEBFIRST(3)
        VPUP_INIT=1E-4**3.
        EPUP_INIT=0.
        E_HPUP_INIT=0.
       ELSE ! ANIMAL HAS NOT DIED, USE VALUES FROM LAST HOUR OF PREVIOUS DAY TO START NEXT DAY
        V_INIT=V(24)
        E_INIT=ED(24)
        E_S_INIT=E_S(24)
        CUMREPRO_INIT=CUMREPRO(24)
        Q_INIT=Q(24)
        HS_INIT=HS(24)
        CUMBATCH_INIT=CUMBATCH(24)
        V_BABY_INIT=V_BABY1(24)
        E_BABY_INIT=E_BABY1(24)
        EH_BABY_INIT=EH_BABY1(24)
        E_H_INIT=E_H(24)
        MLO2_INIT=MLO2(24)
        GH2OMET_INIT= GH2OMET(24)
        DEBQMET_INIT=DEBQMET(24)
        SURVIV_INIT=SURVIV(24)
        VOLD_INIT=VOLD(24)
        VPUP_INIT=VPUP(24)
        EPUP_INIT=EPUP(24)
        E_HPUP_INIT=E_HPUP(24)
       ENDIF
!       CONTLAST=CONTDEPTH
       CONTLAST=CONTDEP
      ENDIF ! END CHECK FOR RESETS AND NEXT DAY INITIAL CONDITIONS

C     READ IN ENVIRONMENTAL DATA FOR CURRENT DAY
      IF(MICROYEAR.EQ.1)THEN
       MICROS=(COUNTDAY*25-24)+(IYEAR-1)*365*25
       MICROF=COUNTDAY*25+(IYEAR-1)*365*25
       MICROS2=(COUNTDAY*24-23)+(IYEAR-1)*365*24
       MICROF2=COUNTDAY*24+(IYEAR-1)*365*24
C      ABOVE-GROUND ENVIRONMENT
       DO 1804 I=MICROS,MICROF
        I2=I-MICROS+1
        IF(I.LT.MICROF)THEN ! READ 24 HRS OF ENVIRONMETNAL DATA
         TIME(I-(COUNTDAY-1)*25-(IYEAR-1)*365*25)=
     &   METOUT1(MICROS2+I2-1,2)
         TALOC(I-(COUNTDAY-1)*25-(IYEAR-1)*365*25)=
     &   METOUT1(MICROS2+I2-1,3)
         TREF(I-(COUNTDAY-1)*25-(IYEAR-1)*365*25)=
     &   METOUT1(MICROS2+I2-1,4)
         RH(I-(COUNTDAY-1)*25-(IYEAR-1)*365*25)=
     &   METOUT1(MICROS2+I2-1,5)
         RHREF(I-(COUNTDAY-1)*25-(IYEAR-1)*365*25)=
     &   METOUT1(MICROS2+I2-1,6)
         VLOC(I-(COUNTDAY-1)*25-(IYEAR-1)*365*25)=
     &   METOUT1(MICROS2+I2-1,7)
         VREF(I-(COUNTDAY-1)*25-(IYEAR-1)*365*25)=
     &   METOUT1(MICROS2+I2-1,8)
         Z(I-(COUNTDAY-1)*25-(IYEAR-1)*365*25)=
     &   METOUT1(MICROS2+I2-1,12)
         TSKYC(I-(COUNTDAY-1)*25-(IYEAR-1)*365*25)=
     &   METOUT1(MICROS2+I2-1,14)
         TSHLOW(I-(COUNTDAY-1)*25-(IYEAR-1)*365*25)=
     &   SHADMET1(MICROS2+I2-1,4)
         TSHSKI(I-(COUNTDAY-1)*25-(IYEAR-1)*365*25)=
     &   SHADMET1(MICROS2+I2-1,14)
         QSOL(I-(COUNTDAY-1)*25-(IYEAR-1)*365*25)=
     &   METOUT1(MICROS2+I2-1,13)
         HRN(I-(COUNTDAY-1)*25-(IYEAR-1)*365*25)=
     &   RAINHR1(MICROS2+I2-1)
        ELSE ! MAKE 25TH HOUR (NEEDED FOR INTEGRATION) EQUAL TO THE 24TH HOUR VALUE
         TIME(I-(COUNTDAY-1)*25-(IYEAR-1)*365*25)=1440
         TALOC(I-(COUNTDAY-1)*25-(IYEAR-1)*365*25)=
     &   METOUT1(MICROS2+I2-2,3)
         TREF(I-(COUNTDAY-1)*25-(IYEAR-1)*365*25)=
     &   METOUT1(MICROS2+I2-2,4)
         RH(I-(COUNTDAY-1)*25-(IYEAR-1)*365*25)=
     &   METOUT1(MICROS2+I2-2,5)
         RHREF(I-(COUNTDAY-1)*25-(IYEAR-1)*365*25)=
     &   METOUT1(MICROS2+I2-2,6)
         VLOC(I-(COUNTDAY-1)*25-(IYEAR-1)*365*25)=
     &   METOUT1(MICROS2+I2-2,7)
         VREF(I-(COUNTDAY-1)*25-(IYEAR-1)*365*25)=
     &   METOUT1(MICROS2+I2-2,8)
         Z(I-(COUNTDAY-1)*25-(IYEAR-1)*365*25)=
     &   METOUT1(MICROS2+I2-2,12)
         TSKYC(I-(COUNTDAY-1)*25-(IYEAR-1)*365*25)=
     &   METOUT1(MICROS2+I2-2,14)
         TSHLOW(I-(COUNTDAY-1)*25-(IYEAR-1)*365*25)=
     &   SHADMET1(MICROS2+I2-2,4)
         TSHSKI(I-(COUNTDAY-1)*25-(IYEAR-1)*365*25)=
     &   SHADMET1(MICROS2+I2-2,14)
         QSOL(I-(COUNTDAY-1)*25-(IYEAR-1)*365*25)=
     &   METOUT1(MICROS2+I2-2,13)
         HRN(I-(COUNTDAY-1)*25-(IYEAR-1)*365*25)=
     &   RAINHR1(MICROS2+I2-2)     
        ENDIF
1804   CONTINUE
C      SOIL ENVIRONMENT
       DO 1805 J=3,12
        DO 1806 I=MICROS,MICROF
         I2=I-MICROS+1
         IF(I.LT.MICROF)THEN ! READ 24 HRS OF ENVIRONMETNAL DATA
          ATSOIL(I-(COUNTDAY-1)*25-(IYEAR-1)*365*25,J-2)=
     &    SOIL1(MICROS2+I2-1,J)
          ATSHSOI(I-(COUNTDAY-1)*25-(IYEAR-1)*365*25,J-2)=
     &    SHADSOIL1(MICROS2+I2-1,J)
          ATPOT(I-(COUNTDAY-1)*25-(IYEAR-1)*365*25,J-2)=
     &    SOILPOT1(MICROS2+I2-1,J)
          ATSHADPOT(I-(COUNTDAY-1)*25-(IYEAR-1)*365*25,J-2)=
     &    SHADPOT1(MICROS2+I2-1,J)
          ATMOIST(I-(COUNTDAY-1)*25-(IYEAR-1)*365*25,J-2)=
     &    SOILMOIST1(MICROS2+I2-1,J)
          ATSHADMOIST(I-(COUNTDAY-1)*25-(IYEAR-1)*365*25,J-2)=
     &    SHADMOIST1(MICROS2+I2-1,J)
          ATHUMID(I-(COUNTDAY-1)*25-(IYEAR-1)*365*25,J-2)=
     &    HUMID1(MICROS2+I2-1,J)
          ATSHADHUMID(I-(COUNTDAY-1)*25-(IYEAR-1)*365*25,J-2)=
     &    SHADHUMID1(MICROS2+I2-1,J)
         ELSE ! MAKE 25TH HOUR (NEEDED FOR INTEGRATION) EQUAL TO THE 24TH HOUR VALUE
          ATSOIL(I-(COUNTDAY-1)*25-(IYEAR-1)*365*25,J-2)=
     &    SOIL1(MICROS2+I2-2,J)
          ATSHSOI(I-(COUNTDAY-1)*25-(IYEAR-1)*365*25,J-2)=
     &    SHADSOIL1(MICROS2+I2-2,J)
          ATPOT(I-(COUNTDAY-1)*25-(IYEAR-1)*365*25,J-2)=
     &    SOILPOT1(MICROS2+I2-2,J)
          ATSHADPOT(I-(COUNTDAY-1)*25-(IYEAR-1)*365*25,J-2)=
     &    SHADPOT1(MICROS2+I2-2,J)
          ATMOIST(I-(COUNTDAY-1)*25-(IYEAR-1)*365*25,J-2)=
     &    SOILMOIST1(MICROS2+I2-2,J)
          ATSHADMOIST(I-(COUNTDAY-1)*25-(IYEAR-1)*365*25,J-2)=
     &    SHADMOIST1(MICROS2+I2-2,J)
          ATHUMID(I-(COUNTDAY-1)*25-(IYEAR-1)*365*25,J-2)=
     &    HUMID1(MICROS2+I2-2,J)
          ATSHADHUMID(I-(COUNTDAY-1)*25-(IYEAR-1)*365*25,J-2)=
     &    SHADHUMID1(MICROS2+I2-2,J)
         ENDIF
1806    CONTINUE
1805   CONTINUE
C      POND ENVIRONMENT
       DO 1807 J=1,20
        DO 1808 I=MICROS,MICROF
         I2=I-MICROS+1
         IF(I.LT.MICROF)THEN
          ATGLMTEMP(I-(COUNTDAY-1)*25-(IYEAR-1)*365*25,J)=
     &    GLMTEMP1(MICROS2+I2-1,J)
          ATGLMO2(I-(COUNTDAY-1)*25-(IYEAR-1)*365*25,J)=
     &    GLMO21(MICROS2+I2-1,J)
          ATGLMSALT(I-(COUNTDAY-1)*25-(IYEAR-1)*365*25,J)=
     &    GLMSALT1(MICROS2+I2-1,J)
          ATGLMPH(I-(COUNTDAY-1)*25-(IYEAR-1)*365*25,J)=
     &    GLMPH1(MICROS2+I2-1,J)
          ATGLMFOOD(I-(COUNTDAY-1)*25-(IYEAR-1)*365*25,J)=
     &    GLMFOOD1(MICROS2+I2-1,J)
         ELSE
          ATGLMTEMP(I-(COUNTDAY-1)*25-(IYEAR-1)*365*25,J)=
     &    GLMTEMP1(MICROS2+I2-2,J)
          ATGLMO2(I-(COUNTDAY-1)*25-(IYEAR-1)*365*25,J)=
     &    GLMO21(MICROS2+I2-2,J)
          ATGLMSALT(I-(COUNTDAY-1)*25-(IYEAR-1)*365*25,J)=
     &    GLMSALT1(MICROS2+I2-2,J)
          ATGLMPH(I-(COUNTDAY-1)*25-(IYEAR-1)*365*25,J)=
     &    GLMPH1(MICROS2+I2-2,J)
          ATGLMFOOD(I-(COUNTDAY-1)*25-(IYEAR-1)*365*25,J)=
     &    GLMFOOD1(MICROS2+I2-2,J)
         ENDIF
1808    CONTINUE
1807   CONTINUE
       RAINFALL=RAINFALL1(COUNTDAY+(IYEAR-1)*365)
       DAYDOY(COUNTDAY)=INT(METOUT1(COUNTDAY*24,1))
       IF(DAYDOY(COUNTDAY).EQ.0)THEN
        GOTO 200
       ENDIF
       DOY=DAYDOY(COUNTDAY)
      ENDIF ! END READING IN ENVIRONMENTAL DATA

C     SETTING DAY OF YEAR COUNTER (FOR TRANSIENT CALCULATIONS)
      IF (JP.EQ.0) THEN
       DDOY=0.
      ENDIF

      IF(DAYCOUNT.EQ.1)THEN ! SET INPUT VARIABLES
       ALT=ECTOINPUT1(1)
       BP = 101325.*((1.-(.0065*ALT/288.))**(1./.190284)) ! BAROMETRIC PRESSURE
       FLTYPE=ECTOINPUT1(2)
       OBJDIS=ECTOINPUT1(3)
       OBJL=ECTOINPUT1(4)
       PDIF=ECTOINPUT1(5)
       EMISSK=ECTOINPUT1(6)
       EMISSB=ECTOINPUT1(7)
       ABSSB=ECTOINPUT1(8)
       SHADE=MINSHADES(DAYCOUNT)!ECTOINPUT1(9)
       ENBERR2=ECTOINPUT1(10)
       AMASS=ECTOINPUT1(11)
       EMISAN=ECTOINPUT1(12)
       ABSAN=ECTOINPUT1(13)
       RQ=ECTOINPUT1(14)
       RINSUL=ECTOINPUT1(15)
       GEOMETRY=INT(ECTOINPUT1(16))
       LIVE=INT(ECTOINPUT1(17))
       PANTMAX=ECTOINPUT1(18)
       FLSHCOND=ECTOINPUT1(19)
       SPHEAT=ECTOINPUT1(20)
       ANDENS=ECTOINPUT1(21)
       ABSMAX=ECTOINPUT1(22)
       ABSMIN=ECTOINPUT1(23)
       FATOSK=ECTOINPUT1(24)
       FATOSB=ECTOINPUT1(25)
       FATOBJ=ECTOINPUT1(26)
       TMAXPR=ECTOINPUT1(27)
       TMINPR=ECTOINPUT1(28)
       DELTAR=ECTOINPUT1(29)
       SKINW=ECTOINPUT1(30)/100.
       PEYES=ECTOINPUT1(31)/100.
       PMOUTH=ECTOINPUT1(32)/100.
       EXTREF=ECTOINPUT1(33)
       TPREF=ECTOINPUT1(34)
       TDIGPR=TPREF
       PTCOND=ECTOINPUT1(35)/100.
       PTCOND_ORIG = PTCOND/100.
       SKINT=ECTOINPUT1(36)
       O2GAS=ECTOINPUT1(37)
       CO2GAS=ECTOINPUT1(38)
       N2GAS=ECTOINPUT1(39)
       IF(ECTOINPUT1(40).EQ.1)THEN
        TRANST='Y'
        TRANNY=1
       ELSE
        TRANST='N'
        TRANNY=0
       ENDIF
       SOILNODE=INT(ECTOINPUT1(41))
       EXTREF=ECTOINPUT1(42)
       SPARE4=ECTOINPUT1(43) ! WAS ACTLVL
       TANNUL=ECTOINPUT1(44)
       NODNUM=INT(ECTOINPUT1(45))
       POSTUR=INT(ECTOINPUT1(46))
       MAXSHD=MAXSHADES(DAYCOUNT)!ECTOINPUT1(47)
       REFSHD=MINSHADES(DAYCOUNT)!ECTOINPUT1(48)
       CTMAX=ECTOINPUT1(49)
       CTMIN=ECTOINPUT1(50)
       IF(ECTOINPUT1(51).EQ.1)THEN
        DAYACT = 'Y'
       ELSE
        DAYACT = 'N'
       ENDIF
       IF(ECTOINPUT1(52).EQ.1)THEN
        NOCTURN = 'Y'
       ELSE
        NOCTURN = 'N'
       ENDIF
       IF(ECTOINPUT1(53).EQ.1)THEN
        CREPUS='Y'
       ELSE
        CREPUS='N'
       ENDIF
       IF(ECTOINPUT1(54).EQ.1)THEN
        RAINACT='Y'
       ELSE
        RAINACT='N'
       ENDIF
       IF(ECTOINPUT1(55).EQ.1)THEN
        BURROW = 'Y'
       ELSE
        BURROW = 'N'
       ENDIF
       IF(ECTOINPUT1(56).EQ.1)THEN
        CKGRSHAD='Y'
       ELSE
        CKGRSHAD='N'
       ENDIF
       IF(ECTOINPUT1(57).EQ.1)THEN
        CLIMB='Y'
       ELSE
        CLIMB='N'
       ENDIF
       IF(ECTOINPUT1(58).EQ.1)THEN
        FOSORIAL='Y'
       ELSE
        FOSORIAL='N'
       ENDIF
       SPARE3=ECTOINPUT(59) !WAS NOFOOD
       RAINTHRESH=ECTOINPUT1(61)
       VIVIPAROUS=INT(ECTOINPUT1(62))
       PREGNANT=INT(ECTOINPUT1(63))

C    CHECK IF BUCKET MODEL HAS RUN (OR IF WET0D WAS RUN) AND, IF SO, SWITCH OFF POND
       IF(((AQUATIC.EQ.1).AND.(POND.EQ.0)).OR.(ECTOINPUT1(101).EQ.0).OR.
     &  (ECTOINPUT1(116).EQ.1))THEN
        CONTH=0.
        CONTW=0.
        CONTREF=ECTOINPUT1(64)
        CONTLAST=0.
        TRANST='N'
        RAINMULT=0.
        JP=0
        DDOY=0.
       ELSE
        CONTH=ECTOINPUT1(64)
        CONTREF=CONTH
        CONTW=ECTOINPUT1(65)
        CONTLAST=ECTOINPUT1(66)
        RAINMULT=ECTOINPUT1(71)
       ENDIF
       TCINIT=ECTOINPUT1(68)
       NYEAR=INT(ECTOINPUT1(69))
       LAT=ECTOINPUT1(70)
       JULSTART=INT(ECTOINPUT1(72))
       DSHD=ECTOINPUT1(73) !WAS MONTHLY
       CUSTOMGEOM(1)=ECTOINPUT1(74)
       CUSTOMGEOM(2)=ECTOINPUT1(75)
       CUSTOMGEOM(3)=ECTOINPUT1(76)
       CUSTOMGEOM(4)=ECTOINPUT1(77)
       CUSTOMGEOM(5)=ECTOINPUT1(78)
       CUSTOMGEOM(6)=ECTOINPUT1(79)
       CUSTOMGEOM(7)=ECTOINPUT1(80)
       CUSTOMGEOM(8)=ECTOINPUT1(81)
       MR_1=ECTOINPUT1(82)
       MR_2=ECTOINPUT1(83)
       MR_3=ECTOINPUT1(84)
       DEB1=INT(ECTOINPUT1(85))
       TESTER=INT(ECTOINPUT1(86))
       RHO1_3=ECTOINPUT1(87)
       TRANS1=ECTOINPUT1(88)
       AREF=ECTOINPUT1(89)
       BREF=ECTOINPUT1(90)
       CREF=ECTOINPUT1(91)
       PHI=ECTOINPUT1(92)
       PHI_INIT=PHI
       WINGMOD=INT(ECTOINPUT1(93))
       PHIMAX=ECTOINPUT1(94)
       PHIMIN=ECTOINPUT1(95)
       SHP(1)=ECTOINPUT1(96)
       SHP(2)=ECTOINPUT1(97)
       SHP(3)=ECTOINPUT1(98)
       IF((SHP(1).EQ.SHP(2)).AND.(SHP(2).EQ.SHP(3)))THEN
        SHP(3)=SHP(3)-0.0000001
       ENDIF
       MINWATER=ECTOINPUT1(99)
       MICROYEAR=INT(ECTOINPUT1(100))
       FLYER=INT(ECTOINPUT1(102))
       FLYSPEED=ECTOINPUT1(103)
       NON=INT(ECTOINPUT1(105))
       CTMINTHRESH=INT(ECTOINPUT1(106))
       CTKILL=INT(ECTOINPUT1(107))
       GUTFILL=ECTOINPUT1(108)/100.
       MINNODE=INT(ECTOINPUT1(109))
       RAINFALL=RAINFALL1(DAYCOUNT)
       TBASK=ECTOINPUT1(110)
       TEMERGE=ECTOINPUT1(111)
       P_XMREF=ECTOINPUT1(112)
       SUBTK=ECTOINPUT1(113)
       FLYMETAB=ECTOINPUT1(114)
       CONTINIT=ECTOINPUT1(115)
       WETMOD=INT(ECTOINPUT1(116))
       CONTONLY=INT(ECTOINPUT1(117))
       CONTHOLE=ECTOINPUT1(118)
       CONTYPE=INT(ECTOINPUT1(119))
       SHDBURROW=INT(ECTOINPUT1(120))
       BREEDTEMPTHRESH=ECTOINPUT1(121)
       BREEDTEMPCUM=INT(ECTOINPUT1(122))
       CONTWET=ECTOINPUT1(123)/100.
       WARMSIG=ECTOINPUT1(124)!INT(ECTOINPUT1(124))
       AQUABASK=INT(ECTOINPUT1(125))
       DESIDEATH=ECTOINPUT1(126)
       AESTNODE=INT(ECTOINPUT1(128))
       EGGSHADE=INT(ECTOINPUT1(129))
       PO2THRESH=INT(ECTOINPUT1(130))
       INTMETHOD=INT(ECTOINPUT1(131))
       DO 800 I=1,10
        ZSOIL(I)=DEP1(I)
800    CONTINUE
       DO 801 I=1,25
        IF(I.LT.25)THEN
         DAYDOY(I)=INT(METOUT1(I,1))
         IF(DAYDOY(I).EQ.0)THEN
          GOTO 200
         ENDIF
         TIME(I)=METOUT1(I,2)
         TALOC(I)=METOUT1(I,3)
         TREF(I)=METOUT1(I,4)
         RH(I)=METOUT1(I,5)
         VLOC(I)=METOUT1(I,7)
         VREF(I)=METOUT1(I,8)
         Z(I)=METOUT1(I,12)
         TSKYC(I)=METOUT1(I,14)
         TSHLOW(I)=SHADMET1(I,4)
         TSHSKI(I)=SHADMET1(I,14)
         QSOL(I)=METOUT1(I,13)
         HRN(I)=RAINHR1(I)
        ELSE
         DAYDOY(I)=INT(METOUT1(24,1))
         IF(DAYDOY(I).EQ.0)THEN
          GOTO 200
         ENDIF
         TIME(I)=1440
         TALOC(I)=METOUT1(24,3)
         TREF(I)=METOUT1(24,4)
         RH(I)=METOUT1(24,5)
         VLOC(I)=METOUT1(24,7)
         VREF(I)=METOUT1(24,8)
         Z(I)=METOUT1(24,12)
         TSKYC(I)=METOUT1(24,14)
         TSHLOW(I)=SHADMET1(24,4)
         TSHSKI(I)=SHADMET1(24,14)
         QSOL(I)=METOUT1(24,13)
         HRN(I)=RAINHR1(24)
        ENDIF
801    CONTINUE
       DO 802 J=3,12
        DO 803 I=1,25
         IF(I.LT.25)THEN
          ATSOIL(I,J-2)=SOIL1(I,J)
          ATSHSOI(I,J-2)=SHADSOIL1(I,J)
          ATMOIST(I,J-2)=SOILMOIST1(I,J)
          ATSHADMOIST(I,J-2)=SHADMOIST1(I,J)
          ATPOT(I,J-2)=SOILPOT1(I,J)
          ATSHADPOT(I,J-2)=SHADPOT1(I,J)
          ATHUMID(I,J-2)=HUMID1(I,J)
          ATSHADHUMID(I,J-2)=SHADHUMID1(I,J)
         ELSE
          ATSOIL(24,J-2)=SOIL1(24,J)
          ATSHSOI(24,J-2)=SHADSOIL1(24,J)
          ATMOIST(I,J-2)=SOILMOIST1(24,J)
          ATSHADMOIST(I,J-2)=SHADMOIST1(24,J)
          ATPOT(I,J-2)=SOILPOT1(24,J)
          ATSHADPOT(I,J-2)=SHADPOT1(24,J)
          ATHUMID(I,J-2)=HUMID1(24,J)
          ATSHADHUMID(I,J-2)=SHADHUMID1(24,J)
         ENDIF
803     CONTINUE
802    CONTINUE
       DO 804 J=1,20
        DO 805 I=1,25
         IF(I.LT.25)THEN
          ATGLMTEMP(I,J)=GLMTEMP1(I,J)
          ATGLMO2(I,J)=GLMO21(I,J)
          ATGLMSALT(I,J)=GLMSALT1(I,J)
          ATGLMPH(I,J)=GLMPH1(I,J)
          ATGLMFOOD(I,J)=GLMFOOD1(I,J)
         ELSE
          ATGLMTEMP(24,J)=GLMTEMP1(24,J)
          ATGLMO2(I,J)=GLMO21(I,J)
          ATGLMSALT(I,J)=GLMSALT1(I,J)
          ATGLMPH(I,J)=GLMPH1(I,J)
          ATGLMFOOD(I,J)=GLMFOOD1(I,J)
         ENDIF
805     CONTINUE
804    CONTINUE
       DOY=DAYDOY(1)
C      DEB MODEL
       CLUTCHSIZE=DEBMOD1(1)
       ANDENS_DEB=DEBMOD1(2)
       D_V=DEBMOD1(3)
       EGGDRYFRAC=DEBMOD1(4)
       MU_X=DEBMOD1(5)
       MU_E=DEBMOD1(6)
       MU_V=DEBMOD1(7)
       MU_P=DEBMOD1(8)
       T_REF=DEBMOD1(9)
C      PRIMARY DEB PARAMETERS
       ZFACT=DEBMOD1(10)
       KAP=DEBMOD1(11)
       KAP_X=DEBMOD1(12)
       P_MREF=DEBMOD1(13)
       VDOTREF=DEBMOD1(14)
       E_G=DEBMOD1(15)
       KAP_R=DEBMOD1(16)
       E_SM=DEBMOD1(17)
       DELTA_DEB=DEBMOD1(18)
       H_AREF=DEBMOD1(19)
       V_INIT_BABY=DEBMOD1(20)
       E_INIT_BABY=DEBMOD1(21)
       V_BABY=V_INIT_BABY
       E_BABY=E_INIT_BABY
       K_JREF=DEBMOD1(22)
       E_HB=DEBMOD1(23)
       E_HJ=DEBMOD1(24)
       E_HP=DEBMOD1(25)
       E_HE=DEBMOD1(94)
       K_EL=DEBMOD1(95)
       K_EV=DEBMOD1(96)
       MU_N=DEBMOD1(97)
C      OTHER DEB-RELATED PARAMETERS
       CLUTCHB=DEBMOD1(26)
       BATCH=INT(DEBMOD1(27))
       BREEDRAINTHRESH=DEBMOD1(28)
       PHOTOSTART=INT(DEBMOD1(29))
       PHOTOFINISH=INT(DEBMOD1(30))
       DAYLENGTHSTART=DEBMOD1(31)
       DAYLENGTHFINISH=DEBMOD1(32)
       PHOTODIRS=INT(DEBMOD1(33))
       PHOTODIRF=INT(DEBMOD1(34))
       CLUTCHA=DEBMOD1(35)
       AQUABREED=INT(DEBMOD1(36))
       AQUASTAGE=INT(DEBMOD1(37))
       ETAO(1,1)=DEBMOD1(38)
       ETAO(2,1)=DEBMOD1(39)
       ETAO(3,1)=DEBMOD1(40)
       ETAO(4,1)=DEBMOD1(41)
       ETAO(1,2)=DEBMOD1(42)
       ETAO(2,2)=DEBMOD1(43)
       ETAO(3,2)=DEBMOD1(44)
       ETAO(4,2)=DEBMOD1(45)
       ETAO(1,3)=DEBMOD1(46)
       ETAO(2,3)=DEBMOD1(47)
       ETAO(3,3)=DEBMOD1(48)
       ETAO(4,3)=DEBMOD1(49)
       JM_JO(1,1)=DEBMOD1(50)
       JM_JO(2,1)=DEBMOD1(51)
       JM_JO(3,1)=DEBMOD1(52)
       JM_JO(4,1)=DEBMOD1(53)
       JM_JO(1,2)=DEBMOD1(54)
       JM_JO(2,2)=DEBMOD1(55)
       JM_JO(3,2)=DEBMOD1(56)
       JM_JO(4,2)=DEBMOD1(57)
       JM_JO(1,3)=DEBMOD1(58)
       JM_JO(2,3)=DEBMOD1(59)
       JM_JO(3,3)=DEBMOD1(60)
       JM_JO(4,3)=DEBMOD1(61)
       JM_JO(1,4)=DEBMOD1(62)
       JM_JO(2,4)=DEBMOD1(63)
       JM_JO(3,4)=DEBMOD1(64)
       JM_JO(4,4)=DEBMOD1(65)
       E_EGG=DEBMOD1(66)
       KAP_X_P=DEBMOD1(67)
       PTUREA=DEBMOD1(68)
       PFEWAT=DEBMOD1(69)
       W_X=DEBMOD1(70)
       W_E=DEBMOD1(71)
       W_V=DEBMOD1(72)
       W_P=DEBMOD1(73)
       W_N=DEBMOD1(74)
       FOODWATER=DEBMOD1(75)
       FOODWATERCUR=FOODWATER
       FUNCT=DEBMOD1(76)
       S_G = DEBMOD1(77)
       HALFSAT=DEBMOD1(78)
       X_FOOD=DEBMOD1(79)
       METAB_MODE=INT(DEBMOD1(80))
       STAGES=INT(DEBMOD1(81))
       KAP_V=DEBMOD1(82)
       S_J=DEBMOD1(83)
       STARTDAY=INT(DEBMOD1(84))
       RAINDRINK=DEBMOD1(85)
       RESET=INT(DEBMOD1(86))
       MA=DEBMOD1(87)
       MI=DEBMOD1(88)
       MH=DEBMOD1(89)
       AESTIVATE=INT(DEBMOD1(90))
       DEPRESS=DEBMOD1(91)
       MINCLUTCH=DEBMOD1(92)
       L_B=DEBMOD1(93)
       L_INSTAR(1)=S_INSTAR(1)**0.5*L_B
       DO 89 J=2,(STAGES)
        L_INSTAR(J)=S_INSTAR(J)**0.5*L_INSTAR(J-1)
89     CONTINUE

C      INITIAL CONDITIONS OR VALUES FROM LAST DAY
C      IYEAR=DEBLAST1(1)
       COUNTDAY=INT(DEBLAST1(2))
       V_INIT=DEBLAST1(3)
       E_INIT=DEBLAST1(4)
       E_S_INIT=DEBLAST1(5)
       CUMREPRO_INIT=DEBLAST1(6)
       Q_INIT=DEBLAST1(7)
       HS_INIT=DEBLAST1(8)
       CUMBATCH_INIT=DEBLAST1(9)
       V_BABY_INIT=DEBLAST1(10)
       E_BABY_INIT=DEBLAST1(11)
       E_H_INIT=DEBLAST1(12)
       STAGE=DEBLAST1(13)
       MLO2_INIT=0.
       GH2OMET_INIT=0.
       DEBQMET_INIT=0.
       SURVIV_INIT=1.
       VOLD_INIT=DEBLAST1(3)
       VPUP_INIT=1E-4**3.
       EPUP_INIT=0.
       E_HPUP_INIT=0.
C      SAVE INITIAL VALUES FOR RESETTING TO EGG UPON DEATH
       IF((DAYCOUNT.EQ.1).AND.(IHOUR.EQ.0))THEN
        DO 1101 I=1,13
         DEBFIRST(I)=DEBLAST1(I)
1101    CONTINUE
       ENDIF
       P_AM_REF=P_MREF*ZFACT/KAP
       E_M=P_AM_REF/VDOTREF
       MAXMASS=(ZFACT**3)*ANDENS_DEB+((((ZFACT**3)*E_M)/
     & MU_E)*W_E)/D_V
      ENDIF
C     END OF CHECK THAT DAYCOUNT IS 1

      IF(CONTH.GT.0)THEN ! SIMULATING CONTAINER
       LIVE=0
       TRANST='Y'
      ELSE
       IF(ECTOINPUT1(40).EQ.1)THEN ! SIMULATING TRANSIENT HEAT BUDGET
        TRANST='Y'
       ELSE
        TRANST='N'
       ENDIF
      ENDIF

      IF (LIVE .EQ. 0) THEN ! SIMULATE INANIMATE OBJECT
       DAYACT='Y'
       NOCTURN='Y'
       CREPUS='Y'
       BURROW='N'
       CLIMB='N'
       CKGRSHAD ='N'
       TMAXPR=100.
       TMINPR=-100.
       TBASK=-100.
       TEMERGE=-100.
       TPREF =100.
      ENDIF

      TIMEND = 1440.
C     INITIALIZING TIME (IN CUMULATIVE MINUTES)
      T = TIME(1)
C     HOUR OF THE DAY
      IHOUR = INT((T/60.)) + 1
      DTIME=TPRINT*60
      INTNUM=INT(1500/TPRINT)

C     MORE CONTAINER MODEL SETUP
      IF(CONTH.GT.0)THEN
       SKINW=CONTWET
       IF((DAYCOUNT.EQ.1).AND.(T.EQ.0.))THEN
        IF(CONTINIT.LT.0.01)THEN
         CONTINIT=0.01
        ENDIF
        CONTDEP=CONTINIT
        ZD4(1)=CONTDEP
       ELSE
        IF(RAINHOUR.EQ.0)THEN
         CONTDEP=RAINFALL*RAINMULT+CONTLAST-CONTHOLE
        ENDIF
       ENDIF
       IF(CONTDEP.LT.0.)THEN
        CONTDEP=0.
       ENDIF
       IF(CONTDEP.GT.CONTH)THEN
         CONTDEP=CONTH
       ENDIF
      ENDIF
      
C     DOPRI initialise
      X=0.
      YY=0. 
      XEND=0.
      RTOL=0.  
      ATOL=0. 
      ITOL=0  
      IOUT=0  
      WORK=0.  
      IWORK=0  
      RPAR=0.  
      IPAR=0
      IDID=0
      VSTI=0
      
      GEOMREF = GEOMETRY

C     INITIALIZE MASS
      IF((DEB1.EQ.1).AND.(LIVE.EQ.1))THEN
       IF((DAYCOUNT.EQ.1).AND.(IHOUR.EQ.1))THEN
        AMASS=((((V_INIT*E_INIT)/MU_E)*W_E)/D_V + V_INIT)/1000
       ENDIF
      ENDIF
C     ****************** END OF I/O *********************

C     COMPUTING ANIMAL (OBJECT) AREAS AND CONVECTION DIMENSION
      CALL GEOM

C     ESTABLISHING A REFERENCE FOR THE USER SUPPLIED FLESH THERMAL CONDUCTIVITY
      REFLSH=FLSHCOND
      WC=AMASS*SPHEAT

C     UNUSED CODE FOR COMPUTING GEOMETRY OF DIFFUSE RADIATION CONFIGURATION FACTOR,F,
C     BETWEEN ANIMAL AND LARGE NEARBY OBJECT IN THE ENVIRONMENT
C     (OTHER THAN SKY AND GROUND)

C     #18 DISC - DISC; CONFIGURATION FACTOR,APPENDIX C,SIEGEL & HOWELL
C      RR1=(AL/2.)/OBJDIS
C      RR2=(OBJL/2.)/OBJDIS
C      X=1.+(1.+RR2**2)/RR1**2
C      FATOBJ=0.5*(X-(X**2-4.*(RR2/RR1)**2)**.5)

C     COMPUTING SOLAR AND LONG WAVE INFRARED HEAT INPUT

C     CHOOSING NORMAL OR POINTING POSTURE
      IF(LIVE.EQ.0)THEN
       IF(POSTUR.EQ.1)THEN
        ASIL=ASILN
       ENDIF
       IF(POSTUR.EQ.2)THEN
        ASIL=ASILP
       ENDIF
       IF(POSTUR.EQ.0)THEN
        ASIL=(ASILN+ASILP)/2.
       ENDIF
      ELSE
C      START IN FORAGING POSTURE
       ASIL=(ASILN+ASILP)/2. ! AVERAGE OF NORMAL AND PARALLEL POSTURES
       POSTUR=0 ! 0 MEANS FORAGING POSTURE
       PTCOND=PTCOND_ORIG
      ENDIF
      
C     COMPUTING SOIL DEPTH (M) FOR CONDUCTION: FROM SURFACE TO FIRST NODE DOWN.
      DEPSUB=(ZSOIL(2)-ZSOIL(1))/100.

C     INITIALIZE HRSACT FOR THIS MONTH
      HRSACT=0

C     CHECKING THIS MONTH'S MINIMUM ACTIVITY TEMPERATURE
      IF(TDIGPR.LT.TMINPR)THEN
       TMINPR=TDIGPR
      ENDIF
      DO 5778 I=1,24
5778   REPRO(I)=0
      DO 5787 I=1,25
5787  STAGE_REC(I)=0

      IHOUR=0
      HRCALL=0
      HRCALL2=0

C     SETTING PHOTOPERIOD-SPECIFIED BREEDING PERIODS FOR DEB MODEL
      CALL PHOTOPERIOD(LAT,DAYCOUNT,IHOUR,DOY,STARTDAY,PHOTOSTART,
     & PHOTOFINISH,PHOTODIRS,PHOTODIRF,DAYLENGTHSTART,DAYLENGTHFINISH,
     & BREEDSTART,BREEDEND,BREED,LAMBDA,PREVDAYLENGTH,LENGTHDAYDIR,
     &LENGTHDAY)

C     ****************START OF 25 HOURS IN THE DAY LOOP (0 - 24)***********************
54    CONTINUE
C     START STEADY STATE LOOP
      PANT=1. ! INITIALISE PANTING
      SHADE=MINSHADES(DAYCOUNT)
      MAXSHD=MAXSHADES(DAYCOUNT)
      IHOUR=IHOUR+1
      IF((IHOUR.EQ.1).AND.(COUNTDAY.EQ.1).AND.(IYEAR.EQ.1))THEN
       HOURCOUNT=0
      ENDIF
      IF(IHOUR.LT.25)THEN
       HOURCOUNT=HOURCOUNT+1
      ENDIF
      IF(IHOUR.EQ.25)THEN
       DO 5777 I=1,24
       ACTHR(I)=0D0
5777   REPRO(I)=0D0
      ENDIF

C     CHECK IF USING HOURLY RAINFALL INPUT   
      IF(HRN(IHOUR).GE.0)THEN 
       RAINFALL=HRN(IHOUR)
       RAINHOUR=1
      ENDIF

C     INITIALISING FOR SUMMARY CALCULATIONS OF ANNUAL STATISTICS AND FOR TRANSIENT TC
      IF((IHOUR.EQ.1).AND.(DAYCOUNT.EQ.1))THEN
       CENSUS=STARTDAY-1
       TC=TCINIT
       TSKIN=TCINIT+0.01
       IF(CENSUS.LE.0)THEN
        CENSUS=365
       ENDIF
       CENSUS=365
      ENDIF

      IF((((DAYCOUNT.EQ.1).AND.(IHOUR.EQ.1)).OR.
     &(COUNTDAY.EQ.CENSUS+1)).AND.(IHOUR.EQ.1))THEN
       YMAXSTG=0.
       YMAXWGT=0.
       YMAXLEN=0.
       YTMAX=0.
       YTMIN=0.
       YMINRES=0.
       YMAXDES=0.
       YMINSHADE=0.
       YMAXSHADE=0.
       YMINDEP=0.
       YMAXDEP=0.
       YBSK=0.
       YFORAGE=0.
       YDIST=0.
       YFOOD=0.
       YDRINK=0.
       YNWASTE=0.
       YFECES=0.
       YO2=0.
       YCLUTCH=0.
       YFEC=0.
       YDLAY=0.
       YDEGG=0.
       YDHATCH=0.
       YDSTG1=0.
       YDSTG2=0.
       YDSTG3=0.
       YDSTG4=0.
       YDSTG5=0.
       YDSTG6=0.
       YDSTG7=0.
       YDSTG8=0.
       YMSTG1=0.
       YMSTG2=0.
       YMSTG3=0.
       YMSTG4=0.
       YMSTG5=0.
       YMSTG6=0.
       YMSTG7=0.
       YMSTG8=0.
       YSURV=1.
      ENDIF

      IF((AQUATIC.EQ.1).AND.(POND.EQ.0).AND.(IHOUR.LT.25))THEN
C     GET CURRENT POND ENVIRONMENT, INITIALIZE MAX/MIN TEMPS TO WATER TEMP AT HOUR 1
       IF(WETMOD.EQ.1)THEN
        TWATERS=ATGLMTEMP(IHOUR,:) ! CURRENT HOUR'S WATER PROFILE
        O2WATERS=ATGLMO2(IHOUR,:) ! CURRENT HOUR'S O2 PROFILE
        PHWATERS=ATGLMPH(IHOUR,:) ! CURRENT HOUR'S PH PROFILE
        SALWATERS=ATGLMSALT(IHOUR,:) ! CURRENT HOUR'S PH PROFILE
        XWATERS=ATGLMFOOD(IHOUR,:) ! CURRENT HOUR'S FOOD PROFILE
        MINWDEP=0
        DO 65 I=1,20
         IF((TWATERS(21-I).NE.-999).AND.(MINWDEP.EQ.0))THEN ! FIND WATER LEVEL
          MINWDEP = 21-I
         ENDIF
65      CONTINUE
        PONDMAX=MAXVAL(TWATERS(1:MINWDEP))
        PONDMIN=MINVAL(TWATERS(1:MINWDEP))
        PO2MAX=MAXVAL(O2WATERS(1:MINWDEP))
        PO2MIN=MINVAL(O2WATERS(1:MINWDEP))
        PHMAX=MAXVAL(PHWATERS(1:MINWDEP))
        PHMIN=MINVAL(PHWATERS(1:MINWDEP))
        FOODMAX=MAXVAL(XWATERS(1:MINWDEP))
        FOODMIN=MINVAL(XWATERS(1:MINWDEP))
        IF((PONDMAX.LT.CTMAX).AND.(PONDMIN.GT.CTMIN))THEN
         IF((PONDMAX.LT.TMAXPR).AND.(PONDMIN.GT.TMINPR))THEN
          DO 66 I=1,MINWDEP
           TWATER=TWATERS(MINWDEP+1-I)
           PO2WATER=O2WATERS(MINWDEP+1-I)
           IF((PONDMAX.LE.TMAXPR).AND.(PONDMIN.GE.TMINPR).AND.
     &      (PO2WATER.GT.PO2THRESH))THEN
            POND_DEPTH=MINWDEP+1-I
            PO2WATER=O2WATERS(I)
            SALWATER=SALWATERS(I)
            GOTO 72
           ENDIF
66        CONTINUE
         ELSE
          IF(PONDMAX.GT.TMAXPR)THEN
           TWATER=PONDMIN
          ELSE
           TWATER=PONDMAX
          ENDIF
          DO 74 I=1,20
           IF(TWATERS(I).EQ.TWATER)THEN
            POND_DEPTH = 21-I
            PO2WATER = O2WATERS(I)
            SALWATER = SALWATERS(I)
           ENDIF
74        CONTINUE
         ENDIF
        ELSE
         IF(PONDMAX.GT.TMAXPR)THEN
          TWATER=PONDMIN
         ELSE
          TWATER=PONDMAX
         ENDIF
         DO 67 I=1,20
          IF(TWATERS(I).EQ.TWATER)THEN
           POND_DEPTH = 21-I
           PO2WATER = O2WATERS(I)
           SALWATER = SALWATERS(I)
          ENDIF
67       CONTINUE
        ENDIF
72      WETLANDDEPTHS(HOURCOUNT)=POND_DEPTH
        !POND_DEPTH = MAXLOC(TWATERS(1:MINWDEP) )
        !TWATERMAX = TWATERS(I)
        !TWATERMIN = MIN(TWATERS, 1)
        !IF(TWATERS(I).LE.CTMAX & TWATERS(I).GE.CTMIN)THEN
        !POND_DEPTH = I
        !TWATER = MAXVAL(ATGLMTEMP(HOURCOUNT,:))
        !TWATER = ATGLMTEMP(HOURCOUNT,1)
        !POND_DEPTH=WETLANDDEPTHS(HOURCOUNT)
        !TWATER=WETLANDTEMPS(HOURCOUNT)
        !PONDMAX=WETLANDTEMPS(HOURCOUNT-IHOUR+1)
        !PONDMIN=WETLANDTEMPS(HOURCOUNT-IHOUR+1)
       ELSE
        POND_DEPTH=POND_ENV(IYEAR,COUNTDAY,IHOUR,2)
        TWATER=POND_ENV(IYEAR,COUNTDAY,IHOUR,1)
        PONDMAX=POND_ENV(IYEAR,COUNTDAY,1,1)
        PONDMIN=POND_ENV(IYEAR,COUNTDAY,1,1)
       ENDIF
      ENDIF

C     INITIALISE FLIGHT STATE
      FLYTEST=0
      FLIGHT=0
      FLYTIME=0.

C     SET STAGE-SPECIFIC PARAMETERS FOR DEB MODEL
      IF((DEB1.EQ.1).AND.(STAGE.LE.(STAGES-1)).AND.(POND.EQ.0))THEN
       STAGE3=INT(STAGE)
       CTMIN=THERMAL_STAGES(STAGE3+1,1)
       CTMAX=THERMAL_STAGES(STAGE3+1,2)
       TMINPR=THERMAL_STAGES(STAGE3+1,3)
       TMAXPR=THERMAL_STAGES(STAGE3+1,4)
       TBASK=THERMAL_STAGES(STAGE3+1,5)
       TPREF=THERMAL_STAGES(STAGE3+1,6)
       T_A=ARRHENIUS(STAGE3+1,1)
       T_AL=ARRHENIUS(STAGE3+1,2)
       T_AH=ARRHENIUS(STAGE3+1,3)
       T_L=ARRHENIUS(STAGE3+1,4)
       T_H=ARRHENIUS(STAGE3+1,5)
       T_A2=ARRHENIUS2(STAGE3+1,1)
       T_AL2=ARRHENIUS2(STAGE3+1,2)
       T_AH2=ARRHENIUS2(STAGE3+1,3)
       T_L2=ARRHENIUS2(STAGE3+1,4)
       T_H2=ARRHENIUS2(STAGE3+1,5)       
       IF(BEHAV_STAGES(STAGE3+1,1).EQ.1)THEN
        DAYACT='Y'
       ELSE
        DAYACT='N'
       ENDIF
       IF(BEHAV_STAGES(STAGE3+1,2).EQ.1)THEN
        NOCTURN='Y'
       ELSE
        NOCTURN='N'
       ENDIF
       IF(BEHAV_STAGES(STAGE3+1,3).EQ.1)THEN
        CREPUS='Y'
       ELSE
        CREPUS='N'
       ENDIF
       IF(BEHAV_STAGES(STAGE3+1,4).EQ.1)THEN
        BURROW='Y'
       ELSE
        BURROW='N'
       ENDIF
       SHDBURROW=INT(BEHAV_STAGES(STAGE3+1,5))
       MINNODE=INT(BEHAV_STAGES(STAGE3+1,6))
       NON=INT(BEHAV_STAGES(STAGE3+1,7))
       IF(BEHAV_STAGES(STAGE3+1,8).EQ.1)THEN
        CKGRSHAD='Y'
       ELSE
        CKGRSHAD='N'
       ENDIF
       IF(BEHAV_STAGES(STAGE3+1,9).EQ.1)THEN
        CLIMB='Y'
       ELSE
        CLIMB='N'
       ENDIF
       IF(BEHAV_STAGES(STAGE3+1,11).EQ.1)THEN
        FOSORIAL='Y'
       ELSE
        FOSORIAL='N'
       ENDIF
       IF(BEHAV_STAGES(STAGE3+1,11).EQ.1)THEN
        RAINACT='Y'
       ELSE
        RAINACT='N'
       ENDIF
       RAINTHRESH=BEHAV_STAGES(STAGE3+1,12)
       BREEDACTTHRES=BEHAV_STAGES(STAGE3+1,13)
       FLYER=INT(BEHAV_STAGES(STAGE3+1,14))
       SKINW=WATER_STAGES(STAGE3+1,1)/100.
       EXTREF=WATER_STAGES(STAGE3+1,2)
       PFEWAT=WATER_STAGES(STAGE3+1,3)
       PTUREA=WATER_STAGES(STAGE3+1,4)
       FOODWATER=WATER_STAGES(STAGE3+1,5)
       MINWATER=WATER_STAGES(STAGE3+1,6)
       RAINDRINK=WATER_STAGES(STAGE3+1,7)
       GUTFILL=WATER_STAGES(STAGE3+1,8)/100.
       FOODLIM=NUTRI_STAGES(STAGE3+1,1)
       IF(AEST.EQ.1)THEN
        DAYACT='N'
        NOCTURN='N'
        CREPUS='N'
        MINNODE=AESTNODE
       ENDIF
      ENDIF


      IF((DEB1.EQ.1).AND.(POND.EQ.0).AND.(((STAGE.EQ.STAGES).AND.
     &    (RESET.LE.STAGES)).OR.(COMPLETE.EQ.1)))THEN ! HAVE REACHED FINAL INSTAR OR RESETTING AFTER A PARTICULAR STAGE
       IF(COMPLETE.EQ.1)THEN
        STAGE3=STAGES
       ELSE
        STAGE3=INT(STAGE)
       ENDIF
       CTMIN=THERMAL_STAGES(STAGE3,1)
       CTMAX=THERMAL_STAGES(STAGE3,2)
       TMINPR=THERMAL_STAGES(STAGE3,3)
       TMAXPR=THERMAL_STAGES(STAGE3,4)
       TBASK=THERMAL_STAGES(STAGE3,5)
       TPREF=THERMAL_STAGES(STAGE3,6)
       IF(BEHAV_STAGES(STAGE3,1).EQ.1)THEN
        DAYACT='Y'
       ELSE
        DAYACT='N'
       ENDIF
       IF(BEHAV_STAGES(STAGE3,2).EQ.1)THEN
        NOCTURN='Y'
       ELSE
        NOCTURN='N'
       ENDIF
       IF(BEHAV_STAGES(STAGE3,3).EQ.1)THEN
        CREPUS='Y'
       ELSE
        CREPUS='N'
       ENDIF
       IF(BEHAV_STAGES(STAGE3,4).EQ.1)THEN
        BURROW='Y'
       ELSE
        BURROW='N'
       ENDIF
       SHDBURROW=INT(BEHAV_STAGES(STAGE3,5))
       MINNODE=INT(BEHAV_STAGES(STAGE3,6))
       NON=INT(BEHAV_STAGES(STAGE3,7))
       IF(BEHAV_STAGES(STAGE3,8).EQ.1)THEN
        CKGRSHAD='Y'
       ELSE
        CKGRSHAD='N'
       ENDIF
       IF(BEHAV_STAGES(STAGE3,9).EQ.1)THEN
        CLIMB='Y'
       ELSE
        CLIMB='N'
       ENDIF
       IF(BEHAV_STAGES(STAGE3,10).EQ.1)THEN
        FOSORIAL='Y'
       ELSE
        FOSORIAL='N'
       ENDIF
       IF(BEHAV_STAGES(STAGE3,11).EQ.1)THEN
        RAINACT='Y'
       ELSE
        RAINACT='N'
       ENDIF
       RAINTHRESH=BEHAV_STAGES(STAGE3,12)
       BREEDACTTHRES=BEHAV_STAGES(STAGE3,13)
       FLYER=INT(BEHAV_STAGES(STAGE3,14))
       SKINW=WATER_STAGES(STAGE3,1)/100.
       EXTREF=WATER_STAGES(STAGE3,2)
       PFEWAT=WATER_STAGES(STAGE3,3)
       PTUREA=WATER_STAGES(STAGE3,4)
       FOODWATER=WATER_STAGES(STAGE3,5)
       MINWATER=WATER_STAGES(STAGE3,6)
       RAINDRINK=WATER_STAGES(STAGE3,7)
       GUTFILL=WATER_STAGES(STAGE3,8)/100.
       FOODLIM=NUTRI_STAGES(STAGE3,1)
       AQUABASK=INT(BEHAV_STAGES(STAGE3,15))
      ENDIF

C     NOTE THIS SHOULD BE SPECIFIC TO THE LAST STAGE BUT PUT STAGE 7
C     FOR HETERONNYMPHA BECAUSE WE ARE ADDING AN EXTRA STAGE SO THAT THE BUTTERFLIES DIE AFTER SOME REPRO
      IF((DEB1.EQ.1).AND.(METAB_MODE.GT.1).AND.(POND.EQ.0))THEN
       IF(STAGE.LT.STAGES-1)THEN
        WINGMOD=0
       ELSE
        WINGMOD=INT(ECTOINPUT1(93))
       ENDIF
      ENDIF

C     SET SOIL ENVIRONMENT
      DO 56 J=1,NON
       TSOIL(J)=ATSOIL(IHOUR,J)
       TSHSOI(J)=ATSHSOI(IHOUR,J)
       MSOIL(J)=ATMOIST(IHOUR,J)
       MSHSOI(J)=ATSHADMOIST(IHOUR,J)
       PSOIL(J)=ATPOT(IHOUR,J)
       PSHSOI(J)=ATSHADPOT(IHOUR,J)
       HSOIL(J)=ATHUMID(IHOUR,J)
       HSHSOI(J)=ATSHADHUMID(IHOUR,J)
56    CONTINUE

C     SET SOIL ENVIRONMENT FOR OVIPOSITION DEPTH
      EGGSOIL(IHOUR)=TSOIL(SOILNODE)
      EGGSHSOI(IHOUR)=TSHSOI(SOILNODE)

C     SETTING OPTIONS FOR SHADE SELECTION WHEN INACTIVE
      IF(SHDBURROW.EQ.2)THEN
       BURROWSHADE=1
       IF((DEB1.EQ.1).AND.(STAGE.EQ.0))THEN
        BURROWSHADE=0
        SHADE=REFSHD
       ENDIF
      ELSE
       IF(((TSOIL(MINNODE).GT.TMAXPR).OR.(TSOIL(MINNODE).LT.CTMIN)).
     &  AND.(SHDBURROW.GE.1))THEN
        BURROWSHADE=1
        IF((DEB1.EQ.1).AND.(STAGE.EQ.0).AND.(VIVIPAROUS.EQ.0))THEN
         IF(EGGSHADE.EQ.0)THEN
          BURROWSHADE=0
          SHADE=REFSHD
         ELSE
          BURROWSHADE=1
         ENDIF
        ENDIF
       ELSE
        BURROWSHADE=0
       ENDIF
      ENDIF
      IF((DEB1.EQ.1).AND.(STAGE.EQ.0).AND.(VIVIPAROUS.EQ.0))THEN
       IF(EGGSHADE.EQ.0)THEN
        BURROWSHADE=0
        SHADE=REFSHD
       ELSE
        BURROWSHADE=1
       ENDIF
      ENDIF
C     SETTING TWO SHADE TEMPERATURES, SKY AND LOCAL AIR TEMP. FOR THIS HOUR FROM INPUT MATRIX SHADMET
      TSHSKY = TSHSKI(IHOUR)
      TSHLOC = TSHLOW(IHOUR)

      PHI=PHI_INIT
      FORAGE=0

      IF(((LIVE.EQ.1).AND.(DEB1.EQ.0)).OR.((LIVE.EQ.1).AND.(DEB1.EQ.1)
     &    .AND.(METAB_MODE.LT.2)))THEN
       TPREF=ECTOINPUT1(34)
      ENDIF

C     INITIALIZING COUNTER FOR ITERATION
      COUNT=0
C     INITIALIZING RETRY COUNTER
      NTRY=1
C     RESETTING SHADE FOR ANY THERMOREGULATION THAT MAY HAVE HAPPENED IN A PRIOR HOUR
      SHADE=REFSHD

C     RESETTING DEPTH SELECTION
      DEPSEL(IHOUR)=0.00
      NEWDEP=0.0
C     SETTING QUIT VARIABLE FOR THERMOREG.FOR
      QUIT=0.

C     CREATE A SOLAR REFERENCE VALUE FOR DETERMINING ACTIVITY
      QSOLRF=QSOL(IHOUR)
      QSOLR=QSOLRF

C     RESETTING ABSORPTIVITY, FLESH THERMAL CONDUCTIVITY AND GEOMETRY TO DEFAULT VALUES.
      ABSAN=ABSMAX
      FLSHCOND=REFLSH
      GEOMETRY=GEOMREF

      CALL GEOM

      IF((TRANST.EQ.'Y').OR.(TRANST.EQ.'Y'))THEN
       GOTO 7111
      ENDIF

C     GET THIS HOUR'S ENVIRONMENTAL CONDITIONS ABOVE GROUND, BECAUSE NEEDED BELOW WHEN IHOUR>0
      CALL ABOVEGROUND

C     CREATE A SOLAR REFERENCE VALUE FOR DETERMINING ACTIVITY
      QSOLRF=QSOLR

7111  CONTINUE

      IF (JP.GE.25) THEN
       ISS=(JP+1)-INT(DDOY*25)
      ELSE
       ISS=JP+1
      ENDIF

      QSOLR = QSOL(IHOUR)
      IF(QSOLR.GT.0.000000000)THEN
       CALL SOLAR
      ELSE
C      NO SUN
       QSOLAR=0.000
      ENDIF

      IF((TRANST.EQ.'Y').OR.(TRANST.EQ.'Y'))THEN
       GOTO 253
      ENDIF

C     CHECK TO SEE IF DEVELOPING EGG AND, IF IT IS, PUT IT IN THE GROUND
      IF((DEB1.EQ.1).AND.(POND.EQ.0))THEN
       IF(STAGE.EQ.0)THEN
        IF((VIVIPAROUS.EQ.1).OR.((RESET.GT.0).AND.(E_H_START.EQ.0).AND.
     &    (AQUABREED.GT.0)))THEN
         AMASS=MAXMASS/1000.
        ELSE
         IF(AQUABREED.NE.1)THEN
          IF(BURROWSHADE.EQ.1)THEN
           TA=EGGSHSOI(IHOUR)
           SHADE=MAXSHADE
          ELSE
           TA=EGGSOIL(IHOUR)
           SHADE=REFSHD
          ENDIF
          CALL BELOWGROUND
          CALL RADIN
          DEPSEL(IHOUR)=-1*ZSOIL(SOILNODE)
          GOTO 252
         ENDIF
        ENDIF
       ENDIF
      ENDIF
      IF((IHOUR.EQ.14).AND.(DAYCOUNT.EQ.2))THEN
       X=X+1-1
      ENDIF
C    *********WORK OUT INITIAL LOCATION OF ANIMAL GIVEN ACTIVITY CONSTRAINTS********
C     CHECK IF IT WAS IN THE BURROW LAST HOUR AND, IF SO, IS IT TOO COLD TO EMERGE AND BASK?
      IF((DAYCOUNT.EQ.1).AND.(IHOUR.EQ.1))THEN
       CONTINUE
      ELSE
       IF(ENVIRON1((IHOUR+24*(DAYCOUNT-1))-1,8).LT.0)THEN
C      GET THE SOIL NODE AND TEMPERATURE FOR THIS HOUR AT THAT DEPTH
        DO 233 I=1,NON
         IF(ENVIRON1((IHOUR+24*(DAYCOUNT-1))-1,8).EQ.(ZSOIL(I)*(-1.)))
     &    THEN
          DEPTH=ZSOIL(I)
          TC_OLD=TSOIL(I)
          CURNOD=I
         ENDIF
233     CONTINUE
        IF((IHOUR+24*(DAYCOUNT-1)).LT.(NN2*24))THEN
         IF(BURROWSHADE.EQ.0)THEN
          PREVSOIL=SOIL1((IHOUR+24*(DAYCOUNT-1))-1,2+CURNOD)
          CURSOIL=SOIL1((IHOUR+24*(DAYCOUNT-1)),2+CURNOD)
         ELSE
          PREVSOIL=SHADSOIL1((IHOUR+24*(DAYCOUNT-1))-1,2+CURNOD)
          CURSOIL=SHADSOIL1((IHOUR+24*(DAYCOUNT-1)),2+CURNOD)
         ENDIF
        ENDIF
        IF((TC_OLD.LT.TEMERGE)
     &   .OR.
     &   ((TC_OLD.GE.TEMERGE) ! POTENTIALY COULD EMERGE
     &     .AND.
     &     (WARMSIG.NE.0D0) ! NEEDS A SIGNAL OF WARMING
     &     .AND.
     &     (CURNOD.GT.2) ! NOT RIGHT NEAR SURFACE
     &     .AND.
     &     (((WARMSIG.GT.0D0).AND.((CURSOIL-PREVSOIL).LT.WARMSIG)) ! NO SIGNAL
     &     .OR.
     &     ((WARMSIG.LT.0D0).AND.((CURSOIL-PREVSOIL).GT.WARMSIG))) ! NO SIGNAL
     &     .AND.
     &     (SUM(ACTHR).EQ.0)))THEN ! NO ACTIVITY YET FOR THE DAY
         TA=TC_OLD ! STAY AT PREV TEMP
         NEWDEP=DEPTH ! STAY AT PREV DEPTH
         IF(BURROWSHADE.EQ.1)THEN
          SHADE=MAXSHD
          CALL SELDEP(TSHSOI,HSHSOI,ZSOIL,RELHUM)
         ELSE
          SHADE=REFSHD
          CALL SELDEP(TSOIL,HSOIL,ZSOIL,RELHUM)
         ENDIF
         DEPSEL(IHOUR)=NEWDEP*(-1.0)
         GOTO 253
        ELSE
         DEPTH=DEPSEL(IHOUR)
        ENDIF
       ENDIF
      ENDIF
      FLTYPE=ECTOINPUT(2)
C     CHECK IF AQUATIC STAGE AND, IF SO, MAKE ITS ENVIRONMENT WATER
      IF((DEB1.EQ.1).AND.(POND.EQ.0).AND.((AQUABREED.EQ.1).OR.
     &    (AQUABREED.EQ.2)))THEN
       IF(AQUABREED.EQ.1)THEN
        IF(STAGE.LE.1)THEN
         FLTYPE=1
         TC=TWATER
         INWATER=1
         DEPSEL(IHOUR)=0.
         IF(STAGE.EQ.1)THEN
          FEEDING=1
          IF(GUTFULL.LT.GUTFILL)THEN
           FORAGE=1
          ENDIF
         ELSE
          FEEDING=0
          FORAGE=0
         ENDIF
         GOTO 252
        ENDIF
       ENDIF
       IF(AQUABREED.EQ.2)THEN
        IF(STAGE.EQ.1)THEN
         FLTYPE=1
         TC=TWATER
         INWATER=1
         FEEDING=1
         DEPSEL(IHOUR)=0.
         IF(GUTFULL.LT.GUTFILL)THEN
          FORAGE=1
         ENDIF
         GOTO 252
        ENDIF
       ENDIF
      ENDIF

C    AQUATIC BEHAVIOUR
      IF((AQUATIC.EQ.1).AND.(POND.EQ.0).AND.(AQUABREED.EQ.4)
     &    .AND.(IHOUR.LT.25))THEN
C     GET CURRENT POND ENVIRONMENT, INITIALIZE MAX/MIN TEMPS TO WATER TEMP AT HOUR 1
       IF(WETMOD.EQ.1)THEN
        TWATERS=ATGLMTEMP(IHOUR,:) ! CURRENT HOUR'S WATER PROFILE
        O2WATERS=ATGLMO2(IHOUR,:) ! CURRENT HOUR'S O2 PROFILE
        PHWATERS=ATGLMPH(IHOUR,:) ! CURRENT HOUR'S PH PROFILE
        XWATERS=ATGLMFOOD(IHOUR,:) ! CURRENT HOUR'S FOOD PROFILE
        MINWDEP=0
        DO 68 I=1,20
         IF((TWATERS(21-I).NE.-999).AND.(MINWDEP.EQ.0))THEN ! FIND WATER LEVEL
          MINWDEP=21-I
         ENDIF
68      CONTINUE
        PONDMAX=MAXVAL(TWATERS(1:MINWDEP))
        PONDMIN=MINVAL(TWATERS(1:MINWDEP))
        PO2MAX=MAXVAL(O2WATERS(1:MINWDEP))
        PO2MIN=MINVAL(O2WATERS(1:MINWDEP))
        PHMAX=MAXVAL(PHWATERS(1:MINWDEP))
        PHMIN=MINVAL(PHWATERS(1:MINWDEP))
        FOODMAX=MAXVAL(XWATERS(1:MINWDEP))
        FOODMIN=MINVAL(XWATERS(1:MINWDEP))
        IF((PONDMAX.LT.CTMAX).AND.(PONDMIN.GT.CTMIN))THEN
         IF((PONDMAX.LT.TMAXPR).AND.(PONDMIN.GT.TMINPR))THEN
          DO 69 I=1,MINWDEP
           TWATER=TWATERS(MINWDEP+1-I)
           PO2WATER=O2WATERS(MINWDEP+1-I)
           IF((PONDMAX.LE.TMAXPR).AND.(PONDMIN.GE.TMINPR).AND.
     &      (PO2WATER.GT.PO2THRESH))THEN
            POND_DEPTH=MINWDEP+1-I
            PO2WATER=O2WATERS(I)
            SALWATER=SALWATERS(I)
            GOTO 71
           ENDIF
69        CONTINUE
         ELSE
         IF(PONDMAX.GT.TMAXPR)THEN
          TWATER=PONDMIN
         ELSE
          TWATER=PONDMAX
         ENDIF
         DO 73 I=1,20
          IF(TWATERS(I).EQ.TWATER)THEN
           POND_DEPTH=21-I
           PO2WATER=O2WATERS(I)
           SALWATER=SALWATERS(I)
          ENDIF
73       CONTINUE
         ENDIF
        ELSE
         IF(PONDMAX.GT.TMAXPR)THEN
          TWATER=PONDMIN
         ELSE
          TWATER=PONDMAX
         ENDIF
         DO 70 I=1,20
          IF(TWATERS(I).EQ.TWATER)THEN
           POND_DEPTH = 21-I
           PO2WATER = O2WATERS(I)
           SALWATER = SALWATERS(I)
          ENDIF
70       CONTINUE
        ENDIF
71      WETLANDDEPTHS(HOURCOUNT)=POND_DEPTH
        !POND_DEPTH=WETLANDDEPTHS(HOURCOUNT)
        !TWATER=WETLANDTEMPS(HOURCOUNT)
        !PONDMAX=WETLANDTEMPS(HOURCOUNT-IHOUR+1)
        !PONDMIN=WETLANDTEMPS(HOURCOUNT-IHOUR+1)
       ELSE
        POND_DEPTH=POND_ENV(IYEAR,COUNTDAY,IHOUR,2)
        TWATER=POND_ENV(IYEAR,COUNTDAY,IHOUR,1)
        PONDMAX=POND_ENV(IYEAR,COUNTDAY,1,1)
        PONDMIN=POND_ENV(IYEAR,COUNTDAY,1,1)
       ENDIF
C      AQUATIC ANIMAL, POND MODEL HAS RUN SO NOW DO ANIMAL - FIRST CHECK FOR WATER IN THE POND (GREATER THAN 10% OF MAX DEPTH)
       IF(POND_DEPTH.GT.0)THEN
        BURROW='N'
        IF(ECTOINPUT(51).EQ.1)THEN
         DAYACT='Y'
        ELSE
         DAYACT='N'
        ENDIF
        IF(ECTOINPUT1(52).EQ.1)THEN
         NOCTURN='Y'
        ELSE
         NOCTURN='N'
        ENDIF
        IF(ECTOINPUT1(53).EQ.1)THEN
         CREPUS='Y'
        ELSE
         CREPUS='N'
        ENDIF
        IF(ECTOINPUT1(54).EQ.1)THEN
         RAINACT='Y'
        ELSE
         RAINACT='N'
        ENDIF
C    NEXT GET DAILY MAX/MIN OF POND TO CHECK THAT IT IS SUITABLE FOR THE ANIMAL
        IF(WETMOD.EQ.1)THEN
         DO 5058 I=(HOURCOUNT-IHOUR+1),(HOURCOUNT-IHOUR+24)
          IF(WETLANDTEMPS(I).GT.PONDMAX)THEN
           PONDMAX=WETLANDTEMPS(I)
          ENDIF
          IF(WETLANDTEMPS(I).LT.PONDMIN)THEN
           PONDMIN=WETLANDTEMPS(I)
          ENDIF
5058     CONTINUE
        ELSE
         DO 5057 I=1,24
          IF(POND_ENV(IYEAR,COUNTDAY,I,1).GT.PONDMAX)THEN
           PONDMAX=POND_ENV(IYEAR,COUNTDAY,I,1)
          ENDIF
          IF(POND_ENV(IYEAR,COUNTDAY,I,1).LT.PONDMIN)THEN
           PONDMIN=POND_ENV(IYEAR,COUNTDAY,I,1)
          ENDIF
5057     CONTINUE
        ENDIF
C       CHECK IF POND TOO HOT - IF IT IS, LEAVE POND
        IF(PONDMAX.GT.TMAXPR)THEN
         FLTYPE=0
         FEEDING=0
         INWATER=0
         BURROW='Y'
         DAYACT='N'
         NOCTURN='N'
         CREPUS='N'
         RAINACT='N'
        ENDIF
C       IF POND ISN'T TOO HOT, CHECK IF WATER TEMP IS RIGHT FOR FEEDING
        IF((TWATER.GT.TMINPR).AND.(TWATER.LT.TMAXPR))THEN
C        IF RIGHT CONDITIONS AND GUT IS NOT YET FULL, THEN ACTIVE AND FEEDING IN WATER, ELSE BASK
         IF(GUTFULL.LT.GUTFILL)THEN
          DEPSEL(IHOUR)=0
          INWATER=1
          FORAGE=1
          IF(AQUABASK.LT.2)THEN
           FLTYPE=1
           TC=TWATER
          ELSE
           FLTYPE=0
          ENDIF
          IF ((DAYACT .EQ. 'Y') .OR. (DAYACT .EQ. 'Y')) THEN
C          DIURNAL  CHECK FOR SUNLIGHT
           IF (QSOLR .EQ. 0.0000) THEN
            IF ((NOCTURN .EQ. 'Y') .OR. (NOCTURN .EQ. 'Y'))THEN
             IF ((RAINACT .EQ. 'Y') .OR. (RAINACT .EQ. 'Y'))THEN
              IF(RAINFALL.GT.RAINTHRESH)THEN
               FEEDING=1
               GOTO 5021
              ELSE
               FEEDING=0
               GOTO 5021
              ENDIF
             ELSE
              FEEDING=1
              GOTO 5021
             ENDIF
            ELSE
             FEEDING=0
             GOTO 5021
            ENDIF
           ELSE
C          SUNLIGHT, MAYBE GO TOPSIDE; DIURNAL, CREPUSCULAR?
C          IF CREPUSCULAR, CHECK FOR DIRECT SUN; STAY UP IF Z(IHOUR) = 90.0
            IF (Z(IHOUR).EQ.90.0) THEN
             IF ((CREPUS.EQ.'Y').OR.(CREPUS.EQ.'Y'))THEN
              IF ((RAINACT.EQ.'Y').OR.(RAINACT.EQ.'Y'))THEN
               IF(RAINFALL.GT.RAINTHRESH)THEN
                FEEDING=1
                GOTO 5021
               ELSE
                FEEDING=0
                GOTO 5021
               ENDIF
              ELSE
               FEEDING=1
               GOTO 5021
              ENDIF
             ELSE
C             NO CREPUSCULAR
              FEEDING=0
              GOTO 5021
             ENDIF
            ELSE
C            SUN ABOVE HORIZON AND DIURNAL
             IF((RAINACT.EQ.'Y').OR.(RAINACT.EQ.'Y'))THEN
              IF(RAINFALL.GT.RAINTHRESH)THEN
               FEEDING=1
               GOTO 5021
              ELSE
               FEEDING=0
               GOTO 5021
              ENDIF
             ELSE
              FEEDING=1
              GOTO 5021
             ENDIF
            ENDIF
C           END ZENITH ANGLE CHECK
           ENDIF
C          END SOLAR CHECK
          ENDIF
C         END DIURNAL CHECK
          IF((NOCTURN.EQ.'Y').OR.(NOCTURN.EQ.'Y'))THEN
C          NOCTURNAL ?; UP WHEN NO SUNLIGHT?; CREPUSCULAR?; DIURNAL
C          CHECK FOR NO SUNLIGHT
           IF (QSOLRF.EQ.0.0000) THEN
C           NIGHTTIME: ACTIVITY OK
            IF ((RAINACT.EQ.'Y').OR.(RAINACT.EQ.'Y'))THEN
             IF(RAINFALL.GT.RAINTHRESH)THEN
              FEEDING=1
              GOTO 5021
             ELSE
              FEEDING=0
              GOTO 5021
             ENDIF
            ELSE
             FEEDING=1
             GOTO 5021
            ENDIF
            GOTO 253
           ENDIF
C          LIGHT, IS SUN OVER HORIZON? CREPUSCULAR?
           IF ((CREPUS .EQ. 'Y').OR.(CREPUS .EQ. 'Y'))THEN
            IF (Z(IHOUR).EQ. 90.0) THEN
C           CREPUSCULAR ENVIRONMENT OK
             IF ((RAINACT .EQ. 'Y') .OR. (RAINACT .EQ.
     & 'Y'))THEN
              IF(RAINFALL.GT.RAINTHRESH)THEN
               FEEDING=1
               GOTO 5021
              ELSE
               FEEDING=0
               GOTO 5021
              ENDIF
             ELSE
              FEEDING=1
              GOTO 5021
             ENDIF
             GOTO 253
            ENDIF
C           NOT CREPUSCULAR, GO TO BURROW ENVIRONMENT, IF BURROW OK
            FEEDING=0
            GOTO 5021
           ENDIF
C          NOT CREPUSCULAR, GO TO BURROW ENVIRONMENT, IF BURROW OK
           FEEDING=0
           GOTO 5021
          ENDIF
C         END OF CHOICES FOR NOCTURNAL ANIMAL
5021      CONTINUE
C         COMMENT THIS GOTO OUT TO MAKE IT ALWAYS BASK
          IF(AQUABASK.LT.2)THEN ! SKIP OVER THIS GOTO IF ALWAYS BASKING
           TC=TWATER
           GOTO 252
          ELSE
           FLTYPE=0
          ENDIF
         ELSE
          FEEDING=0
          IF(AQUABASK.LT.2)THEN ! SKIP OVER THIS GOTO IF ALWAYS BASKING
           TC=TWATER
           GOTO 252
          ELSE
           DEPSEL(IHOUR)=0
           FLTYPE=0
          ENDIF
          CONTINUE
         ENDIF
        ELSE
C        IF WATER TEMP IS NOT RIGHT FOR FEEDING
         IF(AQUABASK.EQ.0)THEN
          FEEDING=0
          DEPSEL(IHOUR)=0
          FLTYPE=1
          TC=TWATER
          INWATER=1
          FORAGE=0
          GOTO 252
         ELSE
C         IF WATER TEMP IS NOT RIGHT FOR FEEDING, TRY BASKING
          DEPSEL(IHOUR)=0
          FLTYPE=0
          INWATER=1
          FEEDING=0
          FORAGE=0
         ENDIF
         CONTINUE
        ENDIF
       ELSE ! POND EMPTY
        FLTYPE=0
        FEEDING=0
        INWATER=0
        BURROW='Y'
        DAYACT='N'
        NOCTURN='N'
        CREPUS='N'
        RAINACT='N'
        CONTINUE
       ENDIF
      ENDIF

      MINWATERLOW=MINWATER*0.5
      IF(DEHYDRATED.EQ.1)THEN
       MINWATER2=MINWATERLOW
      ELSE
       MINWATER2=MINWATER
      ENDIF

C     SETTING AESTIVATION STATE AND SHADE LEVEL OF BELOWGROUND ENVIRONMENT IF AESTIVATING/EGG DEVELOPING
      IF((DEB1.EQ.1).AND.(POND.EQ.0))THEN
       IF((PCTDESI.GT.MINWATER2).AND.(MINWATER.GT.0))THEN
C       TOO DEHYDRATED FOR ACTIVITY
        DEHYDRATED=1
        IF(AESTIVATE.EQ.1)THEN
         AEST=1
        ENDIF
        IF ((BURROW .EQ. 'Y') .OR. (BURROW .EQ. 'Y')) THEN
         MINNODE=AESTNODE
         IF(SHDBURROW.EQ.2)THEN
          BURROWSHADE = 1
          IF((DEB1.EQ.1).AND.(STAGE.EQ.0))THEN
           BURROWSHADE=0
           SHADE=REFSHD
          ENDIF
         ELSE
          IF(((TSOIL(MINNODE).GT.TMAXPR).OR.(TSOIL(MINNODE).LT.CTMIN)).
     &     AND.(SHDBURROW.EQ.1))THEN
           BURROWSHADE=1
           IF((DEB1.EQ.1).AND.(STAGE.EQ.0).AND.(VIVIPAROUS.EQ.0))THEN
           IF(EGGSHADE.EQ.0)THEN
            BURROWSHADE=0
            SHADE=REFSHD
           ELSE
            BURROWSHADE=1
           ENDIF
          ENDIF
         ELSE
          BURROWSHADE=0
         ENDIF
        ENDIF
        IF((DEB1.EQ.1).AND.(STAGE.EQ.0).AND.(VIVIPAROUS.EQ.0))THEN
         IF(EGGSHADE.EQ.0)THEN
          BURROWSHADE=0
          SHADE=REFSHD
         ELSE
          BURROWSHADE=1
         ENDIF
        ENDIF
        IF(BURROWSHADE.EQ.1)THEN
         SHADE=MAXSHD
         CALL SELDEP(TSHSOI,HSHSOI,ZSOIL,RELHUM)
        ELSE
         SHADE=REFSHD
         CALL SELDEP(TSOIL,HSOIL,ZSOIL,RELHUM)
        ENDIF
        DEPSEL(IHOUR) = NEWDEP * (-1.0)
        GOTO 253
       ENDIF
      ELSE
       DEHYDRATED=0
       AEST=0
      ENDIF

C     SETTING SATIATION-RELATED BEHAVIOUR - FORAGE IF STOMACH NOT SUFFICIENTLY FULL, OR RETREAT/BASK
      IF(GUTFULL.LT.GUTFILL)THEN
       FORAGE=1
      ENDIF
      IF((GUTFULL.GE.GUTFILL).AND.(AQUATIC.EQ.0))THEN
C      GUT CLOSE TO FULL - STAY HOME
       IF ((BURROW .EQ. 'Y') .OR. (BURROW .EQ. 'Y')) THEN
        TC_OLD=TC
        IF(BURROWSHADE.EQ.1)THEN
         SHADE=MAXSHD
         CALL SELDEP(TSHSOI,HSHSOI,ZSOIL,RELHUM)
        ELSE
         SHADE=REFSHD
         CALL SELDEP(TSOIL,HSOIL,ZSOIL,RELHUM)
        ENDIF
        DEPSEL(IHOUR)=NEWDEP*(-1.0)
C       CHECK IF TOO COLD IN RETREAT SO THE ANIMAL NEEDS TO BASK
        IF((((WARMSIG.EQ.0D0).OR.(CURNOD.LE.2))
     &    .AND.
     &    (TC.GE.TDIGPR)
     &    .AND.
     &    (TC.GE.TEMERGE))
     &   .OR.
     &    ((WARMSIG.NE.0)
     &     .AND.
     &     (TC.GE.TDIGPR)
     &     .AND.
     &     (TC.GE.TEMERGE)
     &     .AND.
     &     (((WARMSIG.GT.0D0).AND.((CURSOIL-PREVSOIL).LT.WARMSIG)) ! NO SIGNAL
     &     .OR.
     &     ((WARMSIG.LT.0D0).AND.((CURSOIL-PREVSOIL).GT.WARMSIG))) ! NO SIGNAL
     &    ))
     &   THEN
          GOTO 253
         ELSE
          TC=TC_OLD
          SHADE=REFSHD
          CALL ABOVEGROUND
          CALL RADIN
          DEPSEL(IHOUR)=0.
          NEWDEP=0.
          DEPTH=0.
         ENDIF
        ENDIF
       ENDIF
      ENDIF

      IF ((DAYACT.EQ.'Y').OR.(DAYACT.EQ.'Y')) THEN
C      DIURNAL  CHECK FOR SUNLIGHT
       IF(QSOLR.EQ.0.0000) THEN
        IF((NOCTURN.EQ.'Y').OR.(NOCTURN.EQ.'Y'))THEN
         IF((RAINACT.EQ.'Y').OR.(RAINACT.EQ.'Y'))THEN
          IF(RAINFALL.GT.RAINTHRESH)THEN
           CALL ABOVEGROUND
           GOTO 253
          ELSE
C         NOT RIGHT RAINFALL, CAN'T BE ACTIVE
           IF ((BURROW.EQ.'Y').OR.(BURROW.EQ.'Y'))THEN
C          PUT ANIMAL IN BURROW, IT'S NIGHTTIME
            IF(BURROWSHADE.EQ.1)THEN
             SHADE=MAXSHD
             CALL SELDEP(TSHSOI,HSHSOI,ZSOIL,RELHUM)
            ELSE
             SHADE=REFSHD
             CALL SELDEP(TSOIL,HSOIL,ZSOIL,RELHUM)
            ENDIF
            DEPSEL(IHOUR)=NEWDEP*(-1.0)
           ELSE
C           NO BURROW ALLOWED
            CALL ABOVEGROUND
           ENDIF
           GOTO 253
          ENDIF
         ELSE
          CALL ABOVEGROUND
         ENDIF
         GOTO 253
        ELSE
         IF((BURROW.EQ.'Y').OR.(BURROW.EQ.'Y'))THEN
C         PUT ANIMAL IN BURROW, IT'S NIGHTTIME
          CALL SELDEP(TSOIL,HSOIL,ZSOIL,RELHUM)
          IF(BURROWSHADE.EQ.1)THEN
           SHADE=MAXSHD
           CALL SELDEP(TSHSOI,HSHSOI,ZSOIL,RELHUM)
          ELSE
           SHADE=REFSHD
           CALL SELDEP(TSOIL,HSOIL,ZSOIL,RELHUM)
          ENDIF
          DEPSEL(IHOUR)=NEWDEP*(-1.0)
         ELSE
C         NO BURROW ALLOWED
          CALL ABOVEGROUND
         ENDIF
         GOTO 253
        ENDIF
       ELSE
C      SUNLIGHT, MAYBE GO TOPSIDE; DIURNAL, CREPUSCULAR?
C      IF CREPUSCULAR, CHECK FOR DIRECT SUN; STAY UP IF Z(IHOUR) = 90.0
        IF(Z(IHOUR).EQ. 90.0) THEN
         IF((CREPUS.EQ.'Y').OR.(CREPUS.EQ.'Y'))THEN
          IF((RAINACT.EQ.'Y').OR.(RAINACT.EQ.'Y'))THEN
           IF(RAINFALL.GT.RAINTHRESH)THEN
            CALL ABOVEGROUND
            GOTO 253
           ELSE
            IF ((BURROW.EQ.'Y').OR.(BURROW.EQ.'Y'))THEN
C            PUT ANIMAL IN BURROW, IT'S NIGHTTIME
             IF(BURROWSHADE.EQ.1)THEN
              SHADE=MAXSHD
              CALL SELDEP(TSHSOI,HSHSOI,ZSOIL,RELHUM)
             ELSE
              SHADE=REFSHD
              CALL SELDEP(TSOIL,HSOIL,ZSOIL,RELHUM)
             ENDIF
             DEPSEL(IHOUR)=NEWDEP*(-1.0)
            ELSE
C            NO BURROW ALLOWED
             CALL ABOVEGROUND
            ENDIF
            GOTO 253
           ENDIF
          ELSE
           CALL ABOVEGROUND
          ENDIF
          GOTO 253
         ELSE
C         NO CREPUSCULAR
          IF((BURROW.EQ.'Y').OR.(BURROW.EQ.'Y'))THEN
           IF(BURROWSHADE.EQ.1)THEN
            SHADE=MAXSHD
            CALL SELDEP(TSHSOI,HSHSOI,ZSOIL,RELHUM)
           ELSE
            SHADE=REFSHD
            CALL SELDEP(TSOIL,HSOIL,ZSOIL,RELHUM)
           ENDIF
           DEPSEL(IHOUR)=NEWDEP*(-1.0)
          ELSE
C          NO BURROW ALLOWED
           CALL ABOVEGROUND
          ENDIF
          GOTO 253
         ENDIF
        ELSE
C        SUN ABOVE HORIZON AND DIURNAL
         IF((RAINACT.EQ.'Y').OR.(RAINACT.EQ.'Y'))THEN
          IF(RAINFALL.GT.RAINTHRESH)THEN
           CALL ABOVEGROUND
           GOTO 253
          ELSE
           IF((BURROW.EQ.'Y').OR.(BURROW.EQ.'Y'))THEN
C           PUT ANIMAL IN BURROW, IT'S NIGHTTIME
            IF(BURROWSHADE.EQ.1)THEN
             SHADE=MAXSHD
             CALL SELDEP(TSHSOI,HSHSOI,ZSOIL,RELHUM)
            ELSE
             SHADE=REFSHD
             CALL SELDEP(TSOIL,HSOIL,ZSOIL,RELHUM)
            ENDIF
            DEPSEL(IHOUR)=NEWDEP*(-1.0)
           ELSE
C           NO BURROW ALLOWED
            CALL ABOVEGROUND
           ENDIF
           GOTO 253
          ENDIF
         ELSE
          CALL ABOVEGROUND
         ENDIF
         GOTO 253
        ENDIF
C       END ZENITH ANGLE CHECK
       ENDIF
C      END SOLAR CHECK
      ENDIF
C     END DIURNAL CHECK

      IF((NOCTURN.EQ.'Y').OR.(NOCTURN.EQ.'Y'))THEN
C      NOCTURNAL ?; UP WHEN NO SUNLIGHT?; CREPUSCULAR?; DIURNAL
C      CHECK FOR NO SUNLIGHT
       IF(QSOLRF.EQ.0.0000) THEN
C       NIGHTTIME: ACTIVITY OK
        IF((RAINACT.EQ.'Y').OR.(RAINACT.EQ.'Y'))THEN
         IF(RAINFALL.GT.RAINTHRESH)THEN
          CALL ABOVEGROUND
          GOTO 253
         ELSE
          IF((BURROW.EQ.'Y').OR.(BURROW.EQ.'Y'))THEN
C          PUT ANIMAL IN BURROW, IT'S NIGHTTIME
           IF(BURROWSHADE.EQ.1)THEN
            SHADE=MAXSHD
            CALL SELDEP(TSHSOI,HSHSOI,ZSOIL,RELHUM)
           ELSE
            SHADE=REFSHD
            CALL SELDEP(TSOIL,HSOIL,ZSOIL,RELHUM)
           ENDIF
           DEPSEL(IHOUR)=NEWDEP*(-1.0)
          ELSE
C          NO BURROW ALLOWED
           CALL ABOVEGROUND
          ENDIF
         ENDIF
        ELSE
         CALL ABOVEGROUND
        ENDIF
        GOTO 253
       ENDIF
C      LIGHT, IS SUN OVER HORIZON? CREPUSCULAR?
       IF((CREPUS.EQ.'Y').OR.(CREPUS.EQ.'Y'))THEN
        IF(Z(IHOUR).EQ.90.0) THEN
C        CREPUSCULAR ENVIRONMENT OK
         IF((RAINACT.EQ.'Y').OR.(RAINACT.EQ.'Y'))THEN
          IF(RAINFALL.GT.RAINTHRESH)THEN
           CALL ABOVEGROUND
           GOTO 253
          ELSE
           IF((BURROW.EQ. 'Y') .OR. (BURROW .EQ. 'Y'))THEN
C           PUT ANIMAL IN BURROW, IT'S NIGHTTIME
            IF(BURROWSHADE.EQ.1)THEN
             SHADE=MAXSHD
             CALL SELDEP(TSHSOI,HSHSOI,ZSOIL,RELHUM)
            ELSE
             SHADE=REFSHD
             CALL SELDEP(TSOIL,HSOIL,ZSOIL,RELHUM)
            ENDIF
            DEPSEL(IHOUR)=NEWDEP*(-1.0)
           ELSE
C           NO BURROW ALLOWED
            CALL ABOVEGROUND
           ENDIF
           GOTO 253
          ENDIF
         ELSE
          CALL ABOVEGROUND
         ENDIF
         GOTO 253
        ENDIF
C       NOT CREPUSCULAR, GO TO BURROW ENVIRONMENT, IF BURROW OK
        IF((BURROW.EQ.'Y').OR.(BURROW.EQ.'Y'))THEN
         IF(BURROWSHADE.EQ.1)THEN
          SHADE=MAXSHD
          CALL SELDEP(TSHSOI,HSHSOI,ZSOIL,RELHUM)
         ELSE
          SHADE=REFSHD
          CALL SELDEP(TSOIL,HSOIL,ZSOIL,RELHUM)
         ENDIF
         DEPSEL(IHOUR)=NEWDEP*(-1.0)
        ELSE
C        NO BURROW ALLOWED.  YOU ARE 'OUT THERE'
         CALL ABOVEGROUND
        ENDIF
        GOTO 253
       ENDIF
C      NOT CREPUSCULAR, GO TO BURROW ENVIRONMENT, IF BURROW OK
       IF((BURROW .EQ.'Y').OR.(BURROW.EQ.'Y'))THEN
        IF(BURROWSHADE.EQ.1)THEN
         SHADE=MAXSHD
         CALL SELDEP(TSHSOI,HSHSOI,ZSOIL,RELHUM)
        ELSE
         SHADE=REFSHD
         CALL SELDEP(TSOIL,HSOIL,ZSOIL,RELHUM)
        ENDIF
        DEPSEL(IHOUR)=NEWDEP*(-1.0)
       ELSE
C       NO BURROW ALLOWED.  YOU ARE 'OUT THERE'
        CALL ABOVEGROUND
       ENDIF
       GOTO 253
      ENDIF
C     END OF CHOICES FOR NOCTURNAL ANIMAL

      IF(((NOCTURN.EQ.'N').OR.(NOCTURN.EQ.'N')).AND.((DAYACT.EQ.'N')
     & .OR.(DAYACT.EQ.'N')).AND.((CREPUS.EQ.'N').OR.
     & (CREPUS.EQ.'N')))THEN
       IF((BURROW.EQ.'Y').OR.(BURROW.EQ.'Y'))THEN
        IF(BURROWSHADE.EQ.1)THEN
         SHADE=MAXSHD
         CALL SELDEP(TSHSOI,HSHSOI,ZSOIL,RELHUM)
        ELSE
         SHADE=REFSHD
         CALL SELDEP(TSOIL,HSOIL,ZSOIL,RELHUM)
        ENDIF
        DEPSEL(IHOUR)=NEWDEP*(-1.0)
       ELSE
C       NO BURROW ALLOWED.  YOU ARE 'OUT THERE'
        CALL ABOVEGROUND
       ENDIF
       GOTO 253
      ENDIF
253   CONTINUE
C     ******END CHECK OF INITIAL LOCATION********

C     INCREMENTING TIME WITHIN THE DAY LOOP
      T=TIME(IHOUR)
      IHOUR=INT((T/60.)+1)

      IF(TRANST.EQ.'Y')THEN      
       ENARY1=QSOL
       ENARY2=Z
       ENARY3=TALOC
       ENARY4=VLOC
       ENARY5=RH
       ENARY6=TSKYC
       ENARY7=ATSOIL(:,1)
       ENARY8=0.0 ! FULL SUN
       
       SHADE=0.
       QSOLR=ENARY1(IHOUR)
       TA=ENARY3(IHOUR)
       TSUBST=ENARY7(IHOUR)
       TSKY=ENARY6(IHOUR)
       RELHUM=ENARY6(IHOUR)
      
C################################################################
C      SETTING UP CALL TO DOPRI INTEGRATOR

C ---  DIMENSION OF THE SYSTEM
       N=NDGL
C ---  OUTPUT ROUTINE (AND DENSE OUTPUT) IS USED DURING INTEGRATION
       IOUT=0
C ---  INITIAL VALUES AND ENDPOINT OF INTEGRATION
       RPAR(1)=DBLE(AMASS)
       RPAR(2)=DBLE(R1)
       RPAR(3)=DBLE(VOL)
       IF((CONTH.GT.0).AND.(CONTDEP.GT.0.01).AND.(RAINFALL.GT.0))THEN
        TC=(TC*CONTDEP+TALOC(IHOUR)*RAINFALL)/(RAINFALL+CONTDEP) ! WEIGHTED MEAN OF RAIN TEMP AND CONT TEMP
       ENDIF
       IF(IHOUR.EQ.1)THEN
        X=0.
        XEND=0.
       ELSE
        X=T-60.0D+00
        XEND=T
       ENDIF       
       YY(1)=X
       YY(2)=TC
       IF(RAINHOUR.EQ.1)THEN
        CONTDEP=MIN(CONTDEP+RAINFALL,CONTH)
       ENDIF
       IF(((RAINFALL.GT.0.).AND.(CONTH.GT.0.)).OR.(CONTDEP.GT.0))THEN
        SKINW=CONTWET
        CALL GEOM
       ENDIF
C ---  REQUIRED (RELATIVE AND ABSOLUTE) TOLERANCE
       ITOL=0
       RTOL(1)=1.0D-3
       ATOL(1)=RTOL(1)
C ---  DEFAULT VALUES FOR PARAMETERS
       DO 13 I=1,20
        IWORK(I)=0
        WORK(I)=0.D0
  13   CONTINUE
       !LWORK=8*NDGL+5*NRDENS+21,LIWORK=NRDENS+21
C ---  DENSE OUTPUT IS USED FOR THE TWO POSITION COORDINATES 1 AND 2
       IWORK(5)=NRDENS
       IWORK(21)=1
       IWORK(22)=2
       IWORK(23)=3
       IWORK(24)=4
       IWORK(25)=5
C ---  CALL OF THE SUBROUTINE DOPRI5 

       IF(RAINFALL.GT.0)THEN
        RAINFALL=RAINFALL+0.
       ENDIF
       CALL DOPRI5(N,ONELUMP,X,YY,XEND,RTOL,ATOL,ITOL,SOLOUT,IOUT,
     &   WORK,LWORK,IWORK,LIWORK,RPAR,IPAR,IDID,VSTI)
       TC=YY(2)
       TRANSIENT(IHOUR)=TC
       IF(CONTDEP.LE.0.01)THEN
        TRANSIENT(IHOUR)=ATSOIL(IHOUR,1)
       ENDIF
       ZD2(IHOUR)=QMETAB
       ZD3(IHOUR)=WEVAP
       ZD4(IHOUR)=CONTDEP
       IF((AQUATIC.EQ.1).AND.(POND.EQ.1))THEN
         POND_ENV(IYEAR,COUNTDAY,IHOUR,1)=TRANSIENT(IHOUR)
         IF(CONTDEP.LE.0.01)THEN
          POND_ENV(IYEAR,COUNTDAY,IHOUR,2)=0.
         ELSE
          POND_ENV(IYEAR,COUNTDAY,IHOUR,2)=CONTDEP
         ENDIF
       ENDIF
      ENDIF
C################################################################

      IF((TRANST.EQ.'Y').OR.(TRANST.EQ.'Y'))THEN
       GOTO 252
      ENDIF

C     INFRARED CALCULATIONS?
C     CHECKING TO SEE IF WATER ENVIRONMENT
      IF (FLTYPE.EQ.0.0) THEN
C      AIR ENVIRONMENT (TEMPERATURES IN C)
C      TSKY = TSKYC(IHOUR) OR = SOIL TEMPERATURE SET IN SELDEP
       TR=(TSUBST+TSKY)/2.
       CALL RADIN
      ELSE
C      WATER ENVIRONMENT
       FATOBJ=0.00
       FATOSK=0.00
       FATOSB=0.00
       QIRIN=0.00
      ENDIF

      ENBERR=ENBERR2*AMASS
C     USER CONTROL OF ERROR TOLERANCE NOW OVERRIDES LOCAL CONTROL
      TESTX=ENBERR
      REFTOL=TESTX

      FLYTEST=0
      FLIGHT=0
      FLYTIME=0.
      CLIMBING=0

225   CONTINUE

C     COMPUTE WING TEMPERATURE IF WINGMODEL RUNNING
      IF(DEPSEL(IHOUR).GE.0)THEN
       IF(WINGMOD.EQ.2)THEN
        WINGCALC=1
C       SETTING UP FOR FINDING BRACKETING VALUES OF X, TCORE, BETWEN WHICH Y=0
        IF(NTRY.EQ.1)THEN
         X1=0.
         X2=50.
        ELSE
         X1=TC-5.
         X2=TC+5.
        ENDIF
C       GUESSING FOR CORE TEMPERATURE
        X=TA
        CALL ZBRAC(FUNWING,X1,X2,SUCCES)
C       INVOKING THE ENERGY BALANCE EQUATION VIA ZBRENT AND FUN
C       USER CONTROL OF ERROR TOLERANCE NOW OVERRIDES LOCAL CONTROL
        TESTX=ENBERR
        REFTOL=TESTX
        X=ZBRENT(FUNWING,X1,X2,TESTX)
C       OUT COMES THE GUESSED VARIABLE VALUE (X) THAT SATISFIES
C       THE ENERGY BALANCE EQUATION
C       DEPENDENT VARIABLE GUESSED FOR EITHER CORE TEMP. OR METABOLISM
C       GUESS FOR CORE TEMPERATURE
        TWING=X
        WINGCALC=0
       ENDIF
      ENDIF
C     END OF WING TEMP CALC
      WINGTEMP=TWING

      IF(IHOUR.NE.HRCALL2)THEN ! not trying to change AEFF to reduce heat loss a little 
       CALL GEOM
      ENDIF
      
C     CALL RADIN AGAIN NOW IN CASE WING MODEL WAS RUN
      IF(FLTYPE.EQ.0.0) THEN
C      AIR ENVIRONMENT (TEMPERATURES IN C)
C      TSKY = TSKYC(IHOUR) OR = SOIL TEMPERATURE SET IN SELDEP
       TR=(TSUBST+TSKY)/2.
       CALL RADIN
      ELSE
C      WATER ENVIRONMENT
       FATOBJ=0.00
       FATOSK=0.00
       FATOSB=0.00
       QIRIN=0.00
      ENDIF

C     SETTING UP FOR FINDING BRACKETING VALUES OF X, TCORE, BETWEEN WHICH Y=0
      IF(NTRY.EQ.1)THEN
       X1=0.
       X2=50.
       IF((FOSORIAL.EQ.'Y').OR.(FOSORIAL.EQ.'Y'))THEN
C       THERMOREGULATE IN BURROW OR NOT?  IS IT TOO COLD TO DO THAT?
        IF(TSHSOI(IHOUR).LT.TBASK)THEN
         DEPSEL(IHOUR)=200.*(-1.0)
         NEWDEP=200.
         CALL BELOWGROUND
         CALL RADIN
         X1=TA-5.
         X2=TA+5.
        ENDIF
       ENDIF
      ELSE
       X1=TC-5.
       X2=TC+5.
      ENDIF
C     GUESSING FOR CORE TEMPERATURE
      IF(DEPSEL(IHOUR).LT.0.)THEN
       CALL BELOWGROUND
      ELSE
       CALL ABOVEGROUND
      ENDIF
      X=TA

!      IF(AMASS.GT.ZTHRESH)THEN
       CALL ZBRAC(FUN,X1,X2,SUCCES)
C      INVOKING THE ENERGY BALANCE EQUATION VIA ZBRENT AND FUN
C      USER CONTROL OF ERROR TOLERANCE NOW OVERRIDES LOCAL CONTROL
       TESTX=ENBERR
       REFTOL=TESTX
       X=ZBRENT(FUN,X1,X2,TESTX)
!      ENDIF

      IF(X.GT.80.)THEN
       X=TSOIL(1)
      ENDIF
C     OUT COMES THE GUESSED VARIABLE VALUE (X) THAT SATISFIES
C     THE ENERGY BALANCE EQUATION
C     DEPENDENT VARIABLE GUESSED FOR EITHER CORE TEMP. OR METABOLISM
C     GUESS FOR CORE TEMPERATURE
      TC = X
      Y(NEQ)=X
C     INITIAL STORAGE FOR THIS HOUR'S CORE TEMPERATURE

      IF(LIVE.EQ.0)THEN
        ERRTES=ABS(ENB)
        GO TO 252
      ENDIF

C     REVERT TO ACTIVITY POSTURE FOR NEXT ITERATION IF >= TMINPR
      IF((TC.GE.TMINPR).AND.(POSTUR.EQ.1))THEN        
       ASIL=(ASILN+ASILP)/2.
       PTCOND=PTCOND_ORIG
      ENDIF

      IF((AQUATIC.EQ.1).AND.(POND.EQ.0).AND.(AQUABREED.EQ.4))THEN
       IF(POND_DEPTH.GT.0.)THEN
        IF(TWATER.GT.TC)THEN
         TC=TWATER
         INWATER=1
         GOTO 252
        ENDIF
       ENDIF
      ENDIF

      IF(DEPSEL(IHOUR).LT.0)THEN
C      HAS DECIDED TO BURROW, SO DON'T BOTHER THERMOREGULATING IF WITHIN CTMIN AND VTMAX TO SAVE CPU TIME
       IF(DEPSEL(IHOUR).EQ.(-1*ZSOIL(NON)))THEN
C       NO THERMOREGULATION NEEDED BECAUSE NOWHERE TO GO!
        ERRTES=ABS(ENB)
        IF((ERRTES.LE.TESTX).OR.(QUIT.GT.0.0))THEN
C        A SOLUTION! OR A BUST: GET OUT AND GO TO NEXT HOUR
         GO TO 252
        ENDIF
       ENDIF
       IF((TC.GE.CTMIN).AND.(TC.LE.(CTMAX-(CTMAX-TMAXPR)/2)))THEN
C       NO THERMOREGULATION NEEDED, JUST ADJUST GAINS OR LOSSES A BIT
        ERRTES=ABS(ENB)
        GO TO 252
       ENDIF
      ENDIF

C     FOR FLYING INSECT, CHECK IF FLIGHT IS POSSIBLE AND WORK OUT FLIGHT DISTANCE
      IF(((POND.EQ.0).AND.(FLYER.EQ.1).AND.(DEB1.EQ.0)).OR.
     &    ((POND.EQ.0).AND.(FLYER.EQ.1).AND
     &    .(DEB1.EQ.1).AND.(STAGE.GT.STAGES-2)))THEN
       IF(FLYTEST.EQ.1)THEN
        IF((TC.GE.TMINPR).AND.(TC.LE. TMAXPR).AND.(Z(IHOUR).LT.90))THEN
         FLIGHT=1
C        FIRST FORMULA IS FEMALES, SECOND IS MALES, SPECIFIC TO HETERONYMPHA MEROPE
         FLYTIME=-0.0264*TC**2+1.4118*TC-4.456
         FLYTIME=-0.04195*TC**2+2.028902*TC-5.85991
         IF(FLYTIME.LT.0.)THEN
          FLYTIME=0.
         ENDIF
         GO TO 252
        ELSE
         FLYTEST=2
         FLYTIME=0.
         FLIGHT=0
         PHI=PHIMIN
         CALL ABOVEGROUND
         GOTO 225
        ENDIF
       ENDIF
      ENDIF

C     SKIP OVER CHECKS IF CORE TEMPERATURE OK & SOLUTION WITHIN TOLERANCE
      IF((TC.GE.TMINPR).AND.(TC.LE.TPREF))THEN
       IF((WINGMOD.GT.0).AND.(TC.LT.TPREF).AND.(SHADE.EQ.0.))THEN
        CALL THERMOREG(QUIT)
        IF((QUIT.EQ.1.).OR.(PHI.EQ.PHIMAX))THEN
         IF(((POND.EQ.0).AND.(FLYER.EQ.1).AND.(DEB1.EQ.0).AND.(TDIGPR.LT
     &.TPREF).AND.(Z(IHOUR).LT.90.)).OR.((POND.EQ.0).AND.(FLYER.EQ.1)
     &.AND.(DEB1.EQ.1).AND.(STAGE.GT.STAGES-2).AND.(TDIGPR.LT.TPREF)
     &.AND.(Z(IHOUR).LT.90.)))THEN
          IF(FLYTEST.EQ.0)THEN
C          HASN'T YET TRIED FLYING
           FLYTEST=1
           PHI=180.
           CALL ABOVEGROUND
           GOTO 225
          ENDIF
         ENDIF
         GO TO 252
        ENDIF
        GO TO 225
       ENDIF
       IF(((POND.EQ.0).AND.(FLYER.EQ.1).AND.(DEB1.EQ.0).AND.
     &(Z(IHOUR).LT.90)).OR.((POND.EQ.0).AND.(FLYER.EQ.1).AND.(DEB1.EQ.1)
     &.AND.(STAGE.GT.STAGES-2).AND.(Z(IHOUR).LT.90).AND.DEPSEL(IHOUR)
     &.GE.0))THEN
        IF(FLYTEST.EQ.0)THEN
C        HASN'T YET TRIED FLYING
         FLYTEST=1
         PHI=180
         CALL ABOVEGROUND
         GOTO 225
        ENDIF
       ENDIF
C      NO THERMOREGULATION NEEDED, JUST ADJUST GAINS OR LOSSES A BIT
       ERRTES=ABS(ENB)
       IF((ERRTES.LE.TESTX).OR.(QUIT.GT.0.0))THEN!.OR.(AMASS.LE.ZTHRESH))THEN
C       A SOLUTION! OR A BUST: GET OUT AND GO TO NEXT HOUR
        GO TO 252
       ELSE
C       TCORE OK, NOW NEED SMALL ENVIRONMENT ADJUSTMENTS TO GET WITHIN TOLERANCE
C       DROP DOWN TO THE TESTS BELOW
        IF(TC.GT.TMINPR)THEN
         IF(ABSAN.GT.ABSMIN)THEN
C         USE MIN VALUE
          ABSAN = ABSMIN
          GO TO 225
         ENDIF
        ENDIF
        IF(ENB.LT.0.000)THEN
C        REDUCE HEAT LOSSES BY WIND A LITTLE BY SEEKING SHELTER
C        CHANGE POSTURE ONCE/HR TO MINIMIZE HEAT LOSS - ASSUME A SPHERICAL GEOMETRY IF A FROG, A CYLINDER IF A LIZARD
         IF(IHOUR.NE.HRCALL)THEN
C         POSTURE CHANGES ARE VERY POTENT.  CONSIDER GRADING THIS TOWARD % CYLINDER INSTEAD OF ONE COMPLETELY.
C         IT PROVIDES GOOD SOLUTION ACCURACY FOR VERY LITTLE COST.
          IF(GEOMETRY.EQ.3)THEN
C          LIZARD -> CYLINDER GEOMETRY.
           GEOMETRY=1
          ENDIF
          IF(GEOMETRY.EQ.4)THEN
C          FROG -> ELLIPSE
           GEOMETRY=2
          ENDIF
          HRCALL=IHOUR
          CALL GEOM
         ELSE
C         REDUCE EFFECTIVE WET SURFACE AREA
          AEFF=MAX(0.0D0,AEFF-AEFF*0.01)
          HRCALL2=IHOUR ! using this state to prevent call to geom, which would reset AEFF
          IF(AEFF.LE.SKINW*ATOT*0.95)THEN
           AEFF=SKINW*ATOT*0.95
C          SET EXIT CODE ON NEXT ITERATION
           QUIT=1.
          ENDIF
         ENDIF
         GO TO 225
        ELSE
C        ENERGY BALANCE ERROR IS POSITIVE. INCREASE TPREF TOWARDS TMAXPR
         IF(TPREF.LE.TMAXPR)THEN
          TPREF=TPREF+1.
          IF(TPREF.GT.TMAXPR)THEN
           TPREF=TMAXPR
          ELSE
           GO TO 225
          ENDIF
         ENDIF
C        ENERGY BALANCE ERROR IS POSITIVE. REDUCE GAINS BY ADDING SHADE
         IF(SHADE.LT.MAXSHD)THEN
          CALL SHADEADJUST
          GO TO 225
         ELSE
          SHADE=MAXSHD
C         CALL THERMOREG TO DO BEHAVIORAL OR PHYSIOLOGICAL ADJUSTMENTS
          CALL THERMOREG(QUIT)
          IF(QUIT.GT.0.0)THEN
C          ALL BEHAVIORAL AND PHYSIOLOGICAL OPTIONS EXHAUSTED. QUIT WITH THE CURRENT LEVEL OF ERROR.
           GO TO 252
          ENDIF
         ENDIF
         GO TO 225
        ENDIF
       ENDIF
      ENDIF

C     NOTE THAT IF ENB IS NEGATIVE, THE LOSSES ARE GREATEST.  CUT WIND SPEED TO REDUCE LOSSES.
C     IF ENB IS POSITIVE, GAINS ARE GREATEST, REDUCE THOSE (SHADE, MORE WIND)
C     THIS SHOULD HELP TO GUIDE THE BEHAVIORAL CHOICES TO GET BETTER CONVERGENCE.
C     NEED AN ALGORITHM TO REDUCE WIND IF ACTIVE AND HIGH WIND.
      IF((TC.LT.TBASK).OR.(TC.GT.TPREF))THEN
       CALL THERMOREG(QUIT)
       IF(QUIT.EQ.1.)THEN
        GO TO 252
       ENDIF
       IF(NTRY.LT.300)THEN
C       FORCE ANOTHER ITERATIVE TRY
        NTRY=NTRY+1
        IF(IHOUR.LT.25)THEN
         NTRY1(IHOUR)=1
        ENDIF
        GO TO 225
       ELSE
C       NO CHANCE THE ENVIRONMENT IS TOO HARSH: BAIL
        NTRY=1
        GO TO 252
       ENDIF
      ENDIF

C     IF GET THIS FAR, SOLUTION ISN'T SUITABLE YET, BUT BODY TEMPERATURE
C     ABOVE MINIMUM FOR ACTIVITY AND BELOW MAX PREFERRED
      IF(ERRTES.GT.TESTX)THEN
       IF(TC.GE.TMINPR)THEN
C       IN A GOOD BODY TEMPERATURE RANGE...WHAT TO DO???
        CALL THERMOREG(QUIT)
        IF(QUIT.EQ.1.)THEN
         GO TO 252
        ENDIF
        GO TO 225
       ENDIF
      ENDIF

      IF(ERRTES.LE.ENBERR)THEN
C      A SUITABLE SOLUTION.  THE CORE TEMPERATURE MAY BE OUTSIDE DESIRED BOUNDS, BUT IF IN BURROW, QUIT.
       IF(DEPSEL(IHOUR).LT.0.00000)THEN
C       ANIMAL BELOW GROUND AND INACTIVE
        ACTHR(IHOUR)=0.0
        GO TO 252
       ENDIF
C      ANY BEHAVIORAL OPTIONS?
       IF(((BURROW.EQ.'N').OR.(BURROW.EQ.'N')).AND.
     &    ((CLIMB.EQ.'N').OR.(CLIMB.EQ.'N')).AND.
     &     ((CKGRSHAD.EQ.'N').OR.(CKGRSHAD.EQ.'N').OR.
     & (WINGMOD.EQ.0)))THEN
C       NO THERMOREGULATORY OPTIONS -> QUIT
        GO TO 252
       ENDIF
      ENDIF

      IF(TC.GE.TPREF)THEN
       IF((AQUATIC.EQ.1).AND.(POND.EQ.0).AND.(AQUABREED.EQ.4))THEN
        IF(POND_DEPTH.GT.0)THEN
         IF(TWATER.LE.TPREF)THEN
          TC=TWATER
          INWATER=1
          GOTO 252
         ENDIF
        ENDIF
       ENDIF
C      *********** SET A DIFFERENT PHYSICAL ENVIRONMENT,
C      INCLUDING DEPTH, BUT NOT ACTIVITY, WHICH IS DETERMINED BELOW
       IF(((CKGRSHAD.EQ.'N').OR.(CKGRSHAD.EQ.'N')).OR.
     &  (SHADE.EQ.MAXSHD))THEN
        IF((CLIMB.EQ.'N').OR.(CLIMB.EQ.'N'))THEN
         IF((BURROW.EQ.'N').OR.(BURROW.EQ.'N'))THEN
C         NO MORE OPTIONS, HAVE TO GO WITH CURRENT TC
          IF(NTRY.LT.300)THEN
C          FORCE ANOTHER ITERATIVE TRY
           NTRY=NTRY+1
           IF(IHOUR.LT.25)THEN
            NTRY1(IHOUR)=1
           ENDIF
           GO TO 225
          ELSE
C          NO CHANCE THE ENVIRONMENT IS TOO HARSH: BAIL
           NTRY=1
          ENDIF
         ELSE
          IF(BURROWSHADE.EQ.1)THEN
           SHADE=MAXSHD
           CALL SELDEP(TSHSOI,HSHSOI,ZSOIL,RELHUM)
          ELSE
           SHADE=REFSHD
           CALL SELDEP(TSOIL,HSOIL,ZSOIL,RELHUM)
          ENDIF
          DEPSEL(IHOUR)=NEWDEP*(-1.0)
          GO TO 252
         ENDIF
        ELSE
         IF(DEPSEL(IHOUR).NE.200.0)THEN
C         TRY CLIMBING
          IF ((TREF(IHOUR).GE.TMINPR).AND.(TREF(IHOUR).LE.TPREF))THEN
C          IT'S OK UP HIGH
C          CLIMB TO 150 CM HEIGHT
           DEPSEL(IHOUR) = 150.0
C          REFERENCE HEIGHT AIR TEMPERATURE IS THE SAME IN SUN OR SHADE.
           TA = TREF(IHOUR)
           VEL = VREF(IHOUR)
           CLIMBING=1
           GO TO 252
C          NO ASSUMPTION OF INCREASE IN SHADE DUE TO CLIMBING.  MAY STILL BE IN THE SUN.
          ENDIF
         ENDIF
        ENDIF
       ENDIF
C      DEPTH IS NEEDED SINCE THERMOREG MAY CALL SELDEP, WHICH CALLS BELOWGROUND,
C      WHICH MUST HAVE DEPTH TO ASSIGN TEMPERATURE
       DEPSEL(IHOUR)=NEWDEP*(-1.0)
       CALL THERMOREG(QUIT)
       IF(QUIT.EQ.1.)THEN
        GO TO 252
       ENDIF
C      NOW RERUN THE NUMERICAL GUESSING WITH THE NEW ENVIRONMENT
       GO TO 225
      ENDIF

      IF((TC.LT.TBASK).OR.(TC.GT.TPREF))THEN
       IF((AQUATIC.EQ.1).AND.(POND.EQ.0).AND.(AQUABREED.EQ.4).AND.
     & (TC.GT.TPREF))THEN
        IF(POND_DEPTH.GT.0)THEN
         IF(TWATER.LE.TPREF)THEN
          TC=TWATER
          INWATER=1
          GOTO 252
         ENDIF
        ENDIF
       ENDIF
C      OUTSIDE PREFERRED TEMPERATURE RANGE.
C      *********** SET A DIFFERENT PHYSICAL ENVIRONMENT,
C      INCLUDING DEPTH, BUT NOT ACTIVITY, WHICH IS DETERMINED BELOW
       IF(((CKGRSHAD.EQ.'N').OR.(CKGRSHAD.EQ.'N')).OR.
     &  (SHADE.EQ.MAXSHD))THEN
        IF((CLIMB.EQ.'N').OR.(CLIMB.EQ.'N'))THEN
         IF((BURROW.EQ.'N').OR.(BURROW.EQ.'N'))THEN
C         NO MORE OPTIONS, HAVE TO GO WITH CURRENT TC
          GO TO 252
         ELSE
C         BURROW OK, IF GONE UNDERGROUND AND ENB WITHIN TOLERANCE,
C         NO OTHER OPTIONS.  QUIT
          IF((ENB.LE.ENBERR).AND.(DEPSEL(IHOUR).LT.0.000000))THEN
           DEPSEL(IHOUR)=NEWDEP*(-1.0)
           GO TO 252
          ENDIF
          IF(BURROWSHADE.EQ.1)THEN
           SHADE=MAXSHD
           CALL SELDEP(TSHSOI,HSHSOI,ZSOIL,RELHUM)
          ELSE
           SHADE=REFSHD
           CALL SELDEP(TSOIL,HSOIL,ZSOIL,RELHUM)
          ENDIF
          DEPSEL(IHOUR)=NEWDEP*(-1.0)
          GO TO 252
         ENDIF
        ELSE
         IF(DEPSEL(IHOUR).NE.150.0)THEN
C         TRY CLIMBING
          IF ((TREF(IHOUR).GE.TMINPR).AND.(TREF(IHOUR).LE.TPREF))THEN
C          IT'S OK UP HIGH
C          CLIMB TO REFERENCE (NOTIONALLY 150 CM) HEIGHT
           DEPSEL(IHOUR)=150.0
C          REFERENCE HEIGHT AIR TEMPERATURE IS THE SAME IN SUN OR SHADE.
           TA=TREF(IHOUR)
           VEL=VREF(IHOUR)
           CLIMBING=1
           GO TO 252
C          NO ASSUMPTION OF INCREASE IN SHADE DUE TO CLIMBING.  MAY STILL BE IN THE SUN.
          ENDIF
         ENDIF
        ENDIF
       ENDIF
       CALL THERMOREG(QUIT)
       DEPSEL(IHOUR)=NEWDEP*(-1.0)
C      NOW RERUN THE NUMERICAL GUESSING WITH THE NEW ENVIRONMENT
       IF(QUIT.EQ.1.)THEN
        GO TO 252
       ENDIF
       GO TO 225
      ENDIF

      IF((WINGMOD.GT.0).AND.(TC.LT.TPREF))THEN
       CALL THERMOREG(QUIT)
       IF((QUIT.EQ. 1.).OR.(PHI.EQ.PHIMAX))THEN
        GO TO 252
       ENDIF
       GO TO 225
      ENDIF

252   CONTINUE

C     WORK OUT ACTIVITY LEVEL, I.E. WHETHER FORAGING OR BASKING
C     (DRIVEN BY DEB MODEL IF RUNNING, SO SATIATED ANIMALS MAY NOT FORAGE WHEN CONDITIONS ARE RIGHT)
      IF(((DEPSEL(IHOUR).GE. 0).AND.(DEB1.EQ.0).AND.(POND.EQ.0)).OR.
     & ((DEPSEL(IHOUR).GE.0).AND.(DEB1.EQ.1).AND.(STAGE.GT.0).AND.
     & (POND.EQ.0)))THEN
       IF((TC.GE.TBASK).AND.(TC.LE.TMAXPR))THEN
        IF(((RAINFALL.LE.RAINTHRESH).AND.((RAINACT.EQ.'N').OR.
     &(RAINACT.EQ.'N').OR.(INWATER.EQ.1))).OR.((RAINFALL.GT.RAINTHRESH
     &).AND.((RAINACT.EQ.'Y').OR.(RAINACT.EQ.'Y'))).OR.((RAINACT
     &.EQ.'N').OR.(RAINACT.EQ.'N')))THEN
         IF(DEB1.EQ.1)THEN
          IF((AQUATIC.EQ.1).AND.(AQUABREED.EQ.4))THEN
           IF((TC.GE.TMINPR).AND.(FORAGE.EQ.1).AND.(INWATER.EQ.1))THEN
            ACTHR(IHOUR)=2.0
           ELSE
            ACTHR(IHOUR)=1.0
           ENDIF
          ELSE
           IF((TC.GE.TMINPR).AND.(FORAGE.EQ.1))THEN
            ACTHR(IHOUR)=2.0
           ELSE
            ACTHR(IHOUR)=1.0
           ENDIF
          ENDIF
         ELSE
          IF((AQUATIC.EQ.1).AND.(AQUABREED.EQ.4))THEN
           IF((TC.GE.TMINPR).AND.(FORAGE.EQ.1).AND.(INWATER.EQ.1))THEN
            ACTHR(IHOUR)=2.0
           ELSE
            ACTHR(IHOUR)=1.0
           ENDIF
          ELSE
           IF(TC.GE.TMINPR)THEN
            ACTHR(IHOUR)=2.0
           ELSE
            ACTHR(IHOUR)=1.0
           ENDIF
          ENDIF
         ENDIF
         IF((DEAD.EQ.0).AND.(DEADEAD.EQ.0))THEN
          ANNUALACT=ANNUALACT+1
          ACT(IYEAR)=ACT(IYEAR)+1
          FOR(IYEAR)=FOR(IYEAR)+ACTHR(IHOUR)-1
         ENDIF
         IF((DAYACT.EQ.'N').OR.(DAYACT.EQ.'N'))THEN
          IF(Z(IHOUR).LT.90)THEN
           ACTHR(IHOUR)=0.0
          ENDIF
         ENDIF
         IF((NOCTURN.EQ.'N').OR.(NOCTURN.EQ.'N'))THEN
          IF(QSOLR.EQ.0.000)THEN
           IF(Z(IHOUR).EQ.90)THEN
            ACTHR(IHOUR)=0.0
           ENDIF
          ENDIF
         ENDIF
         IF((CREPUS.EQ.'N').OR.(CREPUS.EQ.'N'))THEN
          IF(QSOLR.GT.0.000)THEN
           IF(Z(IHOUR).EQ.90)THEN
            ACTHR(IHOUR)=0.0
           ENDIF
          ENDIF
         ENDIF
         ELSE
          ACTHR(IHOUR)=0.0
         ENDIF
        ELSE
         ACTHR(IHOUR)=0.0
        ENDIF
       ELSE
        ACTHR(IHOUR)=0.0
      ENDIF

      IF(LIVE.EQ.1)THEN
       IF(ASIL.EQ.ASILN)THEN
        POSTUR=1
       ENDIF
       IF(ASIL.EQ.ASILP)THEN
        POSTUR=2
       ENDIF
       IF(ASIL.EQ.((ASILP+ASILN)/2.))THEN
        POSTUR=0
       ENDIF
       IF((Z(IHOUR).EQ.90).OR.DEPSEL(IHOUR).LT.0)THEN
        POSTUR=0
        ASIL=(ASILP+ASILN)/2.
        PTCOND=PTCOND_ORIG
       ENDIF
      ENDIF
      
      TCORES(IHOUR)=TC

      IF(IHOUR.LT.25)THEN
       TBS((DAYCOUNT-1)*24+IHOUR)=TC
      ENDIF
      IF(ACTHR(IHOUR).EQ.0)THEN ! MAKE SURE NOT LOSING WATER FROM EYES WHEN INACTIVE
       IF(WEYES.GT.0)THEN
        WEVAP=WEVAP-WEYES
        WEYES=0.
       ENDIF
      ENDIF
C     HAVE TC, NOW CALL DEB MODEL TO GET NEXT HOUR'S V, E, MASS, HYDRATION STATE, MINERAL AND FOOD /FAECES / URINE FLUXES AND REPRO
C     (BUT DON'T CALL IF IT IS HOUR 25, TO AVOID HAVING AN EXTRA HOUR)
      IF(LIVE.EQ.1)THEN
       IF(DEB1.EQ.1)THEN
        IF((IHOUR.LT.25))THEN
         FOODWATERCUR=FOODWATERS(DAYCOUNT)
         IF(METAB_MODE.GT.1)THEN
          CALL DEB_HOLO(IHOUR) ! RUNNING THE HOLOMETABOLOUS INSECT VERSION
         ELSE
          IF(INTMETHOD.EQ.0)THEN
           CALL DEB_EULER(IHOUR) ! RUNNING THE STANDARD VERSION USING EULER METHOD OF INTEGRATION
          ELSE
           CALL DEB(IHOUR) ! RUNNING THE STANDARD VERSION USING DOPRI INTEGRATION
          ENDIF
         ENDIF
         IF(PTUREA.EQ.0)THEN
          H2O_URINE=0
          URINEFLUX=NWASTE(IHOUR)
         ELSE
          H2O_URINE=NWASTE(IHOUR)/(1-PTUREA)-NWASTE(IHOUR)
          URINEFLUX=NWASTE(IHOUR)/(1-PTUREA)
         ENDIF
         IF(FOODWATERCUR.EQ.0)THEN
          H2O_FREE=0.
          WETFOODFLUX=DRYFOOD(IHOUR)
         ELSE
          H2O_FREE=DRYFOOD(IHOUR)/(1-FOODWATERCUR)-DRYFOOD(IHOUR)
          WETFOODFLUX=DRYFOOD(IHOUR)/(1-FOODWATERCUR)
         ENDIF
         IF(PFEWAT.EQ.0.)THEN
          H2O_FAECES=0.
          WETFAECESFLUX=FAECES(IHOUR)
         ELSE
          H2O_FAECES=FAECES(IHOUR)/(1-PFEWAT)-FAECES(IHOUR)
          WETFAECESFLUX=FAECES(IHOUR)/(1-PFEWAT)
         ENDIF
         IF(STAGE.EQ.0)THEN
          H2O_BAL=0.
          H2O_BALPAST=0.
          H2O_BAL_HR=0.
          PCTDESI=0.
          IF(DEB1.EQ.1)THEN
           WEVAP=0.
           WCUT=0.
           WRESP=0.
           WEYES=0.
          ENDIF
         ELSE
          IF(((RAINFALL.GE.RAINDRINK).AND.(TC.GE.CTMIN)).OR.
     &    (INWATER.EQ.1).OR.(POTFREEMASS.LE.0.))THEN
           DRUNK=ABS(H2O_BAL)
           H2O_BAL=0.
          ELSE
           H2O_BAL=H2O_FREE+GH2OMET(IHOUR)-H2O_URINE-H2O_FAECES-
     &     WEVAP*3600.+H2O_BALPAST
          ENDIF
          IF((H2O_BAL.LT.0).AND.(POTFREEMASS.GT.0))THEN
           PCTDESI=-1.*H2O_BAL/POTFREEMASS*100.
           IF(PCTDESI.GT.DESIDEATH)THEN
            IF((STAGE.GT.DEATHSTAGE).AND.(V(IHOUR).NE.0))THEN
             CAUSEDEATH=3. ! DESICCATION
             DEATHSTAGE=STAGE
             IF(RESET.EQ.0)THEN
              SURVIV(IHOUR)=0.49
              LONGEV=(REAL(DAYCOUNT,4)+REAL(IHOUR)/24.)/365.
              NYEAR=IYEAR
              CENSUS=COUNTDAY
             ENDIF
            ENDIF
            IF(RESET.GT.0)THEN
             DEAD=1
            ELSE
             DEAD=1
             DEADEAD=1
             SURV(IYEAR)=SURVIV(IHOUR)
            ENDIF
           ENDIF
          ELSE
           PCTDESI=0.
          ENDIF
          IF(PCTDESI.GT.MAX_PCTDESI)THEN
           MAX_PCTDESI=PCTDESI
          ENDIF
          IF(H2O_BAL.GT.0)THEN
           H2O_BAL=0.
          ENDIF
          H2O_BAL_HR=H2O_FREE+GH2OMET(IHOUR)-H2O_URINE-H2O_FAECES-WEVAP*
     &    3600.
         ENDIF
         H2O_BALPAST=H2O_BAL
        ENDIF
       ELSE
        O2FLUX=10.**(MR_3*TC)*MR_1*(AMASS*1000.)**MR_2
       ENDIF
      ENDIF
      
      IF((DEAD.EQ.1).OR.(DEADEAD.EQ.1))THEN
       H2O_BAL=0.
       H2O_BALPAST=0.
       H2O_BAL_HR=0.
       PCTDESI=0.
      ENDIF
          
      GOODSOIL=0
      SHD(IHOUR)=SHADE

C     ALMOST END OF HOURS LOOP
       IF(IHOUR.LT.25)THEN
        HCT=IHOUR+24*(DAYCOUNT-1)
        ENBAL1(HCT,1)=DOY
        ENBAL1(HCT,2)=IYEAR
        ENBAL1(HCT,3)=DAYCOUNT
        ENBAL1(HCT,4)=IHOUR
        ENBAL1(HCT,5)=QSOLAR
        ENBAL1(HCT,6)=QIRIN
        ENBAL1(HCT,7)=QMETAB
        ENBAL1(HCT,8)=QSEVAP
        ENBAL1(HCT,9)=QIROUT
        ENBAL1(HCT,10)=QCONV
        ENBAL1(HCT,11)=QCOND
        ENBAL1(HCT,12)=ENB
        ENBAL1(HCT,13)=NTRY
        IF(WRITECSV.EQ.2)THEN
         WRITE(II3,113)ENBAL1(HCT,1),",",ENBAL1(HCT,2),",",ENBAL1(HCT,3
     &   ),",",ENBAL1(HCT,4),",",ENBAL1(HCT,5),",",ENBAL1(HCT,6),","
     &   ,ENBAL1(HCT,7),",",ENBAL1(HCT,8),",",ENBAL1(HCT,9),","
     &   ,ENBAL1(HCT,10),",",ENBAL1(HCT,11),",",ENBAL1(HCT,12),","
     &   ,ENBAL1(HCT,13)
        ENDIF
        IF((IYEAR.EQ.1).AND.(DAYCOUNT.EQ.1).AND.(IHOUR.EQ.1))THEN
         MINTC=TC
         MAXTC=TC
        ENDIF
        IF(TC.LT.MINTC)THEN
         MINTC=TC
        ENDIF
        IF(TC.GT.MAXTC)THEN
         MAXTC=TC
        ENDIF
       ENDIF

       IF(IHOUR.LT.25)THEN
        HCT=IHOUR+24*(DAYCOUNT-1)
        MASBAL1(HCT,1)=DOY
        MASBAL1(HCT,2)=IYEAR
        MASBAL1(HCT,3)=DAYCOUNT
        MASBAL1(HCT,4)=IHOUR
        MASBAL1(HCT,5)=O2FLUX
        IF(DEB1.EQ.1)THEN
         MASBAL1(HCT,6)=CO2FLUX
         MASBAL1(HCT,7)=NWASTE(IHOUR)
         MASBAL1(HCT,8)=H2O_FREE
         MASBAL1(HCT,9)=GH2OMET(IHOUR)
         MASBAL1(HCT,10)=DRYFOOD(IHOUR)
         MASBAL1(HCT,11)=WETFOODFLUX
         MASBAL1(HCT,12)=FAECES(IHOUR)
         MASBAL1(HCT,13)=WETFAECESFLUX
         MASBAL1(HCT,14)=URINEFLUX
         MASBAL1(HCT,18)=H2O_BAL_HR
         MASBAL1(HCT,19)=H2O_BAL
        ELSE
         MASBAL1(HCT,6)=0.
         MASBAL1(HCT,7)=0.
         MASBAL1(HCT,8)=0.
         MASBAL1(HCT,9)=0.
         MASBAL1(HCT,10)=0.
         MASBAL1(HCT,11)=0.
         MASBAL1(HCT,12)=0.
         MASBAL1(HCT,13)=0.
         MASBAL1(HCT,14)=0.
         MASBAL1(HCT,18)=0.
         MASBAL1(HCT,19)=0.
        ENDIF
        MASBAL1(HCT,15)=WRESP*3600.
        MASBAL1(HCT,16)=WCUT*3600.
        MASBAL1(HCT,17)=WEYES*3600.
        IF(WRITECSV.EQ.2)THEN
        WRITE(II2,112)MASBAL1(HCT,1),",",MASBA
     &   L1(HCT,2),",",MASBAL1(HCT,3),",",MASBA
     &   L1(HCT,4),",",MASBAL1(HCT,5),",",MASBA
     &   L1(HCT,6),",",MASBAL1(HCT,7),",",MASBA
     &   L1(HCT,8),",",MASBAL1(HCT,9),",",MASBA
     &   L1(HCT,10),",",MASBAL1(HCT,11),",",MAS
     &   BAL1(HCT,12),",",MASBAL1(HCT,13),",",M
     &   ASBAL1(HCT,14),",",MASBAL1(HCT,15),","
     &   ,MASBAL1(HCT,16),",",MASBAL1(HCT,17),"
     &   ,",MASBAL1(HCT,18),",",MASBAL1(HCT,19)
        ENDIF
       ENDIF

       IF(IHOUR.LT.25)THEN
        HCT=IHOUR+24*(DAYCOUNT-1)
        ENVIRON1(HCT,1)=DOY
        ENVIRON1(HCT,2)=IYEAR
        ENVIRON1(HCT,3)=DAYCOUNT
        ENVIRON1(HCT,4)=IHOUR
        ENVIRON1(HCT,5)=TC
        ENVIRON1(HCT,6)=SHADE
        ENVIRON1(HCT,7)=QSOLR*(1.-SHADE/100.)
        ENVIRON1(HCT,8)=DEPSEL(IHOUR)
        ENVIRON1(HCT,9)=ACTHR(IHOUR)
        ENVIRON1(HCT,10)=TA
        ENVIRON1(HCT,11)=TSUBST
        ENVIRON1(HCT,12)=TSKY
        ENVIRON1(HCT,13)=VEL
        ENVIRON1(HCT,14)=RELHUM
        ENVIRON1(HCT,15)=Z(IHOUR)
        IF((AQUATIC.EQ.1).AND.(POND.EQ.0))THEN
         IF(WETMOD.EQ.1)THEN
          ENVIRON1(HCT,16)=WETLANDDEPTHS(HOURCOUNT)
          ENVIRON1(HCT,17)=WETLANDTEMPS(HOURCOUNT)
         ELSE
          ENVIRON1(HCT,16)=POND_ENV(IYEAR,COUNTDAY,IHOUR,2)
          ENVIRON1(HCT,17)=POND_ENV(IYEAR,COUNTDAY,IHOUR,1)
         ENDIF
        ELSE
          IF(CONTH.GT.0)THEN
           ENVIRON1(HCT,16)=ZD4(IHOUR)
           ENVIRON1(HCT,17)=TRANSIENT(IHOUR)
C          POND_ENV(HCT,1)=DOY
          ELSE
           ENVIRON1(HCT,16)=0
           ENVIRON1(HCT,17)=0
          ENDIF
        ENDIF
        ENVIRON1(HCT,18)=LENGTHDAY
        ENVIRON1(HCT,19)=PHI
        ENVIRON1(HCT,20)=WINGTEMP
        ENVIRON1(HCT,21)=FLIGHT
        ENVIRON1(HCT,22)=FLYTIME
        ENVIRON1(HCT,23)=PO2WATER
        ENVIRON1(HCT,24)=SALWATER
        ENVIRON1(HCT,25)=ABSAN
        ENVIRON1(HCT,26)=PTCOND*100.
        ENVIRON1(HCT,27)=REAL(POSTUR,8)
        ENVIRON1(HCT,28)=REAL(PANT,8)
        IF(WRITECSV.EQ.2)THEN
         WRITE(II1,111)ENVIRON1(HCT,1),',',ENVIRON1(HCT,
     &   2),',',ENVIRON1(HCT,3),',',ENVIRON1(HCT,4),',',ENV
     &   IRON1(HCT,5),',',ENVIRON1(HCT,6),',',ENVIRON1(HCT,
     &   7),',',ENVIRON1(HCT,8),',',ENVIRON1(HCT,9),',',ENVI
     &   RON1(HCT,10),',',ENVIRON1(HCT,11),',',ENVIRON1(HCT,
     &   12),',',ENVIRON1(HCT,13),',',ENVIRON1(HCT,14),',',EN
     &   VIRON1(HCT,15),',',ENVIRON1(HCT,16),',',ENVIRON1(HCT
     &   ,17),',',ENVIRON1(HCT,18),',',ENVIRON1(HCT,19),',',
     &   ENVIRON1(HCT,20),',',ENVIRON1(HCT,21),',',ENVIRON1
     &   (HCT,22),',',ENVIRON1(HCT,23),',',ENVIRON1(HCT,24),',',
     & ENVIRON1(HCT,25),',',ENVIRON1(HCT,26)*100.,',',
     & ENVIRON1(HCT,27),',',ENVIRON1(HCT,28)
        ENDIF
       ENDIF

       IF(COMPLETE.EQ.0)THEN
        IF(IHOUR.LT.25)THEN
C    ********* BEGIN SUMMARY PER YEAR *****
         IF(STAGE.GT.YMAXSTG)THEN
          YMAXSTG=STAGE
         ENDIF
         IF(WETMASS(IHOUR).GT.YMAXWGT)THEN
          YMAXWGT=WETMASS(IHOUR)
         ENDIF
         IF(L_W(IHOUR).GT.YMAXLEN)THEN
          YMAXLEN=L_W(IHOUR)
         ENDIF
         IF((((DAYCOUNT.EQ.1).AND.(IHOUR.EQ.1)).OR.(COUNTDAY.
     &    EQ.STARTDAY)).AND.(IHOUR.EQ.1))THEN
          YTMIN=TC
          YTMAX=TC
          YMINRES=ED(IHOUR)/E_M
          IF(YMINRES.GT.1)THEN
           YMINRES=1
          ENDIF
         ENDIF
         IF(V(IHOUR).GT.0)THEN
          IF(TC.GT.YTMAX)THEN
           YTMAX=TC
          ENDIF
          IF(TC.LT.YTMIN)THEN
           YTMIN=TC
          ENDIF
          IF(ED(IHOUR)/E_M.LT.YMINRES)THEN
           YMINRES=ED(IHOUR)/E_M
           IF(YMINRES.GT.1)THEN
            YMINRES=1
           ENDIF
          ENDIF
          IF(PCTDESI.GE.MAX_PCTDESI)THEN
           YMAXDES=PCTDESI
          ENDIF
          IF(SHADE.LT.YMINSHADE)THEN
           YMINSHADE=SHADE
          ENDIF
          IF(SHADE.GT.YMAXSHADE)THEN
           YMAXSHADE=SHADE
          ENDIF
          IF(DEPSEL(IHOUR).LT.0)THEN
           IF(DEPSEL(IHOUR).GT.YMINDEP)THEN
            YMINDEP=DEPSEL(IHOUR)
           ENDIF
           IF(DEPSEL(IHOUR).LT.YMAXDEP)THEN
            YMAXDEP=DEPSEL(IHOUR)
           ENDIF
          ENDIF
          IF(ACTHR(IHOUR).EQ.1)THEN
           YBSK=YBSK+1
          ENDIF
          IF(ACTHR(IHOUR).EQ.2)THEN
           YFORAGE=YFORAGE+1
          ENDIF
          IF(FLYTIME*FLYSPEED.GT.0)THEN
           YDIST=YDIST+FLYTIME*60.*FLYSPEED/1000
          ENDIF
          YFOOD=YFOOD+DRYFOOD(IHOUR)
          YDRINK=YDRINK+DRUNK
          YNWASTE=YNWASTE+NWASTE(IHOUR)
          YFECES=YFECES+FAECES(IHOUR)
          YO2=YO2+O2FLUX
          IF(REPRO(IHOUR).GT.0)THEN
           YCLUTCH=YCLUTCH+REPRO(IHOUR)
           YFEC=YCLUTCH*NEWCLUTCH
           YDLAY=COUNTDAY
          ENDIF
          IF(((YDEGG.EQ.0).OR.(PREVSTAGE.GT.STAGE)).AND.
     &     (STAGE.EQ.0))THEN
           YDEGG=COUNTDAY
          ENDIF
          IF((STAGE.GT.PREVSTAGE).AND.(STAGE.EQ.1))THEN
           YDSTG1=COUNTDAY
           YMSTG1=WETMASS(IHOUR)
          ENDIF
          IF((STAGE.GT.PREVSTAGE).AND.(STAGE.EQ.2))THEN
           YDSTG2=COUNTDAY
           YMSTG2=WETMASS(IHOUR)
          ENDIF
          IF((STAGE.GT.PREVSTAGE).AND.(STAGE.EQ.3))THEN
           YDSTG3=COUNTDAY
           YMSTG3=WETMASS(IHOUR)
          ENDIF
          IF((STAGE.GT.PREVSTAGE).AND.(STAGE.EQ.4))THEN
           YDSTG4=COUNTDAY
           YMSTG4=WETMASS(IHOUR)
          ENDIF
          IF((STAGE.GT.PREVSTAGE).AND.(STAGE.EQ.5))THEN
           YDSTG5=COUNTDAY
           YMSTG5=WETMASS(IHOUR)
          ENDIF
          IF((STAGE.GT.PREVSTAGE).AND.(STAGE.EQ.6))THEN
           YDSTG6=COUNTDAY
           YMSTG6=WETMASS(IHOUR)
          ENDIF
          IF((STAGE.GT.PREVSTAGE).AND.(STAGE.EQ.7))THEN
           YDSTG7=COUNTDAY
           YMSTG7=WETMASS(IHOUR)
          ENDIF
          IF((STAGE.GT.PREVSTAGE).AND.(STAGE.EQ.8))THEN
           YDSTG8=COUNTDAY
           YMSTG8=WETMASS(IHOUR)
          ENDIF
          IF(SURVIV(IHOUR).LT.YSURV)THEN
           YSURV=SURVIV(IHOUR)
          ENDIF
         ENDIF
C    ********** END SUMMARY PER YEAR *****
        ENDIF
       ENDIF

      PREVSTAGE=STAGE

C       TRANSIENT OUTPUTS FILLED FOR 2D & 3D PLOTS
        JP=INT(DDOY*25.+T/60.+1)
C       X COORDINATE (TIME IN HOURS)
        XP(JP)=INT((T/60.))
C       Y COORDINATE (DAY OF YEAR, I.E. DAY OF SIMULATION)
        YP(JP)=DDOY+1.
C       Z COORDINATE
        ZP1(JP)=INT(Y(NEQ))
        ZP2(JP)=QMETAB
        ZP3(JP)=WEVAP

      IF(DAYCOUNT.EQ.2.)THEN
       IF(TESTER.EQ.2)THEN
        GOTO 2001
       ENDIF
      ENDIF

      IF (TIME(IHOUR).LT.1440.) THEN
       IF(TESTER.EQ.1)THEN
         DEBOUT1(I,1)=DOY
         DEBOUT1(I,2)=IYEAR
         DEBOUT1(I,3)=DAYCOUNT
         DEBOUT1(I,4)=1-24*(DAYCOUNT-1)
         DEBOUT1(I,5)=STAGE_REC(1-24*(DAYCOUNT-1))
         DEBOUT1(I,6)=V(1-24*(DAYCOUNT-1))
         DEBOUT1(I,7)=ED(1-24*(DAYCOUNT-1))
         DEBOUT1(I,8)=E_H(1-24*(DAYCOUNT-1))
         DEBOUT1(I,9)=L_W(1-24*(DAYCOUNT-1))
         DEBOUT1(I,10)=WETMASS(1-24*(DAYCOUNT-1))
         DEBOUT1(I,11)=WETGONAD(1-24*(DAYCOUNT-1))
         DEBOUT1(I,12)=WETFOOD(1-24*(DAYCOUNT-1))
         DEBOUT1(I,13)=PCTDESI
         DEBOUT1(I,14)=CUMREPRO(1-24*(DAYCOUNT-1)) 
         DEBOUT1(I,15)=CUMBATCH(1-24*(DAYCOUNT-1))
         DEBOUT1(I,16)=REAL(BREEDVECT(1-24*(DAYCOUNT-1)),8)
         DEBOUT1(I,17)=PREGNANT
         DEBOUT1(I,18)=V_BABY1(1-24*(DAYCOUNT-1))
         DEBOUT1(I,19)=E_BABY1(1-24*(DAYCOUNT-1))
         DEBOUT1(I,20)=HS(1-24*(DAYCOUNT-1))
         DEBOUT1(I,21)=SURVIV(1-24*(DAYCOUNT-1))
         DEBOUT1(I,22)=PAS(1-24*(DAYCOUNT-1))
         DEBOUT1(I,23)=PCS(1-24*(DAYCOUNT-1))
         DEBOUT1(I,24)=PMS(1-24*(DAYCOUNT-1))
         DEBOUT1(I,25)=PGS(1-24*(DAYCOUNT-1))
         DEBOUT1(I,26)=PDS(1-24*(DAYCOUNT-1))
         DEBOUT1(I,27)=PJS(1-24*(DAYCOUNT-1))
         DEBOUT1(I,28)=PRS(1-24*(DAYCOUNT-1))
         DEBOUT1(I,29)=PBS(1-24*(DAYCOUNT-1))
        GOTO 2001
       ENDIF
C      DO ANOTHER HOUR
       GO TO 54
      ELSE
C      LEAVE TO DO ANOTHER DAY  ***END OF DAY LOOP ***
      ENDIF

       MICROS=DAYCOUNT*24-23
       MICROF=DAYCOUNT*24
       DO 989 I=MICROS,MICROF
        IF(DEPSEL(I-24*(DAYCOUNT-1)).LT.DEPMAX)THEN
         DEPMAX = DEPSEL(I-24*(DAYCOUNT-1))
        ENDIF
         DEBOUT1(I,1)=DOY
         DEBOUT1(I,2)=IYEAR
         DEBOUT1(I,3)=DAYCOUNT
         DEBOUT1(I,4)=I-24*(DAYCOUNT-1)
         DEBOUT1(I,5)=STAGE_REC(I-24*(DAYCOUNT-1))
         DEBOUT1(I,6)=V(I-24*(DAYCOUNT-1))
         DEBOUT1(I,7)=ED(I-24*(DAYCOUNT-1))
         DEBOUT1(I,8)=E_H(I-24*(DAYCOUNT-1))
         DEBOUT1(I,9)=L_W(I-24*(DAYCOUNT-1))
         DEBOUT1(I,10)=WETMASS(I-24*(DAYCOUNT-1))
         DEBOUT1(I,11)=WETGONAD(I-24*(DAYCOUNT-1))
         DEBOUT1(I,12)=WETFOOD(I-24*(DAYCOUNT-1))
         DEBOUT1(I,13)=PCTDESI
         DEBOUT1(I,14)=CUMREPRO(I-24*(DAYCOUNT-1)) 
         DEBOUT1(I,15)=CUMBATCH(I-24*(DAYCOUNT-1))
         DEBOUT1(I,16)=REAL(BREEDVECT(I-24*(DAYCOUNT-1)),8)
         DEBOUT1(I,17)=PREGNANT
         DEBOUT1(I,18)=V_BABY1(I-24*(DAYCOUNT-1))
         DEBOUT1(I,19)=E_BABY1(I-24*(DAYCOUNT-1))
         DEBOUT1(I,20)=HS(I-24*(DAYCOUNT-1))
         DEBOUT1(I,21)=SURVIV(I-24*(DAYCOUNT-1))
         DEBOUT1(I,22)=PAS(I-24*(DAYCOUNT-1))
         DEBOUT1(I,23)=PCS(I-24*(DAYCOUNT-1))
         DEBOUT1(I,24)=PMS(I-24*(DAYCOUNT-1))
         DEBOUT1(I,25)=PGS(I-24*(DAYCOUNT-1))
         DEBOUT1(I,26)=PDS(I-24*(DAYCOUNT-1))
         DEBOUT1(I,27)=PJS(I-24*(DAYCOUNT-1))
         DEBOUT1(I,28)=PRS(I-24*(DAYCOUNT-1))
         DEBOUT1(I,29)=PBS(I-24*(DAYCOUNT-1))
        IF(WRITECSV.EQ.2)THEN
         WRITE(II4,114)DEBOUT1(I,1),',',DEBOUT1(I,2),',',DEB
     &   OUT1(I,3),',',DEBOUT1(I,4),',',DEBOUT1(I,5),',',DEBO
     &   UT1(I,6),',',DEBOUT1(I,7),',',DEBOUT1(I,8),',',DEBOU
     &   T1(I,9),',',DEBOUT1(I,10),',',DEBOUT1(I,11),',',DEBO
     &   UT1(I,12),',',DEBOUT1(I,13),',',DEBOUT1(I,14),',',DE
     &   BOUT1(I,15),',',DEBOUT1(I,16),',',DEBOUT1(I,17),','
     &   ,DEBOUT1(I,18),',',DEBOUT1(I,19),',',DEBOUT1(I,20),',',
     &   DEBOUT1(I,21),',',DEBOUT1(I,22),',',DEBOUT1(I,23),',',
     &   DEBOUT1(I,24),',',DEBOUT1(I,25),',',DEBOUT1(I,26),',',
     &   DEBOUT1(I,27),',',DEBOUT1(I,28),',',DEBOUT1(I,29)
        ENDIF
        IF(STAGE.EQ.0)THEN
         DEVTIME=DEVTIME+(1./24.)
        ENDIF
        IF((STAGE.GT.1).AND.(BIRTH.EQ.0))THEN
         BIRTH=1
         BIRTHDAY=DOY
         BIRTHMASS=DEBOUT1(I,18)
        ENDIF      
989    CONTINUE

      DDOY=DDOY+1.

C     ******************* END OF LOOPS FOR THE DAY *****************

      IF(IDAY.EQ.1) THEN
       ITEST=1
      ENDIF

C     CAUSEDEATH
C     0    NO DEATH
C     1    COLD
C     2    HEAT
C     3    DESI
C     4    STARVE
C     5    AGEING
C     6    POND DRY
      IF(COUNTDAY.EQ.CENSUS)THEN
       YEARSOUT1(IYEAR,1)=DBLE(IYEAR)
       YEARSOUT1(IYEAR,2)=DBLE(YMAXSTG)
       YEARSOUT1(IYEAR,3)=DBLE(YMAXWGT)
       YEARSOUT1(IYEAR,4)=DBLE(YMAXLEN)
       YEARSOUT1(IYEAR,5)=DBLE(YTMAX)
       YEARSOUT1(IYEAR,6)=DBLE(YTMIN)
       YEARSOUT1(IYEAR,7)=DBLE(YMINRES)
       YEARSOUT1(IYEAR,8)=DBLE(YMAXDES)
       YEARSOUT1(IYEAR,9)=DBLE(YMINSHADE)
       YEARSOUT1(IYEAR,10)=DBLE(YMAXSHADE)
       YEARSOUT1(IYEAR,11)=DBLE(YMINDEP)
       YEARSOUT1(IYEAR,12)=DBLE(YMAXDEP)
       YEARSOUT1(IYEAR,13)=DBLE(YBSK)
       YEARSOUT1(IYEAR,14)=DBLE(YFORAGE)
       YEARSOUT1(IYEAR,15)=DBLE(YDIST)
       YEARSOUT1(IYEAR,16)=DBLE(YFOOD)
       YEARSOUT1(IYEAR,17)=DBLE(YDRINK)
       YEARSOUT1(IYEAR,18)=DBLE(YNWASTE)
       YEARSOUT1(IYEAR,19)=DBLE(YFECES)
       YEARSOUT1(IYEAR,20)=DBLE(YO2)
       YEARSOUT1(IYEAR,21)=DBLE(YCLUTCH)
       YEARSOUT1(IYEAR,22)=DBLE(YFEC)
       YEARSOUT1(IYEAR,23)=DBLE(CAUSEDEATH)
       YEARSOUT1(IYEAR,24)=DBLE(YDLAY)
       YEARSOUT1(IYEAR,25)=DBLE(YDEGG)
       YEARSOUT1(IYEAR,26)=DBLE(YDSTG1)
       YEARSOUT1(IYEAR,27)=DBLE(YDSTG2)
       YEARSOUT1(IYEAR,28)=DBLE(YDSTG3)
       YEARSOUT1(IYEAR,29)=DBLE(YDSTG4)
       YEARSOUT1(IYEAR,30)=DBLE(YDSTG5)
       YEARSOUT1(IYEAR,31)=DBLE(YDSTG6)
       YEARSOUT1(IYEAR,32)=DBLE(YDSTG7)
       YEARSOUT1(IYEAR,33)=DBLE(YDSTG8)
       YEARSOUT1(IYEAR,34)=DBLE(YMSTG1)
       YEARSOUT1(IYEAR,35)=DBLE(YMSTG2)
       YEARSOUT1(IYEAR,36)=DBLE(YMSTG3)
       YEARSOUT1(IYEAR,37)=DBLE(YMSTG4)
       YEARSOUT1(IYEAR,38)=DBLE(YMSTG5)
       YEARSOUT1(IYEAR,39)=DBLE(YMSTG6)
       YEARSOUT1(IYEAR,40)=DBLE(YMSTG7)
       YEARSOUT1(IYEAR,41)=DBLE(YMSTG8)
       YEARSOUT1(IYEAR,42)=DBLE(YSURV)
       YEARSOUT1(IYEAR,43)=DBLE(DEATHSTAGE)
       IF(WRITECSV.GE.1)THEN
        II6=7
        OPEN (II6, FILE = 'YEARSOUT'//TRIM(STR(IYEAR))//'.CSV')
        WRITE(II6,1118)"MAXSTG",",","MAXWGT",",","MAXLEN",","
     &  ,"TMAX",",","TMIN",",","MINRES",",","MAXDES",","
     &  ,"MINSHADE",",","MAXSHADE",",","MINDEP",",","MAXDEP"
     &  ,",","BSK",",","FORAGE",",","DIST",",","FOOD",","
     &  ,"DRINK",",","NWASTE",",","FECES",",","O2",",","CLUTCH"
     &  ,",","FEC",",","CAUSEDEATH",",","TLAY",",","TEGG",","
     &  ,"TSTG1",",","TSTG2",",","TSTG3",",","TSTG4",","
     &  ,"TSTG5",",","TSTG6",",","TSTG7",",","TSTG8",",","MSTG1"
     &  ,",","MSTG2",",","MSTG3",",","MSTG4",",","MSTG5",","
     &  ,"MSTG6",",","MSTG7",",","MSTG8",",","SURV",","
     &  ,"OVIPSURV",",","FIT",",","DEATHSTAGE"
        WRITE(II6,1117)YMAXSTG,",",YMAXWGT,",",YMAXLEN,","
     &  ,YTMAX,",",YTMIN,",",YMINRES,",",YMAXDES,",",YMINSH
     &  ADE,",",YMAXSHADE,",",YMINDEP,",",YMAXDEP,",",YBSK
     &  ,",",YFORAGE,",",YDIST,",",YFOOD,",",YDRINK,",",YNWA
     &  STE,",",YFECES,",",YO2,",",YCLUTCH,",",YFEC,",",CAUS
     &  EDEATH,",",YDLAY,",",YDEGG,",",YDSTG1,",",YDSTG2,","
     &  ,YDSTG3,",",YDSTG4,",",YDSTG5,",",YDSTG6,",",YDSTG7,"
     &  ,",YDSTG8,",",YMSTG1,",",YMSTG2,",",YMSTG3,",",YMSTG4
     &  ,",",YMSTG5,",",YMSTG6,",",YMSTG7,",",YMSTG8,",",YSUR
     &  V,",",DEATHSTAGE
        CLOSE(II6)
       ENDIF
      ENDIF

1117  FORMAT(41(F20.10,A),1F20.10)
1118  FORMAT(41(A13,A1),A13)

      DAYCOUNT=DAYCOUNT+1
      COUNTDAY=COUNTDAY+1

      IF(POND.EQ.0)THEN
       IF(STAGE.EQ.STAGES-2)THEN
        CONTH=0.
        CONTW=0.
        CONTDEP=0.
        TRANST='N'
        METAMORPH=1
       ENDIF
      ENDIF

      IF(COUNTDAY.GT.365)THEN
       IYEAR=IYEAR+1
       COUNTDAY=1
       COMPLETION=0
      ENDIF

      IF(IYEAR.GT.NYEAR)THEN
       IYEAR=NYEAR
      ENDIF
      IF(DAYCOUNT.LE.NN)THEN
       GOTO 2000
      ENDIF

2001  CONTINUE

      IF((AQUATIC.EQ.1).AND.(POND.EQ.1))THEN
C     CHECK TO SEE IF JUST CONTAINER MODEL IS RUNNING OR WHETHER TO START AGAIN AND DO AN ANIMAL
       IF(CONTONLY.EQ.0)THEN
        POND=0
        GOTO 5501
       ENDIF
      ENDIF

C     CALCULATE LIFE TABLE AND RMAX
      DO 1010 I=1,NYEAR
       IF(I.LT.NYEAR)THEN
        YEARFRACT=1
       ELSE
        YEARFRACT=LONGEV-AINT(LONGEV)
       ENDIF
C      ACCOUNT FOR NON-SENESCENT MORTALITY VIA PARAMTERES MI, MA AND MH BY MULTIPLYING SENESCENCE BY THESE VALUES
       IF(FOR(I).EQ.0)THEN
        SURV(I)=SURV(I)*MH*YEARFRACT
       ELSE
        SURV(I)=SURV(I)*(1-MI)**(8760.-FOR(I))*(1-MA)**FOR(I)*MH
     &   *YEARFRACT
       ENDIF
       IF(I.EQ.1)THEN
        LX(I)=SURV(I)
       ELSE
        LX(I)=SURV(I)*LX(I-1)
       ENDIF
       MX(I)=FEC(I)/2.
       R0=R0+LX(I)*MX(I)*1.
       TT=TT+I*LX(I)*MX(I)*1.
1010  CONTINUE
      IF(R0.GT.0)THEN
       TT=TT/R0
       RMAX=LOG(R0)/TT
      ELSE
       TT=0.
       R0=0.
      ENDIF

      YEAROUT(1)=DEVTIME
      YEAROUT(2)=BIRTHDAY
      YEAROUT(3)=BIRTHMASS
      YEAROUT(4)=MONMATURE
      YEAROUT(5)=MONREPRO
      YEAROUT(6)=L_WREPRO
      YEAROUT(7)=FECUNDITY
      YEAROUT(8)=CLUTCHES
      YEAROUT(9)=ANNUALACT
      IF(DEB1.EQ.1)THEN
       YEAROUT(10)=MINED
      ELSE
       YEAROUT(10)=0.
      ENDIF
      YEAROUT(11)=FOOD(NYEAR)/1000.
      YEAROUT(12)=ANNFOOD/1000.
      YEAROUT(13)=MINTC
      YEAROUT(14)=MAXTC
      YEAROUT(15)=MAX_PCTDESI
      YEAROUT(16)=LONGEV
      YEAROUT(17)=TT
      YEAROUT(18)=R0
      YEAROUT(19)=RMAX
      YEAROUT(20)=DEBOUT1(NN*24,10)
      IF(WRITECSV.GT.0)THEN
       WRITE(II5,115)YEAROUT(1),",",YEAROUT(2),",",YEAR
     & OUT(3),",",YEAROUT(4),",",YEAROUT(5),",",YEAROUT(
     & 6),",",YEAROUT(7),",",YEAROUT(8),",",YEAROUT(9),"
     & ,",YEAROUT(10),",",YEAROUT(11),",",YEAROUT(12),"
     & ,",YEAROUT(13),",",YEAROUT(14),",",YEAROUT(15),","
     & ,YEAROUT(16),",",YEAROUT(17),",",YEAROUT(18),",",
     & YEAROUT(19),",",YEAROUT(20)
      ENDIF

111   FORMAT(27(1F8.3,A),1F8.3)
112   FORMAT(18(ES20.10E5,A),ES20.10E5)
113   FORMAT(12(ES20.10E5,A),ES20.10E5)
114   FORMAT(4(1F8.3,A),2(1E8.3,A),ES20.10E5,A,2(1E8.3,A),ES20.10E5,A,
     &5(1E8.3,A),1F8.3,A,13(1E8.3,A))
115   FORMAT(19(1F15.3,A),1F10.3)

      IF(WRITECSV.EQ.2)THEN
       CLOSE (II1)
       CLOSE (II2)
       CLOSE (II3)
       CLOSE (II4)
      ENDIF

      IF(WRITECSV.GT.0)THEN
       CLOSE (II5)
      ENDIF

      DEALLOCATE (POND_ENV,DAYDOY,RAINFALL2,RAINHR,WETLANDDEPTHS,
     & MAXSHADES,WETLANDTEMPS,FOODWATERS,FOODLEVELS,XP,YP,DAY,TRANSIENT
     & ,ZP1,ZP2,ZP3,ZP4,ZP5,ZP6,ZP7,ZD1,ZD2,ZD3,ZD4,ZD5,ZD6,ZD7,TBS,FEC,
     & SURV,ACT,FOR,LX,MX,THERMAL_STAGES,BEHAV_STAGES,WATER_STAGES,
     & NUTRI_STAGES,ARRHENIUS,ARRHENIUS2,S_INSTAR,L_INSTAR,MINSHADES)
200   RETURN
      END

      CHARACTER(LEN=20) FUNCTION STR(K)
C!   "CONVERT AN INTEGER TO STRING."
      INTEGER, INTENT(IN) :: K
      WRITE (STR, *) K
      STR = ADJUSTL(STR)
      END FUNCTION STR