      SUBROUTINE DRYAIR(DB,BP,ALT,PATMOS,DENSTY,VISDYN,VISKIN,DIFVPR,
     *THCOND,HTOVPR,TCOEFF,GGROUP)

C     NICHEMAPR: SOFTWARE FOR BIOPHYSICAL MECHANISTIC NICHE MODELLING

C     COPYRIGHT (C) 2018 MICHAEL R. KEARNEY AND WARREN P. PORTER

C     THIS PROGRAM IS FREE SOFTWARE: YOU CAN REDISTRIBUTE IT AND/OR MODIFY
C     IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
C     THE FREE SOFTWARE FOUNDATION, EITHER VERSION 3 OF THE LICENSE, OR (AT
C      YOUR OPTION) ANY LATER VERSION.

C     THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
C     WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
C     MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
C     GENERAL PUBLIC LICENSE FOR MORE DETAILS.

C     YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
C     ALONG WITH THIS PROGRAM. IF NOT, SEE HTTP://WWW.GNU.ORG/LICENSES/.

C***********************************************************************
C
C     SUBROUTINE DRYAIR CALCULATES SEVERAL PROPERTIES OF DRY AIR AND RELATED
C     CHARACTERISTICS SHOWN AS OUTPUT VARIABLES BELOW.  THE PROGRAM IS BASED
C     ON DATA FROM LIST, R. J. 1971. SMITHSONIAN METEOROLOGICAL TABLES.
C     SMITHSONIAN INSTITUTION PRESS. WASHINGTON, DC.
C
C     THE USER MUST SUPPLY VALUES FOR THE INPUT VARIABLES (DB, BP, AND ALT).
C     IF ALT IS KNOWN (-1 000 < ALT < 20 000) BUT NOT BP THEN SET BP=0.
C
C*************************** INPUT VARIABLES ***************************
C
C     DB=DRY BULB TEMPERATURE (DEGREE CELSIUS)
C     BP=BAROMETRIC PRESSURE (PASCAL) [BP AT ONE STANDARD ATMOSPHERE IS
C     101 325 PASCALS (100 PASCALS=1 MILLIBAR)].
C     ALT=ALTITUDE (METRE) (1 METRE=3.280 839 9 FEET)
C
C*************************** OUTPUT VARIABLES **************************
C
C     PATMOS=STANDARD ATMOSPHERIC PRESSURE (PASCAL)
C     DENSTY=DENSITY (KILOGRAM PER CUBIC METRE)
C     VISDYN=DYNAMIC VISCOSITY (KILOGRAM PER METRE SECOND)
C     VISKIN=KINEMATIC VISCOSITY (SQUARE METRE PER SECOND)
C     DIFVPR=DIFFUSIVITY OF WATER VAPOR IN AIR (SQUARE METRE PER SECOND)
C     THCOND=THERMAL CONDUCTIVITY (WATT PER METRE KELVIN)
C     HTOVPR=LATENT HEAT OF VAPORIZATION OF WATER (JOULE PER KILOGRAM)
C     TCOEFF=TEMPERATURE COEFFICIENT OF VOLUME EXPANSION (1 PER KELVIN)
C     GGROUP=GROUP OF VARIABLES IN GRASHOF NUMBER (1 PER CUBIC METRE KELVIN)
C
C***********************************************************************

      IMPLICIT NONE

      DOUBLE PRECISION ALT,BP,C,DB,DENSTY,DIFVPR,GGROUP,HTOVPR,PATMOS,
     & PSTD,TCOEFF,THCOND,TNOT,TSTD,VISDYN,VISKIN,VISNOT

      TSTD=273.15
      PSTD=101325.
      PATMOS=PSTD*((1.-(.0065*ALT/288.))**(1./.190284))
      IF(BP.LE.0.)BP=PATMOS
      DENSTY=BP/(287.04*(DB+TSTD))
      VISNOT=1.8325E-5
      TNOT=296.16
      C=120.
      VISDYN=(VISNOT*((TNOT+C)/(DB+TSTD+C)))*(((DB+TSTD)/TNOT)**1.5)
      VISKIN=VISDYN/DENSTY
      DIFVPR=2.26E-5*(((DB+TSTD)/TSTD)**1.81)*(1.E5/BP)
      THCOND=.02425+(7.038E-5*DB)
      HTOVPR=2.5012E6-2.3787E3*DB
      TCOEFF=1./(DB+TSTD)
      GGROUP=.0980616*TCOEFF/(VISKIN*VISKIN)
      RETURN
      END