      SUBROUTINE DGET_AVELHS(N,A,AVELHS,DAVELHS,RPAR,IPAR)

C     NICHEMAPR: SOFTWARE FOR BIOPHYSICAL MECHANISTIC NICHE MODELLING

C     COPYRIGHT (C) 2018 MICHAEL R. KEARNEY AND WARREN P. PORTER

C     THIS PROGRAM IS FREE SOFTWARE: YOU CAN REDISTRIBUTE IT AND/OR MODIFY
C     IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
C     THE FREE SOFTWARE FOUNDATION, EITHER VERSION 3 OF THE LICENSE, OR (AT
C      YOUR OPTION) ANY LATER VERSION.

C     THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
C     WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
C     MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
C     GENERAL PUBLIC LICENSE FOR MORE DETAILS.

C     YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
C     ALONG WITH THIS PROGRAM. IF NOT, SEE HTTP://WWW.GNU.ORG/LICENSES/.

C     EQUATIONS TO COMPUTE RATES OF CHANGE IN RESERVE, STRUCTURAL VOLUME, 
C     MATURITY REPRODUCTION BUFFER FOR AN INSECT PUPA

      IMPLICIT NONE

      INTEGER IPAR,N

      DOUBLE PRECISION A,AVELHS,DAVELHS,DE,DH,DL,DV,E,E_M,E_S,F,G,H,K_E
      DOUBLE PRECISION K_J,KAP,KAP_V,L,L_M,P_C,R,RPAR,V,V_J
      DIMENSION AVELHS(N),DAVELHS(N),IPAR(13),RPAR(16)

      F=RPAR(1)
      K_E=RPAR(2)
      V_J=RPAR(3)
      E_M=RPAR(4)
      G=RPAR(5)
      KAP=RPAR(6)
      KAP_V=RPAR(7)
      K_J=RPAR(8)
      L_M=RPAR(9)

      A  = AVELHS(1)! % H, TIME SINCE PUPATION
      V  = AVELHS(2)! % CM3, STRUCTURAL VOLUME OF LARVA
      E  = AVELHS(3)! % J, RESERVE OF LARVA
      L  = AVELHS(4)! % CM, STRUCTURAL LENGTH OF IMAGO
      H  = AVELHS(5)! % J, MATURITY

      DV = -1.D+00 * V * K_E                        ! CM^3/TIME, CHANGE IN LARVAL STRUCTURAL VOLUME
      E_S = E/ L**3.D+00/ E_M                        ! -, SCALED RESERVE DENSITY
      R = V_J*(E_S / L - 1.D+00 / L_M)/ (E_S + G)    ! 1/TIME, SPECIFIC GROWTH RATE
      P_C = E * (V_J / L - R)                        ! J/TIME, MOBILISATION RATE
      DE =  DV * G * E_M * KAP * KAP_V - p_C   ! J/TIME, CHANGE IN RESERVE
      DL = R * L/ 3.D+00                             ! CM/TIME, CHANGE IN LENGTH
      DH = (1.D+00 - KAP) * P_C - K_J * H            ! J/TIME, CHANGE IN MATURITY

      DAVELHS(1)=1.0D+00
      DAVELHS(2)=DV
      DAVELHS(3)=DE
      DAVELHS(4)=DL
      DAVELHS(5)=DH

      RETURN
      END