       SUBROUTINE DEB_HOLO(HOUR)

C     NICHEMAPR: SOFTWARE FOR BIOPHYSICAL MECHANISTIC NICHE MODELLING

C     COPYRIGHT (C) 2018 MICHAEL R. KEARNEY AND WARREN P. PORTER

C     THIS PROGRAM IS FREE SOFTWARE: YOU CAN REDISTRIBUTE IT AND/OR MODIFY
C     IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
C     THE FREE SOFTWARE FOUNDATION, EITHER VERSION 3 OF THE LICENSE, OR (AT
C      YOUR OPTION) ANY LATER VERSION.

C     THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
C     WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
C     MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
C     GENERAL PUBLIC LICENSE FOR MORE DETAILS.

C     YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
C     ALONG WITH THIS PROGRAM. IF NOT, SEE HTTP://WWW.GNU.ORG/LICENSES/.

C     IMPLEMENTATION OF LLANDRES ET AL. (2015) DEB MODEL FOR INSECTS

      USE AACOMMONDAT
      IMPLICIT NONE

      EXTERNAL DGET_EEES,DGET_AELES,SOLOUT,DGET_ELH,DGET_AVELHS

      DOUBLE PRECISION WORK,RPAR,RTOL,ATOL,YY,XEND,X,VSTI
      INTEGER NDGL,NRDENS,LWORK,LIWORK,N,IOUT,ITOL,IPAR,IDID,IWORK
      PARAMETER (NDGL=5,NRDENS=5)
      PARAMETER (LWORK=8*NDGL+5*NRDENS+21,LIWORK=NRDENS+21)
      DIMENSION YY(NDGL),WORK(LWORK),IWORK(LIWORK),RTOL(1),
     &ATOL(1),VSTI(NDGL)
      DIMENSION RPAR(16),IPAR(13)
      
      DOUBLE PRECISION A1,A2,A3,A4,A4B,A5,A6,ACTHR,AMASS,ANDENS_DEB
      DOUBLE PRECISION ANNFOOD,AREF,ATOT,BREEDRAINTHRESH,BREEDTEMPTHRESH
      DOUBLE PRECISION BREF,CAUSEDEATH,CLUTCHA,CLUTCHB,CLUTCHENERGY
      DOUBLE PRECISION CLUTCHES,CLUTCHSIZE,CO2FLUX,CONTDEP,CONTH
      DOUBLE PRECISION CONTHOLE,CONTVOL,CONTW,CONTWET,CREF,CTMAX,CTMIN
      DOUBLE PRECISION CUMBATCH,CUMBATCH_INIT,CUMREPRO,CUMREPRO_INIT
      DOUBLE PRECISION CUMREPRO_TEMP,D_V,DAYLENGTHFINISH,DAYLENGTHSTART
      DOUBLE PRECISION DE_HDT,DEATHSTAGE,DEBFIRST,DEBQMET,DEBQMET_INIT
      DOUBLE PRECISION DEDT,DELTA_DEB,DELTAR,DEPSEL,DHSDS,DQDT,DRYFOOD
      DOUBLE PRECISION DSURVDT,DVDT,E_B_PRES,E_BABY,E_BABY_INIT
      DOUBLE PRECISION E_BABY1,E_EGG,E_G,E_H,E_H_INIT,E_H_PRES,E_H_START
      DOUBLE PRECISION E_HB,E_HE,E_HEGGS,E_HP,E_HPUP,E_HPUP_INIT
      DOUBLE PRECISION E_HPUP_PRES,E_INIT,E_INIT_BABY,E_M,E_M2,E_PRES
      DOUBLE PRECISION E_RJ,E_R_PRES,E_S_INIT,E_SCALED,E_TOT
      DOUBLE PRECISION ECTOINPUT,ED,EGGDRYFRAC,EGGSOIL,EH_BABY
      DOUBLE PRECISION EH_BABY_INIT,EH_BABY1,EMISAN,EPUP,EPUP_INIT
      DOUBLE PRECISION EPUP_PRES,ER,ER_OLD,E_S,E_S_PAST,E_S_PRES
      DOUBLE PRECISION E_SM,ETA_PA,ETAO,EXTREF,F,F12,F13,F14,F15
      DOUBLE PRECISION F16,F21,F23,F24,F25,F26,F31,F32,F41,F42,F51,F52
      DOUBLE PRECISION F61,FAECES,FATOSB,FATOSK,FECUNDITY,FLSHCOND
      DOUBLE PRECISION FLYMETAB,FLYSPEED,FLYTIME,FOOD,FOODLIM
      DOUBLE PRECISION FOODWATERCUR,FUNCT,G,GH2OMET,GH2OMET_INIT,GUTFILL
      DOUBLE PRECISION GUTFREEMASS,GUTFULL,H_A,H_AREF,HALFSAT,HRN,HS
      DOUBLE PRECISION HS_INIT,HS_PRES,J_M,J_O,JM_JO,JMCO2,JMCO2_GM
      DOUBLE PRECISION JMH2O,JMH2O_GM,JMNWASTE,JMNWASTE_GM,JMO2,JMO2_GM
      DOUBLE PRECISION JOJE,JOJE_GM,JOJP,JOJP_GM,JOJV,JOJV_GM,JOJX
      DOUBLE PRECISION JOJX_GM,K_JREF,K_M,KAP,KAP_G,KAP_R,KAP_V,KAP_X
      DOUBLE PRECISION KAP_X_P,K_EL,K_EV,KT_E,KT_EL,KT_EV,KT_J,KT_MDOT
      DOUBLE PRECISION L_B,L_J,L_J2,L_M,L_PRES,L_T,L_THRESH,L_W,L_WREPRO
      DOUBLE PRECISION LAMBDA,LAT,LENGTHDAY,LENGTHDAYDIR,LONGEV,M_V
      DOUBLE PRECISION MAXMASS,MINCLUTCH,MINED,MLO2,MLO2_INIT,MONMATURE
      DOUBLE PRECISION MONREPRO,MR_1,MR_2,MR_3,MU_AX,MU_E,MU_M,MU_N,MU_O
      DOUBLE PRECISION MU_P,MU_V,MU_X,NEWCLUTCH,NWASTE,O2FLUX
      DOUBLE PRECISION ORIG_CLUTCHSIZE,ORIG_E_SM,P_A,P_AM,P_AM_ACC,P_B
      DOUBLE PRECISION P_C,P_D,P_G,P_J,P_M,P_MREF,P_MV,P_R
      DOUBLE PRECISION P_X,P_XM_ACC,P_XMREF,PAS,PBS,PCS,PDS,PGS,PJS,PMS
      DOUBLE PRECISION PRS,PFEWAT,PHI,PHIMAX,PHIMIN,PI,POND_DEPTH
      DOUBLE PRECISION POTFREEMASS,PREVDAYLENGTH,PT_AM,PT_XM,Q,Q_INIT
      DOUBLE PRECISION Q_PRES,QCOND,QCONV,QIRIN,QIROUT,QMETAB,QRESP
      DOUBLE PRECISION QSEVAP,QSOL,QSOLAR,R,RAINDRINK,RAINFALL,RAINMULT
      DOUBLE PRECISION RELHUM,REPRO,REPRODENS,RESID,RH,RHO1_3,RHREF
      DOUBLE PRECISION RQ,S_G,S_J,SCALED_L,SIDEX,SIG,STAGE,STAGE_REC
      DOUBLE PRECISION SURVIV,SURVIV_INIT,SURVIV_PRES,T_A,T_A2,T_AH
      DOUBLE PRECISION T_AH2,T_AL,T_AL2,T_H,T_H2,T_L,T_L2,T_REF
      DOUBLE PRECISION TALOC,TB,TBASK,TC,TCORES,TCORR,TCORR2,TDIGPR
      DOUBLE PRECISION TEMERGE,TESTCLUTCH,TIME,TLUNG,TMAXPR,TMINPR,TPREF
      DOUBLE PRECISION TQSOL,TRANS1,TREF,TSKYC,TWATER,TWING,V,V_ACC
      DOUBLE PRECISION V_BABY,V_BABY_INIT,V_BABY1,V_INIT,V_INIT_BABY,V_M
      DOUBLE PRECISION V_PRES,VDOTREF,VOLD,VOLD_INIT,VOLD_PRES,VPUP
      DOUBLE PRECISION VPUP_INIT,VPUP_PRES,VTDOT,VTDOTJ,W_E,W_N,W_P,W_V
      DOUBLE PRECISION W_X,WETFOOD,WETGONAD,WETMASS,WETSTORAGE,WQSOL
      DOUBLE PRECISION X_FOOD,XX,YEX,YPX,YXE,ZFACT


      INTEGER AQUABREED,AQUASTAGE,AQUATIC,BATCH,BREEDACT,BREEDACTTHRES
      INTEGER BREEDING,BREEDTEMPCUM,BREEDVECT,CENSUS,COMPLETE,COMPLETION
      INTEGER CONTONLY,CONTYPE,COUNTDAY,COUNTER,CTKILL,CTMINCUM
      INTEGER CTMINTHRESH,DAYCOUNT,DEAD,DEADEAD,DEB1,DOY,F1COUNT,FEEDING
      INTEGER FIRSTDAY,FLIGHT,FLYER,FLYTEST,HOUR,I,INWATER,IYEAR
      INTEGER METAB_MODE,METAMORPH,NN,NYEAR,PHOTODIRF,PHOTODIRS
      INTEGER PHOTOFINISH,PHOTOSTART,PREGNANT,PREVDEAD,RAINHOUR
      INTEGER RESET,STAGES,STARTDAY,VIVIPAROUS,WAITING,WETMOD,WINGCALC
      INTEGER WINGMOD

      CHARACTER TRANST

      DIMENSION ACTHR(25),BREEDVECT(24),CUMBATCH(24),CUMREPRO(24)
      DIMENSION DEBFIRST(13),DEBQMET(24),DEPSEL(25),DRYFOOD(24)
      DIMENSION E_BABY1(24),E_H(24),E_HPUP(24),ECTOINPUT(125),ED(24)
      DIMENSION EGGSOIL(24),EH_BABY1(24),EPUP(24),E_S(24),ETAO(4,3)
      DIMENSION FAECES(24),FOOD(50),GH2OMET(24),HRN(25),HS(24),J_M(4)
      DIMENSION J_O(4),JM_JO(4,4),L_W(24),MLO2(24),MU_M(4),MU_O(4)
      DIMENSION NWASTE(24),PAS(24),PCS(24)
      DIMENSION PMS(24),PGS(24),PDS(24),PJS(24),PRS(24),PBS(24),Q(24)
      DIMENSION QSOL(25),REPRO(24),RH(25),RHREF(25),STAGE_REC(25)
      DIMENSION SURVIV(24),TCORES(25),TSKYC(25),V(24),V_BABY1(24)
      DIMENSION VOLD(24),VPUP(24),WETFOOD(24),WETGONAD(24),WETMASS(24)
      DIMENSION WETSTORAGE(24)

      DATA PI/3.14159265/

      COMMON/ACCEL/P_AM_ACC,V_ACC,P_XM_ACC,ER,L_J2
      COMMON/ARRHEN/T_A,T_AL,T_AH,T_L,T_H,T_REF
      COMMON/ARRHEN2/T_A2,T_AL2,T_AH2,T_L2,T_H2
      COMMON/BEHAV3/ACTHR
      COMMON/BODYTEMP/BREEDTEMPTHRESH,BREEDTEMPCUM
      COMMON/BREEDER/BREEDING,BREEDVECT
      COMMON/CONT/CONTH,CONTW,CONTVOL,CONTDEP,CONTHOLE,CONTWET,RAINMULT,
     & WETMOD,CONTONLY,CONTYPE,RAINHOUR
      COMMON/COUNTDAY/COUNTDAY,DAYCOUNT
      COMMON/CTMAXMIN/CTMAX,CTMIN,CTMINCUM,CTMINTHRESH,CTKILL
      COMMON/DAYSTORUN/NN
      COMMON/DEATH/CAUSEDEATH,DEATHSTAGE
      COMMON/DEBBABY/V_BABY,E_BABY,EH_BABY
      COMMON/DEBINIT1/V_INIT,E_INIT,CUMREPRO_INIT,CUMBATCH_INIT,
     & VOLD_INIT,VPUP_INIT,EPUP_INIT
      COMMON/DEBINIT2/E_S_INIT,Q_INIT,HS_INIT,P_MREF,VDOTREF,H_AREF,
     & E_BABY_INIT,V_BABY_INIT,EH_BABY_INIT,K_JREF,S_G,SURVIV_INIT,
     & HALFSAT,X_FOOD,E_HPUP_INIT,P_XMREF
      COMMON/DEBINPUT/DEBFIRST,ECTOINPUT
      COMMON/DEBMASS/ETAO,JM_JO
      COMMON/DEBMOD/V,ED,WETMASS,WETSTORAGE,WETGONAD,WETFOOD,O2FLUX,
     & CO2FLUX,CUMREPRO,HS,E_S,L_W,CUMBATCH,Q,V_BABY1,E_BABY1,
     & E_H,STAGE,EH_BABY1,GUTFREEMASS,SURVIV,VOLD,VPUP,EPUP,E_HPUP,
     & RAINDRINK,POTFREEMASS,PAS,PBS,PCS,PDS,PGS,PJS,PMS,PRS,CENSUS,
     & RESET,DEADEAD,STARTDAY,DEAD
      COMMON/DEBMOD2/REPRO,ORIG_CLUTCHSIZE,NEWCLUTCH,ORIG_E_SM,MINCLUTCH
      COMMON/DEBOUTT/FECUNDITY,CLUTCHES,MONREPRO,L_WREPRO,MONMATURE,
     & MINED,ANNFOOD,FOOD,LONGEV,COMPLETION,COMPLETE
      COMMON/DEBPAR1/CLUTCHSIZE,ANDENS_DEB,D_V,EGGDRYFRAC,W_E,MU_E,MU_V,
     & W_V,E_EGG,KAP_V,KAP_X,KAP_X_P,MU_X,MU_P,W_N,W_P,W_X,FUNCT,MU_N
      COMMON/DEBPAR2/ZFACT,KAP,E_G,KAP_R,DELTA_DEB,E_H_START,MAXMASS,
     & E_INIT_BABY,V_INIT_BABY,E_H_INIT,E_HB,E_HP,E_HEGGS,E_SM,LAMBDA,
     & BREEDRAINTHRESH,DAYLENGTHSTART,DAYLENGTHFINISH,LENGTHDAY,
     & LENGTHDAYDIR,PREVDAYLENGTH,LAT,CLUTCHA,CLUTCHB,E_HE,
     & AQUABREED,AQUASTAGE,PHOTODIRS,PHOTODIRF,
     & BREEDACTTHRES,METAMORPH,PHOTOSTART,PHOTOFINISH,BREEDACT,BATCH
      COMMON/DEBPAR3/METAB_MODE,STAGES,K_EL,K_EV
      COMMON/DEBPAR4/S_J,L_B,L_J,E_M2
      COMMON/DEBRESP/MLO2,GH2OMET,DEBQMET,MLO2_INIT,GH2OMET_INIT,
     & DEBQMET_INIT,DRYFOOD,FAECES,NWASTE
      COMMON/DEPTHS/DEPSEL,TCORES
      COMMON/DOYMON/DOY
      COMMON/EGGSOIL/EGGSOIL
      COMMON/ENVAR1/QSOL,RH,TSKYC,TIME,TALOC,TREF,RHREF,HRN
      COMMON/FLY/FLYTIME,FLYSPEED,FLYMETAB,FLIGHT,FLYER,FLYTEST
      COMMON/FUN1/QSOLAR,QIRIN,QMETAB,QRESP,QSEVAP,QIROUT,QCONV,QCOND
      COMMON/FUN2/AMASS,RELHUM,ATOT,FATOSK,FATOSB,EMISAN,SIG,FLSHCOND
      COMMON/GITRAC/PFEWAT,FOODWATERCUR
      COMMON/GUT/GUTFULL,GUTFILL,FOODLIM
      COMMON/POND/INWATER,AQUATIC,TWATER,POND_DEPTH,FEEDING
      COMMON/RAINFALL/RAINFALL
      COMMON/REPYEAR/IYEAR,NYEAR
      COMMON/REVAP1/TLUNG,DELTAR,EXTREF,RQ,MR_1,MR_2,MR_3,DEB1
      COMMON/STAGE_R/STAGE_REC,F1COUNT,COUNTER
      COMMON/TPREFR/TMAXPR,TMINPR,TDIGPR,TPREF,TBASK,TEMERGE
      COMMON/TREG/TC
      COMMON/USROPT/TRANST
      COMMON/VIVIP/VIVIPAROUS,PREGNANT
      COMMON/WINGFUN/RHO1_3,TRANS1,AREF,BREF,CREF,PHI,F21,F31,F41,F51,
     & SIDEX,WQSOL,PHIMIN,PHIMAX,TWING,F12,F32,F42,F52,F61,TQSOL,A1,A2,
     & A3,A4,A4B,A5,A6,F13,F14,F15,F16,F23,F24,F25,F26,WINGCALC,WINGMOD


C     INITIALISE VARIABLES
      PREVDEAD=0
      DEAD=0
      E_RJ=0.
      DEDT=0.
      DE_HDT=0.
      L_THRESH=0.
      VTDOTJ=0.
      PT_XM=0.
      E_M=0.
      ER_OLD=ER
      IPAR(1:13)=0
      RPAR(1:16)=0.0D0
      L_W(HOUR)=0.
      WETGONAD(HOUR)=0.
      WETSTORAGE(HOUR)=0.
      WETFOOD(HOUR)=0.
      WETMASS(HOUR)=0.
      VPUP(HOUR)=0.
      VOLD(HOUR)=0.
      MLO2(HOUR) = 0.
      O2FLUX = 0.
      CO2FLUX = 0.
      V(HOUR)=0.
      E_H(HOUR)=0.
      CUMREPRO(HOUR)=0.
      CUMBATCH(HOUR)=0.
      VPUP(HOUR)=0.
      VOLD(HOUR)=0.
      ED(HOUR)=0.
      HS(HOUR)=0.
      SURVIV(HOUR)=1.
      E_S(HOUR)=0.
      REPRODENS=0.
      PREVDEAD=DEAD
      P_M=0.
      P_R=0.
      P_A=0.
      P_G=0.
      P_J=0.
      P_B=0.
      KT_EL=0.

C     CHECK IF FIRST DAY OF SIMULATION
      IF((DAYCOUNT.EQ.1).AND.(HOUR.EQ.1))THEN
       FIRSTDAY=1
      ELSE
       FIRSTDAY=0
      ENDIF
      
C     RESET CLUTCH SIZE AND MAXIMUM STOMACH ENERGY CONTENT (LATTER MAY BE REDUCED IF VIVIPAROUS)
      IF((HOUR.EQ.1).AND.(DAYCOUNT.EQ.1))THEN
       ORIG_CLUTCHSIZE=CLUTCHSIZE
       ORIG_E_SM=E_SM
      ELSE
       CLUTCHSIZE = ORIG_CLUTCHSIZE
       E_SM=ORIG_E_SM
      ENDIF
      
C     IF(PHOTOSTART.EQ.5)THEN
C      LAMBDA=3./12.
C     ENDIF

C     CHECK IF DEAD OR SIMULATION STILL WAITING FOR START DAY TO OCCUR
      IF((DAYCOUNT.LT.STARTDAY).OR.((COUNTDAY.LT.STARTDAY).AND.
     &  (V_INIT.LE.3E-9)).OR.(DEADEAD.EQ.1))THEN
       DEAD=1
       GOTO 987
      ENDIF

      IF((DEAD.EQ.1).AND.(DEADEAD.EQ.0))THEN
       DO 11 I=1,24
        CUMREPRO(I)=0.
        CUMBATCH(I)=0.
11     CONTINUE
       DEAD=0
      ENDIF
      WAITING=0

C     CHECK IF FIRST DAY OF SIMULATION
      IF((HOUR.EQ.1).AND.(DAYCOUNT.EQ.1))THEN
       ORIG_CLUTCHSIZE=CLUTCHSIZE
       ORIG_E_SM=E_SM
      ELSE
       IF(PREGNANT.EQ.0)THEN
        CLUTCHSIZE = ORIG_CLUTCHSIZE
        E_SM=ORIG_E_SM
       ENDIF
      ENDIF

      IF(DAYCOUNT.LT.STARTDAY)THEN
         DEAD=1
       GOTO 987
      ENDIF

      IF(RESET.EQ.STAGES+1)THEN
        IF(FECUNDITY.GT.1)THEN
        COMPLETE = 1
        GOTO 987
        ENDIF
      ENDIF

C     CHECK IF START OF A NEW DAY
      IF((HOUR.EQ.1).OR.((PREVDEAD.EQ.1).AND.(RESET.GT.0)))THEN
       V_PRES = V_INIT
       E_PRES = E_INIT
       E_S_PRES = E_S_INIT
       !ER = 0.
       IF((DAYCOUNT.EQ.1).OR.(PREVDEAD.EQ.1))THEN
        MINED = E_PRES
       ENDIF
       E_H_PRES = E_H_INIT
       Q_PRES = Q_INIT
       HS_PRES = HS_INIT
       SURVIV_PRES = SURVIV_INIT
       VOLD_PRES = VOLD_INIT
       VPUP_PRES = VPUP_INIT
       EPUP_PRES = EPUP_INIT
       E_HPUP_PRES = E_HPUP_INIT
       E_R_PRES = CUMREPRO_INIT
       E_B_PRES = CUMBATCH_INIT
      ELSE
       V_PRES = V(HOUR-1)
       E_PRES = ED(HOUR-1)
       E_S_PRES = E_S(HOUR-1)
       E_H_PRES = E_H(HOUR-1)
       Q_PRES = Q(HOUR-1)
       HS_PRES = HS(HOUR-1)
       SURVIV_PRES = SURVIV(HOUR-1)
       VOLD_PRES = VOLD(HOUR-1)
       VPUP_PRES = VPUP(HOUR-1)
       EPUP_PRES = EPUP(HOUR-1)
       E_HPUP_PRES = E_HPUP(HOUR-1)
       E_R_PRES = CUMREPRO(HOUR-1)
       E_B_PRES = CUMBATCH(HOUR-1)
      ENDIF

C     LENGTH IN MM
      L_W(HOUR) = V_PRES**(1./3.)/DELTA_DEB*10.
      
C     FOR SIZE-DEPENDENT CLUTCH
      IF((CLUTCHA.GT.0.).AND.(PREGNANT.EQ.0))THEN ! MAKE SURE CLUTCH SIZE DOESN'T INCREASE DURING PREGNANCY BECAUSE OTHERWISE GET JUMP UP IN MASS OF GONAD
       CLUTCHSIZE=FLOOR(CLUTCHA*(L_W(HOUR)/10.)-CLUTCHB)
      ENDIF
      IF(CLUTCHSIZE.GT.ORIG_CLUTCHSIZE)THEN
       CLUTCHSIZE=ORIG_CLUTCHSIZE
      ENDIF

C     SET BODY TEMPERATURE
      TB = MIN(CTMAX, TC) ! DON'T LET IT GO TOO HIGH

      IF((AQUABREED.EQ.1).OR.(AQUABREED.EQ.2))THEN
C      CONTDEP=POND_ENV(IYEAR,COUNTDAY,HOUR,2)
C      TB=POND_ENV(IYEAR,COUNTDAY,HOUR,1)
      ENDIF

C     IF RUNNING AN AQUATIC INSECT, CHECK IF TERRESTRIAL BREEDER AND SET TB TO SOIL TEMP
      IF(STAGE.EQ.0)THEN
       IF(AQUABREED.EQ.2)THEN
        TB = EGGSOIL(HOUR)
       ENDIF
      ENDIF

C     ARRHENIUS TEMPERATURE CORRECTION FACTOR 5 PARAMETERS

C     ARRHENIUS TEMPERATURE CORRECTION FACTOR
C       TCORR = EXP(T_A*(1/(273.15+T_REF)-1/(273.15+TB)))/(1+EXP(T_AL ! EQUATION FROM ORIGINAL SCHOOLFIELD PAPER
C     & *(1/(273.15+TB)-1/T_L))+EXP(T_AH*(1/T_H-1/(273.15+TB))))
       TCORR = EXP(T_A/(273.15+T_REF)-T_A/(273.15+TB))*((1+EXP(T_AL/ ! THIS VERSION ALLOWS K_REF TO VARY FROM WHAT IS SPECIFIED AS A PARAMETER (USED IN DEBTOOL)
     &(273.15+T_REF)-T_AL/T_L)+EXP(T_AH/T_H-T_AH/(273.15+T_REF)))/(1+EXP
     &(T_AL/(273.15+TB)-T_AL/T_L)+EXP(T_AH/T_H-T_AH/(273.15+TB))))
       TCORR2 = EXP(T_A2/(273.15+T_REF)-T_A2/(273.15+TB))*((1+EXP( ! THIS VERSION ALLOWS K_REF TO VARY FROM WHAT IS SPECIFIED AS A PARAMETER (USED IN DEBTOOL)
     &T_AL2/(273.15+T_REF)-T_AL2/T_L2)+EXP(T_AH2/T_H2-T_AH2/(273.15+
     &T_REF)))/(1+EXP(T_AL2/(273.15+TB)-T_AL2/T_L2)+EXP(T_AH2/T_H2-
     &T_AH2/(273.15+TB))))
     
*********************************************************************
C      TCORR=1
C      FEEDING=1
*********************************************************************

C     FOOD DENSITY
      X_FOOD = FOODLEVELS(DAYCOUNT)

      IF(FOODWATERCUR.EQ.0.)THEN
       XX=0.
       FUNCT=0.
      ELSE
       XX = 1.
       FUNCT=1.
      ENDIF
      ! OPTION FOR SPECIFIC LIFE STAGES TO NOT BE FOOD LIMITED
      IF(INT(FOODLIM).EQ.0)THEN
       FUNCT=1.
       X_FOOD = HALFSAT*10000.
       XX = 1.
      ENDIF
      IF(PREGNANT.EQ.1)THEN
C      F=0.7
       F=1
       LAMBDA=LAMBDA-1./(24.*365.)
       IF(LAMBDA.LT.0.1)THEN
        LAMBDA=0.1
       ENDIF
      ELSE
       F=1
      ENDIF

C     TEMPERATURE CORRECTIONS AND COMPOUND PARAMETERS
      M_V = D_V/W_V
      P_MV = P_MREF*TCORR
      K_M = P_MREF/E_G
      KT_MDOT = K_M*TCORR
      KT_J = K_JREF*TCORR2
      P_AM = P_MREF*ZFACT/KAP
      PT_AM = P_AM*TCORR
      PT_XM = P_XMREF*TCORR
      VTDOT = VDOTREF*TCORR
      H_A = H_AREF*TCORR
      E_M = PT_AM/VTDOT
      KT_EV = K_EV*TCORR
      KT_EL = VTDOTJ/L_J2
      
C     IF NOT PUPATED YET, STRUCTURE IS LARVAL STRUCTURE 'VOLD'
      IF(STAGE.LT.(STAGES-2))THEN
       V_PRES=VOLD_PRES
      ENDIF

C     ACCELERATION CHECK
      IF(STAGE.GE.STAGES-2)THEN
C      PUPA OR IMAGO, KEEP WITH NEW ACCELERATED VALUES
       VTDOTJ = V_ACC*TCORR
       PT_AM = P_AM_ACC*TCORR
       PT_XM = P_XM_ACC*TCORR
       E_M = PT_AM/VTDOTJ
      ENDIF
      IF(STAGE.EQ.0)THEN
C      EMBRYO, USE NON-ACCELEARTED VALUES
       VTDOT = VDOTREF*TCORR
       PT_AM = P_AM*TCORR
       PT_XM = P_XMREF*TCORR
       E_M = PT_AM/VTDOT
      ENDIF

      KT_E = VDOTREF*TCORR/L_B
      L_T = 0.
      L_PRES = V_PRES**(1./3.)
      E_SCALED=E_PRES/E_M
      G = E_G/(KAP*(P_AM/VDOTREF))
      L_M = VDOTREF/ K_M/ G
      V_M=L_M**3.
      SCALED_L = L_PRES/L_M
      KAP_G = (D_V*MU_V)/(W_V*E_G)
      YEX=KAP_X*MU_X/MU_E
      YXE=1/YEX
      YPX=KAP_X_P*MU_X/MU_P
      MU_AX=MU_E/YXE
      ETA_PA=YPX/MU_AX
      P_A = V_PRES**(2./3.)*PT_AM*F

      IF(STAGE.EQ.0)THEN
C      EGG, USE MATURITY AT BIRTH
       L_THRESH = E_HB
      ENDIF
      IF(STAGE.EQ.STAGES-2)THEN
C       PUPA, USE MATURITY AT ECLOSION
        L_THRESH = E_HE
      ENDIF

C     FINAL CRITICAL WEIGHT THRESHOLD
      E_RJ=S_J*((1-KAP)*(P_AM/VDOTREF)*G*(((VDOTREF/L_B)+K_M)/
     &((VDOTREF/L_B)-G*K_M)))
      
      IF((STAGE.GT.0).AND.(STAGE.LT.STAGES-3))THEN
C      LARVA, USE CRITICAL LENGTH THRESHOLDS
       L_THRESH=L_INSTAR(INT(STAGE))
      ENDIF
      IF(STAGE.EQ.(STAGES-3))THEN
C      LAST LARVAL INSTAR, USE FINAL CRITICAL WEIGHT THRESHOLD [ERJ]
       L_THRESH=E_RJ
      ENDIF

      IF(AQUABREED.EQ.1)THEN
       IF(CONTDEP.LE.0.1)THEN
        DEAD=1
        IF(STAGE.GT.DEATHSTAGE)THEN
         CAUSEDEATH=6. ! POND DRIED OUT
         DEATHSTAGE=STAGE
        ENDIF
       ENDIF
      ENDIF

C     CALL SUBROUTINE THAT ASSESSES PHOTOPERIOD CUES ON BREEDING
      CALL BREED(DOY,PHOTOSTART,PHOTOFINISH,LENGTHDAY
     &,DAYLENGTHSTART,DAYLENGTHFINISH,PHOTODIRS,PHOTODIRF,PREVDAYLENGTH,
     &LAT,FIRSTDAY,BREEDACT,BREEDACTTHRES,HOUR,
     &BREEDTEMPTHRESH,BREEDTEMPCUM,DAYCOUNT,DEAD,PREVDEAD,ACTHR(HOUR))

C     CALL SUBROUTINE THAT ASSESSES IF USER WANTS CUMULATIVE RESETS OF DEVELOPMENT AFTER METAMORPHOSIS
      CALL DEVRESET(DEAD,E_H_PRES,E_HB,AQUABREED,BREEDING,CONTDEP,
     &STAGE,AQUASTAGE,RESET,COMPLETE,WAITING,HOUR,STAGES,COMPLETION)

C     NOW CHECKING TO SEE IF STARTING WITH EMBRYO, AND IF SO SETTING THE APPROPRIATE RESERVE DENSITY
      IF(HOUR.EQ.1)THEN
       IF(DAYCOUNT.EQ.1)THEN
        IF(STAGE.EQ.0)THEN
         E_PRES=E_INIT
        ENDIF
       ENDIF
C     CHECKING TO SEE IF ANIMAL DIED RECENTLY AND NEEDS TO START AGAIN AS AN EMBRYO
       IF((DAYCOUNT.GT.1).AND.(DEAD.EQ.1))THEN
        IF(STAGE.EQ.0)THEN
         IF(V_PRES.EQ.0)THEN
          E_PRES=0.
         ELSE
          E_PRES=E_EGG/V_PRES
         ENDIF
        ENDIF
       ENDIF
      ENDIF

C     SETTING UP CALL TO DOPRI INTEGRATOR

      IF(STAGE.EQ.0)THEN
C      EMBRYO
C ---  DIMENSION OF THE SYSTEM
       N=NDGL
C ---  OUTPUT ROUTINE (AND DENSE OUTPUT) IS USED DURING INTEGRATION
       IOUT=0
C ---  INITIAL VALUES AND ENDPOINT OF INTEGRATION
       RPAR(1)=DBLE(F)
       RPAR(2)=DBLE(KT_MDOT)
       RPAR(3)=DBLE(VTDOT)
       RPAR(4)=DBLE(KT_J)
       RPAR(5)=DBLE(E_M)
       RPAR(6)=DBLE(G)
       RPAR(7)=DBLE(KAP)
       RPAR(8)=DBLE(E_G)
       RPAR(9)=DBLE(P_MV)
       RPAR(10)=DBLE(PT_AM)
       RPAR(11)=DBLE(L_M)
       X=0.0D0
       YY(1)=0.0D0
       YY(2)=DBLE(E_PRES*VOLD_PRES)
       YY(3)=DBLE(L_PRES)
       YY(4)=DBLE(E_H_PRES)
       YY(5)=DBLE(E_H_PRES)
       XEND=1.D+00
C ---  REQUIRED (RELATIVE AND ABSOLUTE) TOLERANCE
       ITOL=0
       RTOL(1)=1.0D-3
       ATOL(1)=RTOL(1)
C ---  DEFAULT VALUES FOR PARAMETERS
       DO 13 I=1,20
        IWORK(I)=0
        WORK(I)=0.D0
  13   CONTINUE
       !LWORK=8*NDGL+5*NRDENS+21,LIWORK=NRDENS+21
C ---  DENSE OUTPUT IS USED FOR THE TWO POSITION COORDINATES 1 AND 2
       IWORK(5)=NRDENS
       IWORK(21)=1
       IWORK(22)=2
       IWORK(23)=3
       IWORK(24)=4
       IWORK(25)=5
C ---  CALL OF THE SUBROUTINE DOPRI5
       CALL DOPRI5(N,DGET_ELH,X,YY,XEND,RTOL,ATOL,ITOL,SOLOUT,IOUT,
     &  WORK,LWORK,IWORK,LIWORK,RPAR,IPAR,IDID,VSTI)
       L_PRES=YY(3)
       V_PRES=L_PRES**3.
       E_PRES=YY(2)/V_PRES
       ED(HOUR)=E_PRES
       E_H_PRES=YY(4)
       E_H(HOUR)=E_H_PRES
       E_SCALED=E_PRES/E_M
       VOLD(HOUR)=V_PRES
       V(HOUR)=V_PRES
       P_B=0.
       P_M=P_MV*V_PRES
       P_A=0.
       R=VTDOT*(E_SCALED/L_PRES-(1+L_T/L_PRES)/L_M)/(E_SCALED+G)
       P_C=E_PRES*(VTDOT/L_PRES-R)*V_PRES ! J / t, mobilisation rate, equation 2.12 DEB3
       P_G=KAP*P_C-P_M
       P_J=E_H_PRES*KT_J
       P_R=(1-KAP)*P_C-P_J
      ENDIF
C      WRITE(*,*) YY(1:4), TB

      IF((STAGE.GT.0).AND.(STAGE.LT.(STAGES-2)))THEN
C      LARVA
       E_M=(P_AM/VDOTREF)
       G=E_G/(KAP*E_M)
       P_J=E_H_PRES*KT_J

C      SETTING UP CALL TO DOPRI INTEGRATOR

C ---  DIMENSION OF THE SYSTEM
       N=NDGL
C ---  OUTPUT ROUTINE (AND DENSE OUTPUT) IS USED DURING INTEGRATION
       IOUT=0
C ---  INITIAL VALUES AND ENDPOINT OF INTEGRATION
       RPAR(1)=DBLE(F)
       RPAR(2)=DBLE(KT_MDOT)
       RPAR(3)=DBLE(KT_E)
       RPAR(4)=DBLE(P_J)
       RPAR(5)=DBLE((P_MREF*ZFACT/KAP)/L_B*TCORR)
       RPAR(6)=DBLE(E_M)
       RPAR(7)=DBLE(G)
       RPAR(8)=DBLE(KAP)
       RPAR(9)=DBLE(PT_XM/L_B)
       RPAR(10)=DBLE(X_FOOD)
       RPAR(11)=DBLE(HALFSAT)
       IF((TB .GE. TMINPR) .AND. (TB .LE. TMAXPR))THEN
        IF((AQUATIC.EQ.1).AND.(FEEDING.EQ.0))THEN
         RPAR(12)=0.0D0
        ELSE
         IF(ACTHR(HOUR).GT. 1)THEN
          RPAR(12)=1.0D0
         ELSE
          RPAR(12)=0.0D0
         ENDIF
        ENDIF
       ELSE
        RPAR(12)=0.0D0
       ENDIF
       RPAR(13)=DBLE(KAP_X)
       RPAR(14)=DBLE(E_SM)
       X=0.0D0
       YY(1)=0.0D0
       YY(2)=DBLE(E_PRES*VOLD_PRES)
       YY(3)=DBLE(L_PRES)
       YY(4)=DBLE(ER_OLD*VOLD_PRES)
       YY(5)=DBLE(E_S_PRES)
       XEND=1.D+00
C ---  REQUIRED (RELATIVE AND ABSOLUTE) TOLERANCE
       ITOL=0
       RTOL(1)=1.0D-3
       ATOL(1)=RTOL(1)
C ---  DEFAULT VALUES FOR PARAMETERS
       DO 10 I=1,20
        IWORK(I)=0
        WORK(I)=0.D0
  10   CONTINUE
       !LWORK=8*NDGL+5*NRDENS+21,LIWORK=NRDENS+21
C ---  DENSE OUTPUT IS USED FOR THE TWO POSITION COORDINATES 1 AND 2
       IWORK(5)=NRDENS
       IWORK(21)=1
       IWORK(22)=2
       IWORK(23)=3
       IWORK(24)=4
       IWORK(25)=5
C ---  CALL OF THE SUBROUTINE DOPRI5
       CALL DOPRI5(N,DGET_AELES,X,YY,XEND,RTOL,ATOL,ITOL,SOLOUT,IOUT,
     &  WORK,LWORK,IWORK,LIWORK,RPAR,IPAR,IDID,VSTI)
       VOLD_PRES=YY(3)**3.
       ER_OLD=YY(4)/YY(3)**3.
       E_PRES=YY(2)/VOLD_PRES
       ED(HOUR)=E_PRES
       E_S(HOUR)=YY(5)
       CUMREPRO(HOUR)=YY(4)
       IF(E_S(HOUR).GT.E_SM*VOLD_PRES)THEN
        RESID=E_S(HOUR)-E_SM*VOLD_PRES
        E_S(HOUR)=E_SM*VOLD_PRES
       ENDIF
       E_SCALED=E_PRES/E_M
       ER=ER_OLD
       DE_HDT=0.
       E_H(HOUR)=E_H_PRES
       P_B=0.
       VOLD(HOUR)=VOLD_PRES
       V(HOUR)=VOLD_PRES
       R=(E_SCALED*KT_E-G*KT_MDOT)/(E_SCALED+G)
       P_C=(E_PRES*VOLD_PRES)*(KT_E-R)
       P_J=KT_J*E_HB
       P_M=P_MV*VOLD_PRES
       P_G=KAP*P_C-P_M
       P_R=(1-KAP)*P_C-P_J
       P_A=VOLD_PRES*(P_MREF*ZFACT/KAP)/L_B*TCORR*F ! NOTE MULTPLYING BY V AND DIVIDING BY L_B WHICH IS THE SAME AS MULT BY V^2/3 AND BY L/L_b
       
       IF(ER_OLD.LT.E_RJ)THEN
        V_ACC = VDOTREF*(VOLD_PRES**(1./3.)/L_B)
        P_AM_ACC = (P_MREF*ZFACT/KAP)*(VOLD_PRES**(1./3.)/L_B)
        P_XM_ACC = P_XMREF*(VOLD_PRES**(1./3.)/L_B)
        VTDOT = V_ACC*TCORR
        PT_AM = P_AM_ACC*TCORR
        PT_XM = P_XM_ACC*TCORR
C       KEEP TRACK OF LENGTH AT END OF ACCELERATION
        E_M = P_AM_ACC/V_ACC
        V_M=(KAP*PT_AM/P_MV)**(3.)
        L_M = V_M**(1./3.)
        L_J2 = VOLD_PRES**(1./3.)
       ENDIF
      ENDIF

      IF(STAGE.EQ.(STAGES-2))THEN
C      PUPA

C      SETTING UP CALL TO DOPRI INTEGRATOR
C ---  DIMENSION OF THE SYSTEM
       N=NDGL
C ---  OUTPUT ROUTINE (AND DENSE OUTPUT) IS USED DURING INTEGRATION
       IOUT=0
C ---  INITIAL VALUES AND ENDPOINT OF INTEGRATION
       RPAR(1)=DBLE(F)
       RPAR(2)=DBLE(KT_EV)
       RPAR(3)=DBLE(VTDOTJ)
       !RPAR(3)=DBLE(VTDOT)
       RPAR(4)=DBLE(E_M)
       RPAR(5)=DBLE(G)
       RPAR(6)=DBLE(KAP)
       RPAR(7)=DBLE(KAP_V)
       RPAR(8)=DBLE(KT_J)
       RPAR(9)=DBLE(L_M)
       X=0.0D0
       YY(1)=0.0D0
       YY(2)=DBLE(VOLD_PRES)
       !YY(3)=DBLE((E_PRES+ER)*VPUP_PRES)
       !YY(3)=DBLE(E_PRES*VPUP_PRES+CUMREPRO_INIT)
       YY(3)=DBLE(E_PRES*VPUP_PRES)
       YY(4)=DBLE(VPUP_PRES**(1./3.))
       YY(5)=DBLE(E_H_PRES)
       XEND=1.D+00
C ---  REQUIRED (RELATIVE AND ABSOLUTE) TOLERANCE
       ITOL=0
       RTOL(1)=1.0D-3
       ATOL(1)=RTOL(1)
C ---  DEFAULT VALUES FOR PARAMETERS
       DO 12 I=1,20
        IWORK(I)=0
        WORK(I)=0.D0
  12   CONTINUE
       !LWORK=8*NDGL+5*NRDENS+21,LIWORK=NRDENS+21
C ---  DENSE OUTPUT IS USED FOR THE TWO POSITION COORDINATES 1 AND 2
       IWORK(5)=NRDENS
       IWORK(21)=1
       IWORK(22)=2
       IWORK(23)=3
       IWORK(24)=4
       IWORK(25)=5
C ---  CALL OF THE SUBROUTINE DOPRI5
       CALL DOPRI5(N,DGET_AVELHS,X,YY,XEND,RTOL,ATOL,ITOL,SOLOUT,IOUT,
     &  WORK,LWORK,IWORK,LIWORK,RPAR,IPAR,IDID,VSTI)
       E_TOT=YY(3)
       E_PRES=YY(3)/YY(4)**3.
       CUMREPRO(HOUR)=CUMREPRO_INIT
       VOLD_PRES=YY(2)
       VPUP_PRES=YY(4)**3.
       ED(HOUR)=E_PRES
       E_H_PRES=YY(5)
       E_H(HOUR)=E_H_PRES
       E_SCALED=E_PRES/E_M
       VOLD(HOUR)=VOLD_PRES
       VPUP(HOUR)=VPUP_PRES
       V(HOUR)=VOLD_PRES+VPUP_PRES
C      IF(E_H_PRES.GE.E_HEGGS)THEN ! EGG PRODUCTION DURING PUPA
C       P_B=KT_E*CUMREPRO(HOUR)
C      ENDIF
       P_B=0.
       R=VTDOTJ*(E_SCALED/VPUP_PRES**(1./3.)-1.D+00/L_M)/(E_SCALED+G)    ! 1/TIME, SPECIFIC GROWTH RATE
       P_C=E_TOT*(VTDOTJ/VPUP_PRES**(1./3.)-R)                        ! J/TIME, MOBILISATION RATE       
       P_M=P_MV*VPUP_PRES
       P_A=0.
       P_G=KAP*P_C-P_MV*VPUP_PRES
       P_J=KT_J*E_H_PRES
       P_R=(1-KAP)*P_C-P_J
      ENDIF

      IF(STAGE.GE.(STAGES-1))THEN
C      IMAGO
C      SETTING UP CALL TO DOPRI INTEGRATOR
       E_M=(P_AM/VDOTREF)
       G=E_G/(KAP*E_M)
       P_J=E_H_PRES*KT_J
       !P_A=V_PRES**(2./3.)*P_AM_ACC*TCORR*F
       P_A=V_PRES**(2./3.)*P_AM*TCORR*F
       P_M=V_PRES*P_MV
C ---  DIMENSION OF THE SYSTEM
       N=NDGL
C ---  OUTPUT ROUTINE (AND DENSE OUTPUT) IS USED DURING INTEGRATION
       IOUT=0
C ---  INITIAL VALUES AND ENDPOINT OF INTEGRATION
       RPAR(1)=DBLE(F)
       RPAR(2)=DBLE(V_ACC*TCORR/L_J2)
       RPAR(3)=DBLE(P_J)
       RPAR(4)=DBLE(P_AM_ACC*TCORR)
       !RPAR(4)=DBLE(P_AM*TCORR)
       RPAR(5)=DBLE(P_M)
       RPAR(6)=DBLE(P_A)
       RPAR(7)=DBLE(KAP)
       RPAR(8)=DBLE(P_XM_ACC*TCORR)
       !RPAR(8)=DBLE(PT_XM*TCORR)
       RPAR(9)=DBLE(X_FOOD)
       RPAR(10)=DBLE(HALFSAT)
       IF((TB .GE. TMINPR) .AND. (TB .LE. TMAXPR))THEN
        IF((AQUATIC.EQ.1).AND.(FEEDING.EQ.0))THEN
         RPAR(11)=0.0D0
        ELSE
         IF(ACTHR(HOUR).GT. 1)THEN
          RPAR(11)=1.0D0
         ELSE
          RPAR(11)=0.0D0
         ENDIF
        ENDIF
       ELSE
        RPAR(11)=0.0D0
       ENDIF
       RPAR(12)=DBLE(KAP_X)
       RPAR(13)=DBLE(KAP_R)
       RPAR(14)=DBLE(V_PRES)
       RPAR(15)=DBLE(E_SM)
       IPAR(1)=INT(BREEDING)
       X=0.0D0
       YY(1)=0.0D0
       YY(2)=DBLE(E_PRES*V_PRES)
       YY(3)=DBLE(E_R_PRES)
       YY(4)=DBLE(E_B_PRES)
       YY(5)=DBLE(E_S_PRES)
       XEND=1.D+00
C ---  REQUIRED (RELATIVE AND ABSOLUTE) TOLERANCE
       ITOL=0
       RTOL(1)=1.0D-3
       ATOL(1)=RTOL(1)
C ---  DEFAULT VALUES FOR PARAMETERS
       DO 15 I=1,20
        IWORK(I)=0
        WORK(I)=0.D0
  15   CONTINUE
       !LWORK=8*NDGL+5*NRDENS+21,LIWORK=NRDENS+21
C ---  DENSE OUTPUT IS USED FOR THE TWO POSITION COORDINATES 1 AND 2
       IWORK(5)=NRDENS
       IWORK(21)=1
       IWORK(22)=2
       IWORK(23)=3
       IWORK(24)=4
       IWORK(25)=5
C ---  CALL OF THE SUBROUTINE DOPRI5
       CALL DOPRI5(N,DGET_EEES,X,YY,XEND,RTOL,ATOL,ITOL,SOLOUT,IOUT,
     &  WORK,LWORK,IWORK,LIWORK,RPAR,IPAR,IDID,VSTI)
       !E_PRES=min(E_M2/V_PRES,YY(2)/V_PRES)
       E_PRES=min(E_M,YY(2)/V_PRES)
       CUMREPRO(HOUR)=YY(3)
       CUMBATCH(HOUR)=max(0.0D0,YY(4))
       !ER=YY(3)/V_PRES
       !E_B=YY(4)
       V(HOUR)=V_PRES
       VPUP(HOUR)=V_PRES
       ED(HOUR)=E_PRES
       E_H(HOUR)=E_HE
       E_S(HOUR)=MAX(0.,YY(5))
       IF(E_S(HOUR).GT.E_SM*VOLD_PRES)THEN
        RESID=E_S(HOUR)-E_SM*VOLD_PRES
        E_S(HOUR)=E_SM*VOLD_PRES
       ENDIF       
       ! POWERS
       P_C=(E_PRES*V_PRES)*V_ACC*TCORR/L_J2
       P_J=KT_J*E_HE
       P_M=P_MV*V_PRES ! MAINTENANCE POWER
       P_A=V_PRES**(2./3.)*P_AM_ACC*TCORR*F
       IF(YY(2)/V_PRES.GT.E_M)THEN ! CUT P_A DOWN TO P_C BECAUSE RESERVE AT STEADY STATE VALUE
        P_A = P_C
       ENDIF
       IF(BREEDING.EQ.1)THEN
        P_B=max(0.0D0,KAP_R*YY(3)*V_ACC*TCORR/L_J2)
       ELSE
        P_B=0.
       ENDIF
       P_R=P_C-P_M-P_J-P_B
       P_G=0.
       VOLD(HOUR)=VOLD_PRES
       VPUP(HOUR)=VPUP_PRES
      ENDIF

C      IF(AEST.EQ.1)THEN
C      DVDT=0
C      R=0
C      ENDIF

      IF(CLUTCHSIZE.LT.1)THEN
       CLUTCHSIZE=1
      ENDIF
      CLUTCHENERGY = E_EGG*CLUTCHSIZE

C     DIAPAUSE BEFORE POND FILL
      IF(AQUABREED.EQ.1)THEN
       IF(STAGE.LT.STAGES-1)THEN
        IF(CONTDEP.LE.0.1)THEN
         DVDT=0.
        ENDIF
       ENDIF
      ENDIF

C     OTHER POWERS

C     J FOOD EATEN PER HOUR
      IF(ACTHR(HOUR).GT.1)THEN
       P_X = F * PT_XM * V_PRES**(2./3.)*((X_FOOD / HALFSAT)
     &  / (1. + X_FOOD / HALFSAT)) - RESID
      ELSE
       P_X = 0.
      ENDIF
C     TALLYING J FOOD EATEN PER YEAR
      FOOD(IYEAR)=FOOD(IYEAR)+P_X
C     TALLYING LIFETIME FOOD EATEN
      IF(IYEAR.EQ.NYEAR)THEN
       IF(HOUR.EQ.24)THEN
        DO 1 I=1,NYEAR
         ANNFOOD=ANNFOOD+FOOD(I)
1       CONTINUE
       ENDIF
      ENDIF

      IF((STAGE.GT.0).AND.(STAGE.NE.(STAGES-2)))THEN
       P_D = P_M+P_J+(1-KAP_R)*P_B ! LARVA OR IMAGO, ALLOCATE TO REPRODUCTION
      ELSE
       P_D = P_M+P_J+P_R ! EGG OR PUPA, ALL (1-KAP) TO MATURATION
      ENDIF

      IF(L_PRES.EQ.0)THEN
       R=0.
       DQDT=0.
      ELSE
       R=VTDOT*(E_SCALED/L_PRES-(1+L_T/L_PRES)/L_M)/
     &  (E_SCALED+G)
       DQDT=(Q_PRES*(V_PRES/V_M)*S_G+H_A)*(E_PRES/E_M)
     &  *((VTDOT/L_PRES)-R)-R*Q_PRES
      ENDIF

      IF(STAGE.GE.STAGES-1)THEN
       IF(HOUR.EQ.1)THEN
        Q(HOUR)=Q_INIT + DQDT
       ELSE
        Q(HOUR)=Q(HOUR-1)+DQDT
       ENDIF
      ELSE
       Q(HOUR)=0.
      ENDIF

C     DHSDS = H_A*Q(HOUR)/V_PRES
      DHSDS=Q_PRES-R*HS_PRES

      IF(STAGE.GE.STAGES-1)THEN
       IF(HOUR.EQ.1)THEN
        HS(HOUR)=HS_INIT+DHSDS
       ELSE
        HS(HOUR)=HS(HOUR-1)+DHSDS
       ENDIF
      ELSE
       HS(HOUR)=0.
      ENDIF

C     H_W = ((H_A*(E_PRES/E_M)*VTDOT)/(6.*V_PRES**(1./3.)))
C     &    **(1./3.)
C     SURVIV(HOUR) = EXP(-1*(H_W*((DAYCOUNT-1)*24+HOUR))**3)
      IF(STAGE.GE.STAGES-1)THEN
       DSURVDT=-1.*SURVIV_PRES*HS(HOUR)
      ELSE
       DSURVDT=0.
      ENDIF
      SURVIV(HOUR) = SURVIV_PRES+DSURVDT

      IF(COUNTDAY.EQ.365)THEN
       IF(HOUR.EQ.24)THEN
        SURV(IYEAR)=SURVIV(HOUR)
       ENDIF
      ENDIF

      IF(TC.LT.CTMIN)THEN
       CTMINCUM=CTMINCUM+1
      ELSE
       CTMINCUM=0
      ENDIF

C     AVERAGE LONGEVITY IN YEARS
      IF((LONGEV.EQ.0.).OR.(RESET.GT.0))THEN
C     IF((TB.LT.CTMIN).OR.(TB.GT.CTMAX))THEN
       IF(CTKILL.EQ.1)THEN
        IF((CTMINCUM.GT.CTMINTHRESH).OR.(TC.GT.CTMAX+2))THEN
         IF(RESET.GT.0)THEN
          DEAD=1
          IF(CTMINCUM.GT.CTMINTHRESH)THEN
           IF((STAGE.GT.DEATHSTAGE).AND.(V_PRES.NE.0))THEN
            CAUSEDEATH=1. ! COLD STRESS
            DEATHSTAGE=STAGE
            CTMINCUM=0
           ENDIF
          ELSE
           IF((STAGE.GT.DEATHSTAGE).AND.(V_PRES.NE.0))THEN
            CAUSEDEATH=2. ! HEAT STRESS
            DEATHSTAGE=STAGE
           ENDIF
          ENDIF
         ELSE
          IF(CTMINCUM.GT.CTMINTHRESH)THEN
           IF((STAGE.GT.DEATHSTAGE).AND.(V_PRES.NE.0))THEN
            CAUSEDEATH=1. ! COLD STRESS
            DEATHSTAGE=STAGE
            CTMINCUM=0
           ENDIF
          ELSE
           IF((STAGE.GT.DEATHSTAGE).AND.(V_PRES.NE.0))THEN
            CAUSEDEATH=2. ! HEAT STRESS
            DEATHSTAGE=STAGE
           ENDIF
          ENDIF
          SURVIV(HOUR)=0.49
          CENSUS=365
         ENDIF
        ENDIF
       ENDIF
       IF(SURVIV(HOUR).LT.0.5)THEN
        LONGEV=(REAL(DAYCOUNT,4)+REAL(HOUR)/24.)/365.
        IF(RESET.GT.0)THEN
C        NEED TO RESET UPON DEATH, SO DON'T LET DEADEAD=1
         DEAD=1
         SURVIV(HOUR)=1.
         IF((STAGE.GT.DEATHSTAGE).AND.(V_PRES.NE.0)
     &    .AND.(CAUSEDEATH.EQ.0))THEN
          CAUSEDEATH=5. ! OLD AGE
          DEATHSTAGE=STAGE
         ENDIF
        ELSE
         DEAD=1
         DEADEAD=1
         IF((STAGE.GT.DEATHSTAGE).AND.(V_PRES.NE.0)
     &    .AND.(CAUSEDEATH.EQ.0))THEN
          CAUSEDEATH=5. ! OLD AGE
          DEATHSTAGE=STAGE
         ENDIF
        ENDIF
       ENDIF
      ENDIF



      IF(VOLD(HOUR).LT.0)THEN
       VOLD(HOUR)=0.
      ENDIF
      IF(VPUP(HOUR).LT.0)THEN
       VPUP(HOUR)=0.
      ENDIF

C     SUM STRUCTURES
C      V(HOUR)=VPUP(HOUR)+VOLD(HOUR)

C     MAKE SURE ED DOESN'T GO BELOW ZERO
      IF(ED(HOUR).LT.0)THEN
       ED(HOUR)=0.
      ENDIF
C     FIND MIN VALUE OF ED FOR THE SIMULATION
      IF(ED(HOUR).LT.MINED)THEN
       MINED=ED(HOUR)
      ENDIF

C     LENGTH IN MM
      L_W(HOUR) = V(HOUR)**(1./3.)/DELTA_DEB*10.

C     TRANSITION BETWEEN STAGES FOR INSECT
      IF(STAGE.EQ.0)THEN
       IF(E_H(HOUR).GE.E_HB)THEN
        STAGE=STAGE+1.0D0 ! 1ST INSTAR
       ENDIF
      ELSE
       IF(STAGE.LT.STAGES-3)THEN
        IF(V_PRES**(1./3.).GT.L_THRESH)THEN
         STAGE=STAGE+1.0D0 ! INSTAR INCREMENT
        ENDIF
       ELSE
        IF(STAGE.EQ.STAGES-3)THEN
         IF(ER.GE.L_THRESH)THEN
          STAGE=STAGE+1.0D0 ! PUPATION
          E_H(HOUR)=0.
          VPUP(HOUR)=1E-4**3.
          ER=ER*V(HOUR)/VPUP(HOUR)
          ED(HOUR)=ED(HOUR)*V(HOUR)/VPUP(HOUR)
          E_M2=ED(HOUR)*VPUP(HOUR)
          V(HOUR)=VPUP(HOUR)+VOLD(HOUR)
         ENDIF
        ELSE
         IF(STAGE.EQ.(STAGES-2))THEN
          IF((E_H(HOUR)).GE.E_HE)THEN
           STAGE=STAGE+1.0D0 ! ECLOSION
           ED(HOUR)=(ED(HOUR)*V(HOUR)+KAP_V*VOLD(HOUR)*M_V*MU_E)/V(HOUR)! % J, convert last bit of larval structure to reserve instantaneously
          ENDIF
         ENDIF
        ENDIF
       ENDIF
      ENDIF
      IF(STAGE.GT.STAGES-1)THEN
       STAGE=STAGES-1.0D0
      ENDIF

      IF(CUMBATCH(HOUR).GT.0)THEN
       IF(MONMATURE.EQ.0)THEN
        MONMATURE=(REAL(COUNTDAY,8)+365.*(REAL(IYEAR,8)-1.))/30.5
       ENDIF
      ENDIF

      IF((CUMBATCH(HOUR).GT.CLUTCHENERGY).OR.(PREGNANT.EQ.1))THEN
C      FOR VARIABLE CLUTCH SIZE FROM REPRO AND BATCH BUFFERS
       IF(VIVIPAROUS.EQ.1)THEN
        IF((PREGNANT.EQ.0).AND.(BREEDING.EQ.1))THEN
         V_BABY=V_INIT_BABY
         E_BABY=E_INIT_BABY
         EH_BABY=0.
         PREGNANT=1
         TESTCLUTCH=FLOOR((CUMBATCH(HOUR))/E_EGG)
C        FOR VARIABLE CLUTCH SIZE FROM REPRO AND BATCH BUFFERS
         IF(TESTCLUTCH.GT.CLUTCHSIZE)THEN
          CLUTCHSIZE=TESTCLUTCH
          CLUTCHENERGY = E_EGG*CLUTCHSIZE
         ENDIF
C        FOR VARIABLE CLUTCH SIZE FROM REPRO AND BATCH BUFFERS
         IF(CUMBATCH(HOUR).LT.CLUTCHENERGY)THEN
C         NEEDS TO DRAW FROM REPRO BUFFER - TEMPORARILY STORE CURRENT REPRO AS CUMREPRO_TEMP,
C         THEN REMOVE WHAT IS NEEDED FROM THE REPRO BUFFER AND ADD IT TO THE BATCH BUFFER
          CUMREPRO_TEMP=CUMREPRO(HOUR)
          CUMREPRO(HOUR)=CUMREPRO(HOUR)+CUMBATCH(HOUR)-CLUTCHENERGY
          CUMBATCH(HOUR)=CUMBATCH(HOUR)+CUMREPRO_TEMP-CUMREPRO(HOUR)
         ENDIF
        ENDIF
        IF(HOUR.EQ.1)THEN
         V_BABY=V_BABY_INIT
         E_BABY=E_BABY_INIT
         EH_BABY=EH_BABY_INIT
        ENDIF
        IF(PREGNANT.EQ.1)THEN
         CALL DEB_BABY
        ENDIF
        IF(EH_BABY.GE.E_HB)THEN
         IF((TB .LT. TMINPR) .OR. (TB .GT. TMAXPR))THEN
          GOTO 898
         ENDIF
         CUMBATCH(HOUR) = CUMBATCH(HOUR)-CLUTCHENERGY
         REPRO(HOUR)=1
         PREGNANT=0
         V_BABY=V_INIT_BABY
         E_BABY=E_INIT_BABY
         EH_BABY=0.
         NEWCLUTCH=CLUTCHSIZE
         FEC(IYEAR)=FEC(IYEAR)+CLUTCHSIZE
         FECUNDITY=FECUNDITY+CLUTCHSIZE
         CLUTCHES=CLUTCHES+1
         IF(FECUNDITY.GE.CLUTCHSIZE)THEN
          MONREPRO=(COUNTDAY+365*(IYEAR-1))/30.5
          L_WREPRO=L_W(HOUR)
         ENDIF
         PREGNANT=0
        ENDIF
       ELSE
C       NOT VIVIPAROUS, SO LAY THE EGGS AT NEXT PERIOD OF ACTIVITY
        IF(BREEDRAINTHRESH.GT.0)THEN
         IF(FOODWATERCUR.LT.BREEDRAINTHRESH)THEN
          GOTO 898
         ENDIF
        ENDIF
        IF((AQUABREED.EQ.1).AND.(POND_DEPTH.LT.50.))THEN
          GOTO 898
         ENDIF
        IF((TB .LT. TMINPR) .OR. (TB .GT. TMAXPR))THEN
         GOTO 898
        ENDIF
C       CHANGE BELOW TO ACTIVE OR NOT ACTIVE RATHER THAN DEPTH-BASED, IN CASE OF FOSSORIAL
        IF((TB .LT. TMINPR) .OR. (TB .GT. TMAXPR))THEN
         GOTO 898
        ENDIF
         TESTCLUTCH=FLOOR(CUMBATCH(HOUR)/E_EGG)
         TESTCLUTCH=REAL(TESTCLUTCH,8)
        IF(TESTCLUTCH.GT.CLUTCHSIZE)THEN
         CLUTCHSIZE=TESTCLUTCH
        ENDIF
        CUMBATCH(HOUR)=CUMBATCH(HOUR)-CLUTCHENERGY
        REPRO(HOUR)=1
        NEWCLUTCH=CLUTCHSIZE
        FEC(IYEAR)=FEC(IYEAR)+CLUTCHSIZE
        FECUNDITY=FECUNDITY+CLUTCHSIZE
        CLUTCHES=CLUTCHES+1
        STAGE=STAGE+1.0D0
        IF(RESET.EQ.STAGES)THEN
         CENSUS=COUNTDAY
        ENDIF
        IF(FECUNDITY.GE.CLUTCHSIZE)THEN
         MONREPRO=(REAL(COUNTDAY,8)+365.*(REAL(IYEAR,8)-1))/30.5
         L_WREPRO=L_W(HOUR)
        ENDIF
       ENDIF
      ENDIF
      E_R_PRES=CUMREPRO(HOUR)
      E_B_PRES=CUMBATCH(HOUR)
898   CONTINUE

      IF((RESET.GT.0).AND.(RESET.NE.8))THEN
       FEC(IYEAR)=COMPLETION
      ENDIF

      IF(E_S(HOUR).GT.E_SM*V_PRES)THEN
       E_S(HOUR)=E_SM*V_PRES
      ENDIF

C     ENSURE GUT EMPTY IF ENTERING PUPAL PHASE
      IF(STAGE.EQ.STAGES-2)THEN
       E_S(HOUR)=0.
       E_S_PRES=0.
      ENDIF
      IF(V_PRES.LE.0.)THEN
       GUTFULL=0.
      ELSE
       GUTFULL=E_S_PRES/(E_SM*V_PRES)*100.
      ENDIF
      IF(GUTFULL.GT.100.)THEN
       GUTFULL=100.
      ENDIF
      E_S_PAST=E_S(HOUR)
      
      PAS(HOUR)=P_A
      PCS(HOUR)=P_C
      PMS(HOUR)=P_M
      PGS(HOUR)=P_G
      PDS(HOUR)=P_D
      PJS(HOUR)=P_J
      PRS(HOUR)=P_R
      PBS(HOUR)=P_B
      
C     MASS BALANCE

      ! MOLAR FLUXES OF FOOD, STRUCTURE, RESERVE AND FAECES (MOL/HOUR)
      JOJX=P_A*ETAO(1,1)+P_D*ETAO(1,2)+P_G*ETAO(1,3) 
      JOJV=P_A*ETAO(2,1)+P_D*ETAO(2,2)+P_G*ETAO(2,3)
      JOJE=P_A*ETAO(3,1)+P_D*ETAO(3,2)+P_G*ETAO(3,3)
      JOJP=P_A*ETAO(4,1)+P_D*ETAO(4,2)+P_G*ETAO(4,3)

      ! NON-ASSIMILATION (I.E. GROWTH AND MAINTENANCE) MOLAR FLUXES AS ABOVE
      JOJX_GM=P_D*ETAO(1,2)+P_G*ETAO(1,3)
      JOJV_GM=P_D*ETAO(2,2)+P_G*ETAO(2,3)
      JOJE_GM=P_D*ETAO(3,2)+P_G*ETAO(3,3)
      JOJP_GM=P_D*ETAO(4,2)+P_G*ETAO(4,3)

      ! MOLAR FLUXES OF 'MINERALS', CO2, H2O, O2 AND NITROGENOUS WASTE (MOL/H)
      JMCO2=JOJX*JM_JO(1,1)+JOJV*JM_JO(1,2)+JOJE*JM_JO(1
     &    ,3)+JOJP*JM_JO(1,4)
      JMH2O=JOJX*JM_JO(2,1)+JOJV*JM_JO(2,2)+JOJE*JM_JO(
     &    2,3)+JOJP*JM_JO(2,4)
      JMO2=JOJX*JM_JO(3,1)+JOJV*JM_JO(3,2)+JOJE*JM_JO
     &    (3,3)+JOJP*JM_JO(3,4)
      JMNWASTE=JOJX*JM_JO(4,1)+JOJV*JM_JO(4,2)+JOJE*
     &    JM_JO(4,3)+JOJP*JM_JO(4,4)

      RQ = JMCO2/JMO2 ! RESPIRATORY QUOTIENT

      ! NON-ASSLIMILATION MOLAR FLUXES OF 'MINERALS', CO2, H2O, O2 AND NITROGENOUS WASTE (MOL/H)
      JMCO2_GM=JOJX_GM*JM_JO(1,1)+JOJV_GM*JM_JO(1,2)
     & +JOJE_GM*JM_JO(1,3)+JOJP_GM*JM_JO(1,4)
      JMH2O_GM=JOJX_GM*JM_JO(2,1)+JOJV_GM*JM_JO(2,2)
     & +JOJE_GM*JM_JO(2,3)+JOJP_GM*JM_JO(2,4)
      JMO2_GM=JOJX_GM*JM_JO(3,1)+JOJV_GM*JM_JO(3,2)
     & +JOJE_GM*JM_JO(3,3)+JOJP_GM*JM_JO(3,4)
      JMNWASTE_GM=JOJX_GM*JM_JO(4,1)+JOJV_GM*JM_JO(4,2)
     & +JOJE_GM*JM_JO(4,3)+JOJP_GM*JM_JO(4,4)
C     MLO2/H, TEMPERATURE CORRECTED (INCLUDING SDA)

      IF(DEB1.EQ.1)THEN
       IF(ED(HOUR).NE.ED(HOUR))THEN
        ED(HOUR)=0.
        V(HOUR)=0.
        DEAD=1
       ENDIF
       IF(CUMBATCH(HOUR).NE.CUMBATCH(HOUR))THEN
        CUMBATCH(HOUR)=0.
       ENDIF
       IF(HS(HOUR).NE.HS(HOUR))THEN
        HS(HOUR)=0.
       ENDIF
       O2FLUX = -1*JMO2*(0.082058*(T_REF+273.15)*(TB+273.15)/
     &  (T_REF+273.15))*1000 ! ml/h at Tb and atmospheric pressure
      ELSE
C      SEND THE ALLOMETRIC VALUE TO THE OUTPUT FILE
       O2FLUX = 10.**(MR_3*TC)*MR_1*(AMASS*1000.)**MR_2 ! REGRESSION-BASED
      ENDIF
      CO2FLUX = JMCO2*(0.082058*(T_REF+273.15)*(TB+273.15)/
     &  (T_REF+273.15))*1000.

C     G METABOLIC WATER/H
      GH2OMET(HOUR) = JMH2O*18.01528
      
C     METABOLIC HEAT PRODUCTION (WATTS) - GROWTH OVERHEAD PLUS DISSIPATION POWER (MAINTENANCE, MATURITY MAINTENANCE,
C     MATURATION/REPRO OVERHEADS) PLUS ASSIMILATION OVERHEADS - CORRECT TO 20 DEGREES SO IT CAN BE TEMPERATURE CORRECTED
C     IN MET.F FOR THE NEW GUESSED TB
      DEBQMET(HOUR) = ((1-KAP_G)*P_G+P_D+(P_A/KAP_X-P_A-P_A*MU_P
     & *ETA_PA))/3600./TCORR   
      MU_O = (/MU_X, MU_V, MU_E, MU_P/) ! J/mol, chemical potentials of organics
      MU_M = (/0.D0, 0.D0, 0.D0, MU_N/)          ! J/mol, chemical potentials of minerals C: CO2, H: H2O, O: O2, N: nitrogenous waste
      J_O = (/JOJX, JOJV, JOJE, JOJP/) ! eta_O * diag(p_ADG(2,:)); # mol/d, J_X, J_V, J_E, J_P in rows, A, D, G in cols
      J_M = (/JMCO2, JMH2O, JMO2, JMNWASTE/) ! - (n_M\n_O) * J_O;        # mol/d, J_C, J_H, J_O, J_N in rows, A, D, G in cols
      DEBQMET(HOUR) = sum(-J_O * MU_O -J_M * MU_M)/3600./TCORR ! W         
   
      IF((STAGE.GT.0).OR.(STAGE.NE.STAGES-2))THEN ! ASSUME PUPAL STAGE CAN'T FEED
       DRYFOOD(HOUR)=-1.*JOJX*W_X ! DRY FOOD INTAKE (G)
      ELSE
       DRYFOOD(HOUR)=0.
      ENDIF
      FAECES(HOUR)=JOJP*W_P ! FAECES PRODUCTION (G)
      NWASTE(HOUR)=JMNWASTE*W_N ! NITROGENOUS WASTE PRODUCTION (G)
      WETGONAD(HOUR) = ((CUMREPRO(HOUR)/MU_E)*W_E)/EGGDRYFRAC ! REPRODUCTIVE WET BIOMASS (G)
     &+((CUMBATCH(HOUR)/MU_E)*W_E)/EGGDRYFRAC
      IF(STAGE.GT.STAGES-2)THEN
       WETSTORAGE(HOUR)=((((V(HOUR)-VOLD(HOUR))*ED(HOUR))/MU_E)*W_E)/D_V ! RESERVE WET MASS (G)
       VOLD(HOUR)=0.0D0 ! THIS RESET NEEDS TO GO HERE TO PREVENT INCORRECT MASS CALC ON TRANSITION TO IMAGO
      ELSE
       IF(STAGE.EQ.STAGES-2)THEN
        WETSTORAGE(HOUR)=((((V(HOUR)-VOLD(HOUR))*ED(HOUR))/MU_E)*W_E)
     &   /D_V ! RESERVE WET MASS (G)
       ELSE
        WETSTORAGE(HOUR)=(((V(HOUR)*ED(HOUR))/MU_E)*W_E)/D_V ! RESERVE WET MASS (G)
       ENDIF
      ENDIF
      WETFOOD(HOUR) = ((E_S(HOUR)/MU_E)*W_E)/(1-FOODWATERS(DAYCOUNT))
      WETMASS(HOUR) = V(HOUR)*ANDENS_DEB+WETGONAD(HOUR)+ ! TOTAL WET MASS (G)
     & WETSTORAGE(HOUR)+WETFOOD(HOUR)
      GUTFREEMASS=V(HOUR)*ANDENS_DEB+WETGONAD(HOUR)+WETSTORAGE(HOUR)
      POTFREEMASS=V(HOUR)*ANDENS_DEB+(((V(HOUR)*E_M)/MU_E)*W_E)/D_V ! NON REPRODUCTIVE AND NON FOOD WET MASS

      !ENDIF
C     STATE OF BABY IF VIVIPAROUS AND PREGNANT     
      V_BABY1(HOUR)=V_BABY
      E_BABY1(HOUR)=E_BABY
      EH_BABY1(HOUR)=EH_BABY

      IF(CONTH.EQ.0)THEN
       IF((VIVIPAROUS.EQ.1).AND.(E_H(HOUR).LT.E_HB))THEN
C       MAKE THE MASS, METABOLIC HEAT AND O2 FLUX THAT OF A FULLY GROWN INDIVIDUAL TO GET THE HEAT BALANCE OF
C       A THERMOREGULATING MOTHER WITH FULL RESERVES
        AMASS=MAXMASS/1000.
        P_A = V_M**(2./3.)*PT_AM*F
        P_M = P_MV*V_M
        P_C = (E_M*(VTDOT/L_M+KT_MDOT*(1+L_T/L_M))*
     &    (1*G)/(1+G))*V_M
        P_J = KT_J*E_HE
        P_R = (1.-KAP) * P_A - P_J
        P_G = 0.
        P_D = P_M+P_J+(1-KAP_R)*P_R
        IF(ACTHR(HOUR).GT.1)THEN
         P_X = F * PT_XM * V_M**(2./3.)*((X_FOOD / HALFSAT)
     &  / (1. + X_FOOD / HALFSAT))
        ELSE
         P_X = 0.
        ENDIF
        JOJX=P_A*ETAO(1,1)+P_D*ETAO(1,2)+P_G*ETAO(1,3)
        JOJV=P_A*ETAO(2,1)+P_D*ETAO(2,2)+P_G*ETAO(2,3)
        JOJE=P_A*ETAO(3,1)+P_D*ETAO(3,2)+P_G*ETAO(3,3)
        JOJP=P_A*ETAO(4,1)+P_D*ETAO(4,2)+P_G*ETAO(4,3)
        JMO2=JOJX*JM_JO(3,1)+JOJV*JM_JO(3,2)+JOJE*JM_JO(3,3)+
     &   JOJP*JM_JO(3,4)
C       MLO2(HOUR) = -1*JMO2/(T_REF/TB/24.4)*1000/TCORR
        MLO2(HOUR) = (-1*JMO2*(0.082058*(TB+273.15))/
     &   (0.082058*293.15))*24.06*1000.
        DEBQMET(HOUR)=(P_D+(P_A/KAP_X-P_A-P_A*MU_P*ETA_PA))/3600./TCORR
       ELSE
        AMASS=WETMASS(HOUR)/1000.
       ENDIF
      ENDIF

C     STARVATION FOR PUPA (AND LATE 5TH INSTAR FOR HETERONYMPHA
C      GOTO 987
      IF(STAGE.NE.STAGES-2)THEN
       IF((V(HOUR).GT.3E-9).AND.(ED(HOUR).LE.E_M*0.1))THEN
        DEAD=1
        IF(RESET.EQ.0)THEN
         SURVIV(HOUR)=0.49
         LONGEV=(REAL(DAYCOUNT,4)+REAL(HOUR)/24.)/365.
         NYEAR=IYEAR
         CENSUS=365
         DEADEAD=1
        ENDIF
        IF((STAGE.GT.DEATHSTAGE).AND.(V(HOUR).NE.0.))THEN
         CAUSEDEATH=4. ! STARVATION
         DEATHSTAGE=STAGE
        ENDIF
       ENDIF
      ENDIF


C ************* YEARLY OUTPUT *************************

987   CONTINUE

      IF(DEAD.EQ.1)THEN
       CTMINCUM=0
       E_S_PAST=0.
       L_W(HOUR)=0.
       WETGONAD(HOUR)=0.
       WETSTORAGE(HOUR)=0.
       WETFOOD(HOUR)=0.
       WETMASS(HOUR)=0.
       MLO2(HOUR) = 0.
       O2FLUX = 0.
       CO2FLUX = 0.
       V(HOUR)=0.
       E_H(HOUR)=0.
       CUMREPRO(HOUR)=0.
       CUMBATCH(HOUR)=0.
       VPUP(HOUR)=0.
       VOLD(HOUR)=0.
       ED(HOUR)=0.
       HS(HOUR)=0.
       SURVIV(HOUR)=1.
       E_S(HOUR)=0.
       STAGE=0.0D0
       V_INIT=DEBFIRST(3)
       E_INIT=DEBFIRST(4)
       E_S_INIT=DEBFIRST(5)
       CUMREPRO_INIT=DEBFIRST(6)
       Q_INIT=DEBFIRST(7)
       HS_INIT=DEBFIRST(8)
       CUMBATCH_INIT=DEBFIRST(9)
       V_BABY_INIT=DEBFIRST(10)
       E_BABY_INIT=DEBFIRST(11)
       E_H_INIT=DEBFIRST(12)
       EH_BABY_INIT=0.
       MLO2_INIT=0.
       GH2OMET_INIT=0.
       DEBQMET_INIT=0.
       SURVIV_INIT=1.
       VOLD_INIT=DEBFIRST(3)
       VPUP_INIT=1E-4**3.
       EPUP_INIT=0.
       E_HPUP_INIT=0.
       V_ACC = VDOTREF
       P_AM_ACC = (P_MREF*ZFACT/KAP)
       P_XM_ACC = P_XMREF
       L_J2 = 0.1
       ER = 0.
       IF(HOUR.GT.1)THEN
        MLO2(HOUR-1)=0
       ENDIF
       AMASS=((((V_INIT*E_INIT)/MU_E)*W_E)/D_V + V_INIT)/1000.
      ENDIF

      STAGE_REC(HOUR)=STAGE

      RETURN
      END