      SUBROUTINE BTRFLGEOM

C     NICHEMAPR: SOFTWARE FOR BIOPHYSICAL MECHANISTIC NICHE MODELLING

C     COPYRIGHT (C) 2018 MICHAEL R. KEARNEY AND WARREN P. PORTER

C     THIS PROGRAM IS FREE SOFTWARE: YOU CAN REDISTRIBUTE IT AND/OR MODIFY
C     IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
C     THE FREE SOFTWARE FOUNDATION, EITHER VERSION 3 OF THE LICENSE, OR (AT
C      YOUR OPTION) ANY LATER VERSION.

C     THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
C     WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
C     MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
C     GENERAL PUBLIC LICENSE FOR MORE DETAILS.

C     YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
C     ALONG WITH THIS PROGRAM. IF NOT, SEE HTTP://WWW.GNU.ORG/LICENSES/.

C     THIS SUBROUTINE CALCULATES THE GEOMETRY AND OTHER ANGLES FOR BUTTERFLY WITH WINGS.
C     SURFACES 1,3 ARE THE WINGS, SURFACE 2 IS THE BACK OF THE BODY BETWEEN THE WINGS,
C     SURFACE 4 IS THE IMAGINARY SURFACE BETWEEN THE TOP EDGES OF THE TWO WINGS.
C     SURFACES 5 & 6 ARE THE IMAGINARY SURFACES AT THE ENDS OF THE WINGS.
C     SURFACES 7&8 ARE IMAGINARY EXTENSIONS OF WINGS 1&3 RESPECTIVELY BELOW THE BODY
C     UNTIL THEY MEET IF THE WINGS ARE OPEN MORE THAN 90 DEGREES FROM THE BACK.
C     ALL CONFIGURATION FACTORS ARE CALCULATED HERE.  DUE TO SYMMETRY F12 = F32,
C     F21=F23, F25 = F26, F52 = F62
C     ***PRIMARY ASSUMPTION: LONG AXIS OF BODY NORMAL TO INCOMING SUN'S DIRECT BEAM &
C     CENTER OF BACK NORMAL TO INCOMING SUN'S DIRECT BEAM ***

      IMPLICIT NONE

      DOUBLE PRECISION A,ALPHA,ANGLE,APL,AREA1,AREA2,AREA3,AREA4,AREA5
      DOUBLE PRECISION AREA6,AREF,AREAA,AREAX,AREAW,AREA4B
      DOUBLE PRECISION B,BODLEN,BPL,BREF
      DOUBLE PRECISION C,CPL,CREF,CTEST,CAPL,CAPW
      DOUBLE PRECISION DEGANGL
      DOUBLE PRECISION F12,F13,F14,F15,F16
      DOUBLE PRECISION F21,F23,F24,F25,F26,F2X
      DOUBLE PRECISION F,F31,F32,F34,F35,F36
      DOUBLE PRECISION F41,F42,F43,F45,F46
      DOUBLE PRECISION F51,F52,F53,F54,F56
      DOUBLE PRECISION F61,F62,F63,F64,F65
      DOUBLE PRECISION FAB
      DOUBLE PRECISION F1X,FX1,FX2,FX3,FX4B,FX5,FXY,FY3,F4X,FX2B
      DOUBLE PRECISION F2A1,F2AX,F2A5A
      DOUBLE PRECISION FWY,FXZ,FWZ,FY4B,FY5,FPARLEL
      DOUBLE PRECISION PHI,PI,PSI,PHIREF,RAREA5
      DOUBLE PRECISION SIDEA,SIDEB,SIDEX
      DOUBLE PRECISION SIDE1,SIDE2,SIDE3,SIDE4,SIDE7,SIDE8
      DOUBLE PRECISION SIDE2B,SIDE4B
      DOUBLE PRECISION SUM1ALL,SUM2ALL,SUM3ALL,SUM4ALL,SUM5ALL,SUM6ALL
      DOUBLE PRECISION TERM1,TERM2,TEST1,THETA,TRILEN
      DOUBLE PRECISION W,X,XPRIME,Y,Z,ASILP

      INTEGER I

      DIMENSION PHI(20)

      COMMON/AS/AREA1,AREA2,AREA3,AREA4,AREA4B,AREA5,AREA6,ASILP
      COMMON/F1X/F12,F13,F14,F15,F16
      COMMON/F2X/F21,F23,F24,F25,F26
      COMMON/F3X/F31,F32,F34,F35,F36
      COMMON/F4X/F41,F42,F43,F45,F46
      COMMON/F5X/F51,F52,F54,F56
      COMMON/F6X/F61,F62
      COMMON/FXX/F1X,FXY,FY3
      COMMON/INTGL/X,ANGLE
      COMMON/LENGTHS/SIDEX
      COMMON/MASTERS/AREF,BREF,CREF,PHIREF,PHI
      COMMON/PLATES/APL,BPL,CPL,FPARLEL
      COMMON/RECTNGL/A,B,C,F
      COMMON/SUMS/SUM1ALL,SUM2ALL,SUM3ALL,SUM4ALL,SUM5ALL,SUM6ALL

      PI=3.14159265
      I=1
      SIDE4B=0.
      SIDE4=0.
      F53=0.

C     DEFINING CHARACTERISTIC LENGTHS FOR AREA AND CONFIGURATION FACTOR CALC'S
C     WIDTH OF BODY = A
      SIDE2=AREF
C     LENGTH OF BODY & WING (PARALLEL TO LONG AXIS OF BODY) = B, A CONSTANT
      BODLEN=BREF
      B=BREF
C     WIDTH OF WING (FROM JUNCTION W BODY TO WING TIP) = C
      SIDE1=CREF
      SIDE3=SIDE1
C     ALL OTHER SIDE LENGTHS A FUNCTION OF ANGLE BETWEEN INCOMING
C     SOLAR BEAM AND THE WING (OR ANGLE FROM THE BODY TO THE WING).

C     BODY TOP AREA IN M**2; INPUT LENGTHS, A,B, IN CM
      AREA2=(SIDE2*BODLEN)

C     CALCULATING WINGS
C     TESTING FOR CROSSED WINGS
      ANGLE=PHIREF
      IF(PHI(I).LT.90.)THEN
C      SMALL ANGLE, CHECK FOR 'SHORT' WING WIDTH, C
C      USE A RIGHT TRIANGLE, WHERE RIGHT ANGLE IS AT MIDDLE OF BACK, A
       TEST1= (SIDE2/2.)/COS(ANGLE)
       IF(TEST1.LT.CREF)THEN
C       'SHORT' WING (I.E. CROSSED WINGS)
C       CALCULATING AREA OF ONE WING (M2)
        AREA1=BODLEN*TEST1
       ELSE
C       CALCULATING AREA OF ONE WING (M2)
        AREA1= BODLEN*SIDE1
       ENDIF
      ELSE
C      WINGS AT >= 90 DEGREES FROM BODY; NO SHORTENED WING.
C      CALCULATING AREA OF ONE WING (M2)
       AREA1 = BODLEN*SIDE1
      ENDIF

C     OTHER WING(S) ON OPPOSITE SIDE OF BODY ARE EQUAL AREA
      AREA3=AREA1

C     FINDING THE LENGTHS & AREAS FOR ANGLE DEPENDENT IMAGINARY SURFACES
C     TO CALC. AREAS & CONFIGURATION FACTORS
C     ANGLE = ANGLE FROM THE BACK TO A WING
C     THETA = ANGLE FROM SUN'S DIRECT BEAM TO WING
C     PSI = PI/2 - THETA, THE ANGLE IF THE WING TIPS TOUCH.
      IF(PHI(I).GT.90.)THEN
C      OPEN ON TOP. ANGLE > 90.
C      THETA = WING ANGLE - 90. AT WING-BACK JUNCTION,
C      PSI IS AT THE WING-IMAGINARY SURFACE 4 JUNCTION
       THETA=ANGLE-PI/2
       PSI=PI/2.-THETA
C      SIDE4B IS THE PART OF 4 THAT EXTENDS BEYOND THE EDGE OF SURFACE 2, THE BACK
       SIDE4B= SIDE1*SIN(THETA)
       SIDE4=2.*SIDE4B+SIDE2
C      SIDES 5&6 ARE RIGHT TRIANGLES, 4B,1,X PLUS TWO RECTANGLES SIDE2*SIDEX
       SIDEX=COS(THETA)*SIDE1
C      IMAGINARY IDENTICAL SIDES 5 & 6 ARE SYMMETRIC

C      CALCULATING AREAS (M2)
C      WINGS AT >= 90 DEGREES FROM BODY; NO SHORTENED WING.
       AREA1=BODLEN*SIDE1
C      AREA2 ALWAYS THE SAME. CALCULATED INDEPENDENT OF ANGLE
       AREA3=AREA1
       AREA4=SIDE4*BODLEN
C      AREA OF TRAPEZOID = 0.5*HEIGHT*(TOPSIDE+BOTTOMSIDE). AREA5=AREA6
       AREA5=0.5*(COS(THETA)*SIDE1)*(SIDE2+SIDE4)
       AREA6=AREA5
       AREAX=SIDEX*BODLEN

C      GETTING CONFIGURATION FACTORS (ADJACENT RECTANGLES) WHEN ANGLE > 90
C      GETTING F21: GOING FROM 2 TO X TO 1, WHERE X IS A PLANE NORMAL TO 2
C      WITH A COMMON EDGE AT THE WING - BODY JUNCTION

C      NOTE: ADJACENT RECTANGLE PROGRAM ONLY WORKS FOR 0-90 DEG ANGLES BETWEEN 2 PLANES
C      AND IT DOES NOT WORK WELL BETWEEN 88 AND 90 DEG. MUST USE RIGHT RECTANGLES
C      SUBROUTINE FOR 90 DEG. USE AN IMAGINARY SURFACE, X, WITH COMMON EDGE TO SURFACE 2
C      AND AT A RIGHT ANGLE TO SURFACE 2. THE GOVERNING EQUATION IS:
C      Q21 = Q2X - QX_4B - 2QX5  (WHICH AFTER CANCELLING COMMON TERMS EPSILON, SIGMA AND T1**4
C      A2*F21 = A2*F2X - AX*FX4B - 2*AX*FX5
C      SURFACE 4 IS AN IMAGINARY SURFACE ACROSS THE TOP OF THE TRIANGLE X,4,1. SURFACE 5
C      IS AN IMAGINARY SURFACE ON EITHER END THAT IS A RIGHT TRIANGLE.
C      F21 = (A2*F2X - AX*FX4B - 2*AX*FX5)/A2
C      GETTING F2X
       C=SIDE2
       A=SIDEX
       CALL RYTREC
       F2X=F
C      GETTING FX4B
       C=SIDEX
       A=SIDE4B
       CALL RYTREC
       FX4B=F
C      GETTING FX1
       C=SIDEX
       A=SIDE1
       ANGLE=PHIREF-PI/2.
       CALL ADJREC
       FX1=F
C      GETTING FX5
       AREAX=SIDEX*BODLEN
C      CALCULATION FOR SMALL TRIANGLE ON ONE SIDE BETWEEN IMAGINARY SURFACE X AND SURFACE 1
       FX5=(1.0-FX1-FX4B)/2.
C      CALCULATING F21
       F21=F2X*FX1
       F12=(AREA2/AREA1)*F21
       F23=F21

C      GETTING F14 (F12 IN CONFIG. FACTOR FORMULA FOR ADJACENT RECTANGLES)
C      SURFACE 1 EDGE = C IN SUB. ADJREC
C      SURFACE 2 EDGE = A IN SUB. ADJREC
C      ANGLE IS THE ANGLE BETWEEN THE 2 SURFACES IN SUB. ADJREC.
       C=SIDE1
       A=SIDE4
       ANGLE=PI/2.-THETA
       DEGANGL= ANGLE*180./PI
       CALL ADJREC
       F14=F
       F41=(AREA1/AREA4)*F14

C      GETTING F13 IN STEPS
C      GETTING F1X (IN SUB. ADJREC, F12, SURF1 = C, SURF2 = A)
       ANGLE=PHIREF-PI/2.
       SIDEX=SIDE1*COS(ANGLE)
       C=SIDE1
       A=SIDEX
       CALL ADJREC
       F1X=F
C      GETTING FX2; SIDE1 = SIDE3, SIDEX = SIDEY, FX1 = FY3
       C=SIDEX
       A=SIDE2
       CALL RYTREC
       FX2=F
C      GETTING FY3
       C=SIDEX
       A=SIDE1
C      ANGLE = PHIREF - PI/2.
       CALL ADJREC
       FY3=F
C      GETTING FX5, 2 RIGHT RECTANGLES WITH COMMON EDGE SIDEX = B, C = BODLEN, A = SIDE2
       C=BODLEN
       B=SIDEX
       A=SIDE2
       CALL RYTREC
       FX5=F
C      GETTING FXY: PARALLEL IDENTICAL RECTANGLES COINCIDENT WITH EACH OTHER
C      A & B ARE RECTANGLE DIMENSIONS, C IS THE DISTANCE BETWEEN THEM
       APL=SIDEX
       BPL=BODLEN
       CPL=SIDE2
       CALL PARECT
       FXY=FPARLEL
C      GETTING FY4B, 2 RIGHT RECTANGLES
       ANGLE=PHIREF- PI/2.
       SIDE4B=SIDE1*SIN(ANGLE)
       C=SIDEX
       A=SIDE4B
       CALL RYTREC
       FY4B=F
       FY5=(1.0-FY4B-FY3)/2.
       AREA1=SIDE1*BODLEN
       AREAX=SIDEX*BODLEN
       TERM1=2.*AREAX*(FX2+FX5)
C      AREAX=AREAY
       TERM2=AREAX*FY4B+2.*AREAX*FY5
C      F13=(AREA1*F1X - TERM1 - TERM2)/AREA1
       F13=F1X*FXY*FY3

C      GETTING F24, PARALLEL RECTANGLES, FOR IR EXCHANGE, WING ANGLE > 90
C      IN THE PARALLEL RECTANGLES SUBROUTINE, PARECT
C      APL = WIDTH
C      BPL = BODLEN
C      CPL = DISTANCE BETWEEN PLATES
C      FOR TRAPEZOIDAL CROSS SECTIONS, THE SHORT HORIZONTAL SIDE,A, = W+X.
C      THE LONG HORIZONTAL SIDE,B, = Y+Z,    WHERE W=Y & X=Z.
C      W & Y ARE SIDES OF IDENTICAL PARALLEL PLATES
C      FROM THE COMMON CENTER LINE TO THE OUTER EDGE.
C      GETTING CONFIG. FACTOR,FWY, BETWEEN IDENTICAL SUBPLATES W & Y.
C      SIDE4 OF SURFACE4, THE IMAGINARY SURFACE BETWEEN THE BUTTERLY WING TIPS,
C      IS LONGER RELATIVE TO SIDE2. USING SYMMETRY & CONSIDERING THE BODY
C      ON ONLY 1 SIDE OF THE BODY FROM A CENTER LINE (PLANE) PERPENDICULAR TO THE BACK,
C      AND ALONG THE CENTER AXIS OF THE BODY, & DEFINING THE DIMENSIONS
C      OF ONE OF THE 2 IDENTICAL PARALLEL PLATES & THE DISTANCE BETWEEN THE 2 PLATES.
       W=SIDE2/2.
       X=(SIDE4/2.)-W
       Y=W
       Z=X
       SIDEA=W+X
       SIDEB=Y+Z
C      TOP SURFACE WIDTH
       APL=W
C      TOP SURFACE LENGTH
       BPL=BODLEN
C      DISTANCE BETWEEN IDENTICAL PARALLEL PLATES
       CPL=SIDEX
       CALL PARECT
       FWY=FPARLEL

C      GETTING CONFIG. FACTOR,FXZ, BETWEEN IDENTICAL SUBPLATES X & Z.
C      THIS IS DETERMINED BY THE LARGER PARALLEL PLATE, IN THIS CASE SURFACE 2.
C      Y=W
C      Z = SIDE4/2.- Y
       APL=X
C      BPL & CPL ARE UNCHANGED FROM CURRENT FWY.
       CALL PARECT
       FXZ=FPARLEL

C      AW*FWZ=AY*FYX; AY*FYX=AX*FXY
       AREAW=W*BODLEN
       AREAX=X*BODLEN
       AREAA=AREAW+AREAX
       AREA4=SIDE4*BODLEN
       AREA2=SIDE2*BODLEN
C      GETTING FAB BETWEEN THE IDENTIAL PARALLEL PLATES WX AND YZ
C      APL = SIDEA = X + W, B = BODLEN, C = DISTANCE BETWEEN PLATES; LATTER 2 UNCHANGED.
       APL=SIDEA
       CALL PARECT
       FAB=FPARLEL
       FWZ=(1./(2.*AREAW))*(AREAA*FAB-AREAW*FWY- AREAX*FXZ)

C      BY SYMMETRY ABOVE THE BACK, THERE IS ONE IMAGINARY PLATE2 OF THE SAME DIMENSIONS
C      DIRECTLY OVERHEAD FLANKED ON EITHER SIDE BY AN IMAGINARY SURFACE, PLATE4,
C      THAT COVERS THE REST OF THE OPEN SPACE BETWEEN THE WING TIPS.
C      BY CONSERVATION OF ENERGY, A4*F42 = 2*(AWFWY+AWFWZ)
C      BY CONSERVATION OF ENERGY, A4*F42 = 2*(AW*FWY+AW*FWZ)
       F24=FWY+FWZ
C      BY RECIPROCITY, A4*F42=A2*F24
       F42=(AREA2/AREA4)*F24

       IF(PHI(I).GE.160.)THEN
C       COMPUTE F56 USING PARALLEL RECTANGLES APPROXIMATION FOR TRAPEZOID END AREA
C       AREA OF TRAPEZOID = 0.5*HEIGHT*(TOPSIDE+BOTTOMSIDE). AREA5=AREA6
C       TRAPEZOID AREA = RECTANGLE AREA: 0.5*SIDEX*(TOPSIDE+BOTTOMSIDE) = SIDE2*XPRIME
        XPRIME=(SIDE2+SIDE4)/2.
C       GETTING EQUIVALENT AREA FOR A RECTANGLE FROM THE TRAPEZOID
        RAREA5=SIDEX*XPRIME
C       GETTING F56: PARALLEL IDENTICAL RECTANGLES COINCIDENT WITH EACH OTHER
C       A & B ARE RECTANGLE DIMENSIONS, C IS THE DISTANCE BETWEEN THEM
        APL=XPRIME
        BPL=SIDEX
        CPL=BODLEN
        CALL PARECT
        F56=FPARLEL
C       COMPUTE F52 USING RIGHT RECTANGLES AND APPROXIMATING SURFACE 5
C       AS AN EQUIVALENT RECTANGLE
C       GETTING F52
        C=XPRIME
C       COMMON EDGE, B
        B=SIDE2
        A=BODLEN
        CALL RYTREC
        F52=F
C       GETTING F54
        C=SIDEX
C       COMMON EDGE, B
        B=XPRIME
        A=BODLEN
        CALL RYTREC
        F54=F
C       GETTING F51
        F51=(1.0-F56-F54-F52)/2.
        F53=F51
       ENDIF
C      GETTING F25, F26 FROM CONSERVATION OF ENERGY; F22 = 0. F25=F26, F21=F23.
C      THESE ARE THE TRAPEZOIDS MAKING UP THE OPEN ENDS AT THE HEAD AND TAIL OF THE BODY.
       F15=(1.0-F12-F13-F14)/2.
       F16=F15
       F25=0.5*(1.0-2.*F21-F24)
       F26=F25
       F43=F41
       F45=(1.0-F41-F42-F43)/2.
       F46=F45
       SUM4ALL=F41+F42+F43+F45+F46
      ENDIF

C     END OF WING ANGLE > 90.

      IF(PHI(I).EQ. 90.)THEN
C      GETTING CONFIGURATION FACTORS (ADJACENT RECTANGLES)
C      GETTING F12
C      BODY WIDTH
       A=SIDE2
       SIDE4=SIDE2
       AREA1=SIDE1*BODLEN
       AREA2=SIDE2*BODLEN
       AREA3=AREA1
       AREA4=SIDE4*BODLEN
       AREA5=SIDE1*SIDE2
       AREA6=AREA5
C      BODY LENGTH
       B=BODLEN
C      WING WIDTH
       C=CREF
C      CALLING RIGHT RECTANGLES SUBROUTINE
       CALL RYTREC
C      WING TO BODY CONFIG. FACTOR
       F12=F
C      FWING - SKY = FWING - BACK WHEN WINGS ARE PARALLEL
       F14=F12
C      BODY TO WING CONFIG. FACTOR
       F21=(AREA1/AREA2)*F12
       F23=F21
C      GETTING CONFIGURATION FACTORS (PARALLEL IDENTIAL RECTANGLES WITH COAXIAL CENTERS)
C      USE PARALLEL PLATES FOR WING TO WING CONFIG. FACTORS, F13; F31=F13, SINCE AREA1=AREA3
       APL=SIDE1
       BPL=BODLEN
       CPL=SIDE2
       CALL PARECT
       F13=FPARLEL
C      GETTING BACK TO SKY PARALLEL PLATES CONFIG. FACTOR, F24
       APL=SIDE2
       CPL=SIDE1
       CALL PARECT
       F24=FPARLEL
C      GETTING BODY TO HEAD IMAGINARY SURFACE AND BODY TO TAIL END IMAGINARY SURFACE; F25=F26.
       F25=0.5*(1.0-2.*F21-F24)
       F26=F25
       F15=(1.0-F12-F13-F14)/2.
       F16=F15
      ENDIF
C     END OF WING ANGLE = 90 DEG.

      IF(PHI(I).LT.90.)THEN
C      ANGLE < 90; POSSIBLY CLOSED ON TOP
       CTEST=(SIDE2/2.)/COS(ANGLE)
       IF(CTEST.LT.CREF)THEN
C       'SHORT' WING, I.E. COMPLETELY CLOSED WINGS
        SIDE1=CTEST
        SIDE3=SIDE1
        SIDE4=0.0
        SIDEX=(SIDE2/2.)*TAN(PHIREF)
        AREA1=BODLEN*SIDE1
        AREA2=BODLEN*SIDE2
        AREA4= .0000
        AREA5=0.5*SIDE2*SIDEX
        AREA6=AREA5
        F14=0.000
        F24=0.000
        F34=0.000
        F54=0.000
        F64=0.000
C       GETTING F12.  ADJACENT RECTANGLES DO NOT WORK WELL AT SMALL OR LARGE ANGLES.
C       MUST SUBDIVIDE ISOCELES TRIANGLE INTO TWO ADJACENT RIGHT TRIANGLES JOINED
C       AT THEIR BASES, X, AN IMAGINARY LINE (SURFACE) AT RIGHT ANGLES TO THE BACK,
C       SURFACE 2, WHICH IS BISECTED INTO 2A & 2B. F21 = F2A_1 + F2B_X * FX1
C       BODY WIDTH
C       GETTING F2A_1 : ADJ. RECT: C IS FIRST SIDE, A IS SECOND SIDE (FCA)
        C=SIDE2/2.
        B=BODLEN
C       APPARENT WING WIDTH
        A=SIDE1
        ANGLE=PHIREF
        CALL ADJREC
        F2A1=F
C       CHECK: GETTING F2A_X
        C=SIDE2/2.
        A=SIDEX
        CALL RYTREC
        F2AX=F
        F2A5A=(1.0-F2AX-F2A1)/2.
C       FROM SYMMETRY F25 = F2A_5A + F2B_5B
        F25=2.*F2A5A
C       GETTING F12
        C=SIDE1
        A=SIDE2
        ANGLE=PHIREF
        CALL ADJREC
        F12=F

C       GETTING F21: BY SYMMETRY 2F21 + F24 + 2F25 = 1.0
        F21=(1.0-F24-2.*F25)/2.
        F23=F21

C       GETTING F13
C       WINGS CLOSED; RELEVANT ANGLE NOW WHERE WINGS MEET
C       GETTING ANGLES: WING ANGLE < 90
C       SIDEX IS DISTANCE FROM BASE OF TRIANGLE (BACK) TO WHERE WING TIPS MEET
C       ALPHA IS ANGLE BETWEEN WING TIP JUNCTION AND PLANE X (BODLEN*SIDEX)
        SIDEX=(SIDE2/2.)*TAN(PHIREF)
        ALPHA=PI/2.-PHIREF
C       MAKING SURE THAT AT ANGLES CLOSE TO 90, HEIGHT FROM BODY TO
C       PLANE BETWEEN WING TIPS NOT GREATER THAN WING LENGTH.
        IF(SIDEX.GT.CREF)THEN
         SIDEX=CREF
        ENDIF

C       ADJACENT RECTANGLE FOR F13 USING EQUIVALENT HEIGHT PLANE WITH AT RIGHT ANGLES TO SURFACE1
C       COMPUTING F1X
        C=SIDE1
        A=SIDEX
        B=BODLEN
        ANGLE=ALPHA
        CALL ADJREC
        F1X=F
C       AREA OF IMAGINARY SURFACE, X
        AREAX=A*B
C       COMPUTING FX3
        SIDE3=SIDE1
        C=SIDEX
        A=SIDE3
        CALL ADJREC
        FX3=F
        F13=F1X*FX3
        F15=(1.0-F12-F13-F14)/2.
        F16=F15
C       F23=F21; F24=0; F26=F25
        F24=0.0
        F26=F25
        IF(PHI(I).LE.20)THEN
C        COMPUTE F56 USING PARALLEL RECTANGLES APPROXIMATION FOR TRIANGLE AREA
C        TRIANGLE AREA = RECTANGLE AREA: 0.5*SIDE2*SIDEX = SIDE2*XPRIME
         XPRIME=SIDEX/2.
C        GETTING EQUIVALENT AREA FOR A RECTANGLE FROM THE TRIANGLE
         RAREA5=SIDE2*XPRIME
C        GETTING F56: PARALLEL IDENTICAL RECTANGLES COINCIDENT WITH EACH OTHER
C        A & B ARE RECTANGLE DIMENSIONS, C IS THE DISTANCE BETWEEN THEM
         APL=XPRIME
         BPL=SIDE2
         CPL=BODLEN
         CALL PARECT
         F56=FPARLEL
C        COMPUTE F52 USING RIGHT RECTANGLES AND APPROXIMATING SURFACE 5
C        AS AN EQUIVALENT RECTANGLE
C        GETTING F52
         C=XPRIME
C        COMMON EDGE, B
         B=SIDE2
         A=BODLEN
         CALL RYTREC
         F52=F
C        GETTING F51
         F51=(1.0-F56-F52)/2.
         F53=F51
        ENDIF
C       END OF WINGS CLOSED AT TIPS
       ELSE
C       WINGS SLIGHTLY OPEN AT TIPS, CALC. F14
        DEGANGL=ANGLE*180./PI
        SIDE1=CREF
        SIDE4=SIDE2 - 2.*COS(ANGLE)*SIDE1
        AREA4=SIDE4*BODLEN
        SIDE2B=(SIDE2/2.)-(SIDE4/2.)
        SIDEX=SIN(PHIREF)*SIDE1
        AREA5=((SIDE2+SIDE4)/2.)*SIDEX
        AREA6=AREA5
        SIDE7=(SIDE4/2.)/COS(ANGLE)
        SIDE8=SIDE7
C       GETTING F14
C       THE GOVERNING EQUATION IS: Q41 = Q4X - QX_2B - 2QX5
C       (WHICH AFTER CANCELLING COMMON TERMS EPSILON, SIGMA AND T1**4
C       A4*F41 = A4*F4X - AX*FX2B - 2*AX*FX5
C       SURFACE 4 IS AN IMAGINARY SURFACE ACROSS THE TOP OF THE TRIANGLE X,4,1. SURFACE 5
C       IS AN IMAGINARY SURFACE ON EITHER END THAT IS A RIGHT TRIANGLE.
C       F41 = (A4*F4X - AX*FX2B - 2*AX*FX5)/A4
C       GETTING F4X
        C=SIDE4
        A=SIDEX
        CALL RYTREC
        F4X=F
C       GETTING FX2B
        C=SIDEX
        SIDE2B=SIDE2/2.-SIDE4/2.
        A=SIDE2B
        CALL RYTREC
        FX2B=F
C       GETTING FX1
        C=SIDEX
        A=SIDE1
        ANGLE=PI/2.-PHIREF
        CALL ADJREC
        FX1=F
C       GETTING FX5
        AREAX=SIDEX*BODLEN
C       CALCULATION FOR SMALL TRIANGLE ON ONE SIDE BETWEEN IMAGINARY SURFACE X AND SURFACE 1
        FX5=(1.0-FX1-FX2B)/2.
C       CALCULATING F41
        F41=F4X*FX1
        F14=(AREA4/AREA1)*F41
        F43=F41

C       GETTING F12
        C=SIDE1
        A=SIDE2
        ANGLE=PHIREF
        SIDE3=SIDE1
        CALL ADJREC
        F12=F
        F21=(AREA1/AREA2)*F12
        F23=F21
C       GET F13
        IF(SIDE4.GT.0.01)THEN
C        SIGNIFICANT GAP BETWEEN WING TIPS, USE COMPOSITE ADJACENT RECTANGLES,
C        IF ANGLE NOT CLOSE TO 90 DEG.
         DEGANGL=PHIREF*(180./PI)
C        FOR ANGLE 85-89.999 USE PARALLEL PLATES, ELSE USE UPSIDE DOWN F13 FOR ANGLE > 90.
         IF(PHI(I).GE.85.)THEN
C         USE PARALLEL PLATES; THE TRAPEZOIDAL INTEGRATION FOR ADJACENT RECTANGLES DOESN'T DO WELL
C         USING THE AVERAGE DISTANCE BETWEEN TOP & BOTTOM OF WING
          SIDEX=((SIDE2/2.)-(SIDE4/2.))*TAN(PHIREF)
          IF(SIDEX.GT.CREF)THEN
           SIDEX=CREF
          ENDIF
          APL=SIDE1
          BPL=BODLEN
          CPL=SIDE4+0.5*((SIDE2/2.)-(SIDE4/2.))
          CALL PARECT
          F13=FPARLEL
C         USING THE SAME APPROXIMATION TO ESTIMATE F12 USING RIGHT RECTANGLES
          C=SIDE1
          A=SIDE2-0.5*((SIDE2/2.)-(SIDE4/2.))
          CALL RYTREC
          F12=F
          F21=(AREA1/AREA2)*F12
         ENDIF
         IF(PHI(I).LT.85.)THEN
C         STILL OPEN AT THE TOP, BUT WING ANGLE < 85 DEG.
C         FIRST COMPUTE IMAGINARY SURFACE HEIGHT FROM SURFACE 2 (BACK)
C         TO SURFACE 4 (ABOVE & PARALLEL TO THE BACK ACROSS THE WING TIPS)
C         SURFACES X & Y ARE PARALLEL, X NORMAL TO THE BACK (SURF. 2) AT WING 1 - BACK JUNCTION
C         SURFACE Y NORMAL TO THE BACK AT WING 3 - BACK JUNCTION
C         PHIREF IS CURRENT BACK TO WING ANGLE
          SIDEX=SIDE1*SIN(PHIREF)
C         GETTING F13: F13 = F1X*FXY*FY3
C         GETTING F1X BY ADJACENT RECTANGLES
          C=SIDE1
          A=SIDEX
          ANGLE=PI/2.-PHIREF
          CALL ADJREC
          F1X=F
C         GETTING FXY BY PARALLEL RECTANGLES
C         DIMENSIONS OF ONE OF IDENTICAL RECTANGLES
          APL=SIDEX
          BPL=BODLEN
C         DISTANCE BETWEEN PLATES
          CPL=SIDE4
          CALL PARECT
          FXY=FPARLEL
C         GETTING FY3: X = Y; SIDE1 = SIDE3
          C=SIDEX
          A=SIDE1
C         ANGLE IS THE SAME AS ABOVE
          CALL ADJREC
          FY3=F
          F13=F1X*FXY*FY3
         ENDIF
C        END WING TIPS OPEN; BACK-WING ANGLE < 90 DEG.
        ELSE
C        WING TIPS TOUCHING - USE ADJACENT RECTANGLES WITH WINGS 'JOINED'
C        AT WING TIPS AS RECTANGLES TO FORM AN ISOCELES TRIANGLE THAT IS COMPOSED OF
C        TWO RIGHT TRIANGLES LYING ON THEIR BACKS (SIDE2/2) LIKE TWO BOOKENDS.
C        IMAGINARY SURFACE X IS THEIR COMMON BASE.
         SIDEX=(SIDE2/2.)*TAN(PHIREF)
         AREA5=0.5*SIDE2*SIDEX
C        F13 = F1X*FX3
C        GETTING F1X BY ADJACENT RECTANGLES
         C=SIDE1
         SIDE3=SIDE1
         A=SIDEX
C        GETTING ANGLE
         ANGLE=PI/2.-PHIREF
         CALL ADJREC
         F1X=F
C        GETTING FX3
         C=SIDEX
         A=SIDE3
C        SAME ANGLE
         CALL ADJREC
         FX3=F
C        NO EFFECTIVE GAP AT WING TIPS
         F13=F1X*FX3
         F14=0.00
        ENDIF

C       GETTING F24 USING COMPOSITE PARALLEL RECTANGLES
C       IN THE PARALLEL RECTANGLES SUBROUTINE, PARECT
C       APL = WIDTH
C       BPL = BODLEN
C       CPL = DISTANCE BETWEEN PLATES
C       FOR TRAPEZOIDAL CROSS SECTIONS, THE SHORT SIDE AREA,A, = W+X.
C       THE LONG SIDE AREA,B, = Y+Z,    WHERE W=Y & X=Z.
C       W & Y ARE IDENTICAL PARALLEL PLATES FROM THE COMMON CENTER LINE TO THE OUTER EDGE.
C       GETTING CONFIG. FACTOR,FWY, BETWEEN IDENTICAL SUBPLATES W & Y.
C       SIDE4, THE IMAGINARY SURFACE BETWEEN THE BUTTERLY WINGS,
C       IS NOW SHORTER RELATIVE TO SIDE2. USING SYMMETRY & TAKING HALF THE SHORT SIDE.
C       DEFINING THE DIMENSIONS OF ONE OF THE IDENTICAL PARALLEL PLATES & DISTANCE BETWEEN.
        IF(SIDE4.LT.0.01)THEN
C        TOO SMALL FOR COMPOSITE PARALLEL PLATES - ASSUME NO SIDE4 - SKIP
         F24=0.00
         F42=0.00
         AREA4=0.00
        ELSE
C        COMPOSITE PLATES ON TOP AND BOTTOM; DIVIDING IN HALF TO TAKE ADVANTAGE OF SYMMETRY
         W=SIDE4/2.
         X=(SIDE2/2.)-W
         Y=W
         Z=X
         SIDEA=W+X
         SIDEB=Y+Z
C        TOP SURFACE WIDTH
         APL=W
C        TOP SURFACE LENGTH
         BPL=BODLEN
C        DISTANCE BETWEEN IDENTICAL PARALLEL PLATES
         CPL=SIDEX
         CALL PARECT
         FWY=FPARLEL
C        GETTING CONFIG. FACTOR,FXZ, BETWEEN IDENTICAL SUBPLATES X & Z.
C        THIS IS DETERMINED BY THE LARGER PARALLEL PLATE, IN THIS CASE SURFACE 2.
C        Y=W
C        Z = SIDE2/2.- Y
         APL=Z
C        BPL & CPL ARE UNCHANGED.
         CALL PARECT
         FXZ=FPARLEL
C        AW*FWZ=AY*FYX; AY*FYX=AX*FXY
         AREAW=W*BODLEN
         AREAX=X*BODLEN
         AREAA=AREAW+AREAX
         AREA4=SIDE4*BODLEN
         AREA2=SIDE2*BODLEN
C        GETTING FAB BETWEEN THE IDENTIAL PARALLEL PLATES WX AND YZ
C        APL = SIDEA = X + W, B = BODLEN, C = DISTANCE BETWEEN PLATES; LATTER 2 UNCHANGED.
         APL=X+W
         CALL PARECT
         FAB=FPARLEL
         FWZ=(1./(2*AREAW))*(AREAA*FAB-AREAW*FWY-AREAX*FXZ)
C        BY SYMMETRY ABOVE THE BACK, THERE IS ONE IMAGINARY PLATE2 OF THE SAME DIMENSIONS
C        DIRECTLY OVERHEAD FLANKED ON EITHER SIDE BY AN IMAGINARY SURFACE, PLATE4,
C        THAT COVERS THE REST OF THE OPEN SPACE BETWEEN THE WING TIPS.
C        BY CONSERVATION OF ENERGY, A4*F42 = 2*(AWFWY+AWFWZ)
         F42=FWY+FWZ
C        BY RECIPROCITY, A4*F42=A2*F24
         F24=(AREA4/AREA2)*F42
        ENDIF
C       F21+F22+F23+F24+F25+F26=1.0; F22,F24=0; F26=F25; F21=F23
        F15=(1.0-F12-F13-F14)/2.
        F16=F15
        F23=F21
        F25=(1.0-F21-F23-F24)/2.
        F26=F25
       ENDIF
      ENDIF
      IF(SIDE4.GT.0.000000)THEN
       AREA4=SIDE4*BODLEN
       F41=(AREA1/AREA4)*F14
       F42=(AREA2/AREA4)*F24
       F43=F41
       F45=(1.0-2.*F41-F42)/2.
       F46=F45
       SUM4ALL=F41+F42+F43+F45+F46
      ELSE
       AREA4=0.0
       F41=0.0
       F42=0.0
       F43=0.0
       F45=0.0
       F46=0.0
       F54=0.0
       SUM4ALL=0.0
      ENDIF
C     END OF WING ANGLE < 90 DEG.

      IF(PHI(I).EQ. 180.)THEN
       F12=0.0
       F13=0.0
       F14=1.0
       F15=0.0
       F16=0.0
       F21=0.0
       F23=0.0
       F24=1.0
       F25=0.0
       F31=0.0
       F32=0.0
       F34=1.0
       F35=0.0
       F36=0.0
       F51=0.0
       F52=0.0
       F53=0.0
       F54=0.0
       F56=0.0
       F61=0.0
       F62=0.0
       F63=0.0
       F64=0.0
       F65=0.0
      ENDIF

      F32=F12
      F31=F13
      F34=F14
      F35=F15
      F36=F35
      IF(PHI(I).GT.20.) THEN
       IF(PHI(I).LT.160.)THEN
        F51=(AREA1/AREA5)*F15
        F52=(AREA2/AREA5)*F25
        F53=F51
        F54=(AREA4/AREA5)*F45
        F56=(1.0-F51-F52-F53-F54)
       ENDIF
      ENDIF
      F61=F51
      F62=F52
      F63=F53
      F64=F54
      F65=F56

C    CHECKING FOR F52 FROM CHART FROM SAUER
      TRILEN=SIDE2*SIN(ANGLE)
      CAPL=TRILEN/SIDE2
      CAPW=BODLEN/SIDE2

      AREA4B=SIDE4B*BODLEN
      SUM1ALL=F12+F13+F14+F15+F16
      SUM2ALL=F21+F23+F24+F25+F26
      SUM3ALL=F31+F32+F34+F35+F36
      SUM5ALL=F51+F52+F53+F54+F56
      SUM6ALL=F61+F62+F63+F64+F65

      RETURN
      END

