      SUBROUTINE BREED(DOY,PHOTOSTART,PHOTOFINISH,LENGTHDAY
     &,DAYLENGTHSTART,DAYLENGTHFINISH,PHOTODIRS,PHOTODIRF,PREVDAYLENGTH,
     &LAT,FIRSTDAY,BREEDACT,BREEDACTTHRES,HOUR,
     &BREEDTEMPTHRESH,BREEDTEMPCUM,DAYCOUNT,DEAD,PREVDEAD,ACTIVE)

C     NICHEMAPR: SOFTWARE FOR BIOPHYSICAL MECHANISTIC NICHE MODELLING

C     COPYRIGHT (C) 2018 MICHAEL R. KEARNEY AND WARREN P. PORTER

C     THIS PROGRAM IS FREE SOFTWARE: YOU CAN REDISTRIBUTE IT AND/OR MODIFY
C     IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
C     THE FREE SOFTWARE FOUNDATION, EITHER VERSION 3 OF THE LICENSE, OR (AT
C      YOUR OPTION) ANY LATER VERSION.

C     THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
C     WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
C     MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
C     GENERAL PUBLIC LICENSE FOR MORE DETAILS.

C     YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
C     ALONG WITH THIS PROGRAM. IF NOT, SEE HTTP://WWW.GNU.ORG/LICENSES/.

C     DETERMINES BREEDING STATUS (WHEN DEB MODEL RUNNING) ACCORDING TO 
C     VARIOUS USER-SPECIFIED CRITERIA INCLUDING PHOTOPERIOD, ACTIVITY 
C     TIME AND TEMPERATURE HISTORY

      USE AACOMMONDAT
      IMPLICIT NONE

      INTEGER BREEDING,DOY,PHOTOSTART,PHOTOFINISH,PHOTODIRS,PHOTODIRF
     &,FIRSTDAY,BREEDACT,BREEDACTTHRES,HOUR,STARTTIME,ENDTIME,
     &BREEDTEMPCUM,DAYCOUNT,DEAD,PREVDEAD,I,NN,BREEDVECT

      DOUBLE PRECISION DAYLENGTHSTART,DAYLENGTHFINISH,BREEDTEMPTHRESH,
     &LENGTHDAY,PREVDAYLENGTH,LAT,TBMEAN,ACTIVE

      COMMON/BREEDER/BREEDING,BREEDVECT
      COMMON/DAYSTORUN/NN
      DIMENSION BREEDVECT(24)

C     PHOTOPERIOD CUES FOR BREEDING SEASON
C     1=SUMMER, 2=AUTUMN, 3=SPRING, 4=WINTER
C     JUN-21 173 DEC-22 357 MAR-20 80 SEP-22 266

      IF(PHOTOSTART.EQ.0)THEN ! NO PHOTOPERIOD CONTROL ON BREEDING
       BREEDING=1
      ENDIF

C     SEASONAL BREEDING CHECKS

C     CHECK FOR START OF BREEDING SEASON
      IF((PHOTOSTART.GT.0).AND.(PHOTOSTART.LT.5))THEN
       IF(LAT.LT.0)THEN
C     SOUTHERN HEMISPHERE
        IF(PHOTOSTART.EQ.1)THEN
         IF((DOY.EQ.357).OR.(FIRSTDAY.EQ.1))THEN
          BREEDING=1
         ENDIF
        ENDIF
        IF(PHOTOSTART.EQ.2)THEN
         IF(DOY.EQ.80)THEN
          BREEDING=1
         ENDIF
        ENDIF
        IF(PHOTOSTART.EQ.3)THEN
         IF(DOY.EQ.173)THEN
          BREEDING=1
         ENDIF
        ENDIF
        IF(PHOTOSTART.EQ.4)THEN
         IF(DOY.EQ.266)THEN
          BREEDING=1
         ENDIF
        ENDIF
       ELSE
C     NORTHERN HEMISPHERE
        IF(PHOTOSTART.EQ.1)THEN
         IF(DOY.EQ.173)THEN
          BREEDING=1
         ENDIF
        ENDIF
        IF(PHOTOSTART.EQ.2)THEN
         IF(DOY.EQ.266)THEN
          BREEDING=1
         ENDIF
        ENDIF
        IF(PHOTOSTART.EQ.3)THEN
         IF(DOY.EQ.357)THEN
          BREEDING=1
         ENDIF
        ENDIF
        IF(PHOTOSTART.EQ.4)THEN
         IF(DOY.EQ.80)THEN
          BREEDING=1
         ENDIF
        ENDIF
       ENDIF
      ENDIF

C     CHECK FOR END OF BREEDING SEASON
      IF((PHOTOFINISH.GT.0).AND.(PHOTOFINISH.LT.5))THEN
       IF(LAT.LT.0)THEN
C     SOUTHERN HEMISPHERE
        IF(PHOTOFINISH.EQ.1)THEN
         IF(DOY.EQ.357)THEN
          BREEDING=0
          BREEDACT=0
         ENDIF
        ENDIF
        IF(PHOTOFINISH.EQ.2)THEN
         IF(DOY.EQ.80)THEN
          BREEDING=0
          BREEDACT=0
         ENDIF
        ENDIF
        IF(PHOTOFINISH.EQ.3)THEN
         IF(DOY.EQ.173)THEN
          BREEDING=0
          BREEDACT=0
         ENDIF
        ENDIF
        IF(PHOTOFINISH.EQ.4)THEN
         IF(DOY.EQ.266)THEN
          BREEDING=0
          BREEDACT=0
         ENDIF
        ENDIF
       ELSE
C     NORTHERN HEMISPHERE
        IF(PHOTOFINISH.EQ.1)THEN
         IF(DOY.EQ.173)THEN
          BREEDING=0
          BREEDACT=0
         ENDIF
        ENDIF
        IF(PHOTOFINISH.EQ.2)THEN
         IF(DOY.EQ.266)THEN
          BREEDING=0
         ENDIF
        ENDIF
        IF(PHOTOFINISH.EQ.3)THEN
         IF(DOY.EQ.80)THEN
          BREEDING=0
          BREEDACT=0
         ENDIF
        ENDIF
        IF(PHOTOFINISH.EQ.4)THEN
         IF(DOY.EQ.357)THEN
          BREEDING=0
          BREEDACT=0
         ENDIF
        ENDIF
       ENDIF
      ENDIF
C     END CHECK FOR SEASONAL BREEDING

C     CHECK FOR DAYLENGHT INDUCED BREEDING

C     CHECK FOR START OF BREEDING
      IF(PHOTOSTART.EQ.5)THEN
C      USING SPECIFIED DAYLENGTH THRESHOLDS FOR BREEDING INITIATION
       IF((LENGTHDAY.GE.DAYLENGTHSTART).AND.(PREVDAYLENGTH.LE.
     &  DAYLENGTHSTART).AND.(BREEDING.EQ.0).AND.(PHOTODIRS.EQ.1))THEN
C       WE HAVE REACHED THE CRITICAL DAYLENGTH FOR BREEDING INITIATION AND DAY LENGTH IS INCREASING
        BREEDING=1
       ENDIF
       IF((LENGTHDAY.LT.DAYLENGTHSTART).AND.(PREVDAYLENGTH.GE.
     &  DAYLENGTHSTART).AND.(BREEDING.EQ.0).AND.(PHOTODIRS.EQ.0))THEN
C       WE HAVE REACHED THE CRITICAL DAYLENGTH FOR BREEDING INITIATION AND DAY LENGTH IS DECREASING
        BREEDING=1
       ENDIF
      ENDIF

C     CHECK FOR END OF BREEDING
      IF(PHOTOFINISH.EQ.5)THEN
C     USING SPECIFIED DAYLENGTH THRESHOLDS FOR BREEDING CESSATION
       IF((LENGTHDAY.GE.DAYLENGTHFINISH).AND.(PREVDAYLENGTH.LE.
     &  DAYLENGTHFINISH).AND.(BREEDING.EQ.1).AND.(PHOTODIRF.EQ.1))THEN
C       WE HAVE REACHED THE CRITICAL DAYLENGTH FOR BREEDING CESSATION AND DAY LENGTH IS INCREASING
        BREEDING=0
        BREEDACT=0
       ENDIF
       IF((LENGTHDAY.LT.DAYLENGTHFINISH).AND.(PREVDAYLENGTH.GT.
     &  DAYLENGTHFINISH).AND.(BREEDING.EQ.1).AND.(PHOTODIRF.EQ.0))THEN
C       WE HAVE REACHED THE CRITICAL DAYLENGTH FOR BREEDING CESSATION AND DAY LENGTH IS INCREASING
        BREEDING=0
        BREEDACT=0
       ENDIF
      ENDIF
C     END OF DAYLENGTH INDUCED BREEDING CHECKS      

C     CHECK FOR TEMPERATURE-HISTORY INDUCED BREEDING
      TBMEAN=0
      STARTTIME=INT((DAYCOUNT-1)*24+HOUR-BREEDTEMPCUM)
      ENDTIME=INT((DAYCOUNT-1)*24+HOUR)
      IF(STARTTIME.GT.0)THEN
       DO 10 I=STARTTIME,ENDTIME
        TBMEAN=TBMEAN+TBS(I)
10     CONTINUE
       TBMEAN=TBMEAN/BREEDTEMPCUM
       IF(TBMEAN.GT.BREEDTEMPTHRESH)THEN
        BREEDING=0
        BREEDACT=0
       ENDIF
      ENDIF

C     CUMULATIVE ACTIVITY-INDUCED BREEDING (TO ACCOUNT FOR NEED TO MOVE TO BREEDING AREAS)

C     ACCUMULATE ACTIVITY HOURS IN BREEDING SEASON
      IF(BREEDING.EQ.1)THEN
       IF(ACTIVE.GT.1)THEN
        BREEDACT=BREEDACT+1 ! ACCUMULATE ACTIVITY
       ENDIF
      ENDIF
      
      IF(BREEDACT.LT.BREEDACTTHRES)THEN
       BREEDING=0
      ENDIF
C     END CUMULATIV ACTIVITY-INDUCED BREEDING

C     CHECK IF DIED ON PREVIOUS 
      IF(PREVDEAD.EQ.1)THEN
       IF(BREEDING.EQ.0)THEN
        DEAD=1
        GOTO 987
       ENDIF
      ENDIF

987   RETURN
      END