% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rundeb.R
\name{rundeb}
\alias{rundeb}
\title{rundeb}
\usage{
rundeb(
  allstat = allstat,
  species = "Daphnia.magna",
  Euler = 0,
  start.stage = 0,
  stages = 6,
  S_instar = rep(1.618, stages),
  ndays = 50,
  div = 24,
  Tbs = rep(20, ndays * div),
  Xs = rep(100, ndays * div),
  E_sm = 350,
  fdry = 0.3,
  clutchsize = 5,
  kap.mult = 1,
  z.mult = 1,
  v.mult = 1,
  p.M.mult = 1,
  E.0.mult = 1,
  plot = 1,
  mass.unit = "g",
  length.unit = "cm",
  ageing = 1
)
}
\arguments{
\item{allstat}{= allstat, the allstat data set}

\item{species}{= 'Daphnia.magna', a species in the allstat file}

\item{Euler}{= 0, use Euler integration? (faster, but less accurate), 0 or 1}

\item{start.stage}{= 0, stage at which simulation starts, 0=embryo, 1=birth, 2=puberty}

\item{stages}{= 6, how many life cycle stages? (e.g. 6 for a abp insect model), #}

\item{S_instar}{= rep(1.618, stages), 'stress' factor determining body lengths at which molts occur (for abp insect model), -}

\item{ndays}{= 50, days to run the simulation for}

\item{div}{= 24, value to divide the default step size (days) by, which determines output frequency (and integration frequency if Euler = 1)}

\item{Tbs}{= rep(20, ndays*div), vector of body temperatures for each time step, °C}

\item{Xs}{= rep(100, ndays*div), vector of food densities,J/cm2 or J/cm3}

\item{E_sm}{= 350, maximum stomach energy density per structure, J/cm3}

\item{fdry}{= 0.3, dry fraction of food, -}

\item{clutchsize}{= 5, eggs in a clutch, #}

\item{kap.mult}{= 1, multiplier on original value for kappa, -}

\item{z.mult}{= 1, multiplier on original value of z, to explore implications of DEB covariation rules for body size scaling, -}

\item{v.mult}{= 1, multiplier on original value of energy conductance, v, -}

\item{p.M.mult}{= 1, multiplier on original value of somatic maintenance p.M, -}

\item{E.0.mult}{= 1, multiplier on original value of egg energy E.0, -}

\item{plot}{= 1, produce example plots? 0=no, 1=yes}

\item{mass.unit}{= 'g', mass unit for the plots, 'mg', 'g' or 'kg'}

\item{length.unit}{= 'cm', length unit for the plots, 'mm', 'cm' or 'm'}

\item{ageing}{= 1, impose ageing? 0=immortal, 1=aging according to parameter h.a}
}
\description{
Function to simulate the development, growth and reproduction trajectory of
an organism using DEB theory, drawing parameters from the 'AmP' parameter
database at https://github.com/add-my-pet/AmPtool. It requires the
'allStat.mat' file to have been converted to 'allStat.Rda' via the R.matlab
package (i.e. allStat <- readMat('allStat.mat' then
save(allStat, file = 'allstat.Rda'))).
}
\examples{
#library(R.matlab)
#allStat<-readMat('allStat.mat') # this will take a few minutes
#save(allStat, file = 'allstat.Rda') # save it as an R data file for faster future loading
load('allStat.Rda')
species <- "Daphnia.magna" # must be in the AmP collection - see allDEB.species list
Euler <- 0 # use Euler integration (faster but less accurate) (1) or deSolve's ODE solve (0)
start.stage <- 0 # stage in life cycle to start (0 = egg, 1 = juvenile, 2 = puberty)
ndays <- 50 # number days to run the simulation for
div <- 24 # time step divider (1 = days, 24 = hours, etc.) - keep small if using Euler method for integration
Tbs <- rep(20, ndays * div) # deg C, body temperature
starvetime <- 0 # length of low food period when simulating starvation
X <- 100 # J/cm2 base food density
Xs <- c(rep(X, ndays * div/2), rep(0.000005, starvetime), rep(X, ndays * div/2-starvetime + 1)) # body temperature
E_sm <- 350 # J/cm3, volume-specific stomach energy
fdry <- 0.3 # J/cm3, volume-specific stomach energy
clutchsize <- 50 # -, clutch size
kap.mult <- 1 # -, factor to multiply kappa by (caps at 1)
p.M.mult <- 1 # -, factor to multiply p.M by (caps at 1)
v.mult <- 1 # -, factor to multiply energy conductance by
z.mult <- 1 # -, factor to multiply zoom factor by
E.0.mult <- 1 # -, factor by which to multiply initial egg energy
plot <- 1 # plot results?
mass.unit <- 'g'
length.unit <- 'mm'

deb <- rundeb(species = species, ndays = ndays, div = div, Tbs = Tbs,
              clutchsize = clutchsize, kap.mult = kap.mult, v.mult = v.mult,
              p.M.mult = p.M.mult, Xs = Xs, z.mult = z.mult, E.0.mult = E.0.mult,
              mass.unit = mass.unit, length.unit = length.unit, start.stage = start.stage,
              E_sm = E_sm, Euler = Euler, plot = plot)

debout <- as.data.frame(deb$debout) # retrieve the output
parameters <- deb$pars # retrieve the extracted parameters
}
