% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pedotransfer.R
\name{pedotransfer}
\alias{pedotransfer}
\title{Pedotransfer functions for soil hydraulic properties}
\usage{
pedotransfer(soilpro, 1, DEP)
}
\arguments{
\item{soilpro}{Matrix of n x 5 matrix of soil composition with the following columns 1. depth (cm), 2. bulk density (Mg/m3), 3. clay (\%), 4. silt (\%), 5. sand (\%)}

\item{model}{Choice of equation to compute soil hydraulic parameters (see details)}

\item{DEP}{sequence of depths at which results are required, within the range provided by column 1 of input table 'soilpro'}
}
\value{
PE air entry water potential (J/kg), Campbell (1985) eq. 5.12, p. 46 or Cosby et al. (1984) Table 5

BB Campbell's b parameter, Campbell (1985) eq. 5.11, p. 45 or Cosby et al. (1984) Table 5

BD bulk density, Mg/m3

KS saturated hydraulic conductivity (kg s / m3), Campbell (1985) eq. 6.12, p. 54 or Cosby et al. (1984) Table 5

FC Field capacity (m3/m3, \%) Based on model 6 in Table 6 of Rab, M. A., S. Chandra, P. D. Fisher, N. J. Robinson, M. Kitching, C. D. Aumann, and M. Imhof. 2011. Modelling and prediction of soil water contents at field capacity and permanent wilting point of dryland cropping soils. Soil Research 49:389-407.

PWP Permanent Wilting Point (m3/m3, \%) Based on model 2 in Table 7 of Rab et al. 2011 (cited above)
}
\description{
A function to compute soil hydrological properties from information on bulk
density and soil composition (clay/silt/sand composition) at particular depths,
with capacity to spline results to other depths.
Calculations of Campbell's b, air-entry potential and hydraulic conductivity
are based on either on equations in Campbell, G. S. 1985. Soil Physics
with Basic: Transport Models for Soil-Plant Systems. Elsevier, Amsterdam,
or Cosby, B. J., G. M. Hornberger, R. B. Clapp, and T. R. Ginn. 1984.
A Statistical Exploration of the Relationships of Soil Moisture Characteristics
to the Physical Properties of Soils. Water Resources Research 20:682-690.
Field capacity and permanent wilting point are based on Rab, M. A., S. Chandra, P.
D. Fisher, N. J. Robinson, M. Kitching, C. D. Aumann, and M. Imhof. 2011. Modelling
and prediction of soil water contents at field capacity and permanent wilting
point of dryland cropping soils. Soil Research 49:389-407.
}
\details{
\code{model}{ = 1, choose the pedotransfer function to use; 0 for Cosby et al. (1984) univariate regression (their Table 5), for Cosby et al. (1984) multivariate regression (their Table 4), or 2 for Campbell (1985)}\cr\cr
}
